/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.axis;

import com.safelayer.trustedx.client.axis.EncodeBase64Block;
import com.safelayer.trustedx.client.axis.TagInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import org.apache.axis.encoding.Base64;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class Base64UnPackFilter
extends XMLFilterImpl {
    protected TagInfo currentActive;
    protected EncodeBase64Block encoder;
    protected String valueReqId;
    protected StringBuffer name;
    protected Hashtable tags;
    protected String loadPath;
    protected boolean useRandomId;
    protected String atrReqId;

    public Base64UnPackFilter() {
    }

    public Base64UnPackFilter(XMLReader parent) {
        super(parent);
    }

    public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
        TagInfo tmp;
        String value;
        if (!this.useRandomId && this.valueReqId == null && arg3 != null && arg3.getLength() > 0 && (value = arg3.getValue("", this.atrReqId)) != null) {
            this.valueReqId = value;
        }
        if ((tmp = (TagInfo)this.tags.get(arg1)) != null) {
            this.currentActive = tmp;
            this.name = new StringBuffer();
        }
        super.startElement(arg0, arg1, arg2, arg3);
    }

    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        if (this.currentActive != null) {
            FileInputStream in = null;
            try {
                String nameFile;
                if (this.loadPath != null && this.loadPath.length() > 0) {
                    StringBuffer pathFile = new StringBuffer();
                    pathFile.append(this.loadPath);
                    pathFile.append(File.separator);
                    pathFile.append(new String(Base64.decode((String)this.name.toString())));
                    nameFile = pathFile.toString();
                } else {
                    nameFile = new String(Base64.decode((String)this.name.toString()));
                }
                boolean endOfFile = false;
                in = new FileInputStream(nameFile);
                if (!this.currentActive.isHandleAsBase64()) {
                    byte[] bufferBytes = new byte[65536];
                    this.encoder = this.encoder == null ? new EncodeBase64Block() : this.encoder;
                    this.encoder.init();
                    while (!endOfFile) {
                        String currentBase64Str;
                        int bytesRead = in.read(bufferBytes);
                        if (bytesRead > 0) {
                            currentBase64Str = this.encoder.getBlock(bufferBytes, 0, bytesRead);
                            this.sendChars(currentBase64Str.toCharArray());
                            continue;
                        }
                        currentBase64Str = this.encoder.lastBlock();
                        if (currentBase64Str != null) {
                            this.sendChars(currentBase64Str.toCharArray());
                        }
                        endOfFile = true;
                    }
                } else {
                    InputStreamReader fileRead = new InputStreamReader((InputStream)in, "US-ASCII");
                    char[] buffer = new char[1024];
                    while (!endOfFile) {
                        int charsRead = fileRead.read(buffer);
                        if (charsRead == -1) {
                            endOfFile = true;
                        }
                        super.characters(buffer, 0, charsRead);
                    }
                    fileRead.close();
                }
                in.close();
                this.currentActive = null;
            }
            catch (Exception ex) {
                throw new SAXException(ex);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        super.endElement(arg0, arg1, arg2);
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.currentActive == null) {
            super.characters(arg0, arg1, arg2);
        } else {
            this.name.append(arg0, arg1, arg2);
        }
    }

    protected void sendChars(char[] charBase64) throws Exception {
        int sizeBlock = 1024;
        int srcPos = 0;
        int size = charBase64.length;
        int i = 0;
        while (size > 0) {
            if (size > sizeBlock) {
                super.characters(charBase64, srcPos, sizeBlock);
                size -= sizeBlock;
                srcPos += sizeBlock;
            } else {
                super.characters(charBase64, srcPos, size);
                size = 0;
            }
            ++i;
        }
    }

    public void setLoadPath(String loadPath) {
        this.loadPath = loadPath;
    }

    public void setTags(Hashtable tags) {
        this.tags = tags;
    }

    public void setUseRandomId(boolean useRandomId) {
        this.useRandomId = useRandomId;
    }

    public void setAtrReqId(String atrReqId) {
        this.atrReqId = atrReqId;
    }

    public String getValueReqId() {
        return this.valueReqId;
    }
}

