/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.axis;

import com.safelayer.trustedx.client.axis.DecodeBase64Block;
import com.safelayer.trustedx.client.axis.TagInfo;
import com.safelayer.trustedx.client.axis.TxAxisClientException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Random;
import org.apache.axis.encoding.Base64;
import org.apache.axis.types.HexBinary;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class Base64PackFilter
extends XMLFilterImpl {
    protected FileOutputStream fos;
    protected OutputStreamWriter osw;
    protected TagInfo currentActive;
    protected String name;
    protected DecodeBase64Block decode;
    protected String valueReqId;
    protected Random random;
    protected Hashtable tags;
    protected String savePath;
    protected boolean useRandomId;
    protected String atrReqId;
    protected boolean overwrite;

    public Base64PackFilter() {
    }

    public Base64PackFilter(XMLReader arg0) {
        super(arg0);
    }

    public void startDocument() throws SAXException {
        if (this.useRandomId) {
            this.random = new Random();
        }
        super.startDocument();
    }

    public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
        try {
            TagInfo tmp;
            String value;
            if (!this.useRandomId && this.valueReqId == null && arg3 != null && arg3.getLength() > 0 && (value = arg3.getValue("", this.atrReqId)) != null) {
                this.valueReqId = value;
            }
            if ((tmp = (TagInfo)this.tags.get(arg1)) != null) {
                String pathFile;
                this.currentActive = tmp;
                this.currentActive.incrCount();
                if (this.valueReqId == null) {
                    if (!this.useRandomId) {
                        throw new TxAxisClientException("RequestIDRequiredNotFound");
                    }
                    byte[] randBytes = new byte[10];
                    this.random.nextBytes(randBytes);
                    this.valueReqId = HexBinary.encode((byte[])randBytes);
                }
                StringBuffer nameBuffer = new StringBuffer();
                nameBuffer.append(this.valueReqId);
                nameBuffer.append("-");
                nameBuffer.append(arg1);
                nameBuffer.append("-");
                nameBuffer.append(this.currentActive.getCount());
                this.name = nameBuffer.toString();
                if (this.savePath == null || this.savePath.length() == 0) {
                    pathFile = this.name;
                } else {
                    nameBuffer = new StringBuffer();
                    nameBuffer.append(this.savePath);
                    nameBuffer.append(File.separator);
                    nameBuffer.append(this.name);
                    pathFile = nameBuffer.toString();
                }
                File file = new File(pathFile);
                if (file.canRead() && !this.overwrite) {
                    throw new TxAxisClientException("ResponseFileAlreadyExists");
                }
                this.fos = new FileOutputStream(file);
                if (this.currentActive.isHandleAsBase64()) {
                    this.osw = new OutputStreamWriter((OutputStream)this.fos, "US-ASCII");
                } else {
                    this.decode = new DecodeBase64Block();
                    this.decode.init();
                }
            }
            super.startElement(arg0, arg1, arg2, arg3);
        }
        catch (Exception ex) {
            try {
                this.fos.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw new SAXException(ex);
        }
    }

    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        if (this.currentActive != null) {
            try {
                char[] nameChar = Base64.encode((byte[])this.name.getBytes()).toCharArray();
                super.characters(nameChar, 0, nameChar.length);
                if (!this.currentActive.isHandleAsBase64()) {
                    this.decode.lastBlock();
                } else {
                    this.osw.flush();
                    this.osw.close();
                }
                this.fos.flush();
                this.currentActive = null;
            }
            catch (Exception ex) {
                throw new SAXException(ex);
            }
            finally {
                try {
                    this.fos.close();
                }
                catch (Exception e) {}
            }
        }
        super.endElement(arg0, arg1, arg2);
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        try {
            if (this.currentActive == null) {
                super.characters(arg0, arg1, arg2);
            } else if (this.currentActive.isHandleAsBase64()) {
                this.osw.write(arg0, arg1, arg2);
            } else {
                byte[] read = this.decode.getBlock(arg0, arg1, arg2);
                this.fos.write(read);
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public void setTags(Hashtable tags) {
        this.tags = tags;
    }

    public void setUseRandomId(boolean useRandomId) {
        this.useRandomId = useRandomId;
    }

    public void setAtrReqId(String atrReqId) {
        this.atrReqId = atrReqId;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

