/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartSignatureResult;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.Translate;
import com.safelayer.trustedx.client.smartwrapper.exception.SerializationException;
import com.safelayer.www.TWS.MultiSignatureResult;
import java.io.IOException;
import java.util.Hashtable;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.MessageElement;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Document;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.VerifyResponse;
import org.w3c.dom.Node;

public class SmartVerifyResponse
extends AbstractSmartDataResponse {
    private VerifyResponse response;
    private Node node;
    private boolean signatureB64AsXml = false;

    public SmartVerifyResponse(VerifyResponse verifyResponse, Hashtable hashtable, Node node) {
        super(hashtable);
        this.response = verifyResponse;
        this.node = node;
    }

    public Object getInternalObject() {
        return this.response;
    }

    public String getRequestId() {
        return this.response.getRequestID();
    }

    public String getProfile() {
        if (this.response != null && this.response.getProfile() != null) {
            String string = this.response.getProfile().toString();
            String string2 = Translate.getProfile(string);
            if (string2 != null) {
                string = string2;
            }
            return string;
        }
        return null;
    }

    public String getResultMajor() {
        if (this.response != null && this.response.getResult() != null && this.response.getResult().getResultMajor() != null) {
            return this.response.getResult().getResultMajor().toString();
        }
        return null;
    }

    public String getResultMinor() {
        if (this.response != null && this.response.getResult() != null && this.response.getResult().getResultMinor() != null) {
            return this.response.getResult().getResultMinor().toString();
        }
        return null;
    }

    public String getResultMessage() {
        if (this.response != null && this.response.getResult() != null && this.response.getResult().getResultMessage() != null) {
            return this.response.getResult().getResultMessage().get_value();
        }
        return null;
    }

    public String getDocumentBase64Data() {
        String string = null;
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getDocument() != null && this.response.getOptionalOutputs().getDocument().getBase64Data() != null) {
            string = this.response.getOptionalOutputs().getDocument().getBase64Data().toString();
        }
        return string;
    }

    public int getNumberSignatures() {
        int n = 0;
        if (this.response != null && this.response.getOptionalOutputs() != null) {
            MultiSignatureResult multiSignatureResult = this.response.getOptionalOutputs().getMultiSignatureResult();
            n = multiSignatureResult != null ? multiSignatureResult.getSignatureResult().length : 1;
        }
        return n;
    }

    public int getNumberVerifyResponses() {
        int n = 0;
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getOtherVerifyResponses() != null) {
            n = this.response.getOptionalOutputs().getOtherVerifyResponses().getVerifyResponse().length;
        }
        return n;
    }

    public SmartSignatureResult getSignature(int n) throws IndexOutOfBoundsException {
        int n2 = this.getNumberSignatures();
        if (n2 > 0) {
            if (n2 == 1) {
                if (n > 0) {
                    throw new IndexOutOfBoundsException();
                }
                return new SmartSignatureResult(this.response, this.node);
            }
            return new SmartSignatureResult(this.response.getOptionalOutputs().getMultiSignatureResult().getSignatureResult(n), SmartWrapperUtil.getXmlNode(this.node, "/dss:OptionalOutputs/css:MultiSignatureResult/css:SignatureResult(" + n + ")"));
        }
        return null;
    }

    public SmartVerifyResponse getOtherResponse(int n) throws IndexOutOfBoundsException {
        if (this.getNumberVerifyResponses() > 0) {
            return new SmartVerifyResponse(this.response.getOptionalOutputs().getOtherVerifyResponses().getVerifyResponse(n), this.options, SmartWrapperUtil.getXmlNode(this.node, "/dss:OptionalOutputs/css:OtherVerifyResponses/dss:VerifyResponse(i)"));
        }
        return null;
    }

    public String getSignersCertificates() throws SerializationException {
        if (this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getSignersCertificates() != null) {
            return SmartWrapperUtil.serialize(this.node, "/dss:OptionalOutputs/css:SignersCertificates");
        }
        return null;
    }

    public String getDocumentXmlData() {
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getDocument() != null && this.response.getOptionalOutputs().getDocument().getXMLData() != null) {
            return this.response.getOptionalOutputs().getDocument().getXMLData().get_any()[0].toString();
        }
        return null;
    }

    public String getDocumentXmlBase64() {
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getDocument() != null && this.response.getOptionalOutputs().getDocument().getBase64XML() != null) {
            return Base64.encode((byte[])this.response.getOptionalOutputs().getDocument().getBase64XML());
        }
        return null;
    }

    public String getDocumentMime() {
        String string = null;
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getMime() != null) {
            string = new String(this.response.getOptionalOutputs().getMime().get_value());
        }
        return string;
    }

    public String getDigestPdf() {
        String string = null;
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getDocument() != null && this.response.getOptionalOutputs().getDocument().getBase64Data() != null) {
            string = this.response.getOptionalOutputs().getDocument().getBase64Data().toString();
        }
        return string;
    }

    public int getPdfNumberSignatures() {
        int n = 0;
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getNumberPdfSignatures() != null) {
            n = this.response.getOptionalOutputs().getNumberPdfSignatures().intValue();
        }
        return n;
    }

    public String getPdfSignatureFieldsInfo() throws Exception {
        String string = null;
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getSignatureFieldsInfo() != null) {
            return SmartWrapperUtil.serialize(this.node, "/dss:OptionalOutputs/css:SignatureFieldsInfo");
        }
        return string;
    }

    public String getSignatureBase64() {
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getUpdatedSignature() != null && this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject() != null && this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject().getBase64Signature() != null) {
            return this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject().getBase64Signature().toString();
        }
        return null;
    }

    public String getSignatureBase64Type() {
        String string;
        String string2 = null;
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getUpdatedSignature() != null && this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject() != null && this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject().getBase64Signature() != null && (string = Translate.getSignatureType(string2 = this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject().getBase64Signature().getType().toString())) != null) {
            string2 = string;
        }
        return string2;
    }

    public String getDocumentWithSignaturePdf() {
        MessageElement[] messageElementArray;
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getDocumentWithSignature() != null && this.response.getOptionalOutputs().getDocumentWithSignature().getXMLData() != null && this.response.getOptionalOutputs().getDocumentWithSignature().getXMLData().get_any() != null && (messageElementArray = this.response.getOptionalOutputs().getDocumentWithSignature().getXMLData().get_any()) != null && messageElementArray.length > 0 && messageElementArray[0] != null) {
            return messageElementArray[0].getValue();
        }
        return null;
    }

    public String getSignatureMime() {
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getUpdatedSignature() != null && this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject() != null && this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject().getMimeSignature() != null) {
            return this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject().getMimeSignature().toString();
        }
        return null;
    }

    public String getSignatureMimeType() {
        String string;
        String string2 = null;
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getUpdatedSignature() != null && this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject() != null && this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject().getMimeSignature() != null && (string = Translate.getMimeSignatureType(string2 = this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject().getMimeSignature().getType().toString())) != null) {
            string2 = string;
        }
        return string2;
    }

    void setSignatureB64AsXml(boolean bl) {
        this.signatureB64AsXml = bl;
    }

    public String getSignatureXml() throws Exception {
        if (this.signatureB64AsXml) {
            String string = this._getSignatureXmlBase64();
            String string2 = new String(Base64.decode((String)string));
            if (this.isAxisPlusTag("Base64XML")) {
                String string3 = new String(this.getReferenceFileContent(string2, true));
                if (this.isAxisPlusTagAsBase64("Base64XML")) {
                    return new String(Base64.decode((String)string3));
                }
                return string3;
            }
            return string2;
        }
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getUpdatedSignature() != null && this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject() != null && this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject().getSignature() != null) {
            return SmartWrapperUtil.serialize(this.node, "/dss:OptionalOutputs/dss:UpdatedSignature/dss:SignatureObject/dsig:Signature");
        }
        return null;
    }

    public String getSignatureXmlBase64() {
        String string = null;
        if (!this.signatureB64AsXml) {
            string = this._getSignatureXmlBase64();
        }
        return string;
    }

    String _getSignatureXmlBase64() {
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getUpdatedSignature() != null && this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject() != null && this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject().getBase64XMLSignature() != null) {
            return this.response.getOptionalOutputs().getUpdatedSignature().getSignatureObject().getBase64XMLSignature().toString();
        }
        return null;
    }

    public String getDocumentWithSignatureXml() {
        if (this.signatureB64AsXml) {
            String string = this._getDocumentWithSignatureXmlBase64();
            String string2 = new String(Base64.decode((String)string));
            String string3 = null;
            if (this.isAxisPlusTag("Base64XML")) {
                try {
                    string3 = new String(this.getReferenceFileContent(string2, true));
                    if (this.isAxisPlusTagAsBase64("Base64XML")) {
                        string3 = new String(Base64.decode((String)string3));
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                string3 = string2;
            }
            return string3;
        }
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getDocumentWithSignature() != null && this.response.getOptionalOutputs().getDocumentWithSignature().getXMLData() != null) {
            return this.response.getOptionalOutputs().getDocumentWithSignature().getXMLData().get_any()[0].toString();
        }
        return null;
    }

    public String getDocumentWithSignatureXmlBase64() {
        String string = null;
        if (!this.signatureB64AsXml) {
            string = this._getDocumentWithSignatureXmlBase64();
        }
        return string;
    }

    String _getDocumentWithSignatureXmlBase64() {
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getDocumentWithSignature() != null && this.response.getOptionalOutputs().getDocumentWithSignature().getBase64XML() != null) {
            return Base64.encode((byte[])this.response.getOptionalOutputs().getDocumentWithSignature().getBase64XML());
        }
        return null;
    }

    public SmartSignedDocument getSignedDocument(int n) throws Exception {
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getSignedDocuments() != null && n < this.response.getOptionalOutputs().getSignedDocuments().getDocument().length && this.response.getOptionalOutputs().getSignedDocuments().getDocument(n) != null) {
            return new SmartSignedDocument(this.response.getOptionalOutputs().getSignedDocuments().getDocument(n));
        }
        return null;
    }

    public int getNumberSignedDocuments() {
        int n = 0;
        if (this.response != null && this.response.getOptionalOutputs() != null && this.response.getOptionalOutputs().getSignedDocuments() != null) {
            n = this.response.getOptionalOutputs().getSignedDocuments().getDocument().length;
        }
        return n;
    }

    public class SmartSignedDocument {
        Document doc = null;

        public SmartSignedDocument(Document document) {
            this.doc = document;
        }

        public String getRefUri() {
            if (this.doc != null && this.doc.getRefURI() != null) {
                return this.doc.getRefURI().toString();
            }
            return null;
        }

        public String getRefType() {
            if (this.doc != null && this.doc.getRefType() != null) {
                return this.doc.getRefType().toString();
            }
            return null;
        }

        public String getDocumentXmlData() {
            if (this.doc != null && this.doc.getXMLData() != null) {
                return this.doc.getXMLData().get_any()[0].toString();
            }
            return null;
        }

        public String getDocumentXmlBase64() {
            if (this.doc != null && this.doc.getBase64XML() != null) {
                return Base64.encode((byte[])this.doc.getBase64XML());
            }
            return null;
        }

        public String getDocumentBase64Data() {
            if (this.doc != null && this.doc.getBase64Data() != null) {
                return this.doc.getBase64Data().toString();
            }
            return null;
        }
    }
}

