/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartSignatureSelection;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.Translate;
import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import com.safelayer.trustedx.client.smartwrapper.exception.InvalidValueException;
import com.safelayer.www.TWS.AddCertificateValuesType;
import com.safelayer.www.TWS.AddRevocationValuesType;
import com.safelayer.www.TWS.AddSignatureAlgorithm;
import com.safelayer.www.TWS.AddSignatureType;
import com.safelayer.www.TWS.AddSignedAttributes;
import com.safelayer.www.TWS.AddTimeStampValues;
import com.safelayer.www.TWS.AddUnsignedAttributes;
import com.safelayer.www.TWS.Base64Binary;
import com.safelayer.www.TWS.DSV_wsdl.DRBindingStub;
import com.safelayer.www.TWS.DSV_wsdl.DSVBindingStub;
import com.safelayer.www.TWS.DSV_wsdl.SignatureUpdateType;
import com.safelayer.www.TWS.DSV_wsdl.SignatureVerificationType;
import com.safelayer.www.TWS.DSV_wsdl.TWSDRLocator;
import com.safelayer.www.TWS.DSV_wsdl.TWSDSVLocator;
import com.safelayer.www.TWS.DocumentItem;
import com.safelayer.www.TWS.IncludeManifests;
import com.safelayer.www.TWS.MimeSignature;
import com.safelayer.www.TWS.MultiSignatureSelection;
import com.safelayer.www.TWS.MultiSignatureSelectionSignatureSelection;
import com.safelayer.www.TWS.PDFFieldType;
import com.safelayer.www.TWS.Reference;
import com.safelayer.www.TWS.ReturnSignedDocuments;
import com.safelayer.www.TWS.SignedReferences;
import com.safelayer.www.TWS.SignersCertificates;
import com.safelayer.www.TWS.ToBeVerifiedFields;
import java.math.BigInteger;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.axis.types.Language;
import org.apache.axis.types.URI;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Base64Data;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Base64Signature;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Document;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.DocumentHash;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.InputDocuments;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.OptionalInputs;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.ReturnUpdatedSignature;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignatureObject;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Timestamp;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.VerifyRequest;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.VerifyResponse;
import org.w3.www._2000._09.xmldsig.DigestMethodType;
import org.w3.www._2000._09.xmldsig.DigestValueType;
import org.w3.www._2000._09.xmldsig.KeyInfoType;
import org.w3.www._2000._09.xmldsig.X509DataType;
import org.w3c.dom.Node;

public class SmartVerifyRequest
extends AbstractSmartDataRequest {
    static final boolean DEFAULT_ADDSIGNATUREFORM = false;
    static final boolean DEFAULT_EXCLUDESIGNINGDOCUMENT = false;
    static final boolean DEFAULT_ADDADDITIONALINFOVALUES = false;
    static final String DEFAULT_ADDCERTIFICATEVALUES = "none";
    static final String DEFAULT_ADDREVOCATIONVALUES = "none";
    static final String DEFAULT_ADDTIMESTAMPVALUES = "none";
    static final String DEFAULT_ADDTSACERTIFICATEVALUES = "none";
    static final String DEFAULT_ADDTSAREVOCATIONVALUES = "none";
    static final String DEFAULT_ADDTSAARCHIVEDREVOCATIONVALUES = "none";
    static final String DEFAULT_ADDTSACHAINCERTIFICATEVALUES = "none";
    static final boolean DEFAULT_ADDOTHERVERIFYRESPONSES = false;
    static final boolean DEFAULT_ADDRULESINFORMATION = false;
    static final String DEFAULT_ADDCHAINCERTIFICATEVALUES = "none";
    static final String DEFAULT_ADDCHAINREVOCATIONVALUES = "none";
    static final String DEFAULT_ADDARCHIVEDREVOCATIONVALUES = "none";
    static final boolean DEFAULT_ADDSIGNATUREALGORITHM = false;
    static final boolean DEFAULT_ADDSIGNEDATTRIBUTES = false;
    static final boolean DEFAULT_ADDUNSIGNEDATTRIBUTES = false;
    static final String DEFAULT_SIGNATURETYPE = "cms";
    static final String DEFAULT_RETURNSIGNINGDOCUMENT = "none";
    static final boolean DEFAULT_XMLINCLUDEMANIFESTS = false;
    static final String DEFAULT_SIGNATUREMIMETYPE = "smime3";
    static final boolean DEFAULT_PDFVERIFYLASTSIGNATURE = false;
    static final boolean DEFAULT_PDFADDSIGNATUREINFO = false;
    static final boolean DEFAULT_PDFADDSIGNATUREFIELDSINFO = false;
    static final String DEFAULT_INPUTHASHALGORITHM = "sha1";
    private DRBindingStub bindingDr;
    private DSVBindingStub bindingDsv;
    private VerifyRequest request = new VerifyRequest();
    private OptionalInputs optionalInputs = null;
    private InputDocuments inputDocs = null;
    private boolean userHasCallRequestId = false;
    private boolean userHasCallXmlReturnBase64 = false;
    private String signatureFileToDelete = null;
    private String xmlFileToDelete = null;

    public SmartVerifyRequest(String string) throws Exception {
        this(string, "dsv");
    }

    public SmartVerifyRequest(String string, String string2) throws Exception {
        if ("dr".equals(string2)) {
            TWSDRLocator tWSDRLocator = new TWSDRLocator();
            tWSDRLocator.setSignatureUpdateEndpointAddress(string);
            SignatureUpdateType signatureUpdateType = tWSDRLocator.getSignatureUpdate();
            this.bindingDr = (DRBindingStub)signatureUpdateType;
            this.initUpdate();
            SmartWrapperUtil.setProperties(tWSDRLocator.getEngine());
        } else {
            TWSDSVLocator tWSDSVLocator = new TWSDSVLocator();
            tWSDSVLocator.setSignatureVerifyEndpointAddress(string);
            SignatureVerificationType signatureVerificationType = tWSDSVLocator.getSignatureVerify();
            this.bindingDsv = (DSVBindingStub)signatureVerificationType;
            this.initVerify();
            SmartWrapperUtil.setProperties(tWSDSVLocator.getEngine());
        }
    }

    void initUpdate() {
        this.initVerify();
        try {
            this.initDefaultUpdateValues();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void initVerify() {
        this.initRandom();
        try {
            this.initDefaultValues();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Object getInternalObject() {
        return this.request;
    }

    void checkOptionalInputs() {
        if (this.optionalInputs == null) {
            this.optionalInputs = new OptionalInputs();
            this.request.setOptionalInputs(this.optionalInputs);
        }
    }

    void checkInputDocuments() {
        if (this.inputDocs == null) {
            this.inputDocs = new InputDocuments();
            this.request.setInputDocuments(this.inputDocs);
        }
    }

    void initDefaultValues() throws InvalidValueException {
        this.setAddSignatureForm(false);
        this.setExcludeSigningDocument(false);
        this.setAddAdditionalInfoValues(false);
        this.setAddCertificateValues("none");
        this.setAddRevocationValues("none");
        this.setAddSignatureAlgorithm(false);
        this.setAddSignedAttributes(false);
        this.setAddUnsignedAttributes(false);
        this.setAddTimeStampValues("none");
        this.setAddTsaCertificateValues("none");
        this.setAddTsaRevocationValues("none");
        this.setAddTsChainCertificateValues("none");
        this.setAddOtherVerifyResponses(false);
        this.setAddRulesInformation(false);
        this.setAddChainCertificateValues("none");
        this.setAddChainRevocationValues("none");
        this.setReturnSigningDocument("none");
        this.setXmlIncludeManifests(false);
        this.setPdfVerifyLastSignature(false);
        this.setPdfAddSignatureInfo(false);
        this.setPdfAddSignatureFieldsInfo(false);
    }

    void initDefaultUpdateValues() throws InvalidValueException {
        this.setProfile("nonrep");
        this.setAddNewTimeStampValues("none");
        this.setReturnUpdatedSignature("updatesig");
    }

    public void setRequestId(String string) {
        this.request.setRequestID(string);
        this.userHasCallRequestId = true;
    }

    public void setProfile(String string) throws InvalidValueException {
        String string2 = Translate.putProfileDsv(string);
        if (string2 == null) {
            string2 = string;
        }
        try {
            this.request.setProfile(new URI(string2));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
    }

    public void setInputBase64Data(String string) throws ConfigurationException {
        this._setInputBase64Data(string, "string", "base64");
    }

    public void setInputBase64DataFile(String string, String string2) throws ConfigurationException {
        this._setInputBase64Data(string, "file", string2);
    }

    void _setInputBase64Data(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Base64Data", string2, string3);
        this.checkInputDocuments();
        Document document = new Document();
        Base64Data base64Data = new Base64Data(string);
        document.setBase64Data(base64Data);
        this.inputDocs.setDocument(document);
    }

    public void setInputHashDigest(String string) {
        this.checkInputDocuments();
        DocumentHash documentHash = this.inputDocs.getDocumentHash();
        if (documentHash == null) {
            documentHash = new DocumentHash();
            this.inputDocs.setDocumentHash(documentHash);
        }
        documentHash.setDigestValue(new DigestValueType(string));
        if (documentHash.getDigestMethod() == null || documentHash.getDigestMethod().getAlgorithm() == null) {
            try {
                this.setInputHashAlgorithm(DEFAULT_INPUTHASHALGORITHM);
            }
            catch (InvalidValueException invalidValueException) {
                invalidValueException.printStackTrace();
            }
        }
    }

    public void setInputHashAlgorithm(String string) throws InvalidValueException {
        URI uRI;
        String string2 = Translate.putInputHashAlgorithm(string);
        if (string2 == null) {
            string2 = string;
        }
        try {
            uRI = new URI(string2);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
        this.checkInputDocuments();
        DocumentHash documentHash = this.inputDocs.getDocumentHash();
        if (documentHash == null) {
            documentHash = new DocumentHash();
            this.inputDocs.setDocumentHash(documentHash);
        }
        DigestMethodType digestMethodType = new DigestMethodType();
        digestMethodType.setAlgorithm(uRI);
        documentHash.setDigestMethod(digestMethodType);
    }

    public void setSignatureBase64(String string) throws ConfigurationException {
        this._setSignatureBase64(string, "string", "base64");
    }

    public void setSignatureBase64File(String string, String string2) throws ConfigurationException {
        this._setSignatureBase64(string, "file", string2);
    }

    void _setSignatureBase64(String string, String string2, String string3) throws ConfigurationException {
        Base64Signature base64Signature;
        this.fileRequestTag("Base64Signature", string2, string3);
        SignatureObject signatureObject = this.request.getSignatureObject();
        if (signatureObject == null) {
            signatureObject = new SignatureObject();
            this.request.setSignatureObject(signatureObject);
        }
        if ((base64Signature = signatureObject.getBase64Signature()) == null) {
            base64Signature = new Base64Signature(string);
            signatureObject.setBase64Signature(base64Signature);
            try {
                this.setSignatureBase64Type(DEFAULT_SIGNATURETYPE);
            }
            catch (InvalidValueException invalidValueException) {
                invalidValueException.printStackTrace();
            }
        } else {
            URI uRI = base64Signature.getType();
            if (uRI != null) {
                base64Signature = new Base64Signature(string);
                base64Signature.setType(uRI);
            } else {
                try {
                    this.setSignatureBase64Type(DEFAULT_SIGNATURETYPE);
                }
                catch (InvalidValueException invalidValueException) {
                    invalidValueException.printStackTrace();
                }
            }
            signatureObject.setBase64Signature(base64Signature);
        }
    }

    public void setSignatureBase64Type(String string) throws InvalidValueException {
        Base64Signature base64Signature;
        URI uRI;
        String string2 = Translate.putSignatureType(string);
        if (string2 == null) {
            string2 = string;
        }
        try {
            uRI = new URI(string2);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
        SignatureObject signatureObject = this.request.getSignatureObject();
        if (signatureObject == null) {
            signatureObject = new SignatureObject();
            this.request.setSignatureObject(signatureObject);
        }
        if ((base64Signature = signatureObject.getBase64Signature()) == null) {
            base64Signature = new Base64Signature();
            signatureObject.setBase64Signature(base64Signature);
        }
        base64Signature.setType(uRI);
    }

    public void setLanguage(String string) {
        this.checkOptionalInputs();
        this.optionalInputs.setLanguage(new Language(string));
    }

    public void setServicePolicy(String string) throws InvalidValueException {
        this.checkOptionalInputs();
        try {
            this.optionalInputs.setServicePolicy(new URI(string));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string);
        }
    }

    public void setAddSignatureForm(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddSignatureForm((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddSignatureForm(null);
        }
    }

    public void setExcludeSigningDocument(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setExcludeSigningDocument((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setExcludeSigningDocument(null);
        }
    }

    public void setAddAdditionalInfoValues(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddAdditionalInfoValues((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddAdditionalInfoValues(null);
        }
    }

    public void setAddCertificateValues(String string) throws InvalidValueException {
        if (!SmartVerifyRequest.isAddValue(string)) {
            throw new InvalidValueException(string);
        }
        if (SmartVerifyRequest.isAddNoneValue(string)) {
            if (this.optionalInputs != null) {
                this.optionalInputs.setAddCertificateValues(null);
            }
        } else {
            this.checkOptionalInputs();
            AddCertificateValuesType addCertificateValuesType = new AddCertificateValuesType();
            addCertificateValuesType.setBinary(SmartVerifyRequest.isAddBinaryValue(string));
            this.optionalInputs.setAddCertificateValues(addCertificateValuesType);
        }
    }

    public void setAddRevocationValues(String string) throws InvalidValueException {
        if (!SmartVerifyRequest.isAddValue(string)) {
            throw new InvalidValueException(string);
        }
        if (SmartVerifyRequest.isAddNoneValue(string)) {
            if (this.optionalInputs != null) {
                this.optionalInputs.setAddRevocationValues(null);
            }
        } else {
            this.checkOptionalInputs();
            AddRevocationValuesType addRevocationValuesType = new AddRevocationValuesType();
            addRevocationValuesType.setBinary(SmartVerifyRequest.isAddBinaryValue(string));
            this.optionalInputs.setAddRevocationValues(addRevocationValuesType);
        }
    }

    public void setAddTimeStampValues(String string) throws InvalidValueException {
        if (!SmartVerifyRequest.isAddValue(string)) {
            throw new InvalidValueException(string);
        }
        if (SmartVerifyRequest.isAddNoneValue(string)) {
            if (this.optionalInputs != null) {
                this.optionalInputs.setAddTimeStampValues(null);
            }
        } else {
            this.checkOptionalInputs();
            AddTimeStampValues addTimeStampValues = this.optionalInputs.getAddTimeStampValues();
            if (addTimeStampValues == null) {
                addTimeStampValues = new AddTimeStampValues();
                this.optionalInputs.setAddTimeStampValues(addTimeStampValues);
            }
            addTimeStampValues.setBinary(SmartVerifyRequest.isAddBinaryValue(string));
        }
    }

    public void setAddTsaCertificateValues(String string) throws InvalidValueException {
        if (!SmartVerifyRequest.isAddValue(string)) {
            throw new InvalidValueException(string);
        }
        if (SmartVerifyRequest.isAddNoneValue(string)) {
            if (this.optionalInputs != null && this.optionalInputs.getAddTimeStampValues() != null) {
                this.optionalInputs.getAddTimeStampValues().setAddCertificateValues(null);
            }
        } else {
            AddCertificateValuesType addCertificateValuesType;
            this.checkOptionalInputs();
            AddTimeStampValues addTimeStampValues = this.optionalInputs.getAddTimeStampValues();
            if (addTimeStampValues == null) {
                addTimeStampValues = new AddTimeStampValues();
                this.optionalInputs.setAddTimeStampValues(addTimeStampValues);
            }
            if ((addCertificateValuesType = addTimeStampValues.getAddCertificateValues()) == null) {
                addCertificateValuesType = new AddCertificateValuesType();
                addTimeStampValues.setAddCertificateValues(addCertificateValuesType);
            }
            addCertificateValuesType.setBinary(SmartVerifyRequest.isAddBinaryValue(string));
        }
    }

    public void setAddTsaRevocationValues(String string) throws InvalidValueException {
        if (!SmartVerifyRequest.isAddValue(string)) {
            throw new InvalidValueException(string);
        }
        if (SmartVerifyRequest.isAddNoneValue(string)) {
            if (this.optionalInputs != null && this.optionalInputs.getAddTimeStampValues() != null) {
                this.optionalInputs.getAddTimeStampValues().setAddRevocationValues(null);
            }
        } else {
            AddRevocationValuesType addRevocationValuesType;
            this.checkOptionalInputs();
            AddTimeStampValues addTimeStampValues = this.optionalInputs.getAddTimeStampValues();
            if (addTimeStampValues == null) {
                addTimeStampValues = new AddTimeStampValues();
                this.optionalInputs.setAddTimeStampValues(addTimeStampValues);
            }
            if ((addRevocationValuesType = addTimeStampValues.getAddRevocationValues()) == null) {
                addRevocationValuesType = new AddRevocationValuesType();
                addTimeStampValues.setAddRevocationValues(addRevocationValuesType);
            }
            addRevocationValuesType.setBinary(SmartVerifyRequest.isAddBinaryValue(string));
        }
    }

    public void setAddTsChainCertificateValues(String string) throws InvalidValueException {
        if (!SmartVerifyRequest.isAddValue(string)) {
            throw new InvalidValueException(string);
        }
        if (SmartVerifyRequest.isAddNoneValue(string)) {
            if (this.optionalInputs != null && this.optionalInputs.getAddTimeStampValues() != null) {
                this.optionalInputs.getAddTimeStampValues().setAddChainCertificateValues(null);
            }
        } else {
            AddCertificateValuesType addCertificateValuesType;
            this.checkOptionalInputs();
            AddTimeStampValues addTimeStampValues = this.optionalInputs.getAddTimeStampValues();
            if (addTimeStampValues == null) {
                addTimeStampValues = new AddTimeStampValues();
                this.optionalInputs.setAddTimeStampValues(addTimeStampValues);
            }
            if ((addCertificateValuesType = addTimeStampValues.getAddChainCertificateValues()) == null) {
                addCertificateValuesType = new AddCertificateValuesType();
                addTimeStampValues.setAddChainCertificateValues(addCertificateValuesType);
            }
            addCertificateValuesType.setBinary(SmartVerifyRequest.isAddBinaryValue(string));
        }
    }

    public void setAddOtherVerifyResponses(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddOtherVerifyResponses((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddOtherVerifyResponses(null);
        }
    }

    public void setAddRulesInformation(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddRulesInformation((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddRulesInformation(null);
        }
    }

    public void setAddChainCertificateValues(String string) throws InvalidValueException {
        if (!SmartVerifyRequest.isAddValue(string)) {
            throw new InvalidValueException(string);
        }
        if (SmartVerifyRequest.isAddNoneValue(string)) {
            if (this.optionalInputs != null) {
                this.optionalInputs.setAddChainCertificateValues(null);
            }
        } else {
            this.checkOptionalInputs();
            AddCertificateValuesType addCertificateValuesType = new AddCertificateValuesType();
            addCertificateValuesType.setBinary(SmartVerifyRequest.isAddBinaryValue(string));
            this.optionalInputs.setAddChainCertificateValues(addCertificateValuesType);
        }
    }

    public void setAddChainRevocationValues(String string) throws InvalidValueException {
        if (!SmartVerifyRequest.isAddValue(string)) {
            throw new InvalidValueException(string);
        }
        if (SmartVerifyRequest.isAddNoneValue(string)) {
            if (this.optionalInputs != null) {
                this.optionalInputs.setAddChainRevocationValues(null);
            }
        } else {
            this.checkOptionalInputs();
            AddRevocationValuesType addRevocationValuesType = new AddRevocationValuesType();
            addRevocationValuesType.setBinary(SmartVerifyRequest.isAddBinaryValue(string));
            this.optionalInputs.setAddChainRevocationValues(addRevocationValuesType);
        }
    }

    public void setAddSignatureAlgorithm(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddSignatureAlgorithm(new AddSignatureAlgorithm());
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddSignatureAlgorithm(null);
        }
    }

    public void setAddSignedAttributes(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddSignedAttributes(new AddSignedAttributes());
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddSignedAttributes(null);
        }
    }

    public void setAddUnsignedAttributes(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddUnsignedAttributes(new AddUnsignedAttributes());
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddUnsignedAttributes(null);
        }
    }

    public void setSignerCertificate(String string) {
        this.checkOptionalInputs();
        if (this.optionalInputs.getSignersCertificates() != null) {
            SignersCertificates signersCertificates = this.optionalInputs.getSignersCertificates();
            KeyInfoType[] keyInfoTypeArray = signersCertificates.getKeyInfo();
            KeyInfoType[] keyInfoTypeArray2 = new KeyInfoType[keyInfoTypeArray.length + 1];
            KeyInfoType keyInfoType = new KeyInfoType();
            X509DataType x509DataType = new X509DataType();
            keyInfoType.setX509Data(x509DataType);
            x509DataType.setX509Certificate(Base64.decode((String)string));
            for (int i = 0; i < keyInfoTypeArray.length; ++i) {
                keyInfoTypeArray2[i] = keyInfoTypeArray[i];
            }
            keyInfoTypeArray2[keyInfoTypeArray.length] = keyInfoType;
            signersCertificates.setKeyInfo(keyInfoTypeArray);
            this.optionalInputs.setSignersCertificates(signersCertificates);
        } else {
            SignersCertificates signersCertificates = new SignersCertificates();
            KeyInfoType[] keyInfoTypeArray = new KeyInfoType[1];
            KeyInfoType keyInfoType = new KeyInfoType();
            X509DataType x509DataType = new X509DataType();
            keyInfoType.setX509Data(x509DataType);
            x509DataType.setX509Certificate(Base64.decode((String)string));
            keyInfoTypeArray[0] = keyInfoType;
            signersCertificates.setKeyInfo(keyInfoTypeArray);
            this.optionalInputs.setSignersCertificates(signersCertificates);
        }
    }

    public void setXmlReturnBase64(boolean bl) {
        this.userHasCallXmlReturnBase64 = bl;
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setReturnBase64XML((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setReturnBase64XML(null);
        }
    }

    public void setInputXmlData(String string) throws Exception {
        if (SmartVerifyRequest.isBig(string)) {
            if (this.xmlFileToDelete != null) {
                this.removeReference(this.xmlFileToDelete);
                this.xmlFileToDelete = null;
            }
            this.xmlFileToDelete = this.setReferenceContent(string.getBytes());
            this.setInputXmlBase64File(Base64.encode((byte[])this.xmlFileToDelete.getBytes()), "raw");
        } else {
            this.setInputXmlBase64(Base64.encode((byte[])string.getBytes("UTF-8")));
        }
    }

    public void setInputXmlBase64(String string) throws ConfigurationException {
        this._setInputXmlBase64(string, "string", "base64");
    }

    public void setInputXmlBase64File(String string, String string2) throws ConfigurationException {
        this._setInputXmlBase64(string, "file", string2);
    }

    void _setInputXmlBase64(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Base64XML", string2, string3);
        this.checkInputDocuments();
        Document document = new Document();
        if (this.inputDocs.getDocument() != null) {
            document = this.inputDocs.getDocument();
        }
        document.setBase64XML(Base64.decode((String)string));
        this.inputDocs.setDocument(document);
    }

    public void setSignatureXml(String string) throws Exception {
        if (SmartVerifyRequest.isBig(string)) {
            if (this.signatureFileToDelete != null) {
                this.removeReference(this.signatureFileToDelete);
                this.signatureFileToDelete = null;
            }
            this.signatureFileToDelete = this.setReferenceContent(string.getBytes());
            this.setSignatureXmlBase64File(Base64.encode((byte[])this.signatureFileToDelete.getBytes()), "raw");
        } else {
            this.setSignatureXmlBase64(Base64.encode((byte[])string.getBytes("UTF-8")));
        }
    }

    public void setSignatureXmlBase64(String string) throws ConfigurationException {
        this._setSignatureXmlBase64(string, "string", "base64");
    }

    public void setSignatureXmlBase64File(String string, String string2) throws ConfigurationException {
        this._setSignatureXmlBase64(string, "file", string2);
    }

    void _setSignatureXmlBase64(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Base64XMLSignature", string2, string3);
        SignatureObject signatureObject = new SignatureObject();
        signatureObject.setBase64XMLSignature(new Base64Binary(string));
        this.request.setSignatureObject(signatureObject);
    }

    public void setInputRefUri(String string) throws URI.MalformedURIException {
        this.checkInputDocuments();
        if (this.inputDocs.getDocument() != null) {
            Document document = this.inputDocs.getDocument();
            document.setRefURI(string);
            this.inputDocs.setDocument(document);
        } else {
            Document document = new Document();
            document.setRefURI(string);
            this.inputDocs.setDocument(document);
        }
    }

    public void setInputXmlData(String string, String string2) throws Exception {
        if (SmartVerifyRequest.isBig(string)) {
            if (this.xmlFileToDelete != null) {
                this.removeReference(this.xmlFileToDelete);
                this.xmlFileToDelete = null;
            }
            this.xmlFileToDelete = this.setReferenceContent(string.getBytes());
            this._setInputXmlBase64Uri(Base64.encode((byte[])this.xmlFileToDelete.getBytes()), "file", "raw", string2);
        } else {
            this._setInputXmlBase64Uri(string, "string", "base64", string2);
        }
    }

    public void setInputXmlBase64(String string, String string2) throws Exception {
        this._setInputXmlBase64Uri(string, "string", "base64", string2);
    }

    public void setInputXmlBase64File(String string, String string2, String string3) throws Exception {
        this._setInputXmlBase64Uri(string, "file", string2, string3);
    }

    void _setInputXmlBase64Uri(String string, String string2, String string3, String string4) throws Exception {
        this.fileRequestTag("Base64XML", string2, string3);
        this.checkInputDocuments();
        if (this.inputDocs.getDocument() == null) {
            Document document = new Document();
            document.setBase64XML(Base64.decode((String)string));
            document.setRefURI(string4);
            this.inputDocs.setDocument(document);
        } else {
            Document document = this.inputDocs.getDocument();
            document.setBase64XML(Base64.decode((String)string));
            document.setRefURI(string4);
            this.inputDocs.setDocument(document);
        }
    }

    public void setInputXmlBase64Item(int n, String string) throws Exception {
        this._setInputXmlBase64Item(n, string, null);
    }

    public void setInputXmlBase64Item(int n, String string, String string2) throws Exception {
        this._setInputXmlBase64Item(n, string, string2);
    }

    void _setInputXmlBase64Item(int n, String string, String string2) throws Exception {
        this.fileRequestTag("Base64XML", "string", "base64");
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        if (this.inputDocs.getDocumentItem().length > n) {
            documentItem = this.inputDocs.getDocumentItem(n);
        }
        documentItem.setBase64XML(Base64.decode((String)string));
        if (string2 != null) {
            documentItem.setRefURI(string2);
        }
        this._setInputDocumentItem(n, documentItem);
    }

    public void setInputXmlBase64FileItem(int n, String string, String string2) throws Exception {
        this._setInputXmlBase64FileItem(n, string, string2, null);
    }

    public void setInputXmlBase64FileItem(int n, String string, String string2, String string3) throws Exception {
        this._setInputXmlBase64FileItem(n, string, string2, string3);
    }

    void _setInputXmlBase64FileItem(int n, String string, String string2, String string3) throws Exception {
        this.fileRequestTag("Base64XML", "file", string2);
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        if (this.inputDocs.getDocumentItem().length > n) {
            documentItem = this.inputDocs.getDocumentItem(n);
        }
        documentItem.setBase64XML(Base64.decode((String)string));
        if (string3 != null) {
            documentItem.setRefURI(string3);
        }
        this._setInputDocumentItem(n, documentItem);
    }

    void _setInputDocumentItem(int n, DocumentItem documentItem) throws Exception {
        this.checkInputDocuments();
        if (this.inputDocs.getDocumentItem() == null && n == 0) {
            this.inputDocs.setDocumentItem(new DocumentItem[]{documentItem});
        } else if (this.inputDocs.getDocumentItem().length > n) {
            DocumentItem documentItem2 = this.inputDocs.getDocumentItem(n);
            if (documentItem2.getRefURI() != null && documentItem.getRefURI() == null) {
                documentItem.setRefURI(documentItem2.getRefURI());
            }
            this.inputDocs.setDocumentItem(n, documentItem);
        } else if (this.inputDocs.getDocumentItem().length == n) {
            DocumentItem[] documentItemArray = this.inputDocs.getDocumentItem();
            DocumentItem[] documentItemArray2 = new DocumentItem[n + 1];
            for (int i = 0; i < n; ++i) {
                documentItemArray2[i] = documentItemArray[i];
            }
            documentItemArray2[n] = documentItem;
            this.inputDocs.setDocumentItem(documentItemArray2);
        } else {
            throw new Exception("Index out of bounds");
        }
    }

    public void setInputRefUriItem(int n, String string) throws Exception {
        this.checkInputDocuments();
        if (this.inputDocs.getDocumentItem() == null && n == 0) {
            DocumentItem documentItem = new DocumentItem();
            documentItem.setRefURI(string);
            this.inputDocs.setDocumentItem(new DocumentItem[]{documentItem});
        } else if (this.inputDocs.getDocumentItem().length > n) {
            DocumentItem documentItem = this.inputDocs.getDocumentItem(n);
            documentItem.setRefURI(string);
            this.inputDocs.setDocumentItem(n, documentItem);
        } else if (this.inputDocs.getDocumentItem().length == n) {
            DocumentItem documentItem = new DocumentItem();
            documentItem.setRefURI(string);
            DocumentItem[] documentItemArray = this.inputDocs.getDocumentItem();
            DocumentItem[] documentItemArray2 = new DocumentItem[n + 1];
            for (int i = 0; i < n; ++i) {
                documentItemArray2[i] = documentItemArray[i];
            }
            documentItemArray2[n] = documentItem;
            this.inputDocs.setDocumentItem(documentItemArray2);
        } else {
            throw new Exception("Index out of bounds");
        }
    }

    public void setInputXmlBase64Item(String string) throws Exception {
        this._setInputXmlBase64Item(string, "string", "base64", null);
    }

    public void setInputXmlBase64Item(String string, String string2) throws Exception {
        this._setInputXmlBase64Item(string, "string", "base64", string2);
    }

    public void setInputXmlBase64FileItem(String string, String string2) throws Exception {
        this._setInputXmlBase64Item(string, "file", string2, null);
    }

    public void setInputXmlBase64FileItem(String string, String string2, String string3) throws Exception {
        this._setInputXmlBase64Item(string, "file", string2, string3);
    }

    void _setInputXmlBase64Item(String string, String string2, String string3, String string4) throws Exception {
        this.fileRequestTag("Base64XML", string2, string3);
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        documentItem.setBase64XML(Base64.decode((String)string));
        if (string4 != null) {
            documentItem.setRefURI(string4);
        }
        if (this.inputDocs.getDocumentItem() == null) {
            this._setInputDocumentItem(0, documentItem);
        } else {
            this._setInputDocumentItem(this.inputDocs.getDocumentItem().length, documentItem);
        }
    }

    public void setInputXmlDataItem(int n, String string) throws Exception {
        this._setInputXmlDataItem(n, string, null);
    }

    public void setInputXmlDataItem(int n, String string, String string2) throws Exception {
        this._setInputXmlDataItem(n, string, string2);
    }

    void _setInputXmlDataItem(int n, String string, String string2) throws Exception {
        if (SmartVerifyRequest.isBig(string)) {
            if (this.xmlFileToDelete != null) {
                this.removeReference(this.xmlFileToDelete);
                this.xmlFileToDelete = null;
            }
            this.xmlFileToDelete = this.setReferenceContent(string.getBytes());
            this.setInputXmlBase64FileItem(n, Base64.encode((byte[])this.xmlFileToDelete.getBytes()), "raw", string2);
        } else {
            this.setInputXmlBase64Item(n, Base64.encode((byte[])string.getBytes("UTF-8")), string2);
        }
    }

    public void setInputXmlDataItem(String string) throws Exception {
        this._setInputXmlDataItem(string, null);
    }

    public void setInputXmlDataItem(String string, String string2) throws Exception {
        this._setInputXmlDataItem(string, string2);
    }

    void _setInputXmlDataItem(String string, String string2) throws Exception {
        if (SmartVerifyRequest.isBig(string)) {
            if (this.xmlFileToDelete != null) {
                this.removeReference(this.xmlFileToDelete);
                this.xmlFileToDelete = null;
            }
            this.xmlFileToDelete = this.setReferenceContent(string.getBytes());
            this.setInputXmlBase64FileItem(Base64.encode((byte[])this.xmlFileToDelete.getBytes()), "raw", string2);
        } else {
            this.setInputXmlBase64Item(Base64.encode((byte[])string.getBytes("UTF-8")), string2);
        }
    }

    public void setInputBase64DataItem(int n, String string) throws Exception {
        this._setInputBase64DataItem(n, string, null);
    }

    public void setInputBase64DataItem(int n, String string, String string2) throws Exception {
        this._setInputBase64DataItem(n, string, string2);
    }

    void _setInputBase64DataItem(int n, String string, String string2) throws Exception {
        this.fileRequestTag("Base64Data", "string", "base64");
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        if (this.inputDocs.getDocumentItem().length > n) {
            documentItem = this.inputDocs.getDocumentItem(n);
        }
        documentItem.setBase64Data(new Base64Data(string));
        if (string2 != null) {
            documentItem.setRefURI(string2);
        }
        this._setInputDocumentItem(n, documentItem);
    }

    public void setInputBase64DataItem(String string) throws Exception {
        this._setInputBase64DataItem(string, "string", "base64", null);
    }

    public void setInputBase64DataItem(String string, String string2) throws Exception {
        this._setInputBase64DataItem(string, "string", "base64", string2);
    }

    public void setInputBase64DataFileItem(int n, String string, String string2) throws Exception {
        this._setInputBase64DataFileItem(n, string, string2, null);
    }

    public void setInputBase64DataFileItem(int n, String string, String string2, String string3) throws Exception {
        this._setInputBase64DataFileItem(n, string, string2, string3);
    }

    void _setInputBase64DataFileItem(int n, String string, String string2, String string3) throws Exception {
        this.fileRequestTag("Base64Data", "file", string2);
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        if (this.inputDocs.getDocumentItem().length > n) {
            documentItem = this.inputDocs.getDocumentItem(n);
        }
        documentItem.setBase64Data(new Base64Data(string));
        if (string3 != null) {
            documentItem.setRefURI(string3);
        }
        this._setInputDocumentItem(n, documentItem);
    }

    public void setInputBase64DataFileItem(String string, String string2) throws Exception {
        this._setInputBase64DataItem(string, "file", string2, null);
    }

    public void setInputBase64DataFileItem(String string, String string2, String string3) throws Exception {
        this._setInputBase64DataItem(string, "file", string2, string3);
    }

    void _setInputBase64DataItem(String string, String string2, String string3, String string4) throws Exception {
        this.fileRequestTag("Base64Data", string2, string3);
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        documentItem.setBase64Data(new Base64Data(string));
        if (string4 != null) {
            documentItem.setRefURI(string4);
        }
        if (this.inputDocs.getDocumentItem() == null) {
            this._setInputDocumentItem(0, documentItem);
        } else {
            this._setInputDocumentItem(this.inputDocs.getDocumentItem().length, documentItem);
        }
    }

    public void setReturnSigningDocument(String string) throws InvalidValueException {
        if (!("none".equals(string) || "xml".equals(string) || "base64".equals(string))) {
            throw new InvalidValueException(string);
        }
        if ("none".equals(string)) {
            if (this.optionalInputs != null) {
                this.optionalInputs.setReturnSigningDocument(null);
                this.optionalInputs.setReturnBase64XML(null);
            }
        } else {
            this.checkOptionalInputs();
            this.optionalInputs.setReturnSigningDocument((Object)"");
            if ("base64".equals(string)) {
                this.userHasCallXmlReturnBase64 = true;
                this.optionalInputs.setReturnBase64XML((Object)"");
            }
        }
    }

    public void setReturnSignedDocuments(String string) throws InvalidValueException {
        if (!("none".equals(string) || "xml".equals(string) || "base64".equals(string))) {
            throw new InvalidValueException(string);
        }
        if ("none".equals(string)) {
            if (this.optionalInputs != null) {
                this.optionalInputs.setReturnSignedDocuments(null);
                this.optionalInputs.setReturnBase64XML(null);
            }
        } else {
            this.checkOptionalInputs();
            this.optionalInputs.setReturnSignedDocuments(new ReturnSignedDocuments());
            if ("base64".equals(string)) {
                this.userHasCallXmlReturnBase64 = true;
                this.optionalInputs.setReturnBase64XML((Object)"");
            }
        }
    }

    public void setXmlIncludeManifests(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setIncludeManifests(new IncludeManifests());
        } else if (this.optionalInputs != null && this.optionalInputs.getIncludeManifests() != null) {
            this.optionalInputs.setIncludeManifests(null);
        }
    }

    public void setXmlSignedReference(String string) throws InvalidValueException {
        this.checkOptionalInputs();
        SignedReferences signedReferences = new SignedReferences();
        int n = 1;
        if (signedReferences.getReference() != null) {
            n = signedReferences.getReference().length + 1;
        }
        Reference[] referenceArray = new Reference[n];
        if (signedReferences.getReference() != null) {
            for (int i = 0; i < signedReferences.getReference().length; ++i) {
                referenceArray[i] = signedReferences.getReference(i);
            }
        }
        try {
            referenceArray[n - 1] = new Reference(new URI(string));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
        signedReferences.setReference(referenceArray);
        this.optionalInputs.setSignedReferences(signedReferences);
    }

    public void setSignatureMime(String string) throws ConfigurationException {
        this._setSignatureMime(string, "string", "base64");
    }

    public void setSignatureMimeFile(String string, String string2) throws ConfigurationException {
        this._setSignatureMime(string, "file", string2);
    }

    void _setSignatureMime(String string, String string2, String string3) throws ConfigurationException {
        MimeSignature mimeSignature;
        this.fileRequestTag("MimeSignature", string2, string3);
        SignatureObject signatureObject = this.request.getSignatureObject();
        if (signatureObject == null) {
            signatureObject = new SignatureObject();
            this.request.setSignatureObject(signatureObject);
        }
        if ((mimeSignature = signatureObject.getMimeSignature()) == null) {
            mimeSignature = new MimeSignature(string);
            signatureObject.setMimeSignature(mimeSignature);
            try {
                this.setSignatureMimeType(DEFAULT_SIGNATUREMIMETYPE);
            }
            catch (InvalidValueException invalidValueException) {
                invalidValueException.printStackTrace();
            }
        } else {
            mimeSignature = new MimeSignature(string);
            URI uRI = mimeSignature.getType();
            if (uRI != null) {
                mimeSignature.setType(uRI);
            }
            signatureObject.setMimeSignature(mimeSignature);
        }
    }

    public void setSignatureMimeType(String string) throws InvalidValueException {
        MimeSignature mimeSignature;
        URI uRI;
        String string2 = Translate.putSignatureType(string);
        if (string2 == null) {
            string2 = string;
        }
        try {
            uRI = new URI(string2);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
        SignatureObject signatureObject = this.request.getSignatureObject();
        if (signatureObject == null) {
            signatureObject = new SignatureObject();
            this.request.setSignatureObject(signatureObject);
        }
        if ((mimeSignature = signatureObject.getMimeSignature()) == null) {
            mimeSignature = new MimeSignature();
            signatureObject.setMimeSignature(mimeSignature);
        }
        mimeSignature.setType(uRI);
    }

    public void setAdditionalProfile(String string) throws InvalidValueException {
        String string2 = Translate.putProfileDsv(string);
        if (string2 == null) {
            string2 = string;
        }
        this.checkOptionalInputs();
        try {
            this.optionalInputs.setAdditionalProfile(new URI(string2));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
    }

    public void setTimeStamp(String string) {
        Timestamp timestamp = new Timestamp();
        timestamp.setRFC3161TimeStampToken(Base64.decode((String)string));
        SignatureObject signatureObject = new SignatureObject();
        signatureObject.setTimestamp(timestamp);
        this.request.setSignatureObject(signatureObject);
    }

    public void setInputPdfBase64Data(String string) throws ConfigurationException {
        this._setInputPdfBase64Data(string, "string", "base64");
    }

    public void setInputPdfBase64DataFile(String string, String string2) throws ConfigurationException {
        this._setInputPdfBase64Data(string, "file", string2);
    }

    void _setInputPdfBase64Data(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Base64Data", string2, string3);
        this.checkInputDocuments();
        Document document = new Document();
        Base64Data base64Data = new Base64Data(string);
        base64Data.setMimeType("application/pdf");
        document.setBase64Data(base64Data);
        this.inputDocs.setDocument(document);
    }

    public void setPdfVerifyNumberSignature(int n) throws InvalidValueException {
        if (n <= 0) {
            throw new InvalidValueException("" + n);
        }
        this.checkOptionalInputs();
        this.optionalInputs.setNumberPdfSignature(new BigInteger("" + n));
    }

    public void setPdfVerifyLastSignature(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setVerifyLastSignature((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setVerifyLastSignature(null);
        }
    }

    public void setPdfVerifyField(String string) {
        this.checkOptionalInputs();
        ToBeVerifiedFields toBeVerifiedFields = this.optionalInputs.getToBeVerifiedFields();
        if (toBeVerifiedFields == null) {
            toBeVerifiedFields = new ToBeVerifiedFields();
            this.optionalInputs.setToBeVerifiedFields(toBeVerifiedFields);
        }
        PDFFieldType[] pDFFieldTypeArray = toBeVerifiedFields.getField();
        int n = 1;
        if (pDFFieldTypeArray != null) {
            n = pDFFieldTypeArray.length + 1;
        }
        PDFFieldType[] pDFFieldTypeArray2 = new PDFFieldType[n];
        if (pDFFieldTypeArray != null) {
            for (int i = 0; i < pDFFieldTypeArray.length; ++i) {
                pDFFieldTypeArray2[i] = pDFFieldTypeArray[i];
            }
        }
        pDFFieldTypeArray2[n - 1] = new PDFFieldType(string);
        toBeVerifiedFields.setField(pDFFieldTypeArray2);
    }

    public void setPdfAddSignatureInfo(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddPdfSignatureInfo((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddPdfSignatureInfo(null);
        }
    }

    public void setPdfAddSignatureFieldsInfo(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddSignatureFieldsInfo((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddSignatureFieldsInfo(null);
        }
    }

    public void setAddSignatureType(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setAddSignatureType(new AddSignatureType());
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setAddSignatureType(null);
        }
    }

    public void setSignatureType(String string) throws InvalidValueException {
        String string2 = Translate.putSignatureType(string);
        if (string2 == null) {
            string2 = string;
        }
        this.checkOptionalInputs();
        try {
            this.optionalInputs.setSignatureType(new URI(string2));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
    }

    public void setSignatureSelection(SmartSignatureSelection smartSignatureSelection) {
        this.checkOptionalInputs();
        MultiSignatureSelectionSignatureSelection[] multiSignatureSelectionSignatureSelectionArray = null;
        MultiSignatureSelectionSignatureSelection[] multiSignatureSelectionSignatureSelectionArray2 = null;
        if (this.optionalInputs.getMultiSignatureSelection() == null) {
            this.optionalInputs.setMultiSignatureSelection(new MultiSignatureSelection());
        }
        if (this.optionalInputs.getMultiSignatureSelection().getSignatureSelection() != null) {
            multiSignatureSelectionSignatureSelectionArray = this.optionalInputs.getMultiSignatureSelection().getSignatureSelection();
            int n = multiSignatureSelectionSignatureSelectionArray.length;
            multiSignatureSelectionSignatureSelectionArray2 = new MultiSignatureSelectionSignatureSelection[n + 1];
            for (int i = 0; i < n; ++i) {
                multiSignatureSelectionSignatureSelectionArray2[i] = multiSignatureSelectionSignatureSelectionArray[i];
            }
            multiSignatureSelectionSignatureSelectionArray2[n] = (MultiSignatureSelectionSignatureSelection)smartSignatureSelection.getInternalObject();
        } else {
            multiSignatureSelectionSignatureSelectionArray2 = new MultiSignatureSelectionSignatureSelection[]{(MultiSignatureSelectionSignatureSelection)smartSignatureSelection.getInternalObject()};
        }
        this.optionalInputs.getMultiSignatureSelection().setSignatureSelection(multiSignatureSelectionSignatureSelectionArray2);
    }

    public void setAddNewTimeStampValues(String string) throws InvalidValueException {
        if (!SmartVerifyRequest.isAddValue(string) || SmartVerifyRequest.isAddBinaryValue(string)) {
            throw new InvalidValueException(string);
        }
        if (SmartVerifyRequest.isAddNoneValue(string)) {
            if (this.optionalInputs != null) {
                this.optionalInputs.setAddNewTimeStampValues(null);
            }
        } else {
            this.checkOptionalInputs();
            this.optionalInputs.setAddNewTimeStampValues((Object)"");
        }
    }

    public void setReturnUpdatedSignature(String string) throws InvalidValueException {
        String string2 = Translate.putSignatureFormat(string);
        if (string2 == null) {
            string2 = string;
        }
        URI uRI = null;
        try {
            uRI = new URI(string2);
        }
        catch (URI.MalformedURIException malformedURIException) {
            malformedURIException.printStackTrace();
        }
        this.checkOptionalInputs();
        ReturnUpdatedSignature returnUpdatedSignature = new ReturnUpdatedSignature();
        returnUpdatedSignature.setType(uRI);
        this.optionalInputs.setReturnUpdatedSignature(returnUpdatedSignature);
    }

    public void setHeader(SmartHeader smartHeader) {
        if (this.bindingDsv != null) {
            this.bindingDsv.setHeader(smartHeader.getInternalObject());
        }
        if (this.bindingDr != null) {
            this.bindingDr.setHeader(smartHeader.getInternalObject());
        }
    }

    String getProfile() {
        if (this.request != null && this.request.getProfile() != null) {
            String string = this.request.getProfile().toString();
            String string2 = Translate.getProfile(string);
            if (string2 != null) {
                string = string2;
            }
            return string;
        }
        return null;
    }

    boolean isXmlRequest() {
        return this.request.getInputDocuments() != null && this.request.getInputDocuments().getDocument() != null && this.request.getInputDocuments().getDocument().getBase64XML() != null || this.request.getSignatureObject() != null && this.request.getSignatureObject().getBase64XMLSignature() != null;
    }

    boolean apiShouldCallToXmlReturnBase64() {
        String string = this.getProfile();
        return this.bindingDr != null && !this.userHasCallXmlReturnBase64 && ("xades".equals(string) || "wss".equals(string) || "nonrep".equals(string) && this.isXmlRequest());
    }

    void fillRequest() {
        if (!this.userHasCallRequestId) {
            this.setRequestId(this.getRandomString());
            this.userHasCallRequestId = false;
        }
        if (this.apiShouldCallToXmlReturnBase64()) {
            this.checkOptionalInputs();
            this.optionalInputs.setReturnBase64XML((Object)"");
        }
    }

    public SmartVerifyResponse send() throws Exception {
        this.fillRequest();
        VerifyResponse verifyResponse = null;
        Hashtable hashtable = null;
        Message message = null;
        if (this.bindingDsv != null) {
            verifyResponse = this.bindingDsv.verify(this.request);
            message = this.bindingDsv._getCall().getResponseMessage();
        }
        if (this.bindingDr != null) {
            verifyResponse = this.bindingDr.update(this.request);
            message = this.bindingDr._getCall().getResponseMessage();
        }
        hashtable = this.getOptions();
        Node node = null;
        if (message != null) {
            node = SmartWrapperUtil.getXmlBodyNode(message, "VerifyResponse");
        }
        SmartVerifyResponse smartVerifyResponse = new SmartVerifyResponse(verifyResponse, hashtable, node);
        if (this.apiShouldCallToXmlReturnBase64()) {
            smartVerifyResponse.setSignatureB64AsXml(true);
        }
        return smartVerifyResponse;
    }

    static boolean isAddValue(String string) {
        return "none".equals(string) || "simple".equals(string) || "binary".equals(string);
    }

    static boolean isAddNoneValue(String string) {
        return "none".equals(string);
    }

    static boolean isAddBinaryValue(String string) {
        return "binary".equals(string);
    }

    Hashtable getOptions() throws ConfigurationException {
        try {
            if (this.bindingDsv != null) {
                if (this.bindingDsv._getCall() != null) {
                    String string = this.bindingDsv._getCall().getMessageContext().getTransportName();
                    TWSDSVLocator tWSDSVLocator = (TWSDSVLocator)this.bindingDsv._getService();
                    return SmartWrapperUtil.getTransportOptions(tWSDSVLocator.getEngine(), string);
                }
                TWSDSVLocator tWSDSVLocator = (TWSDSVLocator)this.bindingDsv._getService();
                return tWSDSVLocator.getEngine().getConfig().getHandler(new QName("sender")).getOptions();
            }
            if (this.bindingDr != null) {
                if (this.bindingDr._getCall() != null) {
                    String string = this.bindingDr._getCall().getMessageContext().getTransportName();
                    TWSDRLocator tWSDRLocator = (TWSDRLocator)this.bindingDr._getService();
                    return SmartWrapperUtil.getTransportOptions(tWSDRLocator.getEngine(), string);
                }
                TWSDRLocator tWSDRLocator = (TWSDRLocator)this.bindingDr._getService();
                return tWSDRLocator.getEngine().getConfig().getHandler(new QName("sender")).getOptions();
            }
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
        return null;
    }

    EngineConfiguration getConfig() {
        if (this.bindingDsv != null) {
            TWSDSVLocator tWSDSVLocator = (TWSDSVLocator)this.bindingDsv._getService();
            return tWSDSVLocator.getEngine().getConfig();
        }
        if (this.bindingDr != null) {
            TWSDRLocator tWSDRLocator = (TWSDRLocator)this.bindingDr._getService();
            return tWSDRLocator.getEngine().getConfig();
        }
        return null;
    }

    protected void finalize() {
        if (this.signatureFileToDelete != null) {
            this.removeReference(this.signatureFileToDelete);
            this.signatureFileToDelete = null;
        }
        if (this.xmlFileToDelete != null) {
            this.removeReference(this.xmlFileToDelete);
            this.xmlFileToDelete = null;
        }
    }

    public void enableDocumentBase64DataFile(String string) throws ConfigurationException {
        this.fileResponseTag("Base64Data", "file", string);
    }

    public void enableDocumentMimeFile(String string) throws ConfigurationException {
        this.fileResponseTag("Mime", "file", string);
    }

    public void enableDocumentWithSignatureXmlBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Base64XML", "file", string);
    }

    public void enableDocumentXmlBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Base64XML", "file", string);
    }

    public void enableSignatureBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Base64Signature", "file", string);
    }

    public void enableSignatureMimeFile(String string) throws ConfigurationException {
        this.fileResponseTag("MimeSignature", "file", string);
    }

    public void enableSignatureXmlBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Base64XMLSignature", "file", string);
    }

    public void enableDocumentWithSignaturePdfFile(String string) throws ConfigurationException {
        this.fileResponseTag("Base64Data", "file", string);
    }

    public void enableDigestPdfFile(String string) throws ConfigurationException {
        this.fileResponseTag("Base64Data", "file", string);
    }

    public void disableDocumentBase64DataFile() throws ConfigurationException {
        this.fileResponseTag("Base64Data", "string", "base64");
    }

    public void disableDocumentMimeFile() throws ConfigurationException {
        this.fileResponseTag("Mime", "string", "base64");
    }

    public void disableDocumentWithSignatureXmlBase64File() throws ConfigurationException {
        this.fileResponseTag("Base64XML", "string", "base64");
    }

    public void disableDocumentXmlBase64File() throws ConfigurationException {
        this.fileResponseTag("Base64XML", "string", "base64");
    }

    public void disableSignatureBase64File() throws ConfigurationException {
        this.fileResponseTag("Base64Signature", "string", "base64");
    }

    public void disableSignatureMimeFile() throws ConfigurationException {
        this.fileResponseTag("MimeSignature", "string", "base64");
    }

    public void disableSignatureXmlBase64File() throws ConfigurationException {
        this.fileResponseTag("Base64XMLSignature", "string", "base64");
    }

    public void disableDocumentWithSignaturePdfFile() throws ConfigurationException {
        this.fileResponseTag("Base64Data", "string", "base64");
    }

    public void disableDigestPdfFile() throws ConfigurationException {
        this.fileResponseTag("Base64Data", "string", "base64");
    }

    public static interface Service {
        public static final String DSV = "dsv";
        public static final String DR = "dr";
    }
}

