/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.SmartChain;
import com.safelayer.trustedx.client.smartwrapper.SmartCrl;
import com.safelayer.trustedx.client.smartwrapper.SmartOcsp;
import com.safelayer.trustedx.client.smartwrapper.SmartSignatureResult;
import com.safelayer.trustedx.client.smartwrapper.SmartVa;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.www.TWS.Base64Binary;
import com.safelayer.www.TWS.CertificateType;
import com.safelayer.www.TWS.TimeStampValueType;
import org.w3c.dom.Node;

public class SmartStamp {
    private TimeStampValueType obj;
    private Node node;

    SmartStamp(TimeStampValueType timeStampValueType, Node node) {
        this.obj = timeStampValueType;
        this.node = node;
    }

    public String getResultMajor() {
        return this.obj.getResult().getResultMajor().toString();
    }

    public String getResultMinor() {
        if (this.obj != null && this.obj.getResult().getResultMinor() != null) {
            return this.obj.getResult().getResultMinor().toString();
        }
        return null;
    }

    public String getResultMessage() {
        if (this.obj != null && this.obj.getResult().getResultMessage() != null) {
            return this.obj.getResult().getResultMessage().get_value();
        }
        return null;
    }

    public int getTrustLevel() {
        if (this.obj != null && this.obj.getTrustInfo() != null) {
            return this.obj.getTrustInfo().getTrustLevel().intValue();
        }
        return 0;
    }

    public String getTrustLabel() {
        if (this.obj != null && this.obj.getTrustInfo() != null) {
            return this.obj.getTrustInfo().getTrustLabel();
        }
        return null;
    }

    public String getInfoXml() throws Exception {
        if (this.obj != null && this.obj.getTstInfo() != null) {
            return SmartWrapperUtil.serialize(this.node, "/dss:TstInfo");
        }
        return null;
    }

    public String getInfoBinary() {
        if (this.obj != null && this.obj.getRFC3161TimeStampToken() != null) {
            return this.obj.getRFC3161TimeStampToken().toString();
        }
        return null;
    }

    public String getTsaCertificateXml() throws Exception {
        if (this.obj != null && this.obj.getTSACert() != null && this.obj.getTSACert().getCertificate() != null) {
            return SmartWrapperUtil.serialize(this.node, "/css:TSACert/css:certificate");
        }
        return null;
    }

    public String getTsaCertificateBinary() {
        if (this.obj != null && this.obj.getTSACert() != null && this.obj.getTSACert().getEncapsulatedX509Certificate() != null) {
            return this.obj.getTSACert().getEncapsulatedX509Certificate().toString();
        }
        return null;
    }

    public int getNumberCrls() {
        int n = 0;
        if (this.obj != null && this.obj.getRevocationValues() != null && this.obj.getRevocationValues().getOtherValues() != null) {
            n = SmartSignatureResult.getNumberCrls(this.obj.getRevocationValues().getOtherValues().get_any());
        }
        return n;
    }

    public int getNumberOcsp() {
        int n = 0;
        if (this.obj != null && this.obj.getRevocationValues() != null && this.obj.getRevocationValues().getOtherValues() != null) {
            n = SmartSignatureResult.getNumberOcsp(this.obj.getRevocationValues().getOtherValues().get_any());
        }
        return n;
    }

    public int getNumberVa() {
        int n = 0;
        if (this.obj != null && this.obj.getRevocationValues() != null && this.obj.getRevocationValues().getOtherValues() != null) {
            n = SmartSignatureResult.getNumberVas(this.obj.getRevocationValues().getOtherValues().get_any());
        }
        return n;
    }

    public SmartCrl getCrl(int n) throws IndexOutOfBoundsException {
        if (this.obj != null && this.obj.getRevocationValues() != null) {
            return SmartSignatureResult.getCrl(this.obj.getRevocationValues(), n);
        }
        return null;
    }

    public SmartOcsp getOcsp(int n) throws IndexOutOfBoundsException {
        if (this.obj != null && this.obj.getRevocationValues() != null) {
            return SmartSignatureResult.getOcsp(this.obj.getRevocationValues(), n);
        }
        return null;
    }

    public SmartVa getVa(int n) throws IndexOutOfBoundsException {
        if (this.obj != null && this.obj.getRevocationValues() != null) {
            return SmartSignatureResult.getVa(this.obj.getRevocationValues(), n);
        }
        return null;
    }

    public int getNumberChainCas() {
        int n = 0;
        if (this.obj != null && this.obj.getTSACertChain() != null && this.obj.getTSACertChain().getCertificateValues() != null && this.obj.getTSACertChain().getCertificateValues().getCertificateList() != null && this.obj.getTSACertChain().getCertificateValues().getCertificateList().getCertificate() != null) {
            n = this.obj.getTSACertChain().getCertificateValues().getCertificateList().getCertificate().length;
        }
        return n;
    }

    public SmartChain getChain(int n) throws IndexOutOfBoundsException {
        CertificateType certificateType = null;
        Base64Binary base64Binary = null;
        if (this.obj != null && this.obj.getTSACertChain() != null && this.obj.getTSACertChain().getCertificateValues() != null && this.obj.getTSACertChain().getCertificateValues().getCertificateList() != null && this.obj.getTSACertChain().getCertificateValues().getCertificateList().getCertificate() != null) {
            certificateType = this.obj.getTSACertChain().getCertificateValues().getCertificateList().getCertificate(n);
        }
        if (this.obj != null && this.obj.getTSACertChain() != null && this.obj.getTSACertChain().getCertificateValues() != null && this.obj.getTSACertChain().getCertificateValues().getEncodedValues() != null && this.obj.getTSACertChain().getCertificateValues().getEncodedValues().getEncapsulatedX509Certificate() != null) {
            base64Binary = this.obj.getTSACertChain().getCertificateValues().getEncodedValues().getEncapsulatedX509Certificate(n);
        }
        if (certificateType != null || base64Binary != null) {
            return new SmartChain(certificateType, base64Binary, SmartWrapperUtil.getXmlNode(this.node, "/css:TSACertChain/css:CertificateValues/css:CertificateList/css:certificate(" + n + ")"));
        }
        return null;
    }

    public String getChainCasXml() throws Exception {
        if (this.obj != null && this.obj.getTSACertChain() != null && this.obj.getTSACertChain().getCertificateValues() != null && this.obj.getTSACertChain().getCertificateValues().getCertificateList() != null) {
            return SmartWrapperUtil.serialize(this.node, "/css:TSACertChain/css:CertificateValues/css:CertificateList");
        }
        return null;
    }

    public String getChainCasBinary() throws Exception {
        if (this.obj != null && this.obj.getTSACertChain() != null && this.obj.getTSACertChain().getCertificateValues() != null && this.obj.getTSACertChain().getCertificateValues().getEncodedValues() != null) {
            return SmartWrapperUtil.serialize(this.node, "/css:TSACertChain/css:CertificateValues/css:EncodedValues");
        }
        return null;
    }

    public int getNumberArchivedCrls() {
        int n = 0;
        if (this.obj != null && this.obj.getArchivedRevocationValues() != null && this.obj.getArchivedRevocationValues().getOtherValues() != null) {
            n = SmartSignatureResult.getNumberCrls(this.obj.getArchivedRevocationValues().getOtherValues().get_any());
        }
        return n;
    }

    public int getNumberArchivedOcsp() {
        int n = 0;
        if (this.obj != null && this.obj.getArchivedRevocationValues() != null && this.obj.getArchivedRevocationValues().getOtherValues() != null) {
            n = SmartSignatureResult.getNumberOcsp(this.obj.getArchivedRevocationValues().getOtherValues().get_any());
        }
        return n;
    }

    public int getNumberArchivedVa() {
        int n = 0;
        if (this.obj != null && this.obj.getArchivedRevocationValues() != null && this.obj.getArchivedRevocationValues().getOtherValues() != null) {
            n = SmartSignatureResult.getNumberVas(this.obj.getArchivedRevocationValues().getOtherValues().get_any());
        }
        return n;
    }

    public SmartCrl getArchivedCrl(int n) throws IndexOutOfBoundsException {
        if (this.obj != null && this.obj.getArchivedRevocationValues() != null) {
            return SmartSignatureResult.getCrl(this.obj.getArchivedRevocationValues(), n);
        }
        return null;
    }

    public SmartOcsp getArchivedOcsp(int n) throws IndexOutOfBoundsException {
        if (this.obj != null && this.obj.getArchivedRevocationValues() != null) {
            return SmartSignatureResult.getOcsp(this.obj.getArchivedRevocationValues(), n);
        }
        return null;
    }

    public SmartVa getArchivedVa(int n) throws IndexOutOfBoundsException {
        if (this.obj != null && this.obj.getArchivedRevocationValues() != null) {
            return SmartSignatureResult.getVa(this.obj.getArchivedRevocationValues(), n);
        }
        return null;
    }
}

