/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartSkmPutKeyResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.Translate;
import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import com.safelayer.www.TWS.Base64Binary;
import com.safelayer.www.TWS.SKM.SKMBindingStub;
import com.safelayer.www.TWS.SKM.SymmetricKeyManagementType;
import com.safelayer.www.TWS.SKM.TWSSKMLocator;
import com.safelayer.www.TWS.SkmPutKeyRequestType;
import com.safelayer.www.TWS.SkmPutKeyResponseType;
import com.safelayer.www.TWS.SymmetricKeyAlgorithmType;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.types.URI;

public class SmartSkmPutKeyRequest
extends AbstractSmartDataRequest {
    private SKMBindingStub bindingSkm;
    private SkmPutKeyRequestType request;
    private boolean userHasCallRequestId = false;

    public SmartSkmPutKeyRequest(String string) throws Exception {
        TWSSKMLocator tWSSKMLocator = new TWSSKMLocator();
        tWSSKMLocator.setSymmetricKeyManagementEndpointAddress(string);
        SymmetricKeyManagementType symmetricKeyManagementType = tWSSKMLocator.getSymmetricKeyManagement();
        this.bindingSkm = (SKMBindingStub)symmetricKeyManagementType;
        SmartWrapperUtil.setProperties(tWSSKMLocator.getEngine());
        this.request = new SkmPutKeyRequestType();
        this.initRandom();
    }

    public Object getInternalObject() {
        return this.request;
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingSkm.setHeader(smartHeader.getInternalObject());
    }

    public void setKey(String string) {
        this.request.setKey(new Base64Binary(string));
    }

    public void setEncryptedKey(String string) {
        this.request.setEncryptedKey(new Base64Binary(string));
    }

    public void setResource(String string) {
        this.request.setResource(string);
    }

    public void setServicePolicy(String string) throws URI.MalformedURIException {
        this.request.setServicePolicy(new URI(string));
    }

    public void setKeyId(String string) {
        this.request.setKeyId(string);
    }

    public void setRequestId(String string) {
        this.request.setRequestID(string);
        this.userHasCallRequestId = true;
    }

    public void setSymmetricAlgorithm(String string) {
        String string2 = Translate.putSymmetricAlgorithmSkm(string);
        if (string2 == null) {
            string2 = string;
        }
        this.request.setSymmetricKeyAlgorithm(SymmetricKeyAlgorithmType.fromString((String)string2));
    }

    public SmartSkmPutKeyResponse send() throws Exception {
        this.fillRequest();
        SkmPutKeyResponseType skmPutKeyResponseType = this.bindingSkm.putKey(this.request);
        Hashtable hashtable = this.getOptions();
        SmartSkmPutKeyResponse smartSkmPutKeyResponse = new SmartSkmPutKeyResponse(skmPutKeyResponseType, hashtable);
        return smartSkmPutKeyResponse;
    }

    void fillRequest() {
        if (!this.userHasCallRequestId) {
            this.setRequestId(this.getRandomString());
            this.userHasCallRequestId = false;
        }
    }

    Hashtable getOptions() throws ConfigurationException {
        try {
            if (this.bindingSkm._getCall() != null) {
                String string = this.bindingSkm._getCall().getMessageContext().getTransportName();
                TWSSKMLocator tWSSKMLocator = (TWSSKMLocator)this.bindingSkm._getService();
                return SmartWrapperUtil.getTransportOptions(tWSSKMLocator.getEngine(), string);
            }
            TWSSKMLocator tWSSKMLocator = (TWSSKMLocator)this.bindingSkm._getService();
            return tWSSKMLocator.getEngine().getConfig().getHandler(new QName("sender")).getOptions();
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
    }

    EngineConfiguration getConfig() {
        TWSSKMLocator tWSSKMLocator = (TWSSKMLocator)this.bindingSkm._getService();
        return tWSSKMLocator.getEngine().getConfig();
    }
}

