/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartSkmGetKeyResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import com.safelayer.www.TWS.RecipientType;
import com.safelayer.www.TWS.Recipients;
import com.safelayer.www.TWS.SKM.SKMBindingStub;
import com.safelayer.www.TWS.SKM.SymmetricKeyManagementType;
import com.safelayer.www.TWS.SKM.TWSSKMLocator;
import com.safelayer.www.TWS.SkmGetKeyRequestType;
import com.safelayer.www.TWS.SkmGetKeyResponseType;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.encoding.Base64;
import org.apache.axis.types.URI;
import org.w3.www._2000._09.xmldsig.KeyInfoType;
import org.w3.www._2000._09.xmldsig.X509DataType;

public class SmartSkmGetKeyRequest
extends AbstractSmartDataRequest {
    private SKMBindingStub bindingSkm;
    private SkmGetKeyRequestType request;
    private boolean userHasCallRequestId = false;

    public SmartSkmGetKeyRequest(String string) throws Exception {
        TWSSKMLocator tWSSKMLocator = new TWSSKMLocator();
        tWSSKMLocator.setSymmetricKeyManagementEndpointAddress(string);
        SymmetricKeyManagementType symmetricKeyManagementType = tWSSKMLocator.getSymmetricKeyManagement();
        this.bindingSkm = (SKMBindingStub)symmetricKeyManagementType;
        SmartWrapperUtil.setProperties(tWSSKMLocator.getEngine());
        this.request = new SkmGetKeyRequestType();
        this.initRandom();
    }

    public Object getInternalObject() {
        return this.request;
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingSkm.setHeader(smartHeader.getInternalObject());
    }

    public void setServicePolicy(String string) throws URI.MalformedURIException {
        this.request.setServicePolicy(new URI(string));
    }

    public void setResource(String string) {
        this.request.setResource(string);
    }

    public void setKeyId(String string) {
        this.request.setKeyId(string);
    }

    public void setKeyCertificate(String string) {
        RecipientType recipientType = new RecipientType();
        KeyInfoType keyInfoType = new KeyInfoType();
        X509DataType x509DataType = new X509DataType();
        keyInfoType.setX509Data(x509DataType);
        x509DataType.setX509Certificate(Base64.decode((String)string));
        recipientType.setKeyInfo(keyInfoType);
        Recipients recipients = new Recipients();
        recipients.setRecipient(new RecipientType[]{recipientType});
        this.request.setRecipients(recipients);
    }

    public void setRequestId(String string) {
        this.request.setRequestID(string);
        this.userHasCallRequestId = true;
    }

    public SmartSkmGetKeyResponse send() throws Exception {
        this.fillRequest();
        SkmGetKeyResponseType skmGetKeyResponseType = this.bindingSkm.getKey(this.request);
        Hashtable hashtable = this.getOptions();
        SmartSkmGetKeyResponse smartSkmGetKeyResponse = new SmartSkmGetKeyResponse(skmGetKeyResponseType, hashtable);
        return smartSkmGetKeyResponse;
    }

    void fillRequest() throws Exception {
        if (!this.userHasCallRequestId) {
            this.setRequestId(this.getRandomString());
            this.userHasCallRequestId = false;
        }
    }

    Hashtable getOptions() throws ConfigurationException {
        try {
            if (this.bindingSkm._getCall() != null) {
                String string = this.bindingSkm._getCall().getMessageContext().getTransportName();
                TWSSKMLocator tWSSKMLocator = (TWSSKMLocator)this.bindingSkm._getService();
                return SmartWrapperUtil.getTransportOptions(tWSSKMLocator.getEngine(), string);
            }
            TWSSKMLocator tWSSKMLocator = (TWSSKMLocator)this.bindingSkm._getService();
            return tWSSKMLocator.getEngine().getConfig().getHandler(new QName("sender")).getOptions();
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
    }

    EngineConfiguration getConfig() {
        TWSSKMLocator tWSSKMLocator = (TWSSKMLocator)this.bindingSkm._getService();
        return tWSSKMLocator.getEngine().getConfig();
    }
}

