/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartSkmGenKeyResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.Translate;
import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import com.safelayer.www.TWS.RecipientType;
import com.safelayer.www.TWS.Recipients;
import com.safelayer.www.TWS.SKM.SKMBindingStub;
import com.safelayer.www.TWS.SKM.SymmetricKeyManagementType;
import com.safelayer.www.TWS.SKM.TWSSKMLocator;
import com.safelayer.www.TWS.SkmGenKeyRequestType;
import com.safelayer.www.TWS.SkmGenKeyResponseType;
import com.safelayer.www.TWS.SymmetricKeyAlgorithmType;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.encoding.Base64;
import org.apache.axis.types.URI;
import org.w3.www._2000._09.xmldsig.KeyInfoType;
import org.w3.www._2000._09.xmldsig.X509DataType;

public class SmartSkmGenKeyRequest
extends AbstractSmartDataRequest {
    private SKMBindingStub bindingSkm;
    private SkmGenKeyRequestType request;
    private boolean userHasCallRequestId = false;

    public SmartSkmGenKeyRequest(String string) throws Exception {
        TWSSKMLocator tWSSKMLocator = new TWSSKMLocator();
        tWSSKMLocator.setSymmetricKeyManagementEndpointAddress(string);
        SymmetricKeyManagementType symmetricKeyManagementType = tWSSKMLocator.getSymmetricKeyManagement();
        this.bindingSkm = (SKMBindingStub)symmetricKeyManagementType;
        SmartWrapperUtil.setProperties(tWSSKMLocator.getEngine());
        this.request = new SkmGenKeyRequestType();
        this.initRandom();
    }

    public Object getInternalObject() {
        return this.request;
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingSkm.setHeader(smartHeader.getInternalObject());
    }

    public void setServicePolicy(String string) throws URI.MalformedURIException {
        this.request.setServicePolicy(new URI(string));
    }

    public void setRequestId(String string) {
        this.request.setRequestID(string);
        this.userHasCallRequestId = true;
    }

    public void setResource(String string) {
        this.request.setResource(string);
    }

    public void setSymmetricAlgorithm(String string) {
        String string2 = Translate.putSymmetricAlgorithmSkm(string);
        if (string2 == null) {
            string2 = string;
        }
        this.request.setSymmetricKeyAlgorithm(SymmetricKeyAlgorithmType.fromString((String)string2));
    }

    public void setKeyCertificate(String string) {
        RecipientType recipientType = new RecipientType();
        KeyInfoType keyInfoType = new KeyInfoType();
        X509DataType x509DataType = new X509DataType();
        keyInfoType.setX509Data(x509DataType);
        x509DataType.setX509Certificate(Base64.decode((String)string));
        recipientType.setKeyInfo(keyInfoType);
        Recipients recipients = new Recipients();
        recipients.setRecipient(new RecipientType[]{recipientType});
        this.request.setRecipients(recipients);
    }

    public SmartSkmGenKeyResponse send() throws Exception {
        this.fillRequest();
        SkmGenKeyResponseType skmGenKeyResponseType = this.bindingSkm.genKey(this.request);
        Hashtable hashtable = this.getOptions();
        SmartSkmGenKeyResponse smartSkmGenKeyResponse = new SmartSkmGenKeyResponse(skmGenKeyResponseType, hashtable);
        return smartSkmGenKeyResponse;
    }

    void fillRequest() {
        if (!this.userHasCallRequestId) {
            this.setRequestId(this.getRandomString());
            this.userHasCallRequestId = false;
        }
    }

    Hashtable getOptions() throws ConfigurationException {
        try {
            if (this.bindingSkm._getCall() != null) {
                String string = this.bindingSkm._getCall().getMessageContext().getTransportName();
                TWSSKMLocator tWSSKMLocator = (TWSSKMLocator)this.bindingSkm._getService();
                return SmartWrapperUtil.getTransportOptions(tWSSKMLocator.getEngine(), string);
            }
            TWSSKMLocator tWSSKMLocator = (TWSSKMLocator)this.bindingSkm._getService();
            return tWSSKMLocator.getEngine().getConfig().getHandler(new QName("sender")).getOptions();
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
    }

    EngineConfiguration getConfig() {
        TWSSKMLocator tWSSKMLocator = (TWSSKMLocator)this.bindingSkm._getService();
        return tWSSKMLocator.getEngine().getConfig();
    }
}

