/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import assertion._0._1.SAML.tc.names.oasis.NameIdentifierType;
import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartSignResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.Translate;
import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import com.safelayer.trustedx.client.smartwrapper.exception.InvalidValueException;
import com.safelayer.trustedx.client.smartwrapper.exception.ParserException;
import com.safelayer.trustedx.client.smartwrapper.exception.SerializationException;
import com.safelayer.www.TWS.AddSignatureKeyInfo;
import com.safelayer.www.TWS.Base64Binary;
import com.safelayer.www.TWS.CanonicalizationMethod;
import com.safelayer.www.TWS.CounterSignature;
import com.safelayer.www.TWS.DS_wsdl.DSBindingStub;
import com.safelayer.www.TWS.DS_wsdl.DigitalSignatureType;
import com.safelayer.www.TWS.DS_wsdl.TWSDSLocator;
import com.safelayer.www.TWS.DocumentItem;
import com.safelayer.www.TWS.ExcludeChainCertificates;
import com.safelayer.www.TWS.ExcludeSignerCertificate;
import com.safelayer.www.TWS.ExtendedSignaturePlacement;
import com.safelayer.www.TWS.IncludeDataObjectFormat;
import com.safelayer.www.TWS.IncludeObject;
import com.safelayer.www.TWS.KeyInfoType;
import com.safelayer.www.TWS.KeySelector;
import com.safelayer.www.TWS.MimeSignature;
import com.safelayer.www.TWS.MultiNodeToSign;
import com.safelayer.www.TWS.NodeToSign;
import com.safelayer.www.TWS.PropertyType;
import com.safelayer.www.TWS.ReturnDocumentHash;
import com.safelayer.www.TWS.SignatureDigestAlgorithmType;
import com.safelayer.www.TWS.SignatureFormType;
import com.safelayer.www.TWS.StoreSignatureField;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.IDRef;
import org.apache.axis.types.Id;
import org.apache.axis.types.Language;
import org.apache.axis.types.URI;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.AnyType;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Base64Data;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Base64Signature;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Document;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.DocumentHash;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.EnvelopingSignature;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.InputDocuments;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.OptionalInputs;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Properties;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.PropertiesType;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.Property;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignRequest;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignResponse;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.SignaturePlacement;
import org.w3.www._2000._09.xmldsig.DigestMethodType;
import org.w3.www._2000._09.xmldsig.DigestValueType;
import org.w3.www._2000._09.xmldsig.X509DataType;
import org.w3.www._2000._09.xmldsig.X509IssuerSerialType;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SmartSignRequest
extends AbstractSmartDataRequest {
    static final String URI_NAME_DN = "urn:oasis:names:tc:SAML:1.1:nameid-format:X509SubjectName";
    static final String URI_NAME_EMAIL = "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress";
    static final String DEFAULT_SIGNATURETYPE = "cms";
    static final boolean DEFAULT_ENVELOPINGSIGNATURE = false;
    static final String DEFAULT_KEYSUBJECTUSAGE = "digitalSignature";
    static final String DEFAULT_INPUTHASHALGORITHM = "sha1";
    static final boolean DEFAULT_SIGNPROPERTYCERTIFICATE = false;
    static final String DEFAULT_SIGNATUREPLACEMENT = "detached";
    static final String DEFAULT_XMLCANONICALIZATIONMETHOD = "xml-exc";
    static final boolean DEFAULT_XMLSIMPLEXMLDSIG = false;
    static final boolean DEFAULT_XMLRETURNBASE64 = false;
    static final boolean DEFAULT_XMLCOUNTERSIGNATURE = false;
    static final String DEFAULT_INPUTMIMETYPE = "smime3";
    static final boolean DEFAULT_SIGNPROPERTYTIME = false;
    static final boolean DEFAULT_PDFSIGNATUREFIELDCREATE = true;
    static final boolean DEFAULT_EXCLUDECHAIN_XML_WSS = true;
    static final boolean DEFAULT_EXCLUDECHAIN_CMS_SMIME = false;
    static final boolean DEFAULT_SIGNERSCERTIFICATE = false;
    static final boolean DEFAULT_XMLINCLUDEDATAOBJ = false;
    static final String DEFAULT_XMLENVELOPEDXPATHFIRSTCHILDOF = "/";
    static final String ID_PROP_LOCATION = "urn:safelayer:tws:dss:1.0:property:location";
    static final String ID_PROP_ROLES = "urn:safelayer:tws:dss:1.0:property:roles";
    static final String ID_PROP_POLICIES = "urn:safelayer:tws:dss:1.0:property:policies";
    static final String ID_PROP_COMMITMENTS = "urn:safelayer:tws:dss:1.0:property:commitments";
    static final String ID_PROP_SIGNINGCERT = "urn:safelayer:tws:dss:1.0:property:signingcert";
    static final String ID_PROP_SIGNINGTIME = "urn:safelayer:tws:dss:1.0:property:signingtime";
    static final String ID_PROP_PDFATTRIBUTES = "urn:safelayer:tws:dss:1.0:property:pdfattributes";
    private DSBindingStub bindingDs;
    private SignRequest request;
    private OptionalInputs optionalInputs = null;
    private InputDocuments inputDocs = null;
    private boolean userHasCallRequestId = false;
    private boolean userHasCallXmlReturnBase64 = false;
    private String xmlFileToDelete = null;

    public SmartSignRequest(String string) throws Exception {
        TWSDSLocator tWSDSLocator = new TWSDSLocator();
        tWSDSLocator.setDigitalSignatureEndpointAddress(string);
        DigitalSignatureType digitalSignatureType = tWSDSLocator.getDigitalSignature();
        this.bindingDs = (DSBindingStub)digitalSignatureType;
        SmartWrapperUtil.setProperties(tWSDSLocator.getEngine());
        this.request = new SignRequest();
        this.initRandom();
    }

    public Object getInternalObject() {
        return this.request;
    }

    void checkOptionalInputs() {
        if (this.optionalInputs == null) {
            this.optionalInputs = new OptionalInputs();
            this.setOptionalInputs(this.optionalInputs);
        }
    }

    void checkInputDocuments() {
        if (this.inputDocs == null) {
            this.inputDocs = new InputDocuments();
            this.setInputDocuments(this.inputDocs);
        }
    }

    void initDefaultCmsValues() throws InvalidValueException {
        this.setEnvelopingSignature(false);
        this.setExcludeChainCerts(false);
    }

    void initDefaultXadesValues() throws InvalidValueException {
        this.setSignPropertyCertificate(false);
        this.setSignaturePlacement(DEFAULT_SIGNATUREPLACEMENT);
        this.setXmlCanonicalizationMethod(DEFAULT_XMLCANONICALIZATIONMETHOD);
        this.setXmlSimpleXMLDSig(false);
        this.setXmlIncludeDataObjectFormat(false);
        this.setXmlReturnBase64(false);
        this.setXmlCounterSignature(false);
        this.setExcludeChainCerts(true);
    }

    void initDefaultWssValues() {
        this.setSignPropertyTime(false);
        this.setExcludeChainCerts(true);
    }

    public void setRequestId(String string) {
        this.request.setRequestID(string);
        this.userHasCallRequestId = true;
    }

    public void setProfile(String string) throws InvalidValueException {
        String string2 = Translate.putProfileDs(string);
        if (string2 == null) {
            string2 = string;
        }
        try {
            this.request.setProfile(new URI(string2));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
        if ("cmspkcs7".equals(string) || "smime".equals(string)) {
            this.initDefaultCmsValues();
        } else if ("xades".equals(string)) {
            this.initDefaultXadesValues();
        } else if ("wss".equals(string)) {
            this.initDefaultWssValues();
        }
    }

    public void setEnvelopingSignature(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setEnvelopingSignature(new EnvelopingSignature());
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setEnvelopingSignature(null);
        }
    }

    public void setDigestAlgorithm(String string) throws InvalidValueException {
        String string2 = Translate.putDigestAlgorithm(string);
        if (string2 == null) {
            string2 = string;
        }
        this.checkOptionalInputs();
        this.optionalInputs.setSignatureDigestAlgorithm(SignatureDigestAlgorithmType.fromString((String)string2));
    }

    public void setLanguage(String string) {
        this.checkOptionalInputs();
        this.optionalInputs.setLanguage(new Language(string));
    }

    public void setServicePolicy(String string) throws InvalidValueException {
        this.checkOptionalInputs();
        try {
            this.optionalInputs.setServicePolicy(new URI(string));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string);
        }
    }

    public void setSignatureFormat(String string) throws InvalidValueException {
        String string2 = Translate.putSignatureFormat(string);
        if (string2 == null) {
            string2 = string;
        }
        this.checkOptionalInputs();
        this.optionalInputs.setSignatureForm(SignatureFormType.fromString((String)string2));
    }

    public void setKeySubjectName(String string) {
        this.setKeySelectorName(URI_NAME_DN, string);
    }

    public void setKeyEmailAddress(String string) {
        this.setKeySelectorName(URI_NAME_EMAIL, string);
    }

    void setKeySelectorName(String string, String string2) {
        NameIdentifierType nameIdentifierType;
        KeySelector keySelector;
        this.checkOptionalInputs();
        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector keySelector2 = this.optionalInputs.getKeySelector();
        if (keySelector2 == null) {
            keySelector2 = new org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector();
            this.optionalInputs.setKeySelector(keySelector2);
        }
        if ((keySelector = keySelector2.getKeySelector()) == null) {
            keySelector = new KeySelector();
            keySelector2.setKeySelector(keySelector);
        }
        if ((nameIdentifierType = keySelector.getName()) == null) {
            nameIdentifierType = new NameIdentifierType(string2);
            keySelector.setName(nameIdentifierType);
        }
        try {
            nameIdentifierType.setFormat(new URI(string));
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
        if (keySelector.getKeyUsage() == null) {
            this.setKeySubjectUsage(DEFAULT_KEYSUBJECTUSAGE);
        }
    }

    public void setKeySubjectUsage(String string) {
        KeySelector keySelector;
        this.checkOptionalInputs();
        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector keySelector2 = this.optionalInputs.getKeySelector();
        if (keySelector2 == null) {
            keySelector2 = new org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector();
            this.optionalInputs.setKeySelector(keySelector2);
        }
        if ((keySelector = keySelector2.getKeySelector()) == null) {
            keySelector = new KeySelector();
            keySelector2.setKeySelector(keySelector);
        }
        keySelector.setKeyUsage(string);
    }

    void setDefaultKeySubjectUsage() {
        boolean bl = true;
        if ("timestamping".equals(this.getProfile())) {
            bl = false;
        }
        if (this.optionalInputs != null && this.optionalInputs.getKeySelector() != null && this.optionalInputs.getKeySelector().getKeyInfo() != null) {
            bl = false;
        }
        if (bl && (this.optionalInputs == null || this.optionalInputs.getKeySelector() == null || this.optionalInputs.getKeySelector().getKeySelector() == null || this.optionalInputs.getKeySelector().getKeySelector().getKeyUsage() == null)) {
            this.setKeySubjectUsage(DEFAULT_KEYSUBJECTUSAGE);
        }
    }

    public void setKeySubjectExtUsage(String string) {
        KeySelector keySelector;
        this.checkOptionalInputs();
        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector keySelector2 = this.optionalInputs.getKeySelector();
        if (keySelector2 == null) {
            keySelector2 = new org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector();
            this.optionalInputs.setKeySelector(keySelector2);
        }
        if ((keySelector = keySelector2.getKeySelector()) == null) {
            keySelector = new KeySelector();
            keySelector2.setKeySelector(keySelector);
        }
        keySelector.setExtKeyUsage(string);
        if (keySelector.getKeyUsage() == null) {
            this.setKeySubjectUsage(DEFAULT_KEYSUBJECTUSAGE);
        }
    }

    public void setKeyHash(String string) {
        org.w3.www._2000._09.xmldsig.KeyInfoType keyInfoType;
        this.checkOptionalInputs();
        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector keySelector = this.optionalInputs.getKeySelector();
        if (keySelector == null) {
            keySelector = new org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector();
            this.optionalInputs.setKeySelector(keySelector);
        }
        if ((keyInfoType = keySelector.getKeyInfo()) == null) {
            keyInfoType = new org.w3.www._2000._09.xmldsig.KeyInfoType();
            keySelector.setKeyInfo(keyInfoType);
        }
        keyInfoType.setKeyName(string);
    }

    public void setKeyCertificate(String string) {
        X509DataType x509DataType;
        org.w3.www._2000._09.xmldsig.KeyInfoType keyInfoType;
        this.checkOptionalInputs();
        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector keySelector = this.optionalInputs.getKeySelector();
        if (keySelector == null) {
            keySelector = new org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector();
            this.optionalInputs.setKeySelector(keySelector);
        }
        if ((keyInfoType = keySelector.getKeyInfo()) == null) {
            keyInfoType = new org.w3.www._2000._09.xmldsig.KeyInfoType();
            keySelector.setKeyInfo(keyInfoType);
        }
        if ((x509DataType = keyInfoType.getX509Data()) == null) {
            x509DataType = new X509DataType();
            keyInfoType.setX509Data(x509DataType);
        }
        x509DataType.setX509Certificate(string.getBytes());
    }

    public void setKeyIssuerSerialName(String string) {
        X509IssuerSerialType x509IssuerSerialType;
        X509DataType x509DataType;
        org.w3.www._2000._09.xmldsig.KeyInfoType keyInfoType;
        this.checkOptionalInputs();
        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector keySelector = this.optionalInputs.getKeySelector();
        if (keySelector == null) {
            keySelector = new org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector();
            this.optionalInputs.setKeySelector(keySelector);
        }
        if ((keyInfoType = keySelector.getKeyInfo()) == null) {
            keyInfoType = new org.w3.www._2000._09.xmldsig.KeyInfoType();
            keySelector.setKeyInfo(keyInfoType);
        }
        if ((x509DataType = keyInfoType.getX509Data()) == null) {
            x509DataType = new X509DataType();
            keyInfoType.setX509Data(x509DataType);
        }
        if ((x509IssuerSerialType = x509DataType.getX509IssuerSerial()) == null) {
            x509IssuerSerialType = new X509IssuerSerialType();
            x509DataType.setX509IssuerSerial(x509IssuerSerialType);
        }
        x509IssuerSerialType.setX509IssuerName(string);
    }

    public void setKeyIssuerSerialNumber(String string) throws InvalidValueException {
        X509IssuerSerialType x509IssuerSerialType;
        X509DataType x509DataType;
        org.w3.www._2000._09.xmldsig.KeyInfoType keyInfoType;
        BigInteger bigInteger = null;
        try {
            bigInteger = new BigInteger(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidValueException(string);
        }
        this.checkOptionalInputs();
        org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector keySelector = this.optionalInputs.getKeySelector();
        if (keySelector == null) {
            keySelector = new org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.KeySelector();
            this.optionalInputs.setKeySelector(keySelector);
        }
        if ((keyInfoType = keySelector.getKeyInfo()) == null) {
            keyInfoType = new org.w3.www._2000._09.xmldsig.KeyInfoType();
            keySelector.setKeyInfo(keyInfoType);
        }
        if ((x509DataType = keyInfoType.getX509Data()) == null) {
            x509DataType = new X509DataType();
            keyInfoType.setX509Data(x509DataType);
        }
        if ((x509IssuerSerialType = x509DataType.getX509IssuerSerial()) == null) {
            x509IssuerSerialType = new X509IssuerSerialType();
            x509DataType.setX509IssuerSerial(x509IssuerSerialType);
        }
        x509IssuerSerialType.setX509SerialNumber(bigInteger);
    }

    public void setSignPropertyLocation(String string) throws InvalidValueException, Exception {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken();
        }
        String string6 = "";
        if (string2 != null) {
            string6 = string6 + "<xades:City>" + string2 + "</xades:City>";
        }
        if (string3 != null) {
            string6 = string6 + "<xades:StateOrProvince>" + string3 + "</xades:StateOrProvince>";
        }
        if (string4 != null) {
            string6 = string6 + "<xades:PostalCode>" + string4 + "</xades:PostalCode>";
        }
        if (string5 != null) {
            string6 = string6 + "<xades:CountryName>" + string5 + "</xades:CountryName>";
        }
        if (!string6.equals("")) {
            string6 = "<xades:SignatureProductionPlace xmlns:xades=\"http://uri.etsi.org/01903/v1.3.2#\">" + string6 + "</xades:SignatureProductionPlace>";
            URI uRI = new URI(ID_PROP_LOCATION);
            this.setSimpleSignedProperty(uRI, string6);
        }
    }

    void setSimpleSignedProperty(URI uRI, String string) throws ParserException {
        int n;
        PropertiesType propertiesType;
        this.checkOptionalInputs();
        Properties properties = this.optionalInputs.getProperties();
        if (properties == null) {
            properties = new Properties();
            this.optionalInputs.setProperties(properties);
        }
        if ((propertiesType = properties.getSignedProperties()) == null) {
            propertiesType = new PropertiesType();
            properties.setSignedProperties(propertiesType);
        }
        MessageElement messageElement = SmartWrapperUtil.getMessageElementFromString(string);
        Property property = new Property();
        property.setIdentifier(uRI);
        AnyType anyType = new AnyType();
        anyType.set_any(new MessageElement[]{messageElement});
        property.setValue(anyType);
        int n2 = 0;
        if (propertiesType.getProperty() != null) {
            n2 = propertiesType.getProperty().length;
        }
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            if (propertiesType.getProperty(n) == null || !uRI.equals((Object)propertiesType.getProperty(n).getIdentifier())) continue;
            n3 = n;
            break;
        }
        if (n3 == -1) {
            n = 1;
            if (propertiesType.getProperty() != null) {
                n = propertiesType.getProperty().length + 1;
            }
            Property[] propertyArray = new Property[n];
            if (propertiesType.getProperty() != null) {
                for (int i = 0; i < propertiesType.getProperty().length; ++i) {
                    propertyArray[i] = propertiesType.getProperty(i);
                }
            }
            propertyArray[n - 1] = property;
            propertiesType.setProperty(propertyArray);
        } else {
            propertiesType.setProperty(n3, property);
        }
    }

    public void setSignPropertyRole(String string) throws Exception {
        URI uRI = new URI(ID_PROP_ROLES);
        this.setMultipleSignProperty(uRI, string, "Roles", "Role");
    }

    public void setSignPropertyPolicy(String string) throws Exception {
        URI uRI = new URI(ID_PROP_POLICIES);
        this.setMultipleSignProperty(uRI, string, "Policies", "Policy");
    }

    public void setSignPropertyCommitment(String string) throws InvalidValueException, SerializationException, URI.MalformedURIException, ParserConfigurationException, SAXException, IOException, ParserException {
        String string2 = Translate.putSignPropertyCommitment(string);
        if (string2 == null) {
            string2 = string;
        }
        URI uRI = new URI(ID_PROP_COMMITMENTS);
        this.setMultipleSignProperty(uRI, string2, "Commitments", "Commitment");
    }

    void setMultipleSignProperty(URI uRI, String string, String string2, String string3) throws InvalidValueException, SerializationException, URI.MalformedURIException, ParserConfigurationException, SAXException, IOException, ParserException {
        Property[] propertyArray;
        MessageElement messageElement;
        String string4;
        PropertiesType propertiesType;
        this.checkOptionalInputs();
        Properties properties = this.optionalInputs.getProperties();
        if (properties == null) {
            properties = new Properties();
            this.optionalInputs.setProperties(properties);
        }
        if ((propertiesType = properties.getSignedProperties()) == null) {
            propertiesType = new PropertiesType();
            properties.setSignedProperties(propertiesType);
        }
        int n = 0;
        if (propertiesType.getProperty() != null) {
            n = propertiesType.getProperty().length;
        }
        int n2 = -1;
        for (int i = 0; i < n; ++i) {
            if (propertiesType.getProperty(i) == null || !uRI.equals((Object)propertiesType.getProperty(i).getIdentifier())) continue;
            n2 = i;
            break;
        }
        PropertyType propertyType = new PropertyType();
        propertyType.setUri(string);
        if (n2 != -1) {
            string4 = "<css:" + string2 + " xmlns:css=\"http://www.safelayer.com/TWS\">";
            messageElement = propertiesType.getProperty(n2).getValue().get_any()[0];
            int n3 = SmartWrapperUtil.countSubNode(messageElement, string3);
            for (int i = 0; i < n3; ++i) {
                MessageElement messageElement2 = SmartWrapperUtil.getSubNode(messageElement, string3, i);
                propertyArray = messageElement2.getAttribute("uri");
                string4 = string4 + "<css:" + string3 + " uri=\"" + (String)propertyArray + "\"/>";
            }
            string4 = string4 + "<css:" + string3 + " uri=\"" + string + "\"/>";
            string4 = string4 + "</css:" + string2 + ">";
        } else {
            string4 = "<css:" + string2 + " xmlns:css=\"http://www.safelayer.com/TWS\">" + "<css:" + string3 + " uri=\"" + string + "\"/>" + "</css:" + string2 + ">";
        }
        messageElement = SmartWrapperUtil.getMessageElementFromString(string4);
        AnyType anyType = new AnyType();
        anyType.set_any(new MessageElement[]{messageElement});
        Property property = new Property();
        property.setIdentifier(uRI);
        property.setValue(anyType);
        if (n2 == -1) {
            int n4 = 1;
            if (propertiesType.getProperty() != null) {
                n4 = propertiesType.getProperty().length + 1;
            }
            propertyArray = new Property[n4];
            if (propertiesType.getProperty() != null) {
                for (int i = 0; i < propertiesType.getProperty().length; ++i) {
                    propertyArray[i] = propertiesType.getProperty(i);
                }
            }
            propertyArray[n4 - 1] = property;
            propertiesType.setProperty(propertyArray);
        } else {
            propertiesType.setProperty(n2, property);
        }
    }

    public void setSignatureType(String string) throws InvalidValueException {
        String string2 = Translate.putSignatureType(string);
        if (string2 == null) {
            string2 = string;
        }
        this.checkOptionalInputs();
        try {
            this.optionalInputs.setSignatureType(new URI(string2));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
    }

    public void setExcludeChainCerts(boolean bl) {
        this.checkOptionalInputs();
        if (bl) {
            this.optionalInputs.setExcludeChainCertificates(new ExcludeChainCertificates());
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setExcludeChainCertificates(null);
        }
    }

    public void setExcludeSignerCert(boolean bl) {
        this.checkOptionalInputs();
        if (bl) {
            this.optionalInputs.setExcludeSignerCertificate(new ExcludeSignerCertificate());
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setExcludeSignerCertificate(null);
        }
    }

    public void setReturnDocumentHash(boolean bl) {
        this.checkOptionalInputs();
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setReturnDocumentHash(new ReturnDocumentHash());
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setReturnDocumentHash(null);
        }
    }

    public void setInputBase64Data(String string) throws ConfigurationException {
        this._setInputBase64Data(string, "string", "base64");
    }

    public void setInputBase64DataFile(String string, String string2) throws ConfigurationException {
        this._setInputBase64Data(string, "file", string2);
    }

    void _setInputBase64Data(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Base64Data", string2, string3);
        this.checkInputDocuments();
        Document document = null;
        document = this.inputDocs.getDocument() == null ? new Document() : this.inputDocs.getDocument();
        Base64Data base64Data = new Base64Data(string);
        document.setBase64Data(base64Data);
        this.inputDocs.setDocument(document);
    }

    public void setInputBase64Signature(String string) throws ConfigurationException {
        this._setInputBase64Signature(string, "string", "base64");
    }

    public void setInputBase64SignatureFile(String string, String string2) throws ConfigurationException {
        this._setInputBase64Signature(string, "file", string2);
    }

    void _setInputBase64Signature(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Base64Signature", string2, string3);
        this.checkInputDocuments();
        Base64Signature base64Signature = this.inputDocs.getBase64Signature();
        if (base64Signature == null) {
            base64Signature = new Base64Signature(string);
            this.inputDocs.setBase64Signature(base64Signature);
            try {
                this.setInputBase64SignatureType(DEFAULT_SIGNATURETYPE);
            }
            catch (InvalidValueException invalidValueException) {
                invalidValueException.printStackTrace();
            }
        } else {
            URI uRI = base64Signature.getType();
            base64Signature = new Base64Signature(string);
            this.inputDocs.setBase64Signature(base64Signature);
            if (uRI != null) {
                base64Signature.setType(uRI);
            } else {
                try {
                    this.setInputBase64SignatureType(DEFAULT_SIGNATURETYPE);
                }
                catch (InvalidValueException invalidValueException) {
                    invalidValueException.printStackTrace();
                }
            }
        }
    }

    public void setInputBase64SignatureType(String string) throws InvalidValueException {
        URI uRI;
        String string2 = Translate.putSignatureType(string);
        if (string2 == null) {
            string2 = string;
        }
        try {
            uRI = new URI(string2);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
        this.checkInputDocuments();
        Base64Signature base64Signature = this.inputDocs.getBase64Signature();
        if (base64Signature == null) {
            base64Signature = new Base64Signature();
            this.inputDocs.setBase64Signature(base64Signature);
        }
        base64Signature.setType(uRI);
    }

    public void setInputHashDigest(String string) {
        this.checkInputDocuments();
        DocumentHash documentHash = this.inputDocs.getDocumentHash();
        if (documentHash == null) {
            documentHash = new DocumentHash();
            this.inputDocs.setDocumentHash(documentHash);
        }
        documentHash.setDigestValue(new DigestValueType(string));
        if (documentHash.getDigestMethod() == null || documentHash.getDigestMethod().getAlgorithm() == null) {
            try {
                this.setInputHashAlgorithm(DEFAULT_INPUTHASHALGORITHM);
            }
            catch (InvalidValueException invalidValueException) {
                invalidValueException.printStackTrace();
            }
        }
    }

    public void setInputHashAlgorithm(String string) throws InvalidValueException {
        URI uRI;
        String string2 = Translate.putInputHashAlgorithm(string);
        if (string2 == null) {
            string2 = string;
        }
        try {
            uRI = new URI(string2);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
        this.checkInputDocuments();
        DocumentHash documentHash = this.inputDocs.getDocumentHash();
        if (documentHash == null) {
            documentHash = new DocumentHash();
            this.inputDocs.setDocumentHash(documentHash);
        }
        DigestMethodType digestMethodType = new DigestMethodType();
        digestMethodType.setAlgorithm(uRI);
        documentHash.setDigestMethod(digestMethodType);
    }

    public void setInputXmlData(String string) throws Exception {
        if (SmartSignRequest.isBig(string)) {
            if (this.xmlFileToDelete != null) {
                this.removeReference(this.xmlFileToDelete);
                this.xmlFileToDelete = null;
            }
            this.xmlFileToDelete = this.setReferenceContent(string.getBytes());
            this.setInputXmlBase64File(Base64.encode((byte[])this.xmlFileToDelete.getBytes()), "raw");
        } else {
            this.setInputXmlBase64(Base64.encode((byte[])string.getBytes("UTF-8")));
        }
    }

    public void setInputXmlBase64(String string) throws ConfigurationException {
        this._setInputXmlBase64(string, "string", "base64");
    }

    public void setInputXmlBase64File(String string, String string2) throws ConfigurationException {
        this._setInputXmlBase64(string, "file", string2);
    }

    void _setInputXmlBase64(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Base64XML", string2, string3);
        this.checkInputDocuments();
        if (this.inputDocs.getDocument() == null) {
            Document document = new Document();
            document.setBase64XML(Base64.decode((String)string));
            this.inputDocs.setDocument(document);
        } else {
            Document document = this.inputDocs.getDocument();
            document.setBase64XML(Base64.decode((String)string));
            this.inputDocs.setDocument(document);
        }
    }

    public void setInputRefUri(String string) throws URI.MalformedURIException {
        this.checkInputDocuments();
        if (this.inputDocs.getDocument() != null) {
            Document document = this.inputDocs.getDocument();
            document.setRefURI(string);
            this.inputDocs.setDocument(document);
        } else {
            Document document = new Document();
            document.setRefURI(string);
            this.inputDocs.setDocument(document);
        }
    }

    public void setInputXmlData(String string, String string2) throws Exception {
        if (SmartSignRequest.isBig(string)) {
            if (this.xmlFileToDelete != null) {
                this.removeReference(this.xmlFileToDelete);
                this.xmlFileToDelete = null;
            }
            this.xmlFileToDelete = this.setReferenceContent(string.getBytes());
            this._setInputXmlBase64Uri(Base64.encode((byte[])this.xmlFileToDelete.getBytes()), "file", "raw", string2);
        } else {
            this._setInputXmlBase64Uri(string, "string", "base64", string2);
        }
    }

    public void setInputXmlBase64(String string, String string2) throws Exception {
        this._setInputXmlBase64Uri(string, "string", "base64", string2);
    }

    public void setInputXmlBase64File(String string, String string2, String string3) throws Exception {
        this._setInputXmlBase64Uri(string, "file", string2, string3);
    }

    void _setInputXmlBase64Uri(String string, String string2, String string3, String string4) throws Exception {
        this.fileRequestTag("Base64XML", string2, string3);
        this.checkInputDocuments();
        if (this.inputDocs.getDocument() == null) {
            Document document = new Document();
            document.setBase64XML(Base64.decode((String)string));
            document.setRefURI(string4);
            this.inputDocs.setDocument(document);
        } else {
            Document document = this.inputDocs.getDocument();
            document.setBase64XML(Base64.decode((String)string));
            document.setRefURI(string4);
            this.inputDocs.setDocument(document);
        }
    }

    public void setInputXmlBase64Item(String string) throws Exception {
        this._setInputXmlBase64Item(string, "string", "base64", null, null);
    }

    public void setInputXmlBase64Item(String string, String string2) throws Exception {
        this._setInputXmlBase64Item(string, "string", "base64", string2, null);
    }

    public void setInputXmlBase64Item(String string, String string2, String string3) throws Exception {
        this._setInputXmlBase64Item(string, "string", "base64", string2, string3);
    }

    public void setInputXmlBase64Item(int n, String string) throws Exception {
        this._setInputXmlBase64Item(n, string, null, null);
    }

    public void setInputXmlBase64Item(int n, String string, String string2) throws Exception {
        this._setInputXmlBase64Item(n, string, string2, null);
    }

    public void setInputXmlBase64Item(int n, String string, String string2, String string3) throws Exception {
        this._setInputXmlBase64Item(n, string, string2, string3);
    }

    void _setInputXmlBase64Item(int n, String string, String string2, String string3) throws Exception {
        this.fileRequestTag("Base64XML", "string", "base64");
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        if (this.inputDocs.getDocumentItem().length > n) {
            documentItem = this.inputDocs.getDocumentItem(n);
        }
        documentItem.setBase64XML(Base64.decode((String)string));
        if (string2 != null) {
            documentItem.setRefURI(string2);
        }
        if (string3 != null) {
            documentItem.setID(new Id(string3));
        }
        this._setInputDocumentItem(n, documentItem);
    }

    public void setInputXmlBase64FileItem(int n, String string, String string2) throws Exception {
        this._setInputXmlBase64FileItem(n, string, string2, null, null);
    }

    public void setInputXmlBase64FileItem(int n, String string, String string2, String string3) throws Exception {
        this._setInputXmlBase64FileItem(n, string, string2, string3, null);
    }

    public void setInputXmlBase64FileItem(int n, String string, String string2, String string3, String string4) throws Exception {
        this._setInputXmlBase64FileItem(n, string, string2, string3, string4);
    }

    void _setInputXmlBase64FileItem(int n, String string, String string2, String string3, String string4) throws Exception {
        this.fileRequestTag("Base64XML", "file", string2);
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        if (this.inputDocs.getDocumentItem().length > n) {
            documentItem = this.inputDocs.getDocumentItem(n);
        }
        documentItem.setBase64XML(Base64.decode((String)string));
        if (string3 != null) {
            documentItem.setRefURI(string3);
        }
        if (string4 != null) {
            documentItem.setID(new Id(string4));
        }
        this._setInputDocumentItem(n, documentItem);
    }

    public void setInputXmlBase64FileItem(String string, String string2) throws Exception {
        this._setInputXmlBase64Item(string, "file", string2, null, null);
    }

    public void setInputXmlBase64FileItem(String string, String string2, String string3) throws Exception {
        this._setInputXmlBase64Item(string, "file", string2, string3, null);
    }

    public void setInputXmlBase64FileItem(String string, String string2, String string3, String string4) throws Exception {
        this._setInputXmlBase64Item(string, "file", string2, string3, string4);
    }

    void _setInputXmlBase64Item(String string, String string2, String string3, String string4, String string5) throws Exception {
        this.fileRequestTag("Base64XML", string2, string3);
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        documentItem.setBase64XML(Base64.decode((String)string));
        if (string4 != null) {
            documentItem.setRefURI(string4);
        }
        if (string5 != null) {
            documentItem.setID(new Id(string5));
        }
        if (this.inputDocs.getDocumentItem() == null) {
            this._setInputDocumentItem(0, documentItem);
        } else {
            this._setInputDocumentItem(this.inputDocs.getDocumentItem().length, documentItem);
        }
    }

    public void setInputXmlDataItem(int n, String string) throws Exception {
        this._setInputXmlDataItem(n, string, null, null);
    }

    public void setInputXmlDataItem(int n, String string, String string2) throws Exception {
        this._setInputXmlDataItem(n, string, string2, null);
    }

    public void setInputXmlDataItem(int n, String string, String string2, String string3) throws Exception {
        this._setInputXmlDataItem(n, string, string2, string3);
    }

    void _setInputXmlDataItem(int n, String string, String string2, String string3) throws Exception {
        if (SmartSignRequest.isBig(string)) {
            if (this.xmlFileToDelete != null) {
                this.removeReference(this.xmlFileToDelete);
                this.xmlFileToDelete = null;
            }
            this.xmlFileToDelete = this.setReferenceContent(string.getBytes());
            this.setInputXmlBase64FileItem(n, Base64.encode((byte[])this.xmlFileToDelete.getBytes()), "raw", string2, string3);
        } else {
            this.setInputXmlBase64Item(n, Base64.encode((byte[])string.getBytes("UTF-8")), string2, string3);
        }
    }

    public void setInputXmlDataItem(String string) throws Exception {
        this._setInputXmlDataItem(string, null, null);
    }

    public void setInputXmlDataItem(String string, String string2) throws Exception {
        this._setInputXmlDataItem(string, string2, null);
    }

    public void setInputXmlDataItem(String string, String string2, String string3) throws Exception {
        this._setInputXmlDataItem(string, string2, string3);
    }

    void _setInputXmlDataItem(String string, String string2, String string3) throws Exception {
        if (SmartSignRequest.isBig(string)) {
            if (this.xmlFileToDelete != null) {
                this.removeReference(this.xmlFileToDelete);
                this.xmlFileToDelete = null;
            }
            this.xmlFileToDelete = this.setReferenceContent(string.getBytes());
            this.setInputXmlBase64FileItem(Base64.encode((byte[])this.xmlFileToDelete.getBytes()), "raw", string2, string3);
        } else {
            this.setInputXmlBase64Item(Base64.encode((byte[])string.getBytes("UTF-8")), string2, string3);
        }
    }

    public void setInputBase64DataItem(int n, String string) throws Exception {
        this._setInputBase64DataItem(n, string, null, null);
    }

    public void setInputBase64DataItem(int n, String string, String string2) throws Exception {
        this._setInputBase64DataItem(n, string, string2, null);
    }

    public void setInputBase64DataItem(int n, String string, String string2, String string3) throws Exception {
        this._setInputBase64DataItem(n, string, string2, string3);
    }

    void _setInputBase64DataItem(int n, String string, String string2, String string3) throws Exception {
        this.fileRequestTag("Base64Data", "string", "base64");
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        if (this.inputDocs.getDocumentItem().length > n) {
            documentItem = this.inputDocs.getDocumentItem(n);
        }
        documentItem.setBase64Data(new Base64Data(string));
        if (string2 != null) {
            documentItem.setRefURI(string2);
        }
        if (string3 != null) {
            documentItem.setID(new Id(string3));
        }
        this._setInputDocumentItem(n, documentItem);
    }

    public void setInputBase64DataItem(String string) throws Exception {
        this._setInputBase64DataItem(string, "string", "base64", null, null);
    }

    public void setInputBase64DataItem(String string, String string2) throws Exception {
        this._setInputBase64DataItem(string, "string", "base64", string2, null);
    }

    public void setInputBase64DataItem(String string, String string2, String string3) throws Exception {
        this._setInputBase64DataItem(string, "string", "base64", string2, string3);
    }

    public void setInputBase64DataFileItem(int n, String string, String string2) throws Exception {
        this._setInputBase64DataFileItem(n, string, string2, null, null);
    }

    public void setInputBase64DataFileItem(int n, String string, String string2, String string3) throws Exception {
        this._setInputBase64DataFileItem(n, string, string2, string3, null);
    }

    public void setInputBase64DataFileItem(int n, String string, String string2, String string3, String string4) throws Exception {
        this._setInputBase64DataFileItem(n, string, string2, string3, string4);
    }

    void _setInputBase64DataFileItem(int n, String string, String string2, String string3, String string4) throws Exception {
        this.fileRequestTag("Base64Data", "file", string2);
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        if (this.inputDocs.getDocumentItem().length > n) {
            documentItem = this.inputDocs.getDocumentItem(n);
        }
        documentItem.setBase64Data(new Base64Data(string));
        if (string3 != null) {
            documentItem.setRefURI(string3);
        }
        if (string4 != null) {
            documentItem.setID(new Id(string4));
        }
        this._setInputDocumentItem(n, documentItem);
    }

    public void setInputBase64DataFileItem(String string, String string2) throws Exception {
        this._setInputBase64DataItem(string, "file", string2, null, null);
    }

    public void setInputBase64DataFileItem(String string, String string2, String string3) throws Exception {
        this._setInputBase64DataItem(string, "file", string2, string3, null);
    }

    public void setInputBase64DataFileItem(String string, String string2, String string3, String string4) throws Exception {
        this._setInputBase64DataItem(string, "file", string2, string3, string4);
    }

    void _setInputBase64DataItem(String string, String string2, String string3, String string4, String string5) throws Exception {
        this.fileRequestTag("Base64Data", string2, string3);
        this.checkInputDocuments();
        DocumentItem documentItem = new DocumentItem();
        documentItem.setBase64Data(new Base64Data(string));
        if (string4 != null) {
            documentItem.setRefURI(string4);
        }
        if (string5 != null) {
            documentItem.setID(new Id(string5));
        }
        if (this.inputDocs.getDocumentItem() == null) {
            this._setInputDocumentItem(0, documentItem);
        } else {
            this._setInputDocumentItem(this.inputDocs.getDocumentItem().length, documentItem);
        }
    }

    void _setInputDocumentItem(int n, DocumentItem documentItem) throws Exception {
        this.checkInputDocuments();
        if (this.inputDocs.getDocumentItem() == null && n == 0) {
            this.inputDocs.setDocumentItem(new DocumentItem[]{documentItem});
        } else if (this.inputDocs.getDocumentItem().length > n) {
            DocumentItem documentItem2 = this.inputDocs.getDocumentItem(n);
            if (documentItem2.getRefURI() != null && documentItem.getRefURI() == null) {
                documentItem.setRefURI(documentItem2.getRefURI());
            }
            if (documentItem2.getID() != null && documentItem.getID() == null) {
                documentItem.setID(documentItem2.getID());
            }
            this.inputDocs.setDocumentItem(n, documentItem);
        } else if (this.inputDocs.getDocumentItem().length == n) {
            DocumentItem[] documentItemArray = this.inputDocs.getDocumentItem();
            DocumentItem[] documentItemArray2 = new DocumentItem[n + 1];
            for (int i = 0; i < n; ++i) {
                documentItemArray2[i] = documentItemArray[i];
            }
            documentItemArray2[n] = documentItem;
            this.inputDocs.setDocumentItem(documentItemArray2);
        } else {
            throw new Exception("Index out of bounds");
        }
    }

    public void setInputRefUriItem(int n, String string) throws Exception {
        this.checkInputDocuments();
        if (this.inputDocs.getDocumentItem() == null && n == 0) {
            DocumentItem documentItem = new DocumentItem();
            documentItem.setRefURI(string);
            this.inputDocs.setDocumentItem(new DocumentItem[]{documentItem});
        } else if (this.inputDocs.getDocumentItem().length > n) {
            DocumentItem documentItem = this.inputDocs.getDocumentItem(n);
            documentItem.setRefURI(string);
            this.inputDocs.setDocumentItem(n, documentItem);
        } else if (this.inputDocs.getDocumentItem().length == n) {
            DocumentItem documentItem = new DocumentItem();
            documentItem.setRefURI(string);
            DocumentItem[] documentItemArray = this.inputDocs.getDocumentItem();
            DocumentItem[] documentItemArray2 = new DocumentItem[n + 1];
            for (int i = 0; i < n; ++i) {
                documentItemArray2[i] = documentItemArray[i];
            }
            documentItemArray2[n] = documentItem;
            this.inputDocs.setDocumentItem(documentItemArray2);
        } else {
            throw new Exception("Index out of bounds");
        }
    }

    public void setInputIdItem(int n, String string) throws Exception {
        this.checkInputDocuments();
        if (this.inputDocs.getDocumentItem() == null && n == 0) {
            DocumentItem documentItem = new DocumentItem();
            documentItem.setID(new Id(string));
            this.inputDocs.setDocumentItem(new DocumentItem[]{documentItem});
        } else if (this.inputDocs.getDocumentItem().length > n) {
            DocumentItem documentItem = this.inputDocs.getDocumentItem(n);
            documentItem.setID(new Id(string));
            this.inputDocs.setDocumentItem(n, documentItem);
        } else if (this.inputDocs.getDocumentItem().length == n) {
            DocumentItem documentItem = new DocumentItem();
            documentItem.setID(new Id(string));
            DocumentItem[] documentItemArray = this.inputDocs.getDocumentItem();
            DocumentItem[] documentItemArray2 = new DocumentItem[n + 1];
            for (int i = 0; i < n; ++i) {
                documentItemArray2[i] = documentItemArray[i];
            }
            documentItemArray2[n] = documentItem;
            this.inputDocs.setDocumentItem(documentItemArray2);
        } else {
            throw new Exception("Index out of bounds");
        }
    }

    public void setXmlEnvelopingIncludedDocId(int n, String string) throws Exception {
        this.checkOptionalInputs();
        if (this.optionalInputs.getIncludeObject() == null && n == 0) {
            IncludeObject includeObject = new IncludeObject();
            includeObject.setWhichDocument(new IDRef(string));
            this.optionalInputs.setIncludeObject(new IncludeObject[]{includeObject});
        } else if (this.optionalInputs.getIncludeObject().length > n) {
            this.optionalInputs.getIncludeObject(n).setWhichDocument(new IDRef(string));
        } else if (this.optionalInputs.getIncludeObject().length == n) {
            IncludeObject includeObject = new IncludeObject();
            includeObject.setWhichDocument(new IDRef(string));
            IncludeObject[] includeObjectArray = this.optionalInputs.getIncludeObject();
            IncludeObject[] includeObjectArray2 = new IncludeObject[includeObjectArray.length + 1];
            for (int i = 0; i < includeObjectArray.length; ++i) {
                includeObjectArray2[i] = includeObjectArray[i];
            }
            includeObjectArray2[includeObjectArray.length] = includeObject;
            this.optionalInputs.setIncludeObject(includeObjectArray2);
        } else {
            throw new Exception("Index out of bounds");
        }
    }

    public void setXmlEnvelopingIncludedDocHasObject(int n, boolean bl) throws Exception {
        this.checkOptionalInputs();
        if (this.optionalInputs.getIncludeObject() == null && n == 0) {
            IncludeObject includeObject = new IncludeObject();
            includeObject.setHasObjectTagsAndAttributesSet(bl);
            this.optionalInputs.setIncludeObject(new IncludeObject[]{includeObject});
        } else if (this.optionalInputs.getIncludeObject().length > n) {
            this.optionalInputs.getIncludeObject(n).setHasObjectTagsAndAttributesSet(bl);
        } else if (this.optionalInputs.getIncludeObject().length == n) {
            IncludeObject includeObject = new IncludeObject();
            includeObject.setHasObjectTagsAndAttributesSet(bl);
            IncludeObject[] includeObjectArray = this.optionalInputs.getIncludeObject();
            IncludeObject[] includeObjectArray2 = new IncludeObject[includeObjectArray.length + 1];
            for (int i = 0; i < includeObjectArray.length; ++i) {
                includeObjectArray2[i] = includeObjectArray[i];
            }
            includeObjectArray2[includeObjectArray.length] = includeObject;
            this.optionalInputs.setIncludeObject(includeObjectArray2);
        } else {
            throw new Exception("Index out of bounds");
        }
    }

    public void setXmlEnvelopingIncludedDocObjId(int n, String string) throws Exception {
        this.checkOptionalInputs();
        if (this.optionalInputs.getIncludeObject() == null && n == 0) {
            IncludeObject includeObject = new IncludeObject();
            includeObject.setObjId(string);
            this.optionalInputs.setIncludeObject(new IncludeObject[]{includeObject});
        } else if (this.optionalInputs.getIncludeObject().length > n) {
            this.optionalInputs.getIncludeObject(n).setObjId(string);
        } else if (this.optionalInputs.getIncludeObject().length == n) {
            IncludeObject includeObject = new IncludeObject();
            includeObject.setObjId(string);
            IncludeObject[] includeObjectArray = this.optionalInputs.getIncludeObject();
            IncludeObject[] includeObjectArray2 = new IncludeObject[includeObjectArray.length + 1];
            for (int i = 0; i < includeObjectArray.length; ++i) {
                includeObjectArray2[i] = includeObjectArray[i];
            }
            includeObjectArray2[includeObjectArray.length] = includeObject;
            this.optionalInputs.setIncludeObject(includeObjectArray2);
        } else {
            throw new Exception("Index out of bounds");
        }
    }

    public void setXmlEnvelopingIncludedDocCreateRef(int n, boolean bl) throws Exception {
        this.checkOptionalInputs();
        if (this.optionalInputs.getIncludeObject() == null && n == 0) {
            IncludeObject includeObject = new IncludeObject();
            includeObject.setCreateReference(new Boolean(bl));
            this.optionalInputs.setIncludeObject(new IncludeObject[]{includeObject});
        } else if (this.optionalInputs.getIncludeObject().length > n) {
            this.optionalInputs.getIncludeObject(n).setCreateReference(new Boolean(bl));
        } else if (this.optionalInputs.getIncludeObject().length == n) {
            IncludeObject includeObject = new IncludeObject();
            includeObject.setCreateReference(new Boolean(bl));
            IncludeObject[] includeObjectArray = this.optionalInputs.getIncludeObject();
            IncludeObject[] includeObjectArray2 = new IncludeObject[includeObjectArray.length + 1];
            for (int i = 0; i < includeObjectArray.length; ++i) {
                includeObjectArray2[i] = includeObjectArray[i];
            }
            includeObjectArray2[includeObjectArray.length] = includeObject;
            this.optionalInputs.setIncludeObject(includeObjectArray2);
        } else {
            throw new Exception("Index out of bounds");
        }
    }

    public void setXmlEnvelopedIncludingDocId(String string) {
        this.checkOptionalInputs();
        ExtendedSignaturePlacement extendedSignaturePlacement = this.optionalInputs.getExtendedSignaturePlacement();
        if (extendedSignaturePlacement == null) {
            extendedSignaturePlacement = new ExtendedSignaturePlacement();
            this.optionalInputs.setExtendedSignaturePlacement(extendedSignaturePlacement);
        }
        extendedSignaturePlacement.setWhichDocument(new IDRef(string));
    }

    public void setSignPropertyCertificate(boolean bl) {
        URI uRI = null;
        try {
            uRI = new URI(ID_PROP_SIGNINGCERT);
        }
        catch (URI.MalformedURIException malformedURIException) {
            malformedURIException.printStackTrace();
        }
        this.setSignProperty(bl, uRI);
    }

    void setSignProperty(boolean bl, URI uRI) {
        if (bl) {
            int n;
            PropertiesType propertiesType;
            this.checkOptionalInputs();
            Properties properties = this.optionalInputs.getProperties();
            if (properties == null) {
                properties = new Properties();
                this.optionalInputs.setProperties(properties);
            }
            if ((propertiesType = properties.getSignedProperties()) == null) {
                propertiesType = new PropertiesType();
                properties.setSignedProperties(propertiesType);
            }
            int n2 = 0;
            if (propertiesType.getProperty() != null) {
                n2 = propertiesType.getProperty().length;
            }
            for (n = 0; !(n >= n2 || propertiesType.getProperty(n) != null && uRI.equals((Object)propertiesType.getProperty(n).getIdentifier())); ++n) {
            }
            if (n == n2) {
                Property property = new Property();
                property.setIdentifier(uRI);
                int n3 = 1;
                if (propertiesType.getProperty() != null) {
                    n3 = propertiesType.getProperty().length + 1;
                }
                Property[] propertyArray = new Property[n3];
                if (propertiesType.getProperty() != null) {
                    for (int i = 0; i < propertiesType.getProperty().length; ++i) {
                        propertyArray[i] = propertiesType.getProperty(i);
                    }
                }
                propertyArray[n3 - 1] = property;
                propertiesType.setProperty(propertyArray);
            }
        } else if (this.optionalInputs != null && this.optionalInputs.getProperties() != null && this.optionalInputs.getProperties().getSignedProperties() != null) {
            int n;
            PropertiesType propertiesType = this.optionalInputs.getProperties().getSignedProperties();
            int n4 = 0;
            if (propertiesType.getProperty() != null) {
                n4 = propertiesType.getProperty().length;
            }
            int n5 = 0;
            for (n = 0; n < n4; ++n) {
                if (propertiesType.getProperty(n) == null || !uRI.equals((Object)propertiesType.getProperty(n).getIdentifier())) continue;
                ++n5;
            }
            if (n5 > 0) {
                n = propertiesType.getProperty().length - n5;
                Property[] propertyArray = new Property[n];
                for (int i = 0; i < propertiesType.getProperty().length; ++i) {
                    if (uRI.equals((Object)propertiesType.getProperty(i).getIdentifier())) continue;
                    propertyArray[i] = propertiesType.getProperty(i);
                }
                propertiesType.setProperty(propertyArray);
            }
        }
    }

    public void setSignaturePlacement(String string) {
        this.setSignaturePlacement(Translate.putEnvelopedPlacementBoolean(string));
        this.setEnvelopingSignature(Translate.putEnvelopingPlacementBoolean(string));
    }

    void setSignaturePlacement(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setSignaturePlacement(new SignaturePlacement());
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setSignaturePlacement(null);
        }
    }

    public void setXmlEnvelopedXPathAfter(String string) {
        this.checkOptionalInputs();
        SignaturePlacement signaturePlacement = this.optionalInputs.getSignaturePlacement();
        if (signaturePlacement == null) {
            signaturePlacement = new SignaturePlacement();
            this.optionalInputs.setSignaturePlacement(signaturePlacement);
        }
        signaturePlacement.setXPathAfter(string);
    }

    public void setXmlEnvelopedXPathFirstChildOf(String string) {
        this.checkOptionalInputs();
        SignaturePlacement signaturePlacement = this.optionalInputs.getSignaturePlacement();
        if (signaturePlacement == null) {
            signaturePlacement = new SignaturePlacement();
            this.optionalInputs.setSignaturePlacement(signaturePlacement);
        }
        signaturePlacement.setXPathFirstChildOf(string);
    }

    public void setXmlEnvelopedXPathInsertBeforeOf(String string) {
        this.checkOptionalInputs();
        ExtendedSignaturePlacement extendedSignaturePlacement = this.optionalInputs.getExtendedSignaturePlacement();
        if (extendedSignaturePlacement == null) {
            extendedSignaturePlacement = new ExtendedSignaturePlacement();
            this.optionalInputs.setExtendedSignaturePlacement(extendedSignaturePlacement);
        }
        extendedSignaturePlacement.setXPathBefore(string);
    }

    public void setXmlNodeToSign(String string) {
        this.checkOptionalInputs();
        NodeToSign nodeToSign = new NodeToSign(string);
        MultiNodeToSign multiNodeToSign = this.optionalInputs.getMultiNodeToSign();
        if (multiNodeToSign == null) {
            NodeToSign nodeToSign2 = this.optionalInputs.getNodeToSign();
            if (nodeToSign2 == null) {
                this.optionalInputs.setNodeToSign(nodeToSign);
            } else {
                multiNodeToSign = new MultiNodeToSign();
                NodeToSign[] nodeToSignArray = new NodeToSign[]{nodeToSign2, nodeToSign};
                multiNodeToSign.setNodeToSign(nodeToSignArray);
                this.optionalInputs.setMultiNodeToSign(multiNodeToSign);
                this.optionalInputs.setNodeToSign(null);
            }
        } else {
            int n = 1;
            if (multiNodeToSign.getNodeToSign() != null) {
                n = multiNodeToSign.getNodeToSign().length + 1;
            }
            NodeToSign[] nodeToSignArray = new NodeToSign[n];
            if (multiNodeToSign.getNodeToSign() != null) {
                for (int i = 0; i < multiNodeToSign.getNodeToSign().length; ++i) {
                    nodeToSignArray[i] = multiNodeToSign.getNodeToSign(i);
                }
            }
            nodeToSignArray[n - 1] = nodeToSign;
            multiNodeToSign.setNodeToSign(nodeToSignArray);
        }
    }

    public void setXmlAddSigKeyInfo(String string) {
        this.checkOptionalInputs();
        AddSignatureKeyInfo addSignatureKeyInfo = this.optionalInputs.getAddSignatureKeyInfo();
        if (addSignatureKeyInfo == null) {
            addSignatureKeyInfo = new AddSignatureKeyInfo();
            this.optionalInputs.setAddSignatureKeyInfo(addSignatureKeyInfo);
        }
        int n = 1;
        if (addSignatureKeyInfo.getKeyInfoType() != null) {
            n = addSignatureKeyInfo.getKeyInfoType().length + 1;
        }
        KeyInfoType[] keyInfoTypeArray = new KeyInfoType[n];
        if (addSignatureKeyInfo.getKeyInfoType() != null) {
            for (int i = 0; i < addSignatureKeyInfo.getKeyInfoType().length; ++i) {
                keyInfoTypeArray[i] = addSignatureKeyInfo.getKeyInfoType(i);
            }
        }
        keyInfoTypeArray[n - 1] = KeyInfoType.fromString((String)string);
        addSignatureKeyInfo.setKeyInfoType(keyInfoTypeArray);
    }

    public void setXmlSignSigKeyInfo(boolean bl) {
        this.checkOptionalInputs();
        AddSignatureKeyInfo addSignatureKeyInfo = this.optionalInputs.getAddSignatureKeyInfo();
        if (addSignatureKeyInfo == null) {
            addSignatureKeyInfo = new AddSignatureKeyInfo();
            this.optionalInputs.setAddSignatureKeyInfo(addSignatureKeyInfo);
        }
        addSignatureKeyInfo.setSign(new Boolean(bl));
    }

    public void setXmlIncludeManifest(String string) throws Exception {
        throw new Exception("not supported method setXmlIncludeManifest");
    }

    public void setXmlCanonicalizationMethod(String string) throws InvalidValueException {
        String string2 = Translate.putXmlCanonicalizationMethod(string);
        if (string2 == null) {
            string2 = string;
        }
        this.checkOptionalInputs();
        this.optionalInputs.setCanonicalizationMethod(CanonicalizationMethod.fromString((String)string2));
    }

    public void setXmlSimpleXMLDSig(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setSimpleXMLDSig((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setSimpleXMLDSig(null);
        }
    }

    public void setXmlReturnBase64(boolean bl) {
        this.userHasCallXmlReturnBase64 = bl;
        if (bl) {
            this.checkOptionalInputs();
            this.optionalInputs.setReturnBase64XML((Object)"");
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setReturnBase64XML(null);
        }
    }

    public void setXmlCounterSignature(boolean bl) {
        if (bl) {
            this.checkOptionalInputs();
            CounterSignature counterSignature = this.optionalInputs.getCounterSignature();
            if (counterSignature == null) {
                counterSignature = new CounterSignature();
                this.optionalInputs.setCounterSignature(counterSignature);
            }
        } else if (this.optionalInputs != null) {
            this.optionalInputs.setCounterSignature(null);
        }
    }

    public void setXmlCounterSignatureXPath(String string) {
        this.checkOptionalInputs();
        CounterSignature counterSignature = this.optionalInputs.getCounterSignature();
        if (counterSignature == null) {
            counterSignature = new CounterSignature();
            this.optionalInputs.setCounterSignature(counterSignature);
        }
        counterSignature.setXPath(string);
    }

    public void setXmlIncludeDataObjectFormat(boolean bl) {
        this.checkOptionalInputs();
        if (bl) {
            this.optionalInputs.setIncludeDataObjectFormat(new IncludeDataObjectFormat());
        } else {
            this.optionalInputs.setIncludeDataObjectFormat(null);
        }
    }

    public void setInputMime(String string) throws ConfigurationException {
        this._setInputMime(string, "string", "base64");
    }

    public void setInputMimeFile(String string, String string2) throws ConfigurationException {
        this._setInputMime(string, "file", string2);
    }

    void _setInputMime(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Mime", string2, string3);
        this.checkInputDocuments();
        this.inputDocs.setMime(new Base64Binary(string));
    }

    public void setInputMimeSignature(String string) throws ConfigurationException {
        this._setInputMimeSignature(string, "string", "base64");
    }

    public void setInputMimeSignatureFile(String string, String string2) throws ConfigurationException {
        this._setInputMimeSignature(string, "file", string2);
    }

    void _setInputMimeSignature(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("MimeSignature", string2, string3);
        this.checkInputDocuments();
        MimeSignature mimeSignature = this.inputDocs.getMimeSignature();
        if (mimeSignature == null) {
            mimeSignature = new MimeSignature(string);
            this.inputDocs.setMimeSignature(mimeSignature);
            try {
                this.setInputMimeType(DEFAULT_INPUTMIMETYPE);
            }
            catch (InvalidValueException invalidValueException) {
                invalidValueException.printStackTrace();
            }
        } else {
            URI uRI = mimeSignature.getType();
            mimeSignature = new MimeSignature(string);
            this.inputDocs.setMimeSignature(mimeSignature);
            if (uRI != null) {
                mimeSignature.setType(uRI);
            } else {
                try {
                    this.setInputMimeType(DEFAULT_INPUTMIMETYPE);
                }
                catch (InvalidValueException invalidValueException) {
                    invalidValueException.printStackTrace();
                }
            }
        }
    }

    public void setInputMimeType(String string) throws InvalidValueException {
        URI uRI;
        String string2 = Translate.putSignatureType(string);
        if (string2 == null) {
            string2 = string;
        }
        try {
            uRI = new URI(string2);
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
        this.checkInputDocuments();
        MimeSignature mimeSignature = this.inputDocs.getMimeSignature();
        if (mimeSignature == null) {
            mimeSignature = new MimeSignature();
            this.inputDocs.setMimeSignature(mimeSignature);
        }
        mimeSignature.setType(uRI);
    }

    public void setAdditionalProfile(String string) throws InvalidValueException {
        String string2 = Translate.putProfileDs(string);
        if (string2 == null) {
            string2 = string;
        }
        this.checkOptionalInputs();
        try {
            this.optionalInputs.setAdditionalProfile(new URI(string2));
        }
        catch (URI.MalformedURIException malformedURIException) {
            throw new InvalidValueException(string, malformedURIException);
        }
    }

    public void setSignPropertyTime(boolean bl) {
        URI uRI = null;
        try {
            uRI = new URI(ID_PROP_SIGNINGTIME);
        }
        catch (URI.MalformedURIException malformedURIException) {
            malformedURIException.printStackTrace();
        }
        this.setSignProperty(bl, uRI);
    }

    public void setInputPdfBase64Data(String string) throws ConfigurationException {
        this._setInputPdfBase64Data(string, "string", "base64");
    }

    public void setInputPdfBase64DataFile(String string, String string2) throws ConfigurationException {
        this._setInputPdfBase64Data(string, "file", string2);
    }

    void _setInputPdfBase64Data(String string, String string2, String string3) throws ConfigurationException {
        this.fileRequestTag("Base64Data", string2, string3);
        this.checkInputDocuments();
        Document document = new Document();
        Base64Data base64Data = new Base64Data(string);
        base64Data.setMimeType("application/pdf");
        document.setBase64Data(base64Data);
        this.inputDocs.setDocument(document);
    }

    public void setPdfSignatureFieldName(String string) {
        this.checkOptionalInputs();
        if (this.optionalInputs.getStoreSignatureField() == null) {
            this.optionalInputs.setStoreSignatureField(new StoreSignatureField(string, true));
        } else {
            this.optionalInputs.getStoreSignatureField().setName(string);
        }
    }

    public void setPdfSignatureFieldCreate(boolean bl) {
        this.checkOptionalInputs();
        if (this.optionalInputs.getStoreSignatureField() == null) {
            StoreSignatureField storeSignatureField = new StoreSignatureField();
            storeSignatureField.setCreate(bl);
            this.optionalInputs.setStoreSignatureField(storeSignatureField);
        } else {
            this.optionalInputs.getStoreSignatureField().setCreate(bl);
        }
    }

    public void setPdfSignatureInfo(String string) throws ParserException {
        URI uRI = null;
        try {
            uRI = new URI(ID_PROP_PDFATTRIBUTES);
        }
        catch (URI.MalformedURIException malformedURIException) {
            malformedURIException.printStackTrace();
        }
        this.setSimpleSignedProperty(uRI, string);
    }

    void setOptionalInputs(OptionalInputs optionalInputs) {
        this.request.setOptionalInputs(optionalInputs);
    }

    void setInputDocuments(InputDocuments inputDocuments) {
        this.request.setInputDocuments(inputDocuments);
    }

    String getProfile() {
        if (this.request != null && this.request.getProfile() != null) {
            String string = this.request.getProfile().toString();
            String string2 = Translate.getProfile(string);
            if (string2 != null) {
                string = string2;
            }
            return string;
        }
        return null;
    }

    boolean apiShouldCallToXmlReturnBase64() {
        String string = this.getProfile();
        return !this.userHasCallXmlReturnBase64 && ("xades".equals(string) || "wss".equals(string));
    }

    void fillRequest() throws Exception {
        if (!this.userHasCallRequestId) {
            this.setRequestId(this.getRandomString());
            this.userHasCallRequestId = false;
        }
        if (this.apiShouldCallToXmlReturnBase64()) {
            this.checkOptionalInputs();
            this.optionalInputs.setReturnBase64XML((Object)"");
        }
        this.setDefaultKeySubjectUsage();
        if (this.request != null && this.request.getOptionalInputs().getEnvelopingSignature() == null && this.request.getOptionalInputs().getSignaturePlacement() != null && this.request.getOptionalInputs().getSignaturePlacement().getXPathAfter() == null && this.request.getOptionalInputs().getSignaturePlacement().getXPathFirstChildOf() == null && this.request.getOptionalInputs().getExtendedSignaturePlacement() == null) {
            this.setXmlEnvelopedXPathFirstChildOf(DEFAULT_XMLENVELOPEDXPATHFIRSTCHILDOF);
        }
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingDs.setHeader(smartHeader.getInternalObject());
    }

    public SmartSignResponse send() throws Exception {
        this.fillRequest();
        SignResponse signResponse = this.bindingDs.sign(this.request);
        Hashtable hashtable = this.getOptions();
        Node node = null;
        Message message = this.bindingDs._getCall().getResponseMessage();
        if (message != null) {
            node = SmartWrapperUtil.getXmlBodyNode(message, "SignResponse");
        }
        SmartSignResponse smartSignResponse = new SmartSignResponse(signResponse, hashtable, node);
        if (this.apiShouldCallToXmlReturnBase64()) {
            smartSignResponse.setSignatureB64AsXml(true);
        }
        return smartSignResponse;
    }

    Hashtable getOptions() throws ConfigurationException {
        try {
            if (this.bindingDs._getCall() != null) {
                String string = this.bindingDs._getCall().getMessageContext().getTransportName();
                TWSDSLocator tWSDSLocator = (TWSDSLocator)this.bindingDs._getService();
                return SmartWrapperUtil.getTransportOptions(tWSDSLocator.getEngine(), string);
            }
            TWSDSLocator tWSDSLocator = (TWSDSLocator)this.bindingDs._getService();
            return tWSDSLocator.getEngine().getConfig().getHandler(new QName("sender")).getOptions();
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
    }

    EngineConfiguration getConfig() {
        TWSDSLocator tWSDSLocator = (TWSDSLocator)this.bindingDs._getService();
        return tWSDSLocator.getEngine().getConfig();
    }

    protected void finalize() {
        if (this.xmlFileToDelete != null) {
            this.removeReference(this.xmlFileToDelete);
            this.xmlFileToDelete = null;
        }
    }

    public void enableSignatureBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Base64Signature", "file", string);
    }

    public void enableDocumentWithSignaturePdfFile(String string) throws ConfigurationException {
        this.fileResponseTag("Base64Data", "file", string);
    }

    public void enableDocumentWithSignatureXmlBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Base64XML", "file", string);
    }

    public void enableSignatureMimeFile(String string) throws ConfigurationException {
        this.fileResponseTag("MimeSignature", "file", string);
    }

    public void enableSignatureXmlBase64File(String string) throws ConfigurationException {
        this.fileResponseTag("Base64XMLSignature", "file", string);
    }

    public void disableSignatureBase64File() throws ConfigurationException {
        this.fileResponseTag("Base64Signature", "string", "base64");
    }

    public void disableDocumentWithSignaturePdfFile() throws ConfigurationException {
        this.fileResponseTag("Base64Data", "string", "base64");
    }

    public void disableDocumentWithSignatureXmlBase64File() throws ConfigurationException {
        this.fileResponseTag("Base64XML", "string", "base64");
    }

    public void disableSignatureMimeFile() throws ConfigurationException {
        this.fileResponseTag("MimeSignature", "string", "base64");
    }

    public void disableSignatureXmlBase64File() throws ConfigurationException {
        this.fileResponseTag("Base64XMLSignature", "string", "base64");
    }
}

