/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartSamlPResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.www.TWS.SamlProtocolBindingStub;
import com.safelayer.www.TWS.SamlProtocolType;
import com.safelayer.www.TWS.TWSAALocator;
import java.util.Random;
import org.apache.axis.Message;
import org.apache.axis.types.HexBinary;
import org.apache.axis.types.Id;
import org.apache.axis.types.NCName;
import org.w3c.dom.Node;
import protocol._0._1.SAML.tc.names.oasis.RequestType;
import protocol._0._1.SAML.tc.names.oasis.ResponseType;

public class SmartSamlPRequest {
    private SamlProtocolBindingStub bindingSamlP;
    private RequestType request;
    private boolean userHasCallRequestId = false;
    private Random random;

    public SmartSamlPRequest(String string) throws Exception {
        TWSAALocator tWSAALocator = new TWSAALocator();
        tWSAALocator.setSamlProtocolTypeEndpointAddress(string);
        SamlProtocolType samlProtocolType = tWSAALocator.getSamlProtocolType();
        this.bindingSamlP = (SamlProtocolBindingStub)samlProtocolType;
        SmartWrapperUtil.setProperties(tWSAALocator.getEngine());
        this.request = new RequestType();
        this.initRandom();
    }

    public Object getInternalObject() {
        return this.request;
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingSamlP.setHeader(smartHeader.getInternalObject());
    }

    public void setRequestId(String string) {
        this.request.setRequestID(new Id("_" + string));
        this.userHasCallRequestId = true;
    }

    public void setAssertionIdReference(String string) {
        this.request.setAssertionIDReference(new NCName[]{new NCName(string)});
    }

    public void setAssertionArtifact(String string) {
        this.request.setAssertionArtifact(new String[]{string});
    }

    synchronized void initRandom() {
        this.random = new Random();
    }

    synchronized void getRandomValue(byte[] byArray) {
        this.random.nextBytes(byArray);
    }

    void fillRequest() {
        if (!this.userHasCallRequestId) {
            byte[] byArray = new byte[10];
            this.getRandomValue(byArray);
            this.setRequestId(HexBinary.encode((byte[])byArray));
            this.userHasCallRequestId = false;
        }
    }

    public SmartSamlPResponse send() throws Exception {
        this.fillRequest();
        ResponseType responseType = this.bindingSamlP.samlProtocol(this.request);
        Node node = null;
        Message message = this.bindingSamlP._getCall().getResponseMessage();
        if (message != null) {
            node = SmartWrapperUtil.getXmlBodyNode(message, "Response");
        }
        return new SmartSamlPResponse(responseType, node);
    }
}

