/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartReadResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import com.safelayer.www.TWS.TWSEPLocator;
import com.safelayer.www.TWS.TwsEPBindingStub;
import com.safelayer.www.TWS.TwsEPReadArg;
import com.safelayer.www.TWS.TwsEPReadRes;
import com.safelayer.www.TWS.TwsEPType;
import java.math.BigInteger;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.EngineConfiguration;

public class SmartReadRequest
extends AbstractSmartDataRequest {
    TwsEPReadArg request = new TwsEPReadArg();
    private TwsEPBindingStub bindingEp;

    public SmartReadRequest(String string) throws Exception {
        TWSEPLocator tWSEPLocator = new TWSEPLocator();
        tWSEPLocator.setEndpointAddress("EntityProfiler", string);
        TwsEPType twsEPType = tWSEPLocator.getEntityProfiler();
        this.bindingEp = (TwsEPBindingStub)twsEPType;
        SmartWrapperUtil.setProperties(tWSEPLocator.getEngine());
        this.request = new TwsEPReadArg();
    }

    public Object getInternalObject() {
        return this.request;
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingEp.setHeader(smartHeader.getInternalObject());
    }

    public void setXPath(String string) {
        this.request.setXpath(string);
    }

    public void setNextElements(int n) {
        this.request.setNextElements(BigInteger.valueOf(n));
    }

    public void setStartAt(int n) {
        this.request.setStartAt(BigInteger.valueOf(n));
    }

    public SmartReadResponse send() throws Exception {
        TwsEPReadRes twsEPReadRes = this.bindingEp.read(this.request);
        Hashtable hashtable = this.getOptions();
        SmartReadResponse smartReadResponse = new SmartReadResponse(twsEPReadRes, hashtable);
        return smartReadResponse;
    }

    Hashtable getOptions() throws ConfigurationException {
        try {
            if (this.bindingEp._getCall() != null) {
                String string = this.bindingEp._getCall().getMessageContext().getTransportName();
                TWSEPLocator tWSEPLocator = (TWSEPLocator)this.bindingEp._getService();
                return SmartWrapperUtil.getTransportOptions(tWSEPLocator.getEngine(), string);
            }
            TWSEPLocator tWSEPLocator = (TWSEPLocator)this.bindingEp._getService();
            return tWSEPLocator.getEngine().getConfig().getHandler(new QName("sender")).getOptions();
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
    }

    EngineConfiguration getConfig() {
        TWSEPLocator tWSEPLocator = (TWSEPLocator)this.bindingEp._getService();
        return tWSEPLocator.getEngine().getConfig();
    }
}

