/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartDscVerifyResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import com.safelayer.www.TWS.DSC.DSCBindingStub;
import com.safelayer.www.TWS.DSC.DigitalSignatureCustodyType;
import com.safelayer.www.TWS.DSC.TWSDSCLocator;
import com.safelayer.www.TWS.DscVerifyRequestType;
import com.safelayer.www.TWS.DscVerifyResponseType;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.types.URI;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.OptionalInputs;
import org.w3c.dom.Node;

public class SmartDscVerifyRequest
extends AbstractSmartDataRequest {
    private DscVerifyRequestType request;
    private DSCBindingStub bindingDsc;
    private OptionalInputs optionalInputs = null;
    private boolean userHasCallRequestId = false;

    public SmartDscVerifyRequest(String string) throws Exception {
        this.initRandom();
        this.request = new DscVerifyRequestType();
        TWSDSCLocator tWSDSCLocator = new TWSDSCLocator();
        tWSDSCLocator.setDigitalSignatureCustodyEndpointAddress(string);
        DigitalSignatureCustodyType digitalSignatureCustodyType = tWSDSCLocator.getDigitalSignatureCustody();
        this.bindingDsc = (DSCBindingStub)digitalSignatureCustodyType;
        SmartWrapperUtil.setProperties(tWSDSCLocator.getEngine());
    }

    public Object getInternalObject() {
        return this.request;
    }

    public void setArchiveReference(String string) throws Exception {
        this.request.setArchiveReference(new URI(string));
    }

    public void setArchiveReferenceId(String string) {
        this.request.setArchiveReferenceID(string);
    }

    void checkOptionalInputs() {
        if (this.optionalInputs == null) {
            this.optionalInputs = new OptionalInputs();
            this.request.setOptionalInputs(this.optionalInputs);
        }
    }

    public void setRequestId(String string) {
        this.request.setRequestID(string);
        this.userHasCallRequestId = true;
    }

    public void setServicePolicy(String string) throws Exception {
        this.checkOptionalInputs();
        this.optionalInputs.setServicePolicy(new URI(string));
    }

    void fillRequest() {
        if (!this.userHasCallRequestId) {
            this.setRequestId(this.getRandomString());
            this.userHasCallRequestId = false;
        }
    }

    public SmartDscVerifyResponse send() throws Exception {
        this.fillRequest();
        DscVerifyResponseType dscVerifyResponseType = this.bindingDsc.verify(this.request);
        Hashtable hashtable = this.getOptions();
        Node node = null;
        Message message = this.bindingDsc._getCall().getResponseMessage();
        if (message != null) {
            node = SmartWrapperUtil.getXmlBodyNode(message, "VerifyResponse");
        }
        SmartDscVerifyResponse smartDscVerifyResponse = new SmartDscVerifyResponse(dscVerifyResponseType, hashtable, node);
        return smartDscVerifyResponse;
    }

    public void setHeader(SmartHeader smartHeader) {
        if (this.bindingDsc != null) {
            this.bindingDsc.setHeader(smartHeader.getInternalObject());
        }
    }

    EngineConfiguration getConfig() {
        if (this.bindingDsc != null) {
            TWSDSCLocator tWSDSCLocator = (TWSDSCLocator)this.bindingDsc._getService();
            return tWSDSCLocator.getEngine().getConfig();
        }
        return null;
    }

    Hashtable getOptions() throws ConfigurationException {
        try {
            if (this.bindingDsc != null) {
                if (this.bindingDsc._getCall() != null) {
                    String string = this.bindingDsc._getCall().getMessageContext().getTransportName();
                    TWSDSCLocator tWSDSCLocator = (TWSDSCLocator)this.bindingDsc._getService();
                    return SmartWrapperUtil.getTransportOptions(tWSDSCLocator.getEngine(), string);
                }
                TWSDSCLocator tWSDSCLocator = (TWSDSCLocator)this.bindingDsc._getService();
                return tWSDSCLocator.getEngine().getConfig().getHandler(new QName("sender")).getOptions();
            }
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
        return null;
    }
}

