/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.AbstractSmartDataRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartDscStatusResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.Translate;
import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import com.safelayer.trustedx.client.smartwrapper.exception.InvalidValueException;
import com.safelayer.www.TWS.AdditionalMetadata;
import com.safelayer.www.TWS.CustomMetadata;
import com.safelayer.www.TWS.DSC.DSCBindingStub;
import com.safelayer.www.TWS.DSC.DigitalSignatureCustodyType;
import com.safelayer.www.TWS.DSC.TWSDSCLocator;
import com.safelayer.www.TWS.DocumentKeywords;
import com.safelayer.www.TWS.DscStatusRequestType;
import com.safelayer.www.TWS.DscStatusResponseType;
import com.safelayer.www.TWS.SearchConditions;
import com.safelayer.www.TWS.SignatureFormType;
import com.safelayer.www.TWS.SignatureType;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Message;
import org.apache.axis.types.Time;
import org.apache.axis.types.URI;
import org.oasis_open.docs.www.dss._2004._06.oasis_dss_1_0_core_schema_wd_27_xsd.OptionalInputs;
import org.w3c.dom.Node;

public class SmartDscStatusRequest
extends AbstractSmartDataRequest {
    private DscStatusRequestType request;
    private DSCBindingStub bindingDsc;
    private OptionalInputs optionalInputs = null;
    private SearchConditions searchConditions = null;
    private boolean userHasCallRequestId = false;

    public SmartDscStatusRequest(String string) throws Exception {
        this.initRandom();
        this.request = new DscStatusRequestType();
        TWSDSCLocator tWSDSCLocator = new TWSDSCLocator();
        tWSDSCLocator.setDigitalSignatureCustodyEndpointAddress(string);
        DigitalSignatureCustodyType digitalSignatureCustodyType = tWSDSCLocator.getDigitalSignatureCustody();
        this.bindingDsc = (DSCBindingStub)digitalSignatureCustodyType;
        SmartWrapperUtil.setProperties(tWSDSCLocator.getEngine());
    }

    void checkOptionalInputs() {
        if (this.optionalInputs == null) {
            this.optionalInputs = new OptionalInputs();
            this.request.setOptionalInputs(this.optionalInputs);
        }
    }

    public void setArchiveReference(String string) throws Exception {
        this.request.setArchiveReference(new URI(string));
    }

    public void setArchiveReferenceId(String string) {
        this.request.setArchiveReferenceID(string);
    }

    void checkSearchConditions() {
        this.checkOptionalInputs();
        if (this.searchConditions == null) {
            this.searchConditions = new SearchConditions();
            this.optionalInputs.setSearchConditions(this.searchConditions);
        }
    }

    public void setDigitalDocumentReference(String string) throws Exception {
        this.checkSearchConditions();
        this.searchConditions.setDigitalDocumentReference(new URI(string));
    }

    public void setDocumentTitle(String string) {
        this.checkSearchConditions();
        this.searchConditions.setDocumentTitle(string);
    }

    public void setArchivingPolicy(String string) {
        this.checkSearchConditions();
        this.searchConditions.setArchivingPolicy(string);
    }

    public void setDocumentKeyword(String string) {
        this.checkSearchConditions();
        if (this.searchConditions.getDocumentKeywords() != null && this.searchConditions.getDocumentKeywords().getDocumentKeyword() != null) {
            String[] stringArray = this.searchConditions.getDocumentKeywords().getDocumentKeyword();
            String[] stringArray2 = new String[stringArray.length + 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i];
            }
            stringArray2[stringArray.length] = string;
            this.searchConditions.getDocumentKeywords().setDocumentKeyword(stringArray2);
        } else {
            this.searchConditions.setDocumentKeywords(new DocumentKeywords());
            this.searchConditions.getDocumentKeywords().setDocumentKeyword(new String[]{string});
        }
    }

    public void setSignatureForm(String string) throws Exception {
        String string2 = Translate.putSignatureFormat(string);
        if (string2 == null) {
            string2 = string;
        }
        this.checkSearchConditions();
        this.searchConditions.setSignatureForm(SignatureFormType.fromString((String)string2));
    }

    public void setSignaturePlacement(String string) {
        this.checkSearchConditions();
        this.searchConditions.setSignatureType(SignatureType.fromString((String)string));
    }

    public void setSignerDn(String string) {
        this.checkSearchConditions();
        this.searchConditions.setSigner(string);
    }

    public void setSignerCA(String string) {
        this.checkSearchConditions();
        this.searchConditions.setSignerCA(string);
    }

    public void setSignerSerialNumber(String string) {
        this.checkSearchConditions();
        this.searchConditions.setSignerSerialNumber(string);
    }

    public void setSignerTSA(String string) {
        this.checkSearchConditions();
        this.searchConditions.setSignerTSA(string);
    }

    public void setSignatureAlgorithm(String string) throws Exception {
        this.checkSearchConditions();
        String[] stringArray = string.split(" ");
        if (stringArray.length == 2) {
            String string2 = Translate.putSignatureAlgorithm(stringArray[0]);
            if (string2 != null) {
                this.searchConditions.setSignatureAlgorithm(string2 + " " + stringArray[1]);
            } else {
                this.searchConditions.setSignatureAlgorithm(stringArray[0] + " " + stringArray[1]);
            }
        } else {
            String string3 = Translate.putSignatureAlgorithm(string);
            if (string3 != null) {
                this.searchConditions.setSignatureAlgorithm(string3);
            } else {
                this.searchConditions.setSignatureAlgorithm(string);
            }
        }
    }

    public void setRetentionDate(String string) throws Exception {
        try {
            this.checkSearchConditions();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'Z'");
            this.searchConditions.setRetentionDate(simpleDateFormat.parse(string));
        }
        catch (Exception exception) {
            throw new InvalidValueException();
        }
    }

    public void setRetentionTime(String string) throws Exception {
        try {
            this.checkSearchConditions();
            this.searchConditions.setRetentionTime(new Time(string));
        }
        catch (Exception exception) {
            throw new InvalidValueException();
        }
    }

    public void setExpirationDate(String string) throws Exception {
        try {
            this.checkSearchConditions();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'Z'");
            this.searchConditions.setExpirationDate(simpleDateFormat.parse(string));
        }
        catch (Exception exception) {
            throw new InvalidValueException();
        }
    }

    public void setExpirationTime(String string) throws Exception {
        try {
            this.checkSearchConditions();
            this.searchConditions.setExpirationTime(new Time(string));
        }
        catch (Exception exception) {
            throw new InvalidValueException();
        }
    }

    public void setTXContentType(String string) {
        this.checkSearchConditions();
        this.searchConditions.setTXContentType(string);
    }

    public void setStartAt(int n) {
        this.checkSearchConditions();
        this.searchConditions.setStartAt(BigInteger.valueOf(n));
    }

    public void setNextElements(int n) {
        this.checkSearchConditions();
        this.searchConditions.setNextElements(BigInteger.valueOf(n));
    }

    public void setServicePolicy(String string) throws Exception {
        this.checkOptionalInputs();
        this.optionalInputs.setServicePolicy(new URI(string));
    }

    void checkAdditionalMetadata() {
        if (this.optionalInputs != null && this.request.getOptionalInputs().getAdditionalMetadata() == null) {
            this.optionalInputs.setAdditionalMetadata(new AdditionalMetadata());
            this.request.setOptionalInputs(this.optionalInputs);
        }
    }

    public void setAddCustomMetadata(String string, String string2) throws Exception {
        this.checkOptionalInputs();
        this.checkAdditionalMetadata();
        AdditionalMetadata additionalMetadata = this.optionalInputs.getAdditionalMetadata();
        CustomMetadata[] customMetadataArray = null;
        CustomMetadata customMetadata = new CustomMetadata();
        customMetadata.setName(string);
        customMetadata.setValue(string2);
        if (additionalMetadata.getCustomMetadata() == null) {
            additionalMetadata.setCustomMetadata(new CustomMetadata[]{customMetadata});
            this.optionalInputs.setAdditionalMetadata(additionalMetadata);
        } else {
            customMetadataArray = additionalMetadata.getCustomMetadata();
            CustomMetadata[] customMetadataArray2 = new CustomMetadata[customMetadataArray.length + 1];
            for (int i = 0; i < customMetadataArray.length; ++i) {
                customMetadataArray2[i] = customMetadataArray[i];
            }
            customMetadataArray2[customMetadataArray.length] = customMetadata;
            additionalMetadata.setCustomMetadata(customMetadataArray2);
            this.optionalInputs.setAdditionalMetadata(additionalMetadata);
        }
    }

    public void setAddCustomMetadataName(int n, String string) throws Exception {
        this.checkOptionalInputs();
        this.checkAdditionalMetadata();
        AdditionalMetadata additionalMetadata = this.optionalInputs.getAdditionalMetadata();
        CustomMetadata[] customMetadataArray = additionalMetadata.getCustomMetadata();
        if (customMetadataArray == null) {
            CustomMetadata customMetadata = new CustomMetadata();
            customMetadata.setName(string);
            additionalMetadata.setCustomMetadata(new CustomMetadata[]{customMetadata});
            this.optionalInputs.setAdditionalMetadata(additionalMetadata);
        } else if (customMetadataArray.length > n) {
            this.optionalInputs.getAdditionalMetadata().getCustomMetadata(n).setName(string);
        } else {
            CustomMetadata customMetadata = new CustomMetadata();
            customMetadata.setName(string);
            CustomMetadata[] customMetadataArray2 = new CustomMetadata[customMetadataArray.length + 1];
            for (int i = 0; i < customMetadataArray.length; ++i) {
                customMetadataArray2[i] = customMetadataArray[i];
            }
            customMetadataArray2[customMetadataArray.length] = customMetadata;
            additionalMetadata.setCustomMetadata(customMetadataArray2);
            this.optionalInputs.setAdditionalMetadata(additionalMetadata);
        }
    }

    public void setAddCustomMetadataValue(int n, String string) throws Exception {
        this.checkOptionalInputs();
        this.checkAdditionalMetadata();
        AdditionalMetadata additionalMetadata = this.optionalInputs.getAdditionalMetadata();
        CustomMetadata[] customMetadataArray = additionalMetadata.getCustomMetadata();
        if (customMetadataArray == null) {
            CustomMetadata customMetadata = new CustomMetadata();
            customMetadata.setValue(string);
            additionalMetadata.setCustomMetadata(new CustomMetadata[]{customMetadata});
            this.optionalInputs.setAdditionalMetadata(additionalMetadata);
        } else if (customMetadataArray.length > n) {
            this.optionalInputs.getAdditionalMetadata().getCustomMetadata(n).setValue(string);
        } else {
            CustomMetadata customMetadata = new CustomMetadata();
            customMetadata.setValue(string);
            CustomMetadata[] customMetadataArray2 = new CustomMetadata[customMetadataArray.length + 1];
            for (int i = 0; i < customMetadataArray.length; ++i) {
                customMetadataArray2[i] = customMetadataArray[i];
            }
            customMetadataArray2[customMetadataArray.length] = customMetadata;
            additionalMetadata.setCustomMetadata(customMetadataArray2);
            this.optionalInputs.setAdditionalMetadata(additionalMetadata);
        }
    }

    public void setRequestId(String string) {
        this.request.setRequestID(string);
        this.userHasCallRequestId = true;
    }

    void fillRequest() {
        if (!this.userHasCallRequestId) {
            this.setRequestId(this.getRandomString());
            this.userHasCallRequestId = false;
        }
    }

    public SmartDscStatusResponse send() throws Exception {
        this.fillRequest();
        DscStatusResponseType dscStatusResponseType = this.bindingDsc.status(this.request);
        Hashtable hashtable = this.getOptions();
        Node node = null;
        Message message = this.bindingDsc._getCall().getResponseMessage();
        if (message != null) {
            node = SmartWrapperUtil.getXmlBodyNode(message, "StatusResponse");
        }
        SmartDscStatusResponse smartDscStatusResponse = new SmartDscStatusResponse(dscStatusResponseType, hashtable, node);
        return smartDscStatusResponse;
    }

    public void setHeader(SmartHeader smartHeader) {
        if (this.bindingDsc != null) {
            this.bindingDsc.setHeader(smartHeader.getInternalObject());
        }
    }

    EngineConfiguration getConfig() {
        if (this.bindingDsc != null) {
            TWSDSCLocator tWSDSCLocator = (TWSDSCLocator)this.bindingDsc._getService();
            return tWSDSCLocator.getEngine().getConfig();
        }
        return null;
    }

    Hashtable getOptions() throws ConfigurationException {
        try {
            if (this.bindingDsc != null) {
                if (this.bindingDsc._getCall() != null) {
                    String string = this.bindingDsc._getCall().getMessageContext().getTransportName();
                    TWSDSCLocator tWSDSCLocator = (TWSDSCLocator)this.bindingDsc._getService();
                    return SmartWrapperUtil.getTransportOptions(tWSDSCLocator.getEngine(), string);
                }
                TWSDSCLocator tWSDSCLocator = (TWSDSCLocator)this.bindingDsc._getService();
                return tWSDSCLocator.getEngine().getConfig().getHandler(new QName("sender")).getOptions();
            }
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
        return null;
    }
}

