/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.SmartCompoundResponse;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartRegisterRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import java.util.Random;
import org.apache.axis.types.Id;
import org.w3.www._2002._03.xkms.CompoundRequestType;
import org.w3.www._2002._03.xkms.CompoundResultType;
import org.w3.www._2002._03.xkms.RegisterRequestType;
import org.w3.www._2002._03.xkms.SOAPBindingStub;
import org.w3.www._2002._03.xkms.XKMSPortType;
import org.w3.www._2002._03.xkms.XKMSServiceLocator;

public class SmartCompoundRequest {
    private CompoundRequestType request;
    private SOAPBindingStub bindingKm;
    private boolean userHasCalledId = false;
    private Random random = new Random();
    private static String chars = "abcdefghijklmonpqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    public SmartCompoundRequest(String string) throws Exception {
        XKMSServiceLocator xKMSServiceLocator = new XKMSServiceLocator();
        xKMSServiceLocator.setXKMSPortEndpointAddress(string);
        XKMSPortType xKMSPortType = xKMSServiceLocator.getXKMSPort();
        this.bindingKm = (SOAPBindingStub)xKMSPortType;
        SmartWrapperUtil.setProperties(xKMSServiceLocator.getEngine());
        this.request = new CompoundRequestType();
    }

    public Object getInternalObject() {
        return this.request;
    }

    public void setHeader(SmartHeader smartHeader) {
        this.bindingKm.setHeader(smartHeader.getInternalObject());
    }

    public void setId(String string) {
        this.request.setId(new Id(string));
        this.userHasCalledId = true;
    }

    public void setRegisterRequest(SmartRegisterRequest smartRegisterRequest) {
        if (this.request.getRegisterRequest() != null) {
            RegisterRequestType[] registerRequestTypeArray = new RegisterRequestType[this.request.getRegisterRequest().length + 1];
            for (int i = 0; i < this.request.getRegisterRequest().length; ++i) {
                registerRequestTypeArray[i] = this.request.getRegisterRequest(i);
            }
            registerRequestTypeArray[this.request.getRegisterRequest().length] = (RegisterRequestType)smartRegisterRequest.getInternalObject();
            this.request.setRegisterRequest(registerRequestTypeArray);
        } else {
            this.request.setRegisterRequest(new RegisterRequestType[]{(RegisterRequestType)smartRegisterRequest.getInternalObject()});
        }
    }

    void fillRequest() {
        if (!this.userHasCalledId) {
            this.setId(this.getRandomString());
            this.userHasCalledId = false;
        }
    }

    public SmartCompoundResponse send() throws Exception {
        this.fillRequest();
        CompoundResultType compoundResultType = this.bindingKm.compound(this.request);
        return new SmartCompoundResponse(compoundResultType);
    }

    void getRandomValue(byte[] byArray) {
        this.random.nextBytes(byArray);
    }

    String getRandomString() {
        char[] cArray = new char[10];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = chars.charAt(this.random.nextInt(chars.length()));
        }
        return new String(cArray);
    }
}

