/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.smartwrapper.SmartChainProxy;
import com.safelayer.trustedx.client.smartwrapper.SmartCrl;
import com.safelayer.trustedx.client.smartwrapper.SmartOcsp;
import com.safelayer.trustedx.client.smartwrapper.SmartSignatureResult;
import com.safelayer.trustedx.client.smartwrapper.SmartVa;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.www.TWS.Base64Binary;
import com.safelayer.www.TWS.CertificateType;
import com.safelayer.www.TWS.SingleCertInfo;
import org.w3c.dom.Node;

public class SmartChain {
    private SmartChainProxy obj;
    private Node node;

    SmartChain(SingleCertInfo singleCertInfo, Node node) {
        this.obj = new SmartChainProxy(singleCertInfo);
        this.node = node;
    }

    SmartChain(CertificateType certificateType, Base64Binary base64Binary, Node node) {
        this.obj = new SmartChainProxy(certificateType, base64Binary);
        this.node = node;
    }

    public String getSignerCertificateXml() throws Exception {
        if (this.obj != null && this.obj.getCertificate() != null) {
            return SmartWrapperUtil.serialize(this.node, this.obj.getCertificatePath());
        }
        return null;
    }

    public String getSignerCertificateBinary() {
        if (this.obj != null && this.obj.getEncapsulatedX509Certificate() != null) {
            return this.obj.getEncapsulatedX509Certificate().toString();
        }
        return null;
    }

    public int getNumberCrls() {
        int n = 0;
        if (this.obj != null && this.obj.getRevocationValues() != null && this.obj.getRevocationValues().getOtherValues() != null) {
            n = SmartSignatureResult.getNumberCrls(this.obj.getRevocationValues().getOtherValues().get_any());
        }
        return n;
    }

    public int getNumberOcsp() {
        int n = 0;
        if (this.obj != null && this.obj.getRevocationValues() != null && this.obj.getRevocationValues().getOtherValues() != null) {
            n = SmartSignatureResult.getNumberOcsp(this.obj.getRevocationValues().getOtherValues().get_any());
        }
        return n;
    }

    public int getNumberVa() {
        int n = 0;
        if (this.obj != null && this.obj.getRevocationValues() != null && this.obj.getRevocationValues().getOtherValues() != null) {
            n = SmartSignatureResult.getNumberVas(this.obj.getRevocationValues().getOtherValues().get_any());
        }
        return n;
    }

    public SmartCrl getCrl(int n) {
        if (this.obj != null && this.obj.getRevocationValues() != null) {
            return SmartSignatureResult.getCrl(this.obj.getRevocationValues(), n);
        }
        return null;
    }

    public SmartOcsp getOcsp(int n) {
        if (this.obj != null && this.obj.getRevocationValues() != null) {
            return SmartSignatureResult.getOcsp(this.obj.getRevocationValues(), n);
        }
        return null;
    }

    public SmartVa getVa(int n) {
        if (this.obj != null && this.obj.getRevocationValues() != null) {
            return SmartSignatureResult.getVa(this.obj.getRevocationValues(), n);
        }
        return null;
    }
}

