/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.client.smartwrapper;

import com.safelayer.trustedx.client.axis.TxHttpTransport;
import com.safelayer.trustedx.client.smartwrapper.SmartHeader;
import com.safelayer.trustedx.client.smartwrapper.SmartWrapperUtil;
import com.safelayer.trustedx.client.smartwrapper.exception.ConfigurationException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.types.HexBinary;

abstract class AbstractSmartDataRequest {
    Random random;
    static final String WSSE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    static final String URI_PWD_TEXT = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";

    AbstractSmartDataRequest() {
    }

    abstract void setHeader(SmartHeader var1);

    abstract Hashtable getOptions() throws ConfigurationException;

    abstract EngineConfiguration getConfig();

    synchronized void initRandom() {
        this.random = new Random();
    }

    synchronized void getRandomValue(byte[] byArray) {
        this.random.nextBytes(byArray);
    }

    String getRandomString() {
        byte[] byArray = new byte[10];
        this.getRandomValue(byArray);
        return HexBinary.encode((byte[])byArray);
    }

    String getLoadPath(Hashtable hashtable) {
        return (String)hashtable.get(TxHttpTransport.getReqParam((String)"loadPath", null));
    }

    String getReferenceFileNamePath(String string) {
        Hashtable hashtable = null;
        try {
            hashtable = this.getOptions();
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
        }
        if (hashtable != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getLoadPath(hashtable));
            stringBuffer.append(File.separator);
            stringBuffer.append(string);
            return stringBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String setReferenceContent(byte[] byArray) throws IOException {
        String string = this.getRandomString();
        String string2 = this.getReferenceFileNamePath(string);
        if (string2 != null) {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.write(byArray);
                }
                finally {
                    fileOutputStream.close();
                }
            }
            return string;
        }
        return null;
    }

    void removeReference(String string) {
        String string2 = this.getReferenceFileNamePath(string);
        File file = new File(string2);
        file.delete();
    }

    static boolean isBig(String string) {
        return string.length() > 76800;
    }

    static boolean isAxisPlusTag(String string, Hashtable hashtable) {
        boolean bl = false;
        if (hashtable != null) {
            String string2 = (String)hashtable.get(TxHttpTransport.getReqParam((String)"tags", null));
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                if (!string.equals(string3)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    static boolean isAxisPlusTagAsBase64(String string, Hashtable hashtable) {
        String string2;
        boolean bl = false;
        if (hashtable != null && (string2 = (String)hashtable.get(TxHttpTransport.getReqParam((String)"asBase64", (String)string))) != null && "true".equalsIgnoreCase(string2)) {
            bl = true;
        }
        return bl;
    }

    static void checkIsFile(boolean bl, String string, Hashtable hashtable) throws ConfigurationException {
        if (bl != AbstractSmartDataRequest.isAxisPlusTag(string, hashtable)) {
            throw new ConfigurationException(string);
        }
    }

    void fileRequestTag(String string, String string2, String string3) throws ConfigurationException {
        if ("file".equals(string2)) {
            SmartWrapperUtil.addTag(this.getOptions(), "Request.tags", string);
            this.getOptions().put("Request." + string + ".asBase64", Boolean.toString("base64".equals(string3)));
            this.putLogRequestOption("tags", (String)this.getOptions().get("Request.tags"));
            this.putLogRequestOption(string + ".asBase64", Boolean.toString("base64".equals(string3)));
        } else {
            SmartWrapperUtil.removeTag(this.getOptions(), "Request.tags", string);
            this.getOptions().put("Request." + string + ".asBase64", Boolean.toString("base64".equals(string3)));
            this.putLogRequestOption("tags", (String)this.getOptions().get("Request.tags"));
            this.putLogRequestOption(string + ".asBase64", Boolean.toString("base64".equals(string3)));
        }
    }

    void fileResponseTag(String string, String string2, String string3) throws ConfigurationException {
        if ("file".equals(string2)) {
            SmartWrapperUtil.addTag(this.getOptions(), "Response.tags", string);
            this.getOptions().put("Response." + string + ".asBase64", Boolean.toString("base64".equals(string3)));
            this.putLogResponseOption("tags", (String)this.getOptions().get("Response.tags"));
            this.putLogResponseOption(string + ".asBase64", Boolean.toString("base64".equals(string3)));
        } else {
            SmartWrapperUtil.removeTag(this.getOptions(), "Response.tags", string);
            this.getOptions().put("Response." + string + ".asBase64", Boolean.toString("base64".equals(string3)));
            this.putLogResponseOption("tags", (String)this.getOptions().get("Response.tags"));
            this.putLogResponseOption(string + ".asBase64", Boolean.toString("base64".equals(string3)));
        }
    }

    void putLogRequestOption(String string, String string2) throws ConfigurationException {
        try {
            this.getConfig().getHandler(new QName("req-log")).setOption(string, (Object)string2);
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
    }

    void putLogResponseOption(String string, String string2) throws ConfigurationException {
        try {
            this.getConfig().getHandler(new QName("res-log")).setOption(string, (Object)string2);
        }
        catch (org.apache.axis.ConfigurationException configurationException) {
            throw new ConfigurationException(configurationException);
        }
    }
}

