/*
 * Decompiled with CFR 0.152.
 */
package com.safelayer.trustedx.jsse;

import com.safelayer.trustedx.jsse.KeyAliasConfiguration;
import com.safelayer.trustedx.jsse.TxX509KeyManager;
import com.safelayer.trustedx.jsse.TxX509KeyManagerFactoryConfig;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.X509KeyManager;

public class TxX509KeyManagerFactorySpi
extends KeyManagerFactorySpi {
    public static final String SUN_KEYMANAGER_FACTORY_ALGORITHM = "SunX509";
    public static final String TX_KEYMANAGER_FACTORY_ALGORITHM = "TxTrustX509";
    private KeyManagerFactory kmf;
    private TxX509KeyManager txKeyManager;
    private KeyAliasConfiguration keyAliasConfig;

    @Override
    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (managerFactoryParameters instanceof TxX509KeyManagerFactoryConfig) {
            TxX509KeyManagerFactoryConfig txX509KeyManagerFactoryConfig = (TxX509KeyManagerFactoryConfig)managerFactoryParameters;
            this.keyAliasConfig = txX509KeyManagerFactoryConfig.getKeyAliasConfig();
            try {
                this.kmf = KeyManagerFactory.getInstance(SUN_KEYMANAGER_FACTORY_ALGORITHM);
                this.kmf.init(txX509KeyManagerFactoryConfig.getKeyStore(), txX509KeyManagerFactoryConfig.getKeyStorePassword());
                KeyManager[] keyManagerArray = this.kmf.getKeyManagers();
                if (keyManagerArray == null || keyManagerArray.length == 0) {
                    throw new InvalidAlgorithmParameterException("The default algorithm \"SunX509\" produced no key managers");
                }
                X509KeyManager x509KeyManager = null;
                for (KeyManager keyManager : keyManagerArray) {
                    if (!(keyManager instanceof X509KeyManager)) continue;
                    x509KeyManager = (X509KeyManager)keyManager;
                    break;
                }
                if (x509KeyManager == null) {
                    throw new InvalidAlgorithmParameterException("The default algorithm :\"SunX509\" did not produce a X509 Key manager");
                }
                this.txKeyManager = new TxX509KeyManager(x509KeyManager, this.keyAliasConfig);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                throw new InvalidAlgorithmParameterException(unrecoverableKeyException);
            }
            catch (KeyStoreException keyStoreException) {
                throw new InvalidAlgorithmParameterException(keyStoreException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidAlgorithmParameterException(noSuchAlgorithmException);
            }
        } else {
            throw new InvalidAlgorithmParameterException("ManagerFactoryParameters must implement TxX509KeyManagerFactoryConfig");
        }
    }

    @Override
    protected void engineInit(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.kmf.init(keyStore, cArray);
    }

    @Override
    protected KeyManager[] engineGetKeyManagers() {
        if (this.txKeyManager != null) {
            return new KeyManager[]{this.txKeyManager};
        }
        return this.kmf.getKeyManagers();
    }

    public static String getAlgorithm() {
        return TX_KEYMANAGER_FACTORY_ALGORITHM;
    }
}

