jQuery(function($){
	$(document).ready(function(){
	
	jQuery.fn.extend({
    param: function( a ) { 
        var s = []; 
 
        // If an array was passed in, assume that it is an array 
        // of form elements 
        if ( a.constructor == Array || a.jquery ){
            // Serialize the form elements 
            jQuery.each( a, function(){ 
                s.push(unescape(encodeURIComponent(escape(this.name))) + "=" + unescape(encodeURIComponent(escape(this.value)))); 
            }); 
        } 
        // Otherwise, assume that it's an object of key/value pairs 
        else{ 
            // Serialize the key/values 
            for ( var j in a ) 
                // If the value is an array then the key names need to be repeated 
                if ( a[j] && a[j].constructor == Array ) 
                    jQuery.each( a[j], function(){ 
                        s.push(unescape(encodeURIComponent(escape(j)) + "=" + encodeURIComponent(escape(this)))); 
                    }); 
                else 
                    s.push(unescape(encodeURIComponent(escape(j)) + "=" + encodeURIComponent(escape(a[j])))); 
        } 
        // Return the resulting serialization 
        return s.join("&").replace(/ /g, "+"); 
    },

    serialize: function() { 
        return this.param(this.serializeArray()); 
    }
    
	
}); 
  
	var idCaptcha = (new Date).getTime();
	$("#captcha").attr("src", "https://apps.euskadi.eus/v79aWar/captchaWidget?idCaptcha=" + idCaptcha +'&R01HNoPortal=true');
	$("#idCaptcha").val(idCaptcha);

	$("#formSuscripcionPoder").submit(function(event){
		event.preventDefault();
		$.ajax({
			url: $("#formSuscripcionPoder").attr('action')+"?callback=?&R01HNoPortal=true&p09=true&p04=es",
			type: "GET",
			dataType: "jsonp",
			async: false,
    		jsonpCallback: 'processResponse',
    		contentType: "application/json;charset=utf-8",
			data: $("#formSuscripcionPoder").serialize(),
			success: function( data, status, xhr ) {
				var resultado = data.resultado;
				if (resultado == 'OK'){
					$("#widget_poderadjudicadorform").attr('style','display:none');
					$("#widget_poderadjudicadorerror").attr('style',"display:none");
					$("#widget_poderadjudicadorconfirm").attr('class',"visible");
			    } else if (resultado == 'ERRORCAPTCHA'){
					$("#divErrores").attr("class","erroresSuscripcion");
					$("#divErrores").html(cabeceraError + "<ul id='ulErrores'><li>" + errorCaptcha + "</li></ul>");
				} else {
					$("#widget_poderadjudicadorform").attr('style','display:none');
					$("#widget_poderadjudicadorerror").attr('style',"display:''");
				} 						
				return false;
			},
			error: function (xhr, ajaxOptions, thrownError) {
				alert ("ERROR " + thrownError);
				alert ("ERROR " + xhr.responseText);
				$("#widget_poderadjudicadorform").attr('style','display:none');
				$("#widget_poderadjudicadorerror").attr('class',"visible");	
				return false;
			}
		});
		return false;
	});
			

	$("#btnsuscribir").click(function(event){
		event.preventDefault();
		var idioma = $("#idioma").val();
		var email= $("#email").val();
		var telefono= $("#telefono").val();
		var tipoSuscripcion= $('input[name=p02]:radio:checked').val() ;
		var captcha= $("#captchaText").val();
		
		var mailvalido = validar_email(email);
		var telefovalido = true;
		if (telefono!=null && telefono!=''){
				telefovalido =validar_telefono(telefono);
		}
		var tipoSuscripValido = validar_tipoSuscripcion(tipoSuscripcion);
		if (!mailvalido || !telefovalido){
			var htmlErrores= cabeceraError;			
			htmlErrores = htmlErrores + "<ul id='ulErrores'>";			
			if (!tipoSuscripValido){
				htmlErrores = htmlErrores + "<li>"+ errorTipoSuscripcion+ "</li>";
			}
			if (!mailvalido) {
				if (email==null || email==''){
					htmlErrores = htmlErrores + "<li>"+ errorMailVacio + "</li>";
				} else {
					htmlErrores = htmlErrores + "<li>"+ errorMailFormato+ "</li>";
				}
			}
				
			if (!telefovalido){
				htmlErrores = htmlErrores + "<li>"+ errorTelefonoFormato+ "</li>";
			}

			if (captcha==null || captcha==''){
				htmlErrores = htmlErrores + "<li>"+ errorCaptcha+ "</li>";
			}
				
			htmlErrores = htmlErrores + "</ul>";
			$("#divErrores").attr("class","erroresSuscripcion");
			$("#divErrores").html(htmlErrores);
			
			return false;
		} else {
			$("#formSuscripcionPoder").submit();
		}	
	});	
	
	
	
	
	
	
	
	$("#formCancelarSuscripcionPoder").submit(function(event){

		event.preventDefault();
		$.ajax({
			url: $("#formCancelarSuscripcionPoder").attr('action')+"?callback=?&R01HNoPortal=true&p09=true&p04=es",
			type: "GET",
			dataType: "jsonp",
			async: false,
    		jsonpCallback: 'processResponse',
    		contentType: "application/json;charset=utf-8",
			data: $("#formCancelarSuscripcionPoder").serialize(),
			success: function( data, status, xhr ) {
				var resultado = data.resultado;
				if (resultado == 'OK'){
					$("#widget_poderadjudicadorform").attr('style','display:none');
					$("#widget_bajapoderadjudicadorerror").attr('style',"display:none");
					$("#widget_bajapoderadjudicadorconfirm").attr('class',"visible");	
				} else {
					$("#widget_bajapoderadjudicadorform").attr('style','display:none');
					$("#widget_bajapoderadjudicadorerror").attr('style',"display:''");
				} 						
				return false;
			},
			error: function (xhr, ajaxOptions, thrownError) {
				alert ("ERROR " + thrownError);
				alert ("ERROR " + xhr.responseText);
				$("#widget_bajapoderadjudicadorform").attr('style','display:none');
				$("#widget_bajapoderadjudicadorerror").attr('class',"visible");	
				return false;
			}
		});
		return false;
	});
	
	
	
	
	$("#btncancelar").click(function(event){
		event.preventDefault();
		var idioma = $("#idioma").val();
		var email= $("#emailBaja").val();
		var mailvalido = validar_email(email);

		if (!mailvalido){
			var htmlErrores= cabeceraError;			
			htmlErrores = htmlErrores + "<ul id='ulErrores'>";			
			if (email==null || email==''){
				htmlErrores = htmlErrores + "<li>"+ errorMailVacio + "</li>";
			} else {
				htmlErrores = htmlErrores + "<li>"+ errorMailFormato+ "</li>";
			}
			htmlErrores = htmlErrores + "</ul>";
			$("#divErroresBaja").attr("class","erroresSuscripcion");
			$("#divErroresBaja").html(htmlErrores);
			
			return false;
		} else {
			$("#formCancelarSuscripcionPoder").submit();
		}	
	});		
	
	
	
	
	
	
	
	
	
	
});

});
			
function validar_email(valor)
    {
        // creamos nuestra regla con expresiones regulares.
        var filter = /[\w-\.]{3,}@([\w-]{2,}\.)*([\w-]{2,}\.)[\w-]{2,4}/;
        // utilizamos test para comprobar si el parametro valor cumple la regla
        if(filter.test(valor))
            return true;
        else
            return false;
}
	
function validar_telefono(valor)
{
        // creamos nuestra regla con expresiones regulares.
        var filter = /^\d{9,9}$/;
        // utilizamos test para comprobar si el parametro valor cumple la regla
        if(filter.test(valor))
            return true;
        else
            return false;
}

function validar_tipoSuscripcion(valor)
{
    if (valor ==null || valor ==''){
		return false;
	}
	return(valor=='1' || valor=='2');	
}


