/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.thirdsgateway.security.crypto;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.util.encoders.Base64Utils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Hex;
import p12f.exe.thirdsgateway.security.crypto.CryptoHelperException;

public class TripleDESEBCDICCryptoHelper {
    public static final String CIPHER_3DES_CBC_NOPADDING = "DESede/CBC/NoPadding";
    public static final String CIPHER_3DES_ECB_PKCS5Padding = "DESede/ECB/PKCS5Padding";
    public static final String CIPHER_3DES_ECB_NOPADDING = "DESede/ECB/NoPadding";
    private static String ALGORITHM_3DES = "DESede";
    public static final String encoding = "CP500";
    public static final String ENC_TYPE_HEX = "hex";
    public static final String ENC_TYPE_BASE64 = "base64";
    public static final String ENC_TYPE_NONE = "none";

    private TripleDESEBCDICCryptoHelper() {
    }

    public static String encrypt(String clave1, String clave2, String encType, String str) throws CryptoHelperException {
        if (ENC_TYPE_NONE.equals(encType)) {
            return str;
        }
        if (ENC_TYPE_BASE64.equals(encType)) {
            return TripleDESEBCDICCryptoHelper.encryptBASE64(clave1, clave2, str);
        }
        if (ENC_TYPE_HEX.equals(encType)) {
            return TripleDESEBCDICCryptoHelper.encryptHEX(clave1, clave2, str);
        }
        return null;
    }

    public static String encrypt(String clave1, String clave2, String encType, String modeCipherPadding, String str) throws CryptoHelperException {
        if (ENC_TYPE_NONE.equals(encType)) {
            return str;
        }
        if (ENC_TYPE_BASE64.equals(encType)) {
            return TripleDESEBCDICCryptoHelper.encryptBASE64(clave1, clave2, modeCipherPadding, str);
        }
        if (ENC_TYPE_HEX.equals(encType)) {
            return TripleDESEBCDICCryptoHelper.encryptHEX(clave1, clave2, modeCipherPadding, str);
        }
        return null;
    }

    public static String decrypt(String clave1, String clave2, String encType, String str) throws CryptoHelperException {
        if (ENC_TYPE_NONE.equals(encType)) {
            return str;
        }
        if (ENC_TYPE_BASE64.equals(encType)) {
            return TripleDESEBCDICCryptoHelper.decryptBASE64(clave1, clave2, str);
        }
        if (ENC_TYPE_HEX.equals(encType)) {
            return TripleDESEBCDICCryptoHelper.decryptHEX(clave1, clave2, str);
        }
        return null;
    }

    public static String decrypt(String clave1, String clave2, String encType, String modeCipherPadding, String str) throws CryptoHelperException {
        if (ENC_TYPE_NONE.equals(encType)) {
            return str;
        }
        if (ENC_TYPE_BASE64.equals(encType)) {
            return TripleDESEBCDICCryptoHelper.decryptBASE64(clave1, clave2, modeCipherPadding, str);
        }
        if (ENC_TYPE_HEX.equals(encType)) {
            return TripleDESEBCDICCryptoHelper.decryptHEX(clave1, clave2, modeCipherPadding, str);
        }
        return null;
    }

    public static String encryptBASE64(String clave1, String clave2, String str) throws CryptoHelperException {
        return TripleDESEBCDICCryptoHelper.encryptBASE64(clave1, clave2, CIPHER_3DES_CBC_NOPADDING, str);
    }

    public static String encryptBASE64(String clave1, String clave2, String modeCipherPadding, String str) throws CryptoHelperException {
        try {
            String strToEncrypt;
            String passPhrase = new String(Hex.encode((byte[])TripleDESEBCDICCryptoHelper.doXOR(clave1, clave2))).toUpperCase();
            byte[] seed_key = Hex.decode((String)passPhrase);
            SecretKeySpec keySpec = new SecretKeySpec(seed_key, ALGORITHM_3DES);
            Cipher ecipher = Cipher.getInstance(modeCipherPadding);
            if (modeCipherPadding.equalsIgnoreCase(CIPHER_3DES_CBC_NOPADDING)) {
                byte[] ivBytes = new byte[8];
                IvParameterSpec iv = new IvParameterSpec(ivBytes);
                ecipher.init(1, (Key)keySpec, iv);
            } else {
                ecipher.init(1, keySpec);
            }
            if (str.length() % 8 != 0) {
                int modulo = str.length() % 8;
                strToEncrypt = StringUtils.rPadWithChar((String)str, (char)' ', (int)(str.length() + 8 - modulo));
            } else {
                strToEncrypt = str;
            }
            byte[] toEBCDIC = strToEncrypt.getBytes(encoding);
            byte[] enc = ecipher.doFinal(toEBCDIC);
            return Base64Utils.encode((byte[])enc);
        }
        catch (BadPaddingException e) {
            throw new CryptoHelperException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoHelperException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoHelperException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoHelperException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoHelperException(e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoHelperException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoHelperException(e);
        }
    }

    public static String decryptBASE64(String clave1, String clave2, String encryptedChain) throws CryptoHelperException {
        return TripleDESEBCDICCryptoHelper.decryptBASE64(clave1, clave2, CIPHER_3DES_CBC_NOPADDING, encryptedChain);
    }

    public static String decryptBASE64(String clave1, String clave2, String modeCipherPadding, String encryptedChain) throws CryptoHelperException {
        try {
            String passPhrase = new String(Hex.encode((byte[])TripleDESEBCDICCryptoHelper.doXOR(clave1, clave2))).toUpperCase();
            byte[] seed_key = Hex.decode((String)passPhrase);
            SecretKeySpec keySpec = new SecretKeySpec(seed_key, ALGORITHM_3DES);
            Cipher dcipher = Cipher.getInstance(modeCipherPadding);
            if (modeCipherPadding.equalsIgnoreCase(CIPHER_3DES_CBC_NOPADDING)) {
                byte[] ivBytes = new byte[8];
                IvParameterSpec iv = new IvParameterSpec(ivBytes);
                dcipher.init(2, (Key)keySpec, iv);
            } else {
                dcipher.init(2, keySpec);
            }
            byte[] dec = Base64Utils.decode((String)encryptedChain);
            return new String(dcipher.doFinal(dec), encoding);
        }
        catch (BadPaddingException e) {
            throw new CryptoHelperException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoHelperException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoHelperException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoHelperException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoHelperException(e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoHelperException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoHelperException(e);
        }
    }

    public static String encryptHEX(String clave1, String clave2, String str) throws CryptoHelperException {
        return TripleDESEBCDICCryptoHelper.encryptHEX(clave1, clave2, CIPHER_3DES_CBC_NOPADDING, str);
    }

    public static String encryptHEX(String clave1, String clave2, String modeCipherPadding, String str) throws CryptoHelperException {
        try {
            String strToEncrypt;
            String passPhrase = new String(Hex.encode((byte[])TripleDESEBCDICCryptoHelper.doXOR(clave1, clave2))).toUpperCase();
            byte[] seed_key = Hex.decode((String)passPhrase);
            SecretKeySpec keySpec = new SecretKeySpec(seed_key, ALGORITHM_3DES);
            Cipher ecipher = Cipher.getInstance(modeCipherPadding);
            if (modeCipherPadding.equalsIgnoreCase(CIPHER_3DES_CBC_NOPADDING)) {
                byte[] ivBytes = new byte[8];
                IvParameterSpec iv = new IvParameterSpec(ivBytes);
                ecipher.init(1, (Key)keySpec, iv);
            } else {
                ecipher.init(1, keySpec);
            }
            if (str.length() % 8 != 0) {
                int modulo = str.length() % 8;
                strToEncrypt = StringUtils.rPadWithChar((String)str, (char)' ', (int)(str.length() + 8 - modulo));
            } else {
                strToEncrypt = str;
            }
            byte[] toEBCDIC = strToEncrypt.getBytes(encoding);
            byte[] enc = ecipher.doFinal(toEBCDIC);
            return new String(Hex.encode((byte[])enc)).toUpperCase();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CryptoHelperException(ex);
        }
    }

    public static String decryptHEX(String clave1, String clave2, String encryptedChain) throws CryptoHelperException {
        return TripleDESEBCDICCryptoHelper.decryptHEX(clave1, clave2, CIPHER_3DES_CBC_NOPADDING, encryptedChain);
    }

    public static String decryptHEX(String clave1, String clave2, String modeCipherPadding, String encryptedChain) throws CryptoHelperException {
        try {
            String passPhrase = new String(Hex.encode((byte[])TripleDESEBCDICCryptoHelper.doXOR(clave1, clave2))).toUpperCase();
            byte[] seed_key = Hex.decode((String)passPhrase);
            SecretKeySpec keySpec = new SecretKeySpec(seed_key, ALGORITHM_3DES);
            Cipher dcipher = Cipher.getInstance(modeCipherPadding);
            if (modeCipherPadding.equalsIgnoreCase(CIPHER_3DES_CBC_NOPADDING)) {
                byte[] ivBytes = new byte[8];
                IvParameterSpec iv = new IvParameterSpec(ivBytes);
                dcipher.init(2, (Key)keySpec, iv);
            } else {
                dcipher.init(2, keySpec);
            }
            byte[] encData = Hex.decode((String)encryptedChain);
            return new String(dcipher.doFinal(encData), encoding);
        }
        catch (BadPaddingException e) {
            throw new CryptoHelperException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoHelperException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoHelperException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoHelperException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoHelperException(e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoHelperException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoHelperException(e);
        }
    }

    public static byte[] doXOR(String clave1, String clave2) throws CryptoHelperException {
        if (clave1.length() != clave2.length()) {
            throw new CryptoHelperException("Las dos claves deben tener la misma longitud.");
        }
        byte[] keyBytes1 = Hex.decode((String)clave1);
        byte[] keyBytes2 = Hex.decode((String)clave2);
        byte[] keyBytesXOR = new byte[keyBytes1.length];
        for (int i = 0; i < keyBytesXOR.length; ++i) {
            int intValue = new Byte(keyBytes1[i]).intValue() ^ new Byte(keyBytes2[i]).intValue();
            keyBytesXOR[i] = new Integer(intValue).byteValue();
        }
        return keyBytesXOR;
    }

    public static String getXMLStream() throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream("D:///datos//registro.xml")));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String stream = "";
        String inputLine = "";
        while ((inputLine = in.readLine()) != null) {
            System.out.println(inputLine);
            stream = stream + inputLine;
        }
        in.close();
        return stream;
    }
}

