/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.search.sqlutils;

import com.ejie.r01f.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12f.exe.search.PaymentQuery;
import p12f.exe.search.XMLSearchProperties;
import p12f.exe.search.parameters.EXPSearchedParam;
import p12f.exe.search.parameters.FinantialOrgSearchedParam;
import p12f.exe.search.parameters.PaymentDataSearchedParam;
import p12f.exe.search.parameters.PaymentModeSearchedParam;
import p12f.exe.search.parameters.PaymentStateSearchedParam;
import p12f.exe.search.parameters.ThirdPartySearchedParam;
import p12f.exe.search.sqlutils.PaymentSQL;

public class PaymentQuerySQLComposerHelper {
    private static final Logger log = LoggerFactory.getLogger(PaymentQuerySQLComposerHelper.class);
    private XMLSearchProperties searchProperties = XMLSearchProperties.getInstance();
    private static String TIPO_OPERACION_COBROS_OK = "06";
    private static String TIPO_OPERACION_DEVENGO_COBRO_FUERA_PLAZO = "08";

    public HashMap doInitializeQueryTypes(PaymentQuery paymentQuery) {
        HashMap<String, PaymentSQL> mapQuery = new HashMap<String, PaymentSQL>();
        if (paymentQuery.getpaymentDataParameterList() != null && !paymentQuery.getpaymentDataParameterList().isEmpty()) {
            for (PaymentDataSearchedParam dataSearch : paymentQuery.getpaymentDataParameterList()) {
                if (dataSearch.format != null) {
                    if (mapQuery.containsKey(dataSearch.format)) continue;
                    mapQuery.put(dataSearch.format, this._initFormatQuery(Integer.parseInt(dataSearch.format)));
                    continue;
                }
                if (!mapQuery.containsKey("507")) {
                    mapQuery.put("507", this._initFormatQuery(Integer.parseInt("507")));
                }
                if (!mapQuery.containsKey("502")) {
                    mapQuery.put("502", this._initFormatQuery(Integer.parseInt("502")));
                }
                if (!mapQuery.containsKey("521")) {
                    mapQuery.put("521", this._initFormatQuery(Integer.parseInt("521")));
                }
                if (!mapQuery.containsKey("522")) {
                    mapQuery.put("522", this._initFormatQuery(Integer.parseInt("522")));
                }
                if (mapQuery.containsKey("523")) continue;
                mapQuery.put("523", this._initFormatQuery(Integer.parseInt("523")));
            }
        } else {
            if (!mapQuery.containsKey("507")) {
                mapQuery.put("507", this._initFormatQuery(Integer.parseInt("507")));
            }
            if (!mapQuery.containsKey("502")) {
                mapQuery.put("502", this._initFormatQuery(Integer.parseInt("502")));
            }
            if (!mapQuery.containsKey("521")) {
                mapQuery.put("521", this._initFormatQuery(Integer.parseInt("521")));
            }
            if (!mapQuery.containsKey("522")) {
                mapQuery.put("522", this._initFormatQuery(Integer.parseInt("522")));
            }
            if (!mapQuery.containsKey("523")) {
                mapQuery.put("523", this._initFormatQuery(Integer.parseInt("523")));
            }
        }
        return mapQuery;
    }

    private PaymentSQL _initFormatQuery(int format) {
        PaymentSQL paymentSql = new PaymentSQL(Integer.toString(format));
        String basicQuery = this.searchProperties.get("p12ft", "searchPaymentConfig/basicQueryConfig/query");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("STATUS_TABLE", this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/statusTable/name"));
        variables.put("EXP_TABLE", this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/expTable/name"));
        variables.put("THIRD_TABLE", this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/thirdPartyTable/name"));
        variables.put("PAYMENT_DATA_TABLE", this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/formatTables/FormatTable[@id=" + format + "]//name"));
        variables.put("PARAMS", this.getParametersToSelect(Integer.toString(format)));
        paymentSql.hasBeeInitialized = true;
        paymentSql.selectClause = StringUtils.replaceVariableValues((String)basicQuery, (char)'$', variables);
        return paymentSql;
    }

    public PaymentSQL addExpBlockClause(EXPSearchedParam expediente, PaymentSQL paymentSQL) {
        if (paymentSQL == null) {
            return null;
        }
        String expCondition = null;
        String blockExpedCod = null;
        String blocExpFamily = null;
        String blocExpTramita = null;
        String expCodeFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/expTable/fields/expCode");
        String expFamilyFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/expTable/fields/expFamily");
        String expTramitaFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/expTable/fields/expTramitacion");
        if (expediente.codExp != null) {
            blockExpedCod = expCodeFieldName + "='" + expediente.codExp + "'";
        }
        if (expediente.codFamily != null) {
            blocExpFamily = expFamilyFieldName + "='" + expediente.codFamily + "'";
        }
        if (expediente.codExpLong != null) {
            blocExpTramita = expTramitaFieldName + "='" + expediente.codExpLong + "'";
        }
        if (blockExpedCod != null) {
            expCondition = blockExpedCod;
            if (blocExpFamily != null) {
                expCondition = "(" + blockExpedCod + " AND " + blocExpFamily + ")";
            }
        } else if (blocExpTramita != null) {
            expCondition = blocExpTramita;
        }
        if (expCondition != null) {
            paymentSQL.expDATAconditionClause = paymentSQL.expDATAconditionClause == null ? expCondition : paymentSQL.expDATAconditionClause + " OR " + expCondition;
        }
        return paymentSQL;
    }

    public PaymentSQL addJoinClause(PaymentSQL paymentSQL) {
        if (paymentSQL == null) {
            return null;
        }
        int format = Integer.parseInt(paymentSQL.id);
        String pkCSBTable = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/formatTables/FormatTable[@id=" + format + "]/pkField");
        String pkStatusTable = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/statusTable/joinField");
        String pkExpTable = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/expTable/joinField");
        String pkThirdTable = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/thirdPartyTable/joinField");
        paymentSQL.joinClause = "";
        if (paymentSQL.csbDATAconditionClause != null || paymentSQL.expDATAconditionClause != null || paymentSQL.statusDATAconditionClause != null || paymentSQL.thirdPartyDATAconditionClause != null) {
            paymentSQL.joinClause = paymentSQL.joinClause + "AND ";
        }
        paymentSQL.joinClause = paymentSQL.joinClause + pkCSBTable + " = " + pkStatusTable + "(+) \n" + "AND " + pkCSBTable + " = " + pkExpTable + "(+)\n" + "AND " + pkCSBTable + " = " + pkThirdTable + "(+)\n";
        return paymentSQL;
    }

    public PaymentSQL addPaymentDataBlockClause(PaymentDataSearchedParam dataSearched, PaymentSQL paymentSQL) {
        if (paymentSQL == null) {
            return null;
        }
        String paymenDataCondition = null;
        String blockOidPago = null;
        String blockEmisor = null;
        String blockTributo = null;
        String blockReference = null;
        String blockIdentification = null;
        String blockImporte = null;
        String oidPago = dataSearched.oidPago;
        String emisor = dataSearched.admin;
        String tributo = dataSearched.typo;
        String format = dataSearched.format;
        String reference = dataSearched.reference;
        String identification = dataSearched.identification;
        String importe = dataSearched.importe;
        if (format == null || format.equalsIgnoreCase(paymentSQL.id)) {
            String pagoIdFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/formatTables/FormatTable[@id=" + paymentSQL.id + "]/fields/pagoIdField");
            String adminFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/formatTables/FormatTable[@id=" + paymentSQL.id + "]/fields/adminField");
            String typoFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/formatTables/FormatTable[@id=" + paymentSQL.id + "]/fields/typoField");
            String referenceFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/formatTables/FormatTable[@id=" + paymentSQL.id + "]/fields/referenceField");
            String identificationFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/formatTables/FormatTable[@id=" + paymentSQL.id + "]/fields/identificationField");
            String importeFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/formatTables/FormatTable[@id=" + paymentSQL.id + "]/fields/importeField");
            if (oidPago != null) {
                paymenDataCondition = blockOidPago = pagoIdFieldName + "='" + oidPago + "'";
            }
            if (emisor != null) {
                blockEmisor = adminFieldName + "='" + emisor + "'";
                paymenDataCondition = paymenDataCondition == null ? blockEmisor : paymenDataCondition + " AND " + blockEmisor;
            }
            if (tributo != null) {
                blockTributo = typoFieldName + "='" + tributo + "'";
                paymenDataCondition = paymenDataCondition == null ? blockTributo : paymenDataCondition + " AND " + blockTributo;
            }
            if (reference != null) {
                blockReference = referenceFieldName + "='" + reference + "'";
                paymenDataCondition = paymenDataCondition == null ? blockReference : paymenDataCondition + " AND " + blockReference;
            }
            if (identification != null) {
                blockIdentification = identificationFieldName + "='" + identification + "'";
                paymenDataCondition = paymenDataCondition == null ? blockIdentification : paymenDataCondition + " AND " + blockIdentification;
            }
            if (importe != null) {
                blockImporte = importeFieldName + "='" + importe + "'";
                paymenDataCondition = paymenDataCondition == null ? blockImporte : paymenDataCondition + " AND " + blockImporte;
            }
            if (paymenDataCondition != null) {
                paymentSQL.csbDATAconditionClause = paymentSQL.csbDATAconditionClause == null ? "(" + paymenDataCondition + ")" : paymentSQL.csbDATAconditionClause + " OR (" + paymenDataCondition + ")";
            }
        }
        return paymentSQL;
    }

    public PaymentSQL addStatusBlockClause(PaymentStateSearchedParam statusParam, PaymentSQL paymentSQL) {
        if (paymentSQL == null) {
            return null;
        }
        String statusCondition = null;
        String blockStatusCode = null;
        String blockNRC = null;
        String blockDate = null;
        String blockFinantialOrg = null;
        String statusCodeFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/statusTable/fields/stateCode");
        String nrcCodeFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/statusTable/fields/nrcCode");
        String initDateFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/statusTable/fields/initDate");
        String timestampFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/statusTable/fields/timestamp");
        String finantialOrgFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/statusTable/fields/finantialOrg");
        String backendStatusFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/statusTable/fields/backendStatus");
        String limitChargeabilityDateFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/statusTable/fields/limitChargeabilityDate");
        if (statusParam.stateCode != null) {
            if (statusParam.stateCode.equalsIgnoreCase("99")) {
                statusCondition = blockStatusCode = statusCodeFieldName + "<>'" + "04" + "'";
            } else if (statusParam.stateCode.equalsIgnoreCase("98")) {
                statusCondition = blockStatusCode = statusCodeFieldName + "<>'" + "04" + "' AND " + statusCodeFieldName + "<>'" + "03" + "' AND " + statusCodeFieldName + "<>'" + "06" + "' AND " + statusCodeFieldName + "<>'" + "08" + "' AND " + statusCodeFieldName + "<>'" + "10" + "' AND " + "(" + backendStatusFieldName + " IS NULL OR " + backendStatusFieldName + " = '-1' )";
            } else if (statusParam.stateCode.equalsIgnoreCase("97")) {
                SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy");
                String strHoy = dateFormatter.format(Calendar.getInstance().getTime());
                statusCondition = blockStatusCode = statusCodeFieldName + "<>'" + "04" + "' AND " + statusCodeFieldName + "<>'" + "03" + "' AND " + statusCodeFieldName + "<>'" + "06" + "' AND " + statusCodeFieldName + "<>'" + "08" + "' AND " + statusCodeFieldName + "<>'" + "10" + "' AND " + " (" + limitChargeabilityDateFieldName + " IS NULL OR " + limitChargeabilityDateFieldName + " >= " + "TO_DATE('" + strHoy + " 00:00:00','DD/MM/YYYY HH24:MI:SS') " + " ) AND " + "(" + backendStatusFieldName + " IS NULL OR " + backendStatusFieldName + " = '-1' )";
            } else {
                statusCondition = blockStatusCode = statusCodeFieldName + "='" + statusParam.stateCode + "'";
            }
        }
        if (statusParam.backendStatus != null) {
            statusCondition = blockStatusCode = backendStatusFieldName + "='" + statusParam.backendStatus + "'";
        }
        if (statusParam.nrc != null) {
            blockNRC = nrcCodeFieldName + " = '" + statusParam.nrc + "'";
            if (statusCondition != null) {
                if (blockNRC != null) {
                    statusCondition = statusCondition + " AND " + blockNRC;
                }
            } else if (blockNRC != null) {
                statusCondition = blockNRC;
            }
        }
        if (!statusParam.searchUsingTimestampDate) {
            String dateToString;
            String dateFromString;
            SimpleDateFormat formaterOnlyDate = new SimpleDateFormat("MM/dd/yyyy");
            SimpleDateFormat formaterWithTime = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            if (statusParam.dateFrom != null) {
                dateFromString = formaterOnlyDate.format(statusParam.dateFrom);
                blockDate = initDateFieldName + " >= TO_DATE('" + dateFromString.replaceAll("( [0-9]{2}:[0-9]{2}:[0-9]{2})?$", " 00:00:00") + "','MM/DD/YYYY HH24:MI:SS')";
                if (statusCondition != null) {
                    if (blockDate != null) {
                        statusCondition = statusCondition + " AND " + blockDate;
                    }
                } else if (blockDate != null) {
                    statusCondition = blockDate;
                }
            } else if (statusParam.dateTimeFrom != null) {
                dateFromString = formaterWithTime.format(statusParam.dateTimeFrom);
                blockDate = initDateFieldName + " >= TO_DATE('" + dateFromString + "','MM/DD/YYYY HH24:MI:SS')";
                if (statusCondition != null) {
                    if (blockDate != null) {
                        statusCondition = statusCondition + " AND " + blockDate;
                    }
                } else if (blockDate != null) {
                    statusCondition = blockDate;
                }
            }
            if (statusParam.dateTo != null) {
                dateToString = formaterOnlyDate.format(statusParam.dateTo);
                blockDate = initDateFieldName + " <= TO_DATE('" + dateToString.replaceAll("( [0-9]{2}:[0-9]{2}:[0-9]{2})?$", " 23:59:59") + "','MM/DD/YYYY HH24:MI:SS')";
                if (statusCondition != null) {
                    if (blockDate != null) {
                        statusCondition = statusCondition + " AND " + blockDate;
                    }
                } else if (blockDate != null) {
                    statusCondition = blockDate;
                }
            } else if (statusParam.dateTimeTo != null) {
                dateToString = formaterWithTime.format(statusParam.dateTimeTo);
                blockDate = initDateFieldName + " <= TO_DATE('" + dateToString + "','MM/DD/YYYY HH24:MI:SS')";
                if (statusCondition != null) {
                    if (blockDate != null) {
                        statusCondition = statusCondition + " AND " + blockDate;
                    }
                } else if (blockDate != null) {
                    statusCondition = blockDate;
                }
            }
        } else {
            if (statusParam.dateFrom != null) {
                blockDate = timestampFieldName + " >= '" + statusParam.dateFrom.getTime() + "'";
                if (statusCondition != null) {
                    if (blockDate != null) {
                        statusCondition = statusCondition + " AND " + blockDate;
                    }
                } else if (blockDate != null) {
                    statusCondition = blockDate;
                }
            } else if (statusParam.dateTimeFrom != null) {
                blockDate = timestampFieldName + " >= '" + statusParam.dateTimeFrom.getTime() + "'";
                if (statusCondition != null) {
                    if (blockDate != null) {
                        statusCondition = statusCondition + " AND " + blockDate;
                    }
                } else if (blockDate != null) {
                    statusCondition = blockDate;
                }
            }
            if (statusParam.dateTo != null) {
                blockDate = timestampFieldName + " <= '" + statusParam.dateTo.getTime() + "'";
                if (statusCondition != null) {
                    if (blockDate != null) {
                        statusCondition = statusCondition + " AND " + blockDate;
                    }
                } else if (blockDate != null) {
                    statusCondition = blockDate;
                }
            } else if (statusParam.dateTimeTo != null) {
                blockDate = timestampFieldName + " <= '" + statusParam.dateTimeTo.getTime() + "'";
                if (statusCondition != null) {
                    if (blockDate != null) {
                        statusCondition = statusCondition + " AND " + blockDate;
                    }
                } else if (blockDate != null) {
                    statusCondition = blockDate;
                }
            }
        }
        if (statusParam.finantialOrg != null) {
            blockFinantialOrg = finantialOrgFieldName + " = '" + statusParam.finantialOrg + "'";
            if (statusCondition != null) {
                if (blockFinantialOrg != null) {
                    statusCondition = statusCondition + " AND " + blockFinantialOrg;
                }
            } else if (blockFinantialOrg != null) {
                statusCondition = blockFinantialOrg;
            }
        }
        if (statusCondition != null) {
            paymentSQL.statusDATAconditionClause = paymentSQL.statusDATAconditionClause == null ? statusCondition : paymentSQL.statusDATAconditionClause + " OR " + statusCondition;
        }
        return paymentSQL;
    }

    public PaymentSQL addThridPartyBlockClause(ThirdPartySearchedParam third, PaymentSQL paymentSQL) {
        if (paymentSQL == null) {
            return null;
        }
        String dni = third.dniNIF;
        String razonSocial = third.razonSocial;
        String thirdCondition = null;
        String blockDNI = null;
        String blocRazonSocial = null;
        String dniFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/thirdPartyTable/fields/dni");
        String razonSocialFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/thirdPartyTable/fields/razonSocial");
        if (dni != null) {
            blockDNI = dniFieldName + "='" + dni.toUpperCase() + "'";
        }
        if (razonSocial != null) {
            blocRazonSocial = "UPPER(" + razonSocialFieldName + ")" + " LIKE '%" + razonSocial.toUpperCase() + "%'";
        }
        if (blockDNI != null) {
            thirdCondition = blockDNI;
            if (blocRazonSocial != null) {
                thirdCondition = "(" + thirdCondition + " AND " + blocRazonSocial + ")";
            }
        } else if (blocRazonSocial != null) {
            thirdCondition = blocRazonSocial;
        }
        if (thirdCondition != null) {
            paymentSQL.thirdPartyDATAconditionClause = paymentSQL.thirdPartyDATAconditionClause == null ? thirdCondition : paymentSQL.thirdPartyDATAconditionClause + " OR " + thirdCondition;
        }
        return paymentSQL;
    }

    public PaymentSQL addModeBlockClause(PaymentModeSearchedParam modeParam, PaymentSQL paymentSQL) {
        if (paymentSQL == null) {
            return null;
        }
        String modeCondition = null;
        String blockModeCode = null;
        String modeCodeFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/statusTable/fields/paymentMode");
        if (modeParam.paymentMode != null && !"".equals(modeParam.paymentMode)) {
            modeCondition = blockModeCode = modeCodeFieldName + "='" + modeParam.paymentMode + "'";
        }
        if (modeCondition != null) {
            paymentSQL.paymentModeDATAconditionClause = paymentSQL.paymentModeDATAconditionClause == null ? modeCondition : paymentSQL.paymentModeDATAconditionClause + " OR " + modeCondition;
        }
        return paymentSQL;
    }

    public PaymentSQL addFinantialOrgBlockClause(FinantialOrgSearchedParam efParam, PaymentSQL paymentSQL) {
        if (paymentSQL == null) {
            return null;
        }
        String efCondition = null;
        String blockEFCode = null;
        String efFieldName = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/statusTable/fields/finantialOrg");
        if (efParam.finantialOrg != null && !"".equals(efParam.finantialOrg)) {
            efCondition = blockEFCode = efFieldName + "='" + efParam.finantialOrg + "'";
        }
        if (efCondition != null) {
            paymentSQL.finantialOrgDATAconditionClause = paymentSQL.finantialOrgDATAconditionClause == null ? efCondition : paymentSQL.finantialOrgDATAconditionClause + " OR " + efCondition;
        }
        return paymentSQL;
    }

    public String getParametersToSelect(String id) {
        Properties listaThird = this.searchProperties.getProperties("p12ft", "searchPaymentConfig/tableList/thirdPartyTable/fields");
        Properties listaStatus = this.searchProperties.getProperties("p12ft", "searchPaymentConfig/tableList/statusTable/fields");
        Properties listaExp = this.searchProperties.getProperties("p12ft", "searchPaymentConfig/tableList/expTable/fields");
        Properties csbCodeList = this.searchProperties.getProperties("p12ft", "searchPaymentConfig/tableList/formatTables/FormatTable[@id=" + id + "]/fields");
        String csbParams = "";
        Enumeration<Object> enu = csbCodeList.keys();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            if (csbParams != "") {
                csbParams = csbParams + "," + csbCodeList.getProperty(key) + " " + key;
                continue;
            }
            csbParams = csbParams + csbCodeList.getProperty(key) + " " + key;
        }
        String thirdParams = "";
        Enumeration<Object> enu2 = listaThird.keys();
        while (enu2.hasMoreElements()) {
            String key = (String)enu2.nextElement();
            thirdParams = thirdParams + "," + listaThird.getProperty(key) + " " + key;
        }
        String statusParams = "";
        Enumeration<Object> enu3 = listaStatus.keys();
        while (enu3.hasMoreElements()) {
            String key = (String)enu3.nextElement();
            statusParams = statusParams + "," + listaStatus.getProperty(key) + " " + key;
        }
        String expParams = "";
        Enumeration<Object> enu4 = listaExp.keys();
        while (enu4.hasMoreElements()) {
            String key = (String)enu4.nextElement();
            expParams = expParams + "," + listaExp.getProperty(key) + " " + key;
        }
        return csbParams + thirdParams + statusParams + expParams;
    }

    public String composeHistoricQuery(String pagoId) {
        return this.composeHistoricQuery(pagoId, false);
    }

    public String composeHistoricQueryOrderByDesc(String pagoId) {
        return this.composeHistoricQuery(pagoId, true);
    }

    private String composeHistoricQuery(String pagoId, boolean desc) {
        String selectClause = "";
        String selectParams = "";
        Properties listaSelectHistoric = this.searchProperties.getProperties("p12ft", "searchPaymentConfig/tableList/historicTable/fields");
        Enumeration<Object> enu = listaSelectHistoric.keys();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            if (selectParams != "") {
                selectParams = selectParams + "," + listaSelectHistoric.getProperty(key) + " " + key;
                continue;
            }
            selectParams = selectParams + listaSelectHistoric.getProperty(key) + " " + key;
        }
        selectClause = "SELECT " + selectParams;
        String fromClause = "";
        String fromField = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/historicTable/name");
        fromClause = "FROM " + fromField;
        String whereClause = "";
        String whereField = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/historicTable/joinField");
        whereClause = "WHERE " + whereField + " = '" + pagoId + "'";
        String orderByClause = "";
        String orderByField = this.searchProperties.get("p12ft", "searchPaymentConfig/tableList/historicTable/fields/tst");
        orderByClause = "ORDER BY " + orderByField;
        if (desc) {
            orderByClause = orderByClause + " DESC";
        }
        return selectClause + " " + fromClause + " " + whereClause + " " + orderByClause;
    }
}

