/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.search.sqlutils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12f.exe.search.XMLSearchProperties;

public class PaymentQuerySQLBackendDataComposer {
    private static final Logger log = LoggerFactory.getLogger(PaymentQuerySQLBackendDataComposer.class);
    private XMLSearchProperties _searchProperties = XMLSearchProperties.getInstance();

    public List<String> composeRetrieveBackendIndexDataQuery(List<String> pagoIdList) {
        return this.composeRetrieveBackendIndexDataQuery(pagoIdList, 0);
    }

    public List<String> composeRetrieveBackendIndexDataQuery(List<String> pagoIdList, int maxIN) {
        String s;
        int nIdPago = pagoIdList.size();
        if (nIdPago == 0) {
            return null;
        }
        String SQLSEARCH = this._searchProperties.get("p12ft", "searchPaymentConfig/indexablePaymentConfig/selectInSQLTemplate/sql");
        String INSEARCHSTRING = this._searchProperties.get("p12ft", "searchPaymentConfig/indexablePaymentConfig/selectInSQLTemplate/inSearchString");
        if (SQLSEARCH == null) {
            log.warn("[P12FT][PaymentQuerySQLComposer] >>>> SQLSEARCH IS NULL");
        }
        if (INSEARCHSTRING == null) {
            log.warn("[P12FT][PaymentQuerySQLComposer] >>>> INSEARCHSTRING IS NULL");
        }
        int maxSearchedPaymentsInSet = 0;
        maxSearchedPaymentsInSet = maxIN > 0 ? maxIN : ((s = this._searchProperties.get("p12ft", "searchPaymentConfig/indexablePaymentConfig/selectInSQLTemplate/maxSearchedPaymentsInSet")) == null ? 10 : Integer.parseInt(s));
        log.warn("[P12FT][PaymentQuerySQLComposer] >>>> maxSearchedPaymentsInSet == " + maxSearchedPaymentsInSet);
        ArrayList<String> queryStringList = new ArrayList<String>();
        String inSearchString = "";
        int nIN = 0;
        Iterator<String> itPagos = pagoIdList.iterator();
        while (itPagos.hasNext()) {
            inSearchString = inSearchString + ",'" + itPagos.next() + "'";
            if (++nIN % maxSearchedPaymentsInSet != 0) continue;
            queryStringList.add(SQLSEARCH.replaceFirst(INSEARCHSTRING, inSearchString.replaceFirst(",", "")));
            inSearchString = "";
        }
        log.warn("[P12FT][PaymentQuerySQLComposer] >>>> IS inSearchString NULL? >> " + (inSearchString == null));
        if (!inSearchString.replaceFirst(",", "").equalsIgnoreCase("")) {
            queryStringList.add(SQLSEARCH.replaceFirst(INSEARCHSTRING, inSearchString.replaceFirst(",", "")));
        }
        return queryStringList;
    }
}

