/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.search;

import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.google.gwt.core.shared.GwtIncompatible;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import p12f.exe.pasarelapagos.objects.TramitaData;
import p12f.exe.pasarelapagos.paymentrequest.BackendData;
import p12f.exe.search.PaymentHistoricDataItemList;

public class PaymentSearchResult
implements Serializable,
Comparable<PaymentSearchResult> {
    private static final long serialVersionUID = 9197437038865911165L;
    public static final String FORMATO_507 = "507";
    public static final String FORMATO_502 = "502";
    public static final String FORMATO_508 = "508";
    public static final String FORMATO_521 = "521";
    public static final String FORMATO_522 = "522";
    public String expCode;
    public String nrcCode;
    public String stateCode;
    public String dni;
    public String pagoIdField;
    public String expFamily;
    public String adminField;
    public String typoField;
    public long importe;
    public Date initDate;
    public Date paymentDayDate;
    public Date paymentHourDate;
    public String strPaymentDayDate;
    public String strPaymentHourDate;
    public String strImporte;
    public String strInitDate;
    public String paymentMode;
    public String finantialOrgCode;
    public PaymentHistoricDataItemList historicData = new PaymentHistoricDataItemList();
    public String backendStatus;
    public TramitaData tramitaData;
    public List<BackendData> backendDataMap;

    public PaymentSearchResult() {
        this.initDate = new Date();
        this.paymentDayDate = new Date();
        this.paymentHourDate = new Date();
    }

    @Override
    public int compareTo(PaymentSearchResult o) {
        int comparacion = 0;
        PaymentSearchResult other = o;
        comparacion = this.initDate.compareTo(other.initDate);
        if (comparacion == 0 && (comparacion = this.adminField.compareTo(other.adminField)) == 0 && (comparacion = this.typoField.compareTo(other.typoField)) == 0) {
            comparacion = this.pagoIdField.compareTo(other.pagoIdField);
        }
        return comparacion;
    }

    @GwtIncompatible
    public String toXML() throws XOMarshallerException {
        return XOManager.getXML((String)XMLProperties.get((String)"p12ft", (String)"objectMapPath"), (Object)this);
    }

    @GwtIncompatible
    public static PaymentSearchResult getObject(String xml) throws XOMarshallerException {
        return (PaymentSearchResult)XOManager.getObject((String)XMLProperties.get((String)"p12ft", (String)"objectMapPath"), (String)xml);
    }

    public String getEmisor() {
        String emisor = "";
        String pagoId = this.pagoIdField.trim();
        String formato = pagoId.substring(2, 5);
        if (FORMATO_502.equals(formato)) {
            emisor = pagoId.substring(5, 11);
        } else if (FORMATO_507.equals(formato)) {
            emisor = pagoId.substring(5, 13);
            emisor = emisor + "-" + this.typoField;
        } else if (FORMATO_521.equals(formato)) {
            emisor = pagoId.substring(5, 11);
        } else if (FORMATO_522.equals(formato)) {
            emisor = pagoId.substring(5, 11);
        }
        return emisor;
    }

    public String getReferencia() {
        String referencia = "";
        String formato = this.pagoIdField.trim().substring(2, 5);
        if (FORMATO_502.equals(formato)) {
            referencia = this.pagoIdField.trim().substring(11, 23);
        } else if (FORMATO_507.equals(formato)) {
            referencia = this.pagoIdField.trim().substring(16, 29);
        } else if (FORMATO_521.equals(formato)) {
            referencia = this.pagoIdField.trim().substring(11, 23);
        } else if (FORMATO_522.equals(formato)) {
            String importeVol = this.pagoIdField.substring(34, 42);
            String importeRec = this.pagoIdField.substring(46, 54);
            String lPadImporte = this._lpad(String.valueOf(this.importe), '0', 8);
            if (lPadImporte != null && !"".equals(lPadImporte)) {
                if (lPadImporte.equals(importeVol)) {
                    referencia = this.pagoIdField.trim().substring(11, 23);
                } else if (lPadImporte.equals(importeRec)) {
                    referencia = this.pagoIdField.trim().substring(11, 21) + this.pagoIdField.trim().substring(23, 25);
                }
            }
        }
        return referencia;
    }

    public String getIdentificacion() {
        String identificacion = "";
        String formato = this.pagoIdField.trim().substring(2, 5);
        if (FORMATO_502.equals(formato)) {
            identificacion = this.pagoIdField.trim().substring(23, 30);
        } else if (FORMATO_507.equals(formato)) {
            identificacion = this.pagoIdField.trim().substring(29, 35);
        } else if (FORMATO_521.equals(formato)) {
            identificacion = this.pagoIdField.trim().substring(23, 33);
        } else if (FORMATO_522.equals(formato)) {
            String importeVol = this.pagoIdField.substring(34, 42);
            String importeRec = this.pagoIdField.substring(46, 54);
            String lPadImporte = this._lpad(String.valueOf(this.importe), '0', 8);
            if (lPadImporte != null && !"".equals(lPadImporte)) {
                if (lPadImporte.equals(importeVol)) {
                    identificacion = "5";
                } else if (lPadImporte.equals(importeRec)) {
                    identificacion = "9";
                }
            }
            identificacion = identificacion + this.pagoIdField.trim().substring(25, 34);
        }
        return identificacion;
    }

    private String _lpad(String input, char padding, int length) {
        if (input == null) {
            input = new String();
        }
        if (input.length() >= length) {
            return input;
        }
        StringBuffer result = new StringBuffer();
        int numChars = length - input.length();
        for (int i = 0; i < numChars; ++i) {
            result.append(padding);
        }
        result.append(input);
        return result.toString();
    }
}

