/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.search;

import com.ejie.r01f.util.Initializable;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import p12f.exe.pasarelapagos.objects.TramitaData;
import p12f.exe.search.parameters.EXPSearchedParam;
import p12f.exe.search.parameters.FinantialOrgSearchedParam;
import p12f.exe.search.parameters.PaymentDataSearchedParam;
import p12f.exe.search.parameters.PaymentModeSearchedParam;
import p12f.exe.search.parameters.PaymentStateSearchedParam;
import p12f.exe.search.parameters.ThirdPartySearchedParam;

public class PaymentQuery
implements Serializable,
Initializable {
    private static final long serialVersionUID = -9089192110228855909L;
    protected List<ThirdPartySearchedParam> thirdPartyList = new ArrayList<ThirdPartySearchedParam>();
    protected List<EXPSearchedParam> expList = new ArrayList<EXPSearchedParam>();
    protected List<PaymentStateSearchedParam> stateParameterList = new ArrayList<PaymentStateSearchedParam>();
    protected List<PaymentDataSearchedParam> paymentDataParameterList = new ArrayList<PaymentDataSearchedParam>();
    protected List<FinantialOrgSearchedParam> finantialOrgParameterList = new ArrayList<FinantialOrgSearchedParam>();
    protected List<PaymentModeSearchedParam> paymentModeParameterList = new ArrayList<PaymentModeSearchedParam>();

    public void addThirdPartyData(String dni, String razonSocial) {
        this.thirdPartyList.add(new ThirdPartySearchedParam(dni, razonSocial));
    }

    public void addThirdPartyDNIData(String dni) {
        this.thirdPartyList.add(new ThirdPartySearchedParam(dni, null));
    }

    public void addThirdPartyRazonSocialData(String razonSocial) {
        this.thirdPartyList.add(new ThirdPartySearchedParam(null, razonSocial));
    }

    public void addEXPData(String codExp, String codFamilia) {
        this.expList.add(new EXPSearchedParam(codExp, codFamilia));
    }

    public void addEXPData(String codExp, String codFamilia, String codExpLong) {
        this.expList.add(new EXPSearchedParam(codExp, codFamilia, codExpLong));
    }

    public void addEXPCodeData(String codExp) {
        this.expList.add(new EXPSearchedParam(codExp, null));
    }

    public void addEXPFamilyData(String codFamily) {
        this.expList.add(new EXPSearchedParam(null, codFamily));
    }

    public void addEXPTramitacion(String codigoExpediente) {
        this.expList.add(new EXPSearchedParam(new TramitaData(codigoExpediente)));
    }

    public void addPaymentStateData(String code, String nrc) {
        this.stateParameterList.add(new PaymentStateSearchedParam(code, nrc));
    }

    public void addPaymentStateData(String code, String nrc, Date dateFrom, Date dateTo) {
        this.stateParameterList.add(new PaymentStateSearchedParam(code, nrc, dateFrom, dateTo));
    }

    public void addPaymentStateData(String code, String nrc, Date dateFrom, Date dateTo, String oidEntidad) {
        this.stateParameterList.add(new PaymentStateSearchedParam(code, nrc, dateFrom, dateTo, oidEntidad));
    }

    public void addPaymentStateData(String code, String nrc, Date dateFrom, Date dateTo, String oidEntidad, boolean searchUsingTimestampDate) {
        this.stateParameterList.add(new PaymentStateSearchedParam(code, nrc, dateFrom, dateTo, oidEntidad, searchUsingTimestampDate));
    }

    public void addPaymentStateData(String code, Date dateTimeFrom, Date dateTimeTo, String oidEntidad) {
        this.stateParameterList.add(new PaymentStateSearchedParam(code, dateTimeFrom, dateTimeTo, oidEntidad));
    }

    public void addPaymentStateCodeData(String stateCode) {
        this.stateParameterList.add(new PaymentStateSearchedParam(stateCode, null));
    }

    public void addPaymentStateNRCData(String nrc) {
        this.stateParameterList.add(new PaymentStateSearchedParam(null, nrc));
    }

    public void addPaymentStatePaymentMode(String paymentMode) {
        PaymentStateSearchedParam pm = new PaymentStateSearchedParam();
        pm.paymentMode = paymentMode;
        this.stateParameterList.add(pm);
    }

    public void addPaymentStateEstadoBackend(String backendStatus) {
        PaymentStateSearchedParam bs = new PaymentStateSearchedParam();
        bs.backendStatus = backendStatus;
        this.stateParameterList.add(bs);
    }

    public void addPaymentDataSearchedParam(String admin, String typo, String format) {
        this.paymentDataParameterList.add(new PaymentDataSearchedParam(admin, typo, format));
    }

    public void addPaymentDataSearchedParam(String admin, String typo, String format, String dateFrom, String dateTo) {
        this.paymentDataParameterList.add(new PaymentDataSearchedParam(admin, typo, format));
    }

    public void addPaymentDataSearchedParam(String oid, String admin, String typo, String format) {
        this.paymentDataParameterList.add(new PaymentDataSearchedParam(oid, admin, typo, format));
    }

    public void addPaymentDataSearchedParam(String oid, String admin, String typo, String format, String reference, String identification) {
        this.paymentDataParameterList.add(new PaymentDataSearchedParam(oid, admin, typo, format, reference, identification));
    }

    public void addPaymentDataSearchedParam(String oid, String admin, String typo, String format, String reference, String identification, String importe) {
        this.paymentDataParameterList.add(new PaymentDataSearchedParam(oid, admin, typo, format, reference, identification, importe));
    }

    public void addPaymentDataSearchedParam(String admin) {
        this.paymentDataParameterList.add(new PaymentDataSearchedParam(admin, null, null));
    }

    public void addFinantialOrgData(String finantialOrg) {
        this.finantialOrgParameterList.add(new FinantialOrgSearchedParam(finantialOrg));
    }

    public void addPaymentModeData(String paymentMode) {
        this.paymentModeParameterList.add(new PaymentModeSearchedParam(paymentMode));
    }

    public String toXML() throws XOMarshallerException {
        return XOManager.getXML((String)XMLProperties.get((String)"p12ft", (String)"objectMapPath"), (Object)this);
    }

    public List<ThirdPartySearchedParam> getThirdPartyList() {
        return this.thirdPartyList;
    }

    public List<EXPSearchedParam> getExpList() {
        return this.expList;
    }

    public List<PaymentStateSearchedParam> getStateParameterList() {
        return this.stateParameterList;
    }

    public List<PaymentDataSearchedParam> getpaymentDataParameterList() {
        return this.paymentDataParameterList;
    }

    public List<FinantialOrgSearchedParam> getFinantialOrgParameterList() {
        return this.finantialOrgParameterList;
    }

    public List<PaymentModeSearchedParam> getPaymentModeParameterList() {
        return this.paymentModeParameterList;
    }
}

