/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.v1.objects;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.util.MoneyUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import p12f.exe.pasarelapagos.v1.objects.AbstractPagoObj;
import p12f.exe.pasarelapagos.v1.objects.ConceptoPago;
import p12f.exe.pasarelapagos.v1.objects.ConceptoPeticionPago;
import p12f.exe.pasarelapagos.v1.objects.Descripcion;
import p12f.exe.pasarelapagos.v1.objects.Emisor;
import p12f.exe.pasarelapagos.v1.objects.Mensaje;
import p12f.exe.pasarelapagos.v1.objects.PeticionPago;
import p12f.exe.pasarelapagos.v1.objects.Protocolo;

public class Pago
extends AbstractPagoObj {
    public Emisor emisor;
    public Descripcion descripcion;
    public String referencia;
    public String identificacion;
    public String fechaPago;
    public String fechaLimitePago;
    public String importe;
    public String cuentaCargo;
    public String cuentaAbono;
    public List conceptosPago;
    public String idioma;
    public Map mensajes;
    public Map imagenes;
    public List datosAuxiliares;
    public Protocolo protocolo;

    public Pago() {
    }

    public Pago(PeticionPago inPeticionPago) {
        this.emisor = inPeticionPago.emisor;
        this.descripcion = inPeticionPago.descripcion;
        this.referencia = inPeticionPago.referencia;
        this.identificacion = inPeticionPago.identificacion;
        this.cuentaCargo = inPeticionPago.cuentaAbono;
        this.idioma = inPeticionPago.presentacion.idioma;
        this.fechaPago = DateUtils.getDateFormated((Date)new Date(), (String)XMLProperties.get((String)"p12ft", (String)"formatoFechasViejo"));
        this.fechaLimitePago = inPeticionPago.fechaLimitePago;
        this.importe = String.valueOf(MoneyUtils.getCenteuros((double)inPeticionPago.importe));
        ConceptoPago currConceptoPago = null;
        if (inPeticionPago.conceptosPeticionPago != null && inPeticionPago.conceptosPeticionPago.size() > 0) {
            this.conceptosPago = new ArrayList();
            for (ConceptoPeticionPago currConceptoPeticionPago : inPeticionPago.conceptosPeticionPago) {
                currConceptoPago = new ConceptoPago();
                currConceptoPago.euskera = currConceptoPeticionPago.euskera;
                currConceptoPago.castellano = currConceptoPeticionPago.castellano;
                currConceptoPago.importe = String.valueOf(MoneyUtils.getCenteuros((double)currConceptoPeticionPago.importe));
                this.conceptosPago.add(currConceptoPago);
            }
        }
        if (inPeticionPago.mensajes != null) {
            this.mensajes = new HashMap();
            for (Mensaje currMsg : inPeticionPago.mensajes.values()) {
                this.mensajes.put(currMsg.id, new Mensaje(currMsg.id, currMsg.euskera, currMsg.castellano));
            }
        }
        this.imagenes = inPeticionPago.imagenes;
        this.datosAuxiliares = inPeticionPago.datosAuxiliares;
        this.protocolo = inPeticionPago.protocolo;
    }

    public String toXML() throws XOMarshallerException {
        return XOManager.getXML((String)XMLProperties.get((String)"p12ft", (String)"objectMapPathV1"), (Object)this);
    }

    public static Pago getObject(String xml) throws XOMarshallerException {
        return (Pago)XOManager.getObject((String)XMLProperties.get((String)"p12ft", (String)"objectMapPathV1"), (String)xml);
    }
}

