/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.v1.objects;

import p12f.exe.pasarelapagos.v1.objects.Estado;

public class EstadoPago
extends Estado {
    public static final String PAGO_RECIBIDO_APLICACION_DEPARTAMENTAL = "01";
    public static final String PAGO_CIUDADANO_ACCEDE_PASARELA = "02";
    public static final String PAGO_ANULADO = "03";
    public static final String PAGO_EMITIDA_LIQUIDACION = "10";
    public static final String PAGO_ENTIDAD_FINANCIERA = "20";
    public static final String PAGO_VALIDACION_OK = "21";
    public static final String PAGO_VALIDACION_NOK = "22";
    public static final String PAGO_ONLINE_OK = "30";
    public static final String PAGO_ONLINE_NOK = "31";

    public EstadoPago() {
    }

    public EstadoPago(String estado) {
        if (estado == null) {
            return;
        }
        this.codigo = estado;
        if (estado.equals(PAGO_RECIBIDO_APLICACION_DEPARTAMENTAL)) {
            this.castellano = "Peticion de pago recibida desde la aplicacion departamental";
            this.euskera = "E_Peticion de pago recibida desde la aplicacion departamental";
        } else if (estado.equals(PAGO_CIUDADANO_ACCEDE_PASARELA)) {
            this.castellano = "El ciudadano accede a la pasarela de pagos";
            this.euskera = "E_El ciudadano accede a la pasarela de pagos";
        } else if (estado.equals(PAGO_ANULADO)) {
            this.castellano = "El ciudadano anula el pago";
            this.euskera = "E_El ciudadano anula el pago";
        } else if (estado.equals(PAGO_EMITIDA_LIQUIDACION)) {
            this.castellano = "El ciudadano imprime la liquidacion del pago";
            this.euskera = "E_El ciudadano imprime la liquidacion del pago";
        } else if (estado.equals(PAGO_ENTIDAD_FINANCIERA)) {
            this.castellano = "El ciudadano accede a la entidad financiera";
            this.euskera = "E_El ciudadano accede a la entidad financiera";
        } else if (estado.equals(PAGO_VALIDACION_OK)) {
            this.castellano = "La entidad financiera valida un pago correctamente";
            this.euskera = "E_La entidad financiera valida un pago correctamente";
        } else if (estado.equals(PAGO_VALIDACION_NOK)) {
            this.castellano = "La entidad financiera valida un pago incorrectamente";
            this.euskera = "E_La entidad financiera valida un pago incorrectamente";
        } else if (estado.equals(PAGO_ONLINE_OK)) {
            this.castellano = "El pago se ha realizado correctamente de forma on-line en una entidad financiera";
            this.euskera = "E_El pago se ha realizado correctamente de forma on-line en una entidad financiera";
        } else if (estado.equals(PAGO_ONLINE_NOK)) {
            this.castellano = "No se ha podido realizar el pago on-line en una entidad financiera";
            this.euskera = "E_No se ha podido realizar el pago on-line en una entidad financiera";
        }
    }
}

