/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.v1.objects;

import p12f.exe.pasarelapagos.v1.objects.AbstractPagoObj;

public class Emisor
extends AbstractPagoObj {
    public String codigo;
    public String cif;
    public String nombreEuskera;
    public String nombreCastellano;
    public String calle;
    public String municipio;
    public String territorio;
    public String codigoPostal;

    public Emisor() {
    }

    public Emisor(String inCodigo) {
        if (!this._validateCodigoEmisor(inCodigo)) {
            throw new IllegalArgumentException("El codigo del emisor no es valido, debe tener el formato: '99999999-999'");
        }
        this.codigo = inCodigo;
        this.cif = this.codigo.substring(0, 8);
    }

    public Emisor(String inCodigo, String inNombreEuskera, String inNombreCastellano) {
        this(inCodigo);
        this.nombreCastellano = inNombreCastellano;
        this.nombreEuskera = inNombreEuskera;
    }

    public Emisor(String inCif, String inSufijo, String inNombreEuskera, String inNombreCastellano) {
        this.cif = inCif;
        this.codigo = inCif + "-" + inSufijo;
        this.nombreCastellano = inNombreCastellano;
        this.nombreEuskera = inNombreEuskera;
    }

    public String getSufijo() {
        if (this._validateCodigoEmisor(this.codigo)) {
            return this.codigo.substring(9);
        }
        return "999";
    }

    public String getEmisor() {
        return this.cif;
    }

    public static String getSufijo(String inCodigoEmisor) {
        Emisor tempEmisor = new Emisor(inCodigoEmisor);
        return tempEmisor.getSufijo();
    }

    public static String getEmisor(String inCodigoEmisor) {
        Emisor tempEmisor = new Emisor(inCodigoEmisor);
        return tempEmisor.getEmisor();
    }

    private boolean _validateCodigoEmisor(String inCodigo) {
        if (inCodigo == null || inCodigo.length() == 0 || inCodigo.length() != 12) {
            return false;
        }
        if (!inCodigo.substring(8, 9).equals("-")) {
            return false;
        }
        try {
            String sufijo = inCodigo.substring(9);
            Integer.parseInt(sufijo);
        }
        catch (NumberFormatException nfEx) {
            return false;
        }
        return true;
    }
}

