/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.utils.pif;

import com.ejie.r01f.xml.utils.XMLParserHelper;
import com.ejie.r01f.xmlproperties.XMLProperties;
import com.ejie.y31.exception.Y31JanoServiceFileNotFoundException;
import com.ejie.y31.exception.Y31JanoServiceGenericException;
import com.ejie.y31.factory.Y31JanoServiceAbstractFactory;
import com.ejie.y31.service.Y31JanoService;
import com.ejie.y31.vo.Y31AttachmentBean;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectStreamClass;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import p12f.exe.pasarelapagos.helpers.SessionTokenHelper;

public class PIFHelper {
    private static final Logger log = LoggerFactory.getLogger(PIFHelper.class);
    private String _sessionToken = null;

    public PIFHelper() {
        this._traceConfigurationClass();
        SessionTokenHelper tokenHelper = new SessionTokenHelper();
        if (tokenHelper.setSessionToken(XMLProperties.get((String)"p12ft", (String)"pif/sessionLoginAppId"), XMLProperties.get((String)"p12ft", (String)"pif/simulateXLNets").trim().equalsIgnoreCase("true"))) {
            this.setSessionToken(tokenHelper.getSessionToken());
        } else {
            log.debug("[P12F] PIFHelper() no ha podido obtener token");
        }
    }

    public PIFHelper(String strToken) {
        this._sessionToken = strToken;
    }

    public String getSessionToken() {
        return this._sessionToken;
    }

    public void setSessionToken(String strToken) {
        this._sessionToken = strToken;
    }

    public void writeContentToFile(String fileNameWithPath, String fileContent) {
        this.writeContentToFile(fileNameWithPath, fileContent, null, null);
    }

    public void writeContentToFile(String fileNameWithPath, String fileContent, Long expirationSecs) {
        this.writeContentToFile(fileNameWithPath, fileContent, expirationSecs, null);
    }

    public void writeContentToFile(String fileNameWithPath, String fileContent, String charsetName) {
        this.writeContentToFile(fileNameWithPath, fileContent, null, charsetName);
    }

    public void writeContentToFile(String fileNameWithPath, String fileContent, Long expirationSecs, String charsetName) {
        log.debug("[P12F][PIFHelper] Generaci\u00f3n de fichero " + fileNameWithPath + " en PIF...");
        try {
            Y31JanoService service = null;
            try {
                service = Y31JanoServiceAbstractFactory.getInstance();
            }
            catch (Exception tr) {
                log.debug(">>>>>>>>>>> No se ha podido crear instancia de Y31JanoService");
                tr.printStackTrace();
                throw tr;
            }
            catch (Throwable tr) {
                log.debug(">>>>>>>>>>> No se ha podido crear instancia de Y31JanoService");
                tr.printStackTrace();
                throw tr;
            }
            Document xlnets = XMLParserHelper.parseXML((InputStream)new ByteArrayInputStream(this._sessionToken.getBytes()), (boolean)false);
            ByteArrayInputStream is = null;
            if (charsetName != null) {
                try {
                    is = new ByteArrayInputStream(fileContent.getBytes(charsetName));
                }
                catch (UnsupportedEncodingException uee) {
                    log.debug(">>>>>>>>>>> UnsupportedEncodingException : {}", (Object)charsetName);
                    is = new ByteArrayInputStream(fileContent.getBytes());
                }
            } else {
                is = new ByteArrayInputStream(fileContent.getBytes());
            }
            String to = fileNameWithPath.replace('\\', '/');
            boolean preserveName = true;
            String strSegundos = XMLProperties.get((String)"p12ft", (String)"pif/file/expirationSecs");
            Long defaultExpirationSecs = expirationSecs == null ? new Long(strSegundos == null ? 7200L : Long.parseLong(strSegundos)) : expirationSecs;
            log.debug("[P12F][PIFHelper] PIF borrar\u00e1 el fichero " + fileNameWithPath + " pasados " + defaultExpirationSecs + " segundos...");
            Y31AttachmentBean resul = service.put(xlnets, (InputStream)is, to, preserveName, defaultExpirationSecs);
            this._traza("writeContentToFile/PUT", resul);
        }
        catch (Y31JanoServiceGenericException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String readContentFromFile(String fileNameWithPath) {
        return this.readContentFromFile(fileNameWithPath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readContentFromFile(String fileNameWithPath, String charsetName) {
        StringBuffer fileContent = new StringBuffer("");
        BufferedInputStream bis = null;
        log.debug("[P12F][PIFHelper] Lectura de fichero " + fileNameWithPath + " de PIF...");
        try {
            Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
            Document xlnets = XMLParserHelper.parseXML((InputStream)new ByteArrayInputStream(this._sessionToken.getBytes()), (boolean)false);
            bis = new BufferedInputStream(service.get(xlnets, fileNameWithPath));
            byte[] bytesFileContent = new byte[1024];
            int bytesRead = 0;
            while ((bytesRead = bis.read(bytesFileContent)) != -1) {
                String s = charsetName != null ? new String(bytesFileContent, 0, bytesRead, charsetName) : new String(bytesFileContent, 0, bytesRead);
                fileContent.append(s);
            }
        }
        catch (Y31JanoServiceGenericException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                bis.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        log.debug("[P12F][PIFHelper] Longitud de fichero: " + fileContent.length());
        return fileContent.toString();
    }

    public List<String> readLines(String fileNameWithPath) {
        return this.readLines(fileNameWithPath, null);
    }

    public List<String> readLines(String fileNameWithPath, String charsetName) {
        String content = this.readContentFromFile(fileNameWithPath, charsetName);
        String[] lstring = content.split("\n");
        System.out.println("[PIFHelper] readLines(" + fileNameWithPath + "): " + lstring.length + " lineas");
        ArrayList<String> lineas = new ArrayList<String>();
        for (int k = 0; k < lstring.length; ++k) {
            lineas.add(lstring[k]);
        }
        return lineas;
    }

    public List fileList(String filePath) {
        log.debug("[P12F][PIFHelper] fileList: Listando todos los ficheros de " + filePath + " en PIF");
        List fList = null;
        try {
            Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
            Document xlnets = XMLParserHelper.parseXML((InputStream)new ByteArrayInputStream(this._sessionToken.getBytes()), (boolean)false);
            fList = service.list(xlnets, filePath);
            log.debug("[P12F][PIFHelper] listar " + fList.size() + " ficheros");
        }
        catch (Y31JanoServiceFileNotFoundException e) {
            log.debug("[P12F][PIFHelper] LIST - FILE NOT FOUND - " + filePath + " (Y31JanoServiceFileNotFoundException)");
            return fList;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fList;
    }

    public void deleteFile(String filePath, String fileName) {
        this.deleteFile(filePath + fileName);
    }

    public void deleteFile(String fileNameWithPath) {
        log.debug("[P12F][PIFHelper] deleteFile: Eliminando fichero " + fileNameWithPath + " de PIF");
        try {
            Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
            Document xlnets = XMLParserHelper.parseXML((InputStream)new ByteArrayInputStream(this._sessionToken.getBytes()), (boolean)false);
            service.delete(xlnets, fileNameWithPath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteAllFiles(String filesPath) {
        log.debug("[P12F][PIFHelper] deleteAllFiles: Eliminando todos los ficheros de " + filesPath + " en PIF");
        List fList = this.fileList(filesPath);
        Y31AttachmentBean resul = null;
        for (int i = 0; i < fList.size(); ++i) {
            resul = (Y31AttachmentBean)fList.get(i);
            this._traza("deleteAllFiles/DELETE [" + resul.getFileName() + " de " + filesPath + "]", resul);
            String fileNameWithPath = (filesPath + "/" + resul.getFileName()).replaceAll("//", "/");
            this.deleteFile(fileNameWithPath);
        }
    }

    public boolean copyFile(String fileNameWithPath, String targetPath) {
        String fileName = new File(fileNameWithPath).getName();
        String sourcePath = fileNameWithPath.replaceFirst(fileName + "$", "");
        return this.copyFile(fileName, sourcePath, targetPath);
    }

    public boolean copyFile(String fileName, String sourcePath, String targetPath) {
        log.debug("[P12F][PIFHelper] copyFile: Copiando fichero " + fileName + " de " + sourcePath + " a " + targetPath + " en PIF");
        try {
            Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
            Document xlnets = XMLParserHelper.parseXML((InputStream)new ByteArrayInputStream(this._sessionToken.getBytes()), (boolean)false);
            String origen = (sourcePath + "/").replaceAll("//", "/") + fileName;
            String destino = (targetPath + "/").replaceAll("//", "/") + fileName;
            log.debug("[P12F][PIFHelper] copyFile: origen  --> " + origen);
            log.debug("[P12F][PIFHelper] copyFile: destino --> " + destino);
            Y31AttachmentBean resul = service.copy(xlnets, origen, destino, true);
            this._traza("copyFile/COPY", resul);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void moveFile(String fileNameWithPath, String targetPath) {
        String fileName = new File(fileNameWithPath).getName();
        String sourcePath = fileNameWithPath.replaceFirst(fileName + "$", "");
        this.moveFile(fileName, sourcePath, targetPath);
    }

    public void moveFile(String fileName, String sourcePath, String targetPath) {
        log.debug("[P12F][PIFHelper] moveFile: Moviendo fichero " + fileName + " de " + sourcePath + " a " + targetPath + " en PIF");
        try {
            Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
            Document xlnets = XMLParserHelper.parseXML((InputStream)new ByteArrayInputStream(this._sessionToken.getBytes()), (boolean)false);
            String origen = (sourcePath + "/").replaceAll("//", "/") + fileName;
            String destino = (targetPath + "/").replaceAll("//", "/") + fileName;
            log.debug("[P12F][PIFHelper] moveFile: origen  --> " + origen);
            log.debug("[P12F][PIFHelper] moveFile: destino --> " + destino);
            Y31AttachmentBean resul = service.move(xlnets, origen, destino, true);
            this._traza("moveFile/MOVE", resul);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moveFile(String fileNameWithPath, String targetPath, Long expirationSecs) {
        this.moveFile(fileNameWithPath, targetPath, expirationSecs, null);
    }

    public void moveFile(String fileNameWithPath, String targetPath, Long expirationSecs, String charsetName) {
        String fileName = new File(fileNameWithPath).getName();
        String sourcePath = fileNameWithPath.replaceFirst(fileName + "$", "");
        if (expirationSecs == null) {
            this.moveFile(fileName, sourcePath, targetPath);
        } else {
            String fileContent = this.readContentFromFile(fileNameWithPath);
            this.writeContentToFile(targetPath + fileName, fileContent, expirationSecs, charsetName);
            if (this.info(fileNameWithPath) > -1L) {
                this.deleteFile(fileNameWithPath);
            } else {
                this.moveFile(fileName, sourcePath, targetPath);
            }
        }
    }

    public Long info(String fileNameWithPath) {
        log.debug("[P12F][PIFHelper] info: Informacion de fichero " + fileNameWithPath);
        Long l = -1L;
        try {
            Y31JanoService service = Y31JanoServiceAbstractFactory.getInstance();
            Document xlnets = XMLParserHelper.parseXML((InputStream)new ByteArrayInputStream(this._sessionToken.getBytes()), (boolean)false);
            Y31AttachmentBean resul = service.info(xlnets, fileNameWithPath);
            this._traza("info", resul);
            l = resul.getSize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return l;
    }

    private void _traza(String methodName, Y31AttachmentBean resul) {
        log.debug("[P12F][PIFHelper] " + methodName + ": getContentType --> " + resul.getContentType());
        log.debug("[P12F][PIFHelper] " + methodName + ": getFileName    --> " + resul.getFileName());
        log.debug("[P12F][PIFHelper] " + methodName + ": getFilePath    --> " + resul.getFilePath());
        log.debug("[P12F][PIFHelper] " + methodName + ": getSize        --> " + resul.getSize());
    }

    private void _traceConfigurationClass() {
        try {
            URL locationThis = this.getClass().getResource('/' + this.getClass().getName().replace('.', '/') + ".class");
            log.debug("\n#######################################\nNombre clase this: " + this.getClass().getName() + "\n" + "Location: " + locationThis);
            Class<?> c = Class.forName("org.apache.commons.configuration.Configuration");
            URL location = c.getResource('/' + c.getName().replace('.', '/') + ".class");
            log.debug("\nNombre clase: " + c.getName() + "\n" + "Serialization UID: " + ObjectStreamClass.lookup(c).getSerialVersionUID() + "\n" + "Location: " + location + "\n#######################################\n");
        }
        catch (Exception e) {
            log.debug("\n#######################################\nExcepcion al intentar obtener la clase: org.apache.commons.configuration.Configuration\nError: " + e.getMessage() + "\n#######################################\n");
        }
    }
}

