/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.utils.fop;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;
import p12f.exe.pasarelapagos.utils.fop.XMLTransformerException;

public class XMLTransformer {
    private static final Logger log = LoggerFactory.getLogger(XMLTransformer.class);

    public static byte[] getPDF(Reader xmlReader, File xsltFile) throws XMLTransformerException {
        try {
            return XMLTransformer.getPDF(XMLTransformer._readerToString(xmlReader), xsltFile);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new XMLTransformerException(ioe.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] getPDF(String xml, File xsltFile) throws XMLTransformerException {
        byte[] byArray;
        log.debug("[P12F][FOP] Generando PDF... XMLTransformer.getPDF(...)");
        log.debug("[P12F][FOP] Plantilla: " + xsltFile.getPath());
        byte[] resultado = null;
        String xsltCharset = XMLProperties.get((String)"p12ft", (String)"xslTemplateConfig/xsltCharset");
        if (xsltCharset == null || "".equals(xsltCharset)) return resultado;
        HashMap<String, String> mapVars = new HashMap<String, String>();
        log.debug("[P12F][FOP] Juego de caracteres: " + xsltCharset);
        log.debug("[P12F][FOP] Mapeo de $variables$ a sustituir en plantilla");
        NodeIterator nodeIt = XMLProperties.getPropertyNodeIterator((String)"p12ft", (String)"xslTemplateConfig/varList/var");
        Node n = nodeIt.nextNode();
        while (n != null) {
            String strValue = n.getFirstChild().getNodeValue();
            String strName = n.getAttributes().getNamedItem("name").getNodeValue();
            mapVars.put(strName, strValue);
            log.debug("[P12F][FOP] - $" + strName + "$ <== " + strValue);
            n = nodeIt.nextNode();
        }
        FileInputStream inStr = new FileInputStream(xsltFile);
        try {
            byte[] fileContent = new byte[(int)xsltFile.length()];
            inStr.read(fileContent);
            String strPlantillaXSLContent = new String(fileContent, xsltCharset);
            strPlantillaXSLContent = StringUtils.replaceVariableValues((String)strPlantillaXSLContent, (String)"$", mapVars).trim();
            int indiceComienzoXML = strPlantillaXSLContent.indexOf("<?xml");
            strPlantillaXSLContent = strPlantillaXSLContent.substring(indiceComienzoXML);
            byArray = XMLTransformer.createPDFFile(xml, strPlantillaXSLContent, xsltCharset);
        }
        catch (Throwable throwable) {
            try {
                inStr.close();
                throw throwable;
            }
            catch (Exception fopEx) {
                fopEx.printStackTrace();
                throw new XMLTransformerException(fopEx.toString());
            }
        }
        inStr.close();
        return byArray;
    }

    public static void getHTML(OutputStream out, Reader xmlReader, File xsltFile) throws XMLTransformerException {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer(new StreamSource(xsltFile));
            transformer.transform(new StreamSource(xmlReader), new StreamResult(out));
        }
        catch (Exception ex) {
            throw new XMLTransformerException(ex.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] createPDFFile(String xml, String templateFile, String xsltCharset) throws IOException {
        StreamSource transformSource = new StreamSource(new StringReader(templateFile));
        FopFactory fopFactory = FopFactory.newInstance();
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        ByteArrayOutputStream pdfoutStream = new ByteArrayOutputStream();
        StreamSource source = new StreamSource(new ByteArrayInputStream(xml.getBytes(xsltCharset)));
        try {
            TransformerFactory transfact = TransformerFactory.newInstance();
            Transformer xslfoTransformer = transfact.newTransformer(transformSource);
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)pdfoutStream);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            try {
                xslfoTransformer.transform(source, res);
                byte[] byArray = pdfoutStream.toByteArray();
                return byArray;
            }
            catch (TransformerException e) {
                try {
                    try {
                        e.printStackTrace();
                    }
                    catch (FOPException e2) {
                        e2.printStackTrace();
                    }
                }
                catch (TransformerConfigurationException e3) {
                    e3.printStackTrace();
                }
                catch (TransformerFactoryConfigurationError e4) {
                    e4.printStackTrace();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            pdfoutStream.close();
        }
        return null;
    }

    private static String _readerToString(Reader reader) throws IOException {
        int numCharsRead;
        char[] arr = new char[8192];
        StringBuilder buffer = new StringBuilder();
        while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
            buffer.append(arr, 0, numCharsRead);
        }
        reader.close();
        return buffer.toString();
    }
}

