/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.utils.fop;

import com.ejie.r01f.util.encoders.Base64Utils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFUtils {
    private static final Logger log = LoggerFactory.getLogger(PDFUtils.class);

    public static String getBarCodeImg(String barcodeMessage) {
        return PDFUtils.getBarCodeImg(barcodeMessage, null, null);
    }

    public static String getBarCodeImg(String barcodeMessage, String widthStr, String heightStr) {
        return PDFUtils.getBarCodeImg(barcodeMessage, widthStr, heightStr, null);
    }

    public static String getBarCodeImg(String barcodeMessage, String widthStr, String heightStr, String textSizeStr) {
        return PDFUtils.getBarCodeImg(barcodeMessage, widthStr, heightStr, null, null, null, "true", textSizeStr, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBarCodeImg(String barcodeMessage, String widthStr, String heightStr, String errorLvlStr, String color, String backColor, String withTextStr, String textSizeStr, String encodeStr) {
        PDFUtils_ENCODE encode = PDFUtils_ENCODE.JPEG;
        try {
            encode = PDFUtils_ENCODE.valueOf(encodeStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        ByteArrayOutputStream bos = null;
        String imageString = null;
        try {
            int width = 250;
            int height = 80;
            int textSize = 11;
            boolean withText = true;
            if (widthStr != null && !"".equals(widthStr)) {
                width = new Integer(widthStr);
            }
            if (heightStr != null && !"".equals(heightStr)) {
                height = new Integer(heightStr);
            }
            if (withTextStr != null && !"".equals(withTextStr)) {
                withText = new Boolean(withTextStr);
            }
            if (textSizeStr != null && !"".equals(textSizeStr)) {
                textSize = new Integer(textSizeStr);
            }
            Color backgroundColor = null;
            if (backColor == null || "".equals(backColor)) {
                backgroundColor = Color.WHITE;
            } else {
                try {
                    Field field = Color.class.getField(backColor);
                    backgroundColor = (Color)field.get(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (backgroundColor == null) {
                    backgroundColor = Color.WHITE;
                }
            }
            Color textColor = null;
            if (color == null || "".equals(color)) {
                textColor = Color.BLACK;
            } else {
                try {
                    Field field = Color.class.getField(color);
                    textColor = (Color)field.get(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (textColor == null) {
                    textColor = Color.BLACK;
                }
            }
            ErrorCorrectionLevel errorLvl = ErrorCorrectionLevel.H;
            if (errorLvlStr != null && !"".equals(errorLvlStr)) {
                if ("M".equals(errorLvl)) {
                    errorLvl = ErrorCorrectionLevel.M;
                } else if ("L".equals(errorLvl)) {
                    errorLvl = ErrorCorrectionLevel.L;
                } else if ("Q".equals(errorLvl)) {
                    errorLvl = ErrorCorrectionLevel.Q;
                }
            }
            BufferedImage img = PDFUtils.getBarCodeImg(barcodeMessage, width, height, errorLvl, textColor, backgroundColor, withText, textSize, encode);
            bos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)img, encode.encodeName, bos);
                byte[] imageBytes = bos.toByteArray();
                imageString = Base64Utils.encode((byte[])imageBytes);
                imageString = "data:image/" + (Object)((Object)encode) + ";base64," + imageString;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return imageString;
    }

    public static BufferedImage getBarCodeImg(String barcodeMessage, int width, int height, ErrorCorrectionLevel errorLvl, Color color, Color backgroundColor, boolean withText, int textSize, PDFUtils_ENCODE encode) throws WriterException {
        Graphics2D g2d;
        BufferedImage img = null;
        int textHeight = 0;
        int textAscent = 0;
        if (withText) {
            img = new BufferedImage(width, height, 1);
            g2d = img.createGraphics();
            Font font = new Font("Times", 0, textSize);
            g2d.setFont(font);
            FontMetrics fm = g2d.getFontMetrics();
            int textWidth = fm.stringWidth(barcodeMessage);
            while (textWidth > width) {
                log.debug("El tama\u00f1o de la fuente es demasiado grande = " + textSize + " (" + width + " - " + textWidth + ") -> se reduce a " + (textSize - 1));
                font = new Font("Times", 0, --textSize);
                g2d.setFont(font);
                fm = g2d.getFontMetrics();
                textWidth = fm.stringWidth(barcodeMessage);
            }
            textHeight = fm.getHeight();
            textAscent = fm.getAscent();
            g2d.dispose();
            g2d = img.createGraphics();
            g2d.setColor(backgroundColor);
            g2d.fillRect(0, 0, width, height);
            g2d.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g2d.setFont(font);
            fm = g2d.getFontMetrics();
            g2d.setColor(color);
            long comienzoTexto = Math.round(Math.floor((width - textWidth) / 2));
            comienzoTexto = comienzoTexto > 2L ? (comienzoTexto -= 2L) : 0L;
            g2d.drawString(barcodeMessage, (float)(Math.round(Math.floor((width - textWidth) / 2)) - 2L), (float)(height - textAscent));
            log.debug("Texto tama\u00f1o = " + textWidth + " (" + width + ") con fuente " + textSize);
            g2d.dispose();
        } else {
            img = new BufferedImage(width, height, 1);
            g2d = img.createGraphics();
            g2d = img.createGraphics();
            g2d.setColor(backgroundColor);
            g2d.fillRect(0, 0, width, height);
        }
        HashMap<EncodeHintType, ErrorCorrectionLevel> hintMap = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
        hintMap.put(EncodeHintType.ERROR_CORRECTION, errorLvl);
        Code128Writer code128Writer = new Code128Writer();
        String colorStr = "#" + String.format("%06x", color.getRGB() & 0xFFFFFF);
        String backColorStr = "#" + String.format("%06x", backgroundColor.getRGB() & 0xFFFFFF);
        log.debug("Code128: tama\u00f1o = " + width + "Wx" + height + "H en " + colorStr + " sobre " + backColorStr + " - error level = " + ((ErrorCorrectionLevel)hintMap.get(EncodeHintType.ERROR_CORRECTION)).toString());
        BitMatrix bitMatrix = code128Writer.encode(barcodeMessage, BarcodeFormat.CODE_128, width, height - textHeight - 2 * textAscent, hintMap);
        int matrixWidth = bitMatrix.getWidth();
        int matrixHeight = bitMatrix.getHeight();
        Graphics2D graphics = (Graphics2D)img.getGraphics();
        graphics.setColor(color);
        for (int i = 0; i < matrixWidth; ++i) {
            for (int j = 0; j < matrixHeight; ++j) {
                if (!bitMatrix.get(i, j)) continue;
                graphics.fillRect(i, j + textAscent, 1, 1);
            }
        }
        return img;
    }

    public static String getQRCode(String barcodeMessage) {
        return PDFUtils.getQRCode(barcodeMessage, null);
    }

    public static String getQRCode(String barcodeMessage, String sizeStr) {
        return PDFUtils.getQRCode(barcodeMessage, sizeStr, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getQRCode(String barcodeMessage, String sizeStr, String errorLvlStr, String color, String backColor, String encodeStr) {
        PDFUtils_ENCODE encode = PDFUtils_ENCODE.JPEG;
        try {
            encode = PDFUtils_ENCODE.valueOf(encodeStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        ByteArrayOutputStream bos = null;
        String imageString = null;
        try {
            int size = 80;
            if (sizeStr != null && !"".equals(sizeStr)) {
                size = new Integer(sizeStr);
            }
            Color backgroundColor = null;
            if (backColor == null || "".equals(backColor)) {
                backgroundColor = Color.WHITE;
            } else {
                try {
                    Field field = Color.class.getField(backColor);
                    backgroundColor = (Color)field.get(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (backgroundColor == null) {
                    backgroundColor = Color.WHITE;
                }
            }
            Color textColor = null;
            if (color == null || "".equals(color)) {
                textColor = Color.BLACK;
            } else {
                try {
                    Field field = Color.class.getField(color);
                    textColor = (Color)field.get(null);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (textColor == null) {
                    textColor = Color.BLACK;
                }
            }
            ErrorCorrectionLevel errorLvl = ErrorCorrectionLevel.H;
            if (errorLvlStr != null && !"".equals(errorLvlStr)) {
                if ("M".equals(errorLvl)) {
                    errorLvl = ErrorCorrectionLevel.M;
                } else if ("L".equals(errorLvl)) {
                    errorLvl = ErrorCorrectionLevel.L;
                } else if ("Q".equals(errorLvl)) {
                    errorLvl = ErrorCorrectionLevel.Q;
                }
            }
            BufferedImage img = PDFUtils.getQRCode(barcodeMessage, size, errorLvl, textColor, backgroundColor, encode);
            bos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)img, encode.encodeName, bos);
                byte[] imageBytes = bos.toByteArray();
                imageString = Base64Utils.encode((byte[])imageBytes);
                imageString = "data:image/" + (Object)((Object)encode) + ";base64," + imageString;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (bos != null) {
                    bos.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return imageString;
    }

    public static BufferedImage getQRCode(String barcodeMessage, int size, ErrorCorrectionLevel errorLvl, Color color, Color backgroundColor, PDFUtils_ENCODE encode) throws WriterException {
        BufferedImage image = null;
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        Hashtable<EncodeHintType, ErrorCorrectionLevel> hintMap = new Hashtable<EncodeHintType, ErrorCorrectionLevel>();
        hintMap.put(EncodeHintType.ERROR_CORRECTION, errorLvl);
        log.debug("QRCode: tama\u00f1o = " + size + " - error level = " + ((ErrorCorrectionLevel)hintMap.get(EncodeHintType.ERROR_CORRECTION)).toString());
        BitMatrix bitMatrix = qrCodeWriter.encode(barcodeMessage, BarcodeFormat.QR_CODE, size, size, hintMap);
        int matrixWidth = bitMatrix.getWidth();
        image = new BufferedImage(matrixWidth, matrixWidth, 1);
        image.createGraphics();
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setColor(backgroundColor);
        graphics.fillRect(0, 0, matrixWidth, matrixWidth);
        graphics.setColor(color);
        for (int i = 0; i < matrixWidth; ++i) {
            for (int j = 0; j < matrixWidth; ++j) {
                if (!bitMatrix.get(i, j)) continue;
                graphics.fillRect(i, j, 1, 1);
            }
        }
        return image;
    }

    public static enum PDFUtils_ENCODE {
        JPEG("jpeg"),
        GIF("gif");

        private final String encodeName;

        private PDFUtils_ENCODE(String encodeName) {
            this.encodeName = encodeName;
        }

        public String getEncodeName() {
            return this.encodeName;
        }
    }
}

