/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.utils;

import com.ejie.r01f.xmlproperties.XMLProperties;
import java.util.HashMap;
import p12f.exe.pasarelapagos.objects.security.SecurityContext;
import p12f.exe.pasarelapagos.security.app.SecurityContextGeneratorFactory;
import p12f.exe.pasarelapagos.security.app.SecurityContextGeneratorInterface;
import p12f.exe.pasarelapagos.security.app.SecurityContextParam;
import p12f.exe.pasarelapagos.security.app.manager.custom.DefaultSecurityManager;

public class SecurityContextUtils {
    public static final String SERVICE_CONFIG = "configService";
    public static final String SERVICE_SIPCA = "sipcaService";
    public static final String SERVICE_HOLDER_CERT = "holderCertService";
    public static final String SERVICE_FILE = "fileService";
    public static final String SERVICE_DATA = "dataService";
    public static final String SERVICE_OTP = "otpService";
    public static final String SERVICE_IKUS = "ikusService";
    public static final String SERVICE_SMS = "smsService";
    public static final String SERVICE_STATS = "statsService";
    public static final String SERVICE_MAIL = "mailService";
    public static final String SERVICE_PAYMENT_RECEIPT = "paymentReceiptService";

    private SecurityContextUtils() {
    }

    public static SecurityContext generateSecurityContext(String codAplic, String serviceName, String appId) throws SecurityException {
        SecurityContextParam appClientID = null;
        SecurityContextParam appClientKey = null;
        try {
            String key = XMLProperties.get((String)codAplic, (String)("defaultSecurityClientDefinition/services/service[@id='" + serviceName + "']/app[@id='" + appId + "']/appClientKey"));
            appClientID = new SecurityContextParam("appClientID", appId);
            appClientKey = new SecurityContextParam("appClientKey", key);
        }
        catch (Exception ex) {
            throw new SecurityException("No se ha podido obtener el par DefaultSecurityContextGenerator.APP_CLIENT_ID / APP_CLIENT_KEY en el cliente del servicio: " + ex);
        }
        SecurityContextParam serviceNameCtxParam = new SecurityContextParam("serviceName", serviceName);
        HashMap<String, SecurityContextParam> inputdataList = new HashMap<String, SecurityContextParam>();
        inputdataList.put(appClientID.getID(), appClientID);
        inputdataList.put(appClientKey.getID(), appClientKey);
        inputdataList.put(serviceNameCtxParam.getID(), serviceNameCtxParam);
        SecurityContextGeneratorInterface scxGenerator = SecurityContextGeneratorFactory.getInstance("custom");
        SecurityContext ctx = scxGenerator.generateSecurityContext(inputdataList);
        return ctx;
    }

    public static SecurityContext getSecurityContext(String codAplic, String serviceName) throws SecurityException {
        SecurityContextParam appClientID = null;
        SecurityContextParam appClientKey = null;
        try {
            String id = XMLProperties.getPropertyNode((String)codAplic, (String)("defaultSecurityClientDefinition/services/service[@id='" + serviceName + "']/app/@id")).getNodeValue();
            String key = XMLProperties.get((String)codAplic, (String)("defaultSecurityClientDefinition/services/service[@id='" + serviceName + "']/app[@id='" + id + "']/appClientKey"));
            appClientID = new SecurityContextParam("appClientID", id);
            appClientKey = new SecurityContextParam("appClientKey", key);
        }
        catch (Exception ex) {
            throw new SecurityException("No se ha podido obtener el par DefaultSecurityContextGenerator.APP_CLIENT_ID / APP_CLIENT_KEY en el cliente del servicio: " + ex);
        }
        SecurityContextParam serviceNameCtxParam = new SecurityContextParam("serviceName", serviceName);
        HashMap<String, SecurityContextParam> inputdataList = new HashMap<String, SecurityContextParam>();
        inputdataList.put(appClientID.getID(), appClientID);
        inputdataList.put(appClientKey.getID(), appClientKey);
        inputdataList.put(serviceNameCtxParam.getID(), serviceNameCtxParam);
        SecurityContextGeneratorInterface scxGenerator = SecurityContextGeneratorFactory.getInstance("custom");
        SecurityContext ctx = scxGenerator.generateSecurityContext(inputdataList);
        return ctx;
    }

    public static SecurityContext getSecurityContext(String codAplic) throws SecurityException {
        return SecurityContextUtils.getSecurityContext(codAplic, SERVICE_CONFIG);
    }

    public static SecurityContext getSecurityContext(String id, String key, String serviceName) throws SecurityException {
        SecurityContextParam appClientID = null;
        SecurityContextParam appClientKey = null;
        try {
            appClientID = new SecurityContextParam("appClientID", id);
            appClientKey = new SecurityContextParam("appClientKey", key);
        }
        catch (Exception ex) {
            throw new SecurityException("No se ha podido obtener el par DefaultSecurityContextGenerator.APP_CLIENT_ID / APP_CLIENT_KEY en el cliente del servicio: " + ex);
        }
        SecurityContextParam serviceNameCtxParam = new SecurityContextParam("serviceName", serviceName);
        HashMap<String, SecurityContextParam> inputdataList = new HashMap<String, SecurityContextParam>();
        inputdataList.put(appClientID.getID(), appClientID);
        inputdataList.put(appClientKey.getID(), appClientKey);
        inputdataList.put(serviceNameCtxParam.getID(), serviceNameCtxParam);
        SecurityContextGeneratorInterface scxGenerator = SecurityContextGeneratorFactory.getInstance("custom");
        SecurityContext ctx = scxGenerator.generateSecurityContext(inputdataList);
        return ctx;
    }

    public static boolean checkSecurityContext(String codAplic, SecurityContext ctx) throws SecurityException {
        DefaultSecurityManager mng = new DefaultSecurityManager(codAplic);
        if (mng.hasPermission(ctx)) {
            return true;
        }
        if (ctx != null && ctx.serviceName != null) {
            throw new SecurityException("Security Context No Valido : " + codAplic + " : " + ctx.serviceName);
        }
        throw new SecurityException("Security Context No Valido : " + codAplic + " : null");
    }

    public static boolean checkSecurityContext(String codAplic, SecurityContext ctx, String securityKey, long expirationMillis) throws SecurityException {
        DefaultSecurityManager mng = new DefaultSecurityManager(codAplic);
        if (mng.hasPermission(ctx, securityKey, expirationMillis)) {
            return true;
        }
        if (ctx != null && ctx.serviceName != null) {
            throw new SecurityException("Security Context No Valido : " + codAplic + " : " + ctx.serviceName);
        }
        throw new SecurityException("Security Context No Valido : " + codAplic + " : null");
    }
}

