/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12f.exe.pasarelapagos.objects.Pago;
import p12f.exe.pasarelapagos.objects.PaymentStateData;

public class PaymentStateDataHelper {
    private static final Logger log = LoggerFactory.getLogger(PaymentStateDataHelper.class);

    private static String _getPeriodoActivoPagoPorFecha522C60(Pago pago, PaymentStateData paymentStateData) {
        String strFechaPagoDDMMYY = paymentStateData.estado.fechaPago;
        if (strFechaPagoDDMMYY == null) {
            return null;
        }
        String strFechaPagoYYMMDD = strFechaPagoDDMMYY.replaceAll("([0-9]{2})([0-9]{2})([0-9]{2})", "$3$2$1");
        String strFechaFinPeriodoVolDDMMYY = pago.datosPago.periodosPago.get((Object)"periodoVoluntario").fechaFin;
        String strFechaFinPeriodoRecDDMMYY = pago.datosPago.periodosPago.get((Object)"periodoConRecargo").fechaFin;
        String strFechaFinPeriodoVolYYMMDD = null;
        String strFechaFinPeriodoRecYYMMDD = null;
        if (strFechaFinPeriodoVolDDMMYY != null) {
            strFechaFinPeriodoVolYYMMDD = strFechaFinPeriodoVolDDMMYY.replaceAll("([0-9]{2})([0-9]{2})([0-9]{2})", "$3$2$1");
        }
        if (strFechaFinPeriodoRecDDMMYY != null) {
            strFechaFinPeriodoRecYYMMDD = strFechaFinPeriodoRecDDMMYY.replaceAll("([0-9]{2})([0-9]{2})([0-9]{2})", "$3$2$1");
        }
        if (strFechaFinPeriodoVolYYMMDD != null && Integer.parseInt(strFechaPagoYYMMDD) <= Integer.parseInt(strFechaFinPeriodoVolYYMMDD)) {
            return "periodoVoluntario";
        }
        if (strFechaFinPeriodoRecYYMMDD != null && Integer.parseInt(strFechaPagoYYMMDD) <= Integer.parseInt(strFechaFinPeriodoRecYYMMDD)) {
            return "periodoConRecargo";
        }
        return null;
    }

    private static String _getPeriodoActivoPagoPorAtributo522C60(Pago pago) {
        if (pago.datosPago.periodosPago.get((Object)"periodoVoluntario").activo) {
            return "periodoVoluntario";
        }
        if (pago.datosPago.periodosPago.get((Object)"periodoConRecargo").activo) {
            return "periodoConRecargo";
        }
        return null;
    }

    public static String activarPeriodoPago522C60(Pago pago, PaymentStateData paymentStateData) {
        String periodoActivo = PaymentStateDataHelper._getPeriodoActivoPagoPorAtributo522C60(pago);
        if (periodoActivo == null) {
            log.debug("[P12F][PaymentStateDataHelper] No se encuentra un periodo activo para el pago " + pago.id);
            periodoActivo = PaymentStateDataHelper._getPeriodoActivoPagoPorFecha522C60(pago, paymentStateData);
            log.debug("[P12F][PaymentStateDataHelper] Activando periodo " + periodoActivo + " para el pago " + pago.id);
            if (periodoActivo != null) {
                if ("periodoVoluntario".equalsIgnoreCase(periodoActivo)) {
                    pago.datosPago.periodosPago.get((Object)"periodoVoluntario").activo = true;
                } else if ("periodoConRecargo".equalsIgnoreCase(periodoActivo)) {
                    pago.datosPago.periodosPago.get((Object)"periodoConRecargo").activo = true;
                }
            } else {
                log.debug("[P12F][PaymentStateDataHelper] No se ha podido determinar el periodo activo de este pago " + pago.id);
            }
        } else {
            log.debug("[P12F][PaymentStateDataHelper] El pago " + pago.id + " tiene como periodo activo " + periodoActivo);
        }
        return periodoActivo;
    }
}

