/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.utils;

import com.ejie.r01f.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import p12f.exe.pasarelapagos.objects.DatoAdicional;
import p12f.exe.pasarelapagos.objects.PeriodoPago;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;
import p12f.exe.pasarelapagos.utils.CSBConstants;
import p12f.exe.pasarelapagos.utils.CSBHelpper;
import p12f.exe.pasarelapagos.utils.exceptions.CSBFormatException;
import p12f.exe.pasarelapagos.utils.exceptions.PaymentDataHelpperException;

public class PaymentDataHelper {
    public static final String PAYMENTTYPE_ADMIN = "PAYMENTTYPE_ADMIN";
    public static final String PAYMENTTYPE_TYPE = "PAYMENTTYPE_TYPE";
    public static final String PAYMENTTYPE_FORMAT = "PAYMENTTYPE_FORMAT";

    public static String getOID(PeticionPago peticionPago) throws PaymentDataHelpperException {
        return PaymentDataHelper.getCSBCode(peticionPago);
    }

    public static String getCSBCode(PeticionPago peticionPago) throws PaymentDataHelpperException {
        int formato = Integer.parseInt(peticionPago.datosPago.formato);
        switch (formato) {
            case 507: {
                return PaymentDataHelper.getCSB507Code(peticionPago);
            }
            case 502: {
                return PaymentDataHelper.getCSB502Code(peticionPago);
            }
            case 508: {
                return PaymentDataHelper.getCSB508Code(peticionPago);
            }
            case 521: {
                return PaymentDataHelper.getCSB521Code(peticionPago);
            }
            case 522: {
                return PaymentDataHelper.getCSB522Code(peticionPago);
            }
            case 523: {
                return PaymentDataHelper.getCSB523Code(peticionPago);
            }
        }
        return null;
    }

    public static String getCSB507Code(PeticionPago peticionPago) throws PaymentDataHelpperException {
        String csbCode = CSBConstants.CSB507.ID_APP.defaultValue + CSBConstants.CSB507.csbCode;
        String emisorCSB = null;
        String sufijoCSB = null;
        try {
            StringTokenizer st = new StringTokenizer(peticionPago.datosPago.emisor, "-");
            emisorCSB = st.nextToken();
            sufijoCSB = st.nextToken();
        }
        catch (NullPointerException nulEx) {
            throw new PaymentDataHelpperException("El c\u00f3digo del Emisor no sigue un formato correcto : cif_sin_letras - sufijo , p.e.: 04833001-501 ");
        }
        catch (NoSuchElementException nulEx) {
            throw new PaymentDataHelpperException("El c\u00f3digo del Emisor no sigue un formato correcto : cif_sin_letras - sufijo , p.e.: 04833001-501 ");
        }
        PeriodoPago periodoPago = null;
        if (peticionPago.datosPago == null || peticionPago.datosPago.periodosPago == null || peticionPago.datosPago.periodosPago.values().isEmpty()) {
            throw new PaymentDataHelpperException("PeticionPago.datosPago es nulo o no tiene ningun Periodo de Pago");
        }
        periodoPago = peticionPago.datosPago.periodosPago.values().iterator().next();
        if (periodoPago == null) {
            throw new PaymentDataHelpperException("PeticionPago.datosPago.periodosPago no contiene ning\u00fan periodo de Pago");
        }
        String importe = Long.toString(periodoPago.importe);
        while (importe.length() < 10) {
            importe = "0" + importe;
        }
        csbCode = csbCode + emisorCSB + sufijoCSB + peticionPago.datosPago.referencia + periodoPago.identificacion + importe + CSBConstants.CSB507.DIGITO_PARIDAD.defaultValue;
        return csbCode;
    }

    public static String getCSB502Code(PeticionPago peticionPago) throws PaymentDataHelpperException {
        String csbCode = CSBConstants.CSB502.ID_APP.defaultValue + CSBConstants.CSB502.csbCode;
        PeriodoPago periodoPago = null;
        if (peticionPago.datosPago == null || peticionPago.datosPago.periodosPago == null || peticionPago.datosPago.periodosPago.values().isEmpty()) {
            throw new PaymentDataHelpperException("PeticionPago.datosPago es nulo o no tiene ningun Periodo de Pago");
        }
        periodoPago = peticionPago.datosPago.periodosPago.values().iterator().next();
        if (periodoPago == null) {
            throw new PaymentDataHelpperException("PeticionPago.datosPago.periodosPago no contiene ning\u00fan periodo de Pago");
        }
        String importe = Long.toString(periodoPago.importe);
        while (importe.length() < 8) {
            importe = "0" + importe;
        }
        csbCode = csbCode + peticionPago.datosPago.emisor + peticionPago.datosPago.referencia + periodoPago.identificacion + importe;
        return csbCode;
    }

    public static String getCSB508Code(PeticionPago peticionPago) throws PaymentDataHelpperException {
        String csbCode = CSBConstants.CSB508.ID_APP.defaultValue + CSBConstants.CSB508.csbCode;
        String emisorCSB = null;
        String tesoreroCSB = null;
        emisorCSB = peticionPago.datosPago.emisor;
        tesoreroCSB = peticionPago.emisor.entidadTesorera;
        String fechaLimiteCSB = peticionPago.datosPago.periodosPago.get((Object)"periodoNormal").fechaFin;
        PeriodoPago periodoPago = null;
        if (peticionPago.datosPago == null || peticionPago.datosPago.periodosPago == null || peticionPago.datosPago.periodosPago.values().isEmpty()) {
            throw new PaymentDataHelpperException("PeticionPago.datosPago es nulo o no tiene ningun Periodo de Pago");
        }
        periodoPago = peticionPago.datosPago.periodosPago.values().iterator().next();
        if (periodoPago == null) {
            throw new PaymentDataHelpperException("PeticionPago.datosPago.periodosPago no contiene ning\u00fan periodo de Pago");
        }
        String importe = Long.toString(periodoPago.importe);
        while (importe.length() < 8) {
            importe = "0" + importe;
        }
        csbCode = csbCode + tesoreroCSB + fechaLimiteCSB + emisorCSB + peticionPago.datosPago.referencia + periodoPago.identificacion + importe;
        return csbCode;
    }

    public static String getCSB521Code(PeticionPago peticionPago) throws PaymentDataHelpperException {
        String csbCode = CSBConstants.CSB521.ID_APP.defaultValue + CSBConstants.CSB521.csbCode;
        String emisorCSB = peticionPago.datosPago.emisor;
        PeriodoPago periodoPago = null;
        if (peticionPago.datosPago == null || peticionPago.datosPago.periodosPago == null || peticionPago.datosPago.periodosPago.values().isEmpty()) {
            throw new PaymentDataHelpperException("PeticionPago.datosPago es nulo o no tiene ningun Periodo de Pago");
        }
        periodoPago = peticionPago.datosPago.periodosPago.values().iterator().next();
        if (periodoPago == null) {
            throw new PaymentDataHelpperException("PeticionPago.datosPago.periodosPago no contiene ning\u00fan periodo de Pago");
        }
        String importe = Long.toString(periodoPago.importe);
        while (importe.length() < 8) {
            importe = "0" + importe;
        }
        csbCode = csbCode + emisorCSB + peticionPago.datosPago.referencia + periodoPago.identificacion + importe + CSBConstants.CSB521.DIGITO_PARIDAD.defaultValue;
        return csbCode;
    }

    public static String getCSB522Code(PeticionPago peticionPago) throws PaymentDataHelpperException {
        String csbCode = CSBConstants.CSB522.ID_APP.defaultValue + CSBConstants.CSB522.csbCode;
        String emisorCSB = peticionPago.datosPago.emisor;
        PeriodoPago periodoPagoVoluntario = peticionPago.datosPago.periodosPago.get("periodoVoluntario");
        PeriodoPago periodoPagoConRecargo = peticionPago.datosPago.periodosPago.get("periodoConRecargo");
        String importeVoluntario = Long.toString(periodoPagoVoluntario.importe);
        while (importeVoluntario.length() < 8) {
            importeVoluntario = "0" + importeVoluntario;
        }
        String importeRecargo = Long.toString(periodoPagoConRecargo.importe);
        while (importeRecargo.length() < 8) {
            importeRecargo = "0" + importeRecargo;
        }
        String identificacionVoluntario = periodoPagoVoluntario.identificacion;
        String identificacionConRecargo = periodoPagoConRecargo.identificacion;
        String tributo = identificacionVoluntario.substring(1, 4);
        String ejercicio = identificacionVoluntario.substring(4, 6);
        String fechaVol = identificacionVoluntario.substring(6, 10);
        String fechaRec = identificacionConRecargo.substring(6, 10);
        csbCode = csbCode + emisorCSB + peticionPago.datosPago.referencia + tributo + ejercicio + fechaVol + importeVoluntario + fechaRec + importeRecargo;
        return csbCode;
    }

    public static String getCSB523Code(PeticionPago peticionPago) throws PaymentDataHelpperException {
        String csbCode = CSBConstants.CSB523.ID_APP.defaultValue + CSBConstants.CSB523.csbCode;
        String emisorCSB = peticionPago.datosPago.emisor;
        PeriodoPago periodoPago = null;
        if (peticionPago.datosPago == null || peticionPago.datosPago.periodosPago == null || peticionPago.datosPago.periodosPago.values().isEmpty()) {
            throw new PaymentDataHelpperException("PeticionPago.datosPago es nulo o no tiene ningun Periodo de Pago");
        }
        periodoPago = peticionPago.datosPago.periodosPago.values().iterator().next();
        if (periodoPago == null) {
            throw new PaymentDataHelpperException("PeticionPago.datosPago.periodosPago no contiene ning\u00fan periodo de Pago");
        }
        String importe = Long.toString(periodoPago.importe);
        String expediente = peticionPago.expediente.codigo == null ? "" : peticionPago.expediente.codigo;
        String datoEspecifico = StringUtils.fillLeft((String)"", (int)20, (String)"0");
        String fechaDevengo = StringUtils.fillLeft((String)"", (int)8, (String)"0");
        for (DatoAdicional da : peticionPago.datosAdicionales) {
            if (da != null && "datoEspecifico".equals(da.id)) {
                datoEspecifico = StringUtils.fillLeft((String)da.valor, (int)20, (String)"0");
            }
            if (da == null || !"fechaDevengo".equals(da.id)) continue;
            fechaDevengo = StringUtils.fillLeft((String)da.valor, (int)8, (String)"0");
        }
        csbCode = csbCode + emisorCSB + peticionPago.datosPago.numeroJustificante + fechaDevengo + peticionPago.expediente.tercero.dniNif + StringUtils.fillLeft((String)expediente, (int)12, (String)"0") + datoEspecifico + StringUtils.fillLeft((String)importe, (int)8, (String)"0");
        return csbCode;
    }

    public static Map<String, String> getPaymentTypeConfigAttributes(PeticionPago peticionPago) throws PaymentDataHelpperException {
        HashMap<String, String> data = new HashMap<String, String>();
        String cdbCode = peticionPago.datosPago.codigo;
        String cifEmisor = null;
        String tipo = null;
        String identificacion = null;
        try {
            if (cdbCode == null) {
                throw new PaymentDataHelpperException("El codigo CSB es nulo (peticionPago.datosPago.codigo ");
            }
            int formato = Integer.parseInt(peticionPago.datosPago.formato);
            switch (formato) {
                case 507: {
                    cifEmisor = CSBHelpper.decode507(cdbCode).get(CSBConstants.CSB507.EMISOR);
                    tipo = CSBHelpper.decode507(cdbCode).get(CSBConstants.CSB507.SUFIJO);
                    break;
                }
                case 502: {
                    cifEmisor = CSBHelpper.decode502(cdbCode).get(CSBConstants.CSB502.EMISOR);
                    identificacion = CSBHelpper.decode502(cdbCode).get(CSBConstants.CSB502.IDENTIFICACION);
                    tipo = CSBHelpper.decode502(identificacion, CSBConstants.CSB502.IDENTIFICACION).get(CSBConstants.CSB502.TRIBUTO);
                    break;
                }
                case 508: {
                    cifEmisor = CSBHelpper.decode508(cdbCode).get(CSBConstants.CSB508.EMISOR);
                    identificacion = CSBHelpper.decode508(cdbCode).get(CSBConstants.CSB508.IDENTIFICACION);
                    tipo = CSBHelpper.decode508(identificacion, CSBConstants.CSB508.IDENTIFICACION).get(CSBConstants.CSB508.TRIBUTO);
                    break;
                }
                case 521: {
                    cifEmisor = CSBHelpper.decode521(cdbCode).get(CSBConstants.CSB521.EMISOR);
                    identificacion = CSBHelpper.decode521(cdbCode).get(CSBConstants.CSB521.IDENTIFICACION);
                    tipo = CSBHelpper.decode521(identificacion, CSBConstants.CSB521.IDENTIFICACION).get(CSBConstants.CSB521.TRIBUTO);
                    break;
                }
                case 522: {
                    cifEmisor = CSBHelpper.decode522(cdbCode).get(CSBConstants.CSB522.EMISOR);
                    identificacion = CSBHelpper.decode522(cdbCode).get(CSBConstants.CSB522.IDENTIFICACION_SIN_RECARGO);
                    tipo = CSBHelpper.decode522(cdbCode).get(CSBConstants.CSB522.TRIBUTO);
                    break;
                }
                case 523: {
                    cifEmisor = CSBHelpper.decode523(cdbCode).get(CSBConstants.CSB523.EMISOR);
                    identificacion = CSBHelpper.decode523(cdbCode).get(CSBConstants.CSB523.JUSTIFICANTE);
                    tipo = CSBHelpper.decode523(cdbCode).get(CSBConstants.CSB523.TRIBUTO);
                }
            }
            data.put(PAYMENTTYPE_ADMIN, cifEmisor);
            data.put(PAYMENTTYPE_TYPE, tipo);
            data.put(PAYMENTTYPE_FORMAT, peticionPago.datosPago.formato);
        }
        catch (CSBFormatException e) {
            throw new PaymentDataHelpperException((Exception)((Object)e));
        }
        return data;
    }
}

