/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.utils;

import com.ejie.r01f.util.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12f.exe.pasarelapagos.objects.AccountData;
import p12f.exe.pasarelapagos.security.crypto.TripleDESEBCDICCryptoHelper;

public class PayOnAccountDataUtil {
    private static final Logger log = LoggerFactory.getLogger(PayOnAccountDataUtil.class);

    public static AccountData encryptAndEncodeAccountData(String clave1, String clave2, AccountData accountData) throws Exception {
        return PayOnAccountDataUtil.encryptAccountData(clave1, clave2, accountData);
    }

    public static AccountData encryptAccountData(String clave1, String clave2, AccountData accountData) throws Exception {
        log.info("[P12F] PayOnAccountDataUtil.encryptAccountData(...): CIFRAR");
        AccountData encryptedAccountData = AccountData.getObject(accountData.toXML());
        encryptedAccountData.encData.value = PayOnAccountDataUtil.encryptData(clave1, clave2, accountData);
        return encryptedAccountData;
    }

    public static String encryptData(String clave1, String clave2, AccountData accountData) throws Exception {
        log.info("[P12F] PayOnAccountDataUtil.encryptData(...): CIFRAR");
        log.info("[P12F] ========================================================");
        log.info("[P12F] >>>>> Semiclaves de entrada:");
        log.info("[P12F]      .Semiclave1: [" + clave1.substring(0, clave1.length() / 2) + "...]");
        log.info("[P12F]      .Semiclave2: [" + clave2.substring(0, clave2.length() / 2) + "...]");
        String encType = accountData.encData.encType;
        String data = accountData.encData.value;
        data = StringUtils.rPadWithChar((String)data, (char)' ', (int)32);
        log.debug("[P12F] >>>>> Trama final a encriptar (rellenar a 32 espacios por la derecha para lograr paridad x 8:" + data + "data.length()=" + data.length());
        String claveFinal = new String(Hex.encode((byte[])TripleDESEBCDICCryptoHelper.doXOR(clave1, clave2))).toUpperCase();
        log.debug("[P12F] Clave final xor: [" + claveFinal.substring(0, claveFinal.length() / 2) + "...]");
        TripleDESEBCDICCryptoHelper encrypter = new TripleDESEBCDICCryptoHelper();
        if (encType != null && encType.equalsIgnoreCase("hex")) {
            return encrypter.encryptHEX(claveFinal, data);
        }
        return encrypter.encrypt(claveFinal, data);
    }

    public static AccountData decryptAccountData(String clave1, String clave2, AccountData accountData) throws Exception {
        log.info("[P12F] PayOnAccountDataUtil.encryptAccountData(...): CIFRAR");
        AccountData decryptedAccountData = AccountData.getObject(accountData.toXML());
        decryptedAccountData.encData.value = PayOnAccountDataUtil.decryptData(clave1, clave2, accountData);
        return decryptedAccountData;
    }

    public static String decryptData(String clave1, String clave2, AccountData accountData) throws Exception {
        log.info("[P12F] PayOnAccountDataUtil.decryptData(...): DESCIFRAR");
        log.info("[P12F] ========================================================");
        log.info("[P12F] >>>>> Semiclaves de entrada:");
        log.info("[P12F]      .Semiclave1: [" + clave1.substring(0, clave1.length() / 2) + "...]");
        log.info("[P12F]      .Semiclave2: [" + clave2.substring(0, clave2.length() / 2) + "...]");
        String encType = accountData.encData.encType;
        String data = accountData.encData.value;
        String claveFinal = new String(Hex.encode((byte[])TripleDESEBCDICCryptoHelper.doXOR(clave1, clave2))).toUpperCase();
        log.debug("[P12F] Clave final xor: [" + claveFinal.substring(0, claveFinal.length() / 2) + "...]");
        TripleDESEBCDICCryptoHelper encrypter = new TripleDESEBCDICCryptoHelper();
        if (encType != null && encType.equalsIgnoreCase("hex")) {
            return encrypter.decryptHEX(claveFinal, data).trim();
        }
        return encrypter.decrypt(claveFinal, data).trim();
    }
}

