/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.utils;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12f.exe.pasarelapagos.exceptions.P12RequestException;

public class P12RequestUtils {
    private static final Logger log = LoggerFactory.getLogger(P12RequestUtils.class);
    private String _log = null;
    private boolean _doLog = false;
    private boolean _checkParameterActive = false;
    private Map<String, String> _checksRegExp = new HashMap<String, String>();
    private Map<String, String[]> _checksFunctions = new HashMap<String, String[]>();

    public P12RequestUtils(String log, boolean checkParameterActive, Map<String, String> checks) {
        this(checkParameterActive, checks);
        this._log = log;
        if (this._log != null) {
            this._doLog = true;
        }
    }

    public P12RequestUtils(String log, boolean checkParameterActive, Map<String, String> checksRegExp, Map<String, String[]> checksFunctions) {
        this(checkParameterActive, checksRegExp, checksFunctions);
        this._log = log;
        if (this._log != null) {
            this._doLog = true;
        }
    }

    public P12RequestUtils(boolean checkParameterActive, Map<String, String> checks) {
        this._checkParameterActive = checkParameterActive;
        this._checksRegExp = checks;
    }

    public P12RequestUtils(boolean checkParameterActive, Map<String, String> checksRegExp, Map<String, String[]> checksFunctions) {
        this._checkParameterActive = checkParameterActive;
        this._checksRegExp = checksRegExp;
        this._checksFunctions = checksFunctions;
    }

    public String getRequestParam(HttpServletRequest request, String paramName) throws P12RequestException {
        String paramValue = request.getParameter(paramName);
        if (this._checkParameterActive) {
            this._checkParameter(paramName, paramValue);
        }
        return paramValue;
    }

    public String getRequestParamWithOtherParamValidation(HttpServletRequest request, String paramName, String validationParamName) throws P12RequestException {
        String paramValue = request.getParameter(paramName);
        if (this._checkParameterActive) {
            this._checkParameter(validationParamName, paramValue);
        }
        return paramValue;
    }

    public String getRequestParam(HttpServletRequest request, String paramName, boolean nullable) throws P12RequestException {
        String paramValue = request.getParameter(paramName);
        if ((!nullable || paramValue != null) && this._checkParameterActive) {
            this._checkParameter(paramName, paramValue);
        }
        return paramValue;
    }

    public String getRequestParamWithOtherParamValidation(HttpServletRequest request, String paramName, String validationParamName, boolean nullable) throws P12RequestException {
        String paramValue = request.getParameter(paramName);
        if ((!nullable || paramValue != null) && this._checkParameterActive) {
            this._checkParameter(validationParamName, paramValue);
        }
        return paramValue;
    }

    public String getRequestParam(HttpServletRequest request, String paramName, boolean nullable, boolean canBeEmptyString) throws P12RequestException {
        String paramValue = request.getParameter(paramName);
        if (!(nullable && paramValue == null || canBeEmptyString && "".equals(paramValue) || !this._checkParameterActive)) {
            this._checkParameter(paramName, paramValue);
        }
        return paramValue;
    }

    public String getRequestParamWithOtherParamValidation(HttpServletRequest request, String paramName, String validationParamName, boolean nullable, boolean canBeEmptyString) throws P12RequestException {
        String paramValue = request.getParameter(paramName);
        if (!(nullable && paramValue == null || canBeEmptyString && "".equals(paramValue) || !this._checkParameterActive)) {
            this._checkParameter(validationParamName, paramValue);
        }
        return paramValue;
    }

    public String getRequestParam(HttpServletRequest request, String paramName, String defaultValue) throws P12RequestException {
        String paramValue = request.getParameter(paramName);
        if (paramValue == null) {
            return defaultValue;
        }
        if (this._checkParameterActive) {
            this._checkParameter(paramName, paramValue);
        }
        return paramValue;
    }

    public String getRequestParam(HttpServletRequest request, String paramName, String defaultValue, boolean applyDefaultValueToEmptyString) throws P12RequestException {
        String paramValue = request.getParameter(paramName);
        if (paramValue == null || applyDefaultValueToEmptyString && "".equals(paramValue)) {
            return defaultValue;
        }
        if (this._checkParameterActive) {
            this._checkParameter(paramName, paramValue);
        }
        return paramValue;
    }

    public String getRequestParam(HttpServletRequest request, String paramName, String defaultValue, boolean applyDefaultValueToEmptyString, boolean applyDefaultValueToNoCheckedValue) {
        String paramValue;
        block4: {
            paramValue = request.getParameter(paramName);
            if (paramValue == null || applyDefaultValueToEmptyString && "".equals(paramValue)) {
                return defaultValue;
            }
            if (this._checkParameterActive) {
                try {
                    this._checkParameter(paramName, paramValue);
                }
                catch (P12RequestException e) {
                    if (!applyDefaultValueToNoCheckedValue) break block4;
                    return defaultValue;
                }
            }
        }
        return paramValue;
    }

    public String getRequestParamWithValidation(HttpServletRequest request, String paramName, String validationRegExp) throws P12RequestException {
        String paramValue = request.getParameter(paramName);
        if (this._checkParameterActive) {
            this._checkParameter(paramName, paramValue, validationRegExp);
        }
        return paramValue;
    }

    public String getRequestParamWithValidation(HttpServletRequest request, String paramName, String validationRegExp, String defaultValue, boolean applyDefaultValueToEmptyString) throws P12RequestException {
        String paramValue = request.getParameter(paramName);
        if (paramValue == null || applyDefaultValueToEmptyString && "".equals(paramValue)) {
            return defaultValue;
        }
        if (this._checkParameterActive) {
            this._checkParameter(paramName, paramValue, validationRegExp);
        }
        return paramValue;
    }

    public String getRequestParam(HttpServletRequest request, HttpServletResponse response, String paramName) throws P12RequestException, IOException {
        try {
            return this.getRequestParam(request, paramName);
        }
        catch (P12RequestException e) {
            response.sendError(403, "Requested url is not accessible");
            throw e;
        }
    }

    public String getRequestParam(HttpServletRequest request, HttpServletResponse response, String paramName, boolean nullable) throws P12RequestException, IOException {
        try {
            return this.getRequestParam(request, paramName, nullable);
        }
        catch (P12RequestException e) {
            response.sendError(403, "Requested url is not accessible");
            throw e;
        }
    }

    public String getRequestParam(HttpServletRequest request, HttpServletResponse response, String paramName, boolean nullable, boolean canBeEmptyString) throws P12RequestException, IOException {
        try {
            return this.getRequestParam(request, paramName, nullable, canBeEmptyString);
        }
        catch (P12RequestException e) {
            response.sendError(403, "Requested url is not accessible");
            throw e;
        }
    }

    public String getRequestParam(HttpServletRequest request, HttpServletResponse response, String paramName, String defaultValue) throws P12RequestException, IOException {
        try {
            return this.getRequestParam(request, paramName, defaultValue);
        }
        catch (P12RequestException e) {
            response.sendError(403, "Requested url is not accessible");
            throw e;
        }
    }

    public String getRequestParam(HttpServletRequest request, HttpServletResponse response, String paramName, String defaultValue, boolean applyDefaultValueToEmptyString) throws P12RequestException, IOException {
        try {
            return this.getRequestParam(request, paramName, defaultValue, applyDefaultValueToEmptyString);
        }
        catch (P12RequestException e) {
            response.sendError(403, "Requested url is not accessible");
            throw e;
        }
    }

    public String getRequestParamWithValidation(HttpServletRequest request, HttpServletResponse response, String paramName, String validationRegExp) throws P12RequestException, IOException {
        try {
            return this.getRequestParamWithValidation(request, paramName, validationRegExp);
        }
        catch (P12RequestException e) {
            response.sendError(403, "Requested url is not accessible");
            throw e;
        }
    }

    public String getRequestParamWithValidation(HttpServletRequest request, HttpServletResponse response, String paramName, String validationRegExp, String defaultValue, boolean applyDefaultValueToEmptyString) throws P12RequestException, IOException {
        try {
            return this.getRequestParamWithValidation(request, paramName, validationRegExp, defaultValue, applyDefaultValueToEmptyString);
        }
        catch (P12RequestException e) {
            response.sendError(403, "Requested url is not accessible");
            throw e;
        }
    }

    private void _checkParameter(String paramName, String paramValue) throws P12RequestException {
        if (this._checksRegExp.containsKey(paramName)) {
            if (paramValue == null) {
                if (this._doLog) {
                    log.warn("[P12RequestUtils - Reg Exp] El parametro '" + paramName + "' no puede ser nulo");
                }
                throw new P12RequestException("Requested url is not accessible");
            }
            Pattern theXSSPattern = Pattern.compile(this._checksRegExp.get(paramName));
            Matcher matcher = theXSSPattern.matcher(paramValue);
            if (!matcher.matches()) {
                if (this._doLog) {
                    log.warn("[P12RequestUtils - Reg Exp] El parametro '" + paramName + "' no puede contener el valor '" + paramValue + "' (regExp=" + this._checksRegExp.get(paramName) + ") [properties]");
                }
                throw new P12RequestException("Requested url is not accessible");
            }
        }
        if (this._checksFunctions.containsKey(paramName)) {
            String[] claseYfuncion = this._checksFunctions.get(paramName);
            try {
                Class<?> claseValidadora = Class.forName(claseYfuncion[0]);
                Method metodoValidador = claseValidadora.getMethod(claseYfuncion[1], String.class);
                if (Modifier.isStatic(metodoValidador.getModifiers())) {
                    metodoValidador.invoke(claseValidadora, paramValue);
                } else {
                    Object claseValidadoraInstanciada = claseValidadora.newInstance();
                    metodoValidador.invoke(claseValidadoraInstanciada, paramValue);
                }
            }
            catch (InvocationTargetException e) {
                Throwable mainException = e.getCause();
                if (mainException instanceof P12RequestException) {
                    if (this._doLog) {
                        log.warn("[P12RequestUtils - Function] El parametro '" + paramName + "' no puede contener el valor '" + paramValue + "' (" + claseYfuncion[0] + "." + claseYfuncion[1] + ") [properties]\n" + "[P12RequestUtils - Function] Error: " + ((P12RequestException)((Object)mainException)).getMessage());
                    }
                    throw new P12RequestException("Requested url is not accessible");
                }
                mainException.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void _checkParameter(String paramName, String paramValue, String validationRegExp) throws P12RequestException {
        if (paramValue == null) {
            if (this._doLog) {
                log.warn("[P12RequestUtils - Reg Exp] El parametro '" + paramName + "' no puede ser nulo");
            }
            throw new P12RequestException("Requested url is not accessible");
        }
        Pattern theXSSPattern = Pattern.compile(validationRegExp);
        Matcher matcher = theXSSPattern.matcher(paramValue);
        if (!matcher.matches()) {
            if (this._doLog) {
                log.warn("[P12RequestUtils - Reg Exp] El parametro '" + paramName + "' no puede contener el valor '" + paramValue + "' (regExp=" + validationRegExp + ") [usuario]");
            }
            throw new P12RequestException("Requested url is not accessible");
        }
    }
}

