/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.utils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import p12f.exe.pasarelapagos.objects.PeriodoPago;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;

public class LimitDateHelper {
    public static boolean compruebaFecha(PeticionPago peticionPago) {
        int tipoValidacion = peticionPago.datosPago.validar;
        if (tipoValidacion == 0) {
            return true;
        }
        if (tipoValidacion == 1 || tipoValidacion == 2) {
            if ("523".equals(peticionPago.datosPago.formato)) {
                return true;
            }
            return LimitDateHelper.realizarComprobacionFecha(peticionPago);
        }
        return false;
    }

    public static boolean realizarComprobacionFecha(PeticionPago peticionPago) {
        if (peticionPago.datosPago.formato.equals("507")) {
            String sufijo = peticionPago.datosPago.emisor.substring(peticionPago.datosPago.emisor.length() - 3);
            int numeroSufijo = Integer.parseInt(sufijo);
            if (numeroSufijo < 500) {
                return true;
            }
            PeriodoPago periodoNormal = peticionPago.datosPago.periodosPago.get("periodoNormal");
            if (periodoNormal == null) {
                return false;
            }
            if (!periodoNormal.validarFechaFin) {
                return true;
            }
            return LimitDateHelper.comprobarFecha(periodoNormal.fechaFin);
        }
        if (peticionPago.datosPago.formato.equals("502")) {
            return true;
        }
        if (peticionPago.datosPago.formato.equals("508")) {
            PeriodoPago periodoNormal = peticionPago.datosPago.periodosPago.get("periodoNormal");
            if (periodoNormal == null) {
                return false;
            }
            if (!periodoNormal.validarFechaFin) {
                return true;
            }
            return LimitDateHelper.comprobarFecha(periodoNormal.fechaFin);
        }
        if (peticionPago.datosPago.formato.equals("521")) {
            return true;
        }
        return peticionPago.datosPago.formato.equals("522");
    }

    public static boolean comprobarFecha(String fecha) {
        if (fecha == null) {
            return true;
        }
        if (!LimitDateHelper.comprobarFechaCorrecta(fecha)) {
            return false;
        }
        Calendar diaActual = Calendar.getInstance();
        String anioActual = new Integer(diaActual.get(1)).toString();
        int sigloActual = Integer.parseInt(anioActual.substring(0, 2));
        Date fechaActual = new Date();
        int dia = Integer.parseInt(fecha.substring(0, 2));
        int mes = Integer.parseInt(fecha.substring(2, 4));
        int anio = Integer.parseInt(sigloActual + fecha.substring(4, 6));
        Calendar diaPago = Calendar.getInstance();
        diaPago.set(5, dia);
        diaPago.set(2, mes - 1);
        diaPago.set(1, anio);
        Date fechaPago = diaPago.getTime();
        return fechaActual.compareTo(fechaPago) <= 0;
    }

    public static boolean comprobarFechaCorrecta(String fecha) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyy");
        if (fecha.trim().length() != dateFormat.toPattern().length()) {
            return false;
        }
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(fecha.trim());
        }
        catch (Exception pe) {
            return false;
        }
        return true;
    }

    public static String convertirFecha523(String fecha) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
        if (fecha.trim().length() != dateFormat.toPattern().length()) {
            return null;
        }
        dateFormat.setLenient(false);
        try {
            Date newDate = dateFormat.parse(fecha.trim());
            dateFormat = new SimpleDateFormat("ddMMyy");
            return dateFormat.format(newDate);
        }
        catch (Exception pe) {
            return null;
        }
    }

    public static boolean comprobarFechaCorrecta523(String fecha) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
        if (fecha.trim().length() != dateFormat.toPattern().length()) {
            return false;
        }
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(fecha.trim());
        }
        catch (Exception pe) {
            return false;
        }
        Date fechaActual = new Date();
        int dia = Integer.parseInt(fecha.substring(0, 2));
        int mes = Integer.parseInt(fecha.substring(2, 4));
        int anio = Integer.parseInt(fecha.substring(4, 8));
        Calendar diaPago = Calendar.getInstance();
        diaPago.set(5, dia);
        diaPago.set(2, mes - 1);
        diaPago.set(1, anio);
        Date fechaPago = diaPago.getTime();
        return fechaActual.compareTo(fechaPago) <= 0;
    }

    public static String formatearFecha(String anio, String fechaJuliana) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy");
        String anioActual = dateFormatter.format(new Date());
        int intDecenioActual = Integer.parseInt(anioActual.substring(2, 3));
        int intAnioActual = Integer.parseInt(anioActual.substring(3, 4));
        int intAnio = Integer.parseInt(anio);
        String anioCompleto = "";
        anioCompleto = intAnioActual == 9 && intAnio == 0 ? "20" + (intDecenioActual + 1) + anio : (intAnioActual == 0 && intAnio == 9 ? "20" + (intDecenioActual - 1) + anio : "20" + intDecenioActual + anio);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, Integer.parseInt(anioCompleto));
        calendar.set(6, Integer.parseInt(fechaJuliana));
        Date fecha = calendar.getTime();
        dateFormatter = new SimpleDateFormat("ddMMyy");
        return dateFormatter.format(fecha);
    }

    public static Date obtenerFechaLimiteDePagoID(String pagoID) {
        return LimitDateHelper.obtenerFechaLimiteDePagoID(pagoID, false);
    }

    public static Date obtenerFechaLimiteDePagoID(String pagoID, boolean byVolunteerPeriod) {
        if (pagoID == null) {
            return null;
        }
        Date fecha = new Date();
        String strFormato = pagoID.substring(2, 5);
        String strYYYY = null;
        Calendar hoy = Calendar.getInstance();
        String yyyyHoy = new Integer(hoy.get(1)).toString();
        int sigloHoy = Integer.parseInt(yyyyHoy.substring(0, 2));
        Calendar calLimite = Calendar.getInstance();
        if (strFormato.equals("507")) {
            String strSufijo = pagoID.substring(13, 16);
            if (Integer.parseInt(strSufijo) < 500) {
                return null;
            }
            String strFecha = pagoID.substring(29, 35);
            calLimite.set(5, Integer.parseInt(strFecha.substring(0, 2)));
            calLimite.set(2, Integer.parseInt(strFecha.substring(2, 4)) - 1);
            calLimite.set(1, Integer.parseInt(sigloHoy + strFecha.substring(4, 6)));
            fecha = calLimite.getTime();
        } else if (strFormato.equals("521")) {
            if ("0".equals(pagoID.substring(23, 24))) {
                return null;
            }
            String strSufijo = pagoID.substring(24, 27);
            String strDevengo = pagoID.substring(27, 29);
            String strFecha = pagoID.substring(29, 33);
            if (strDevengo.equalsIgnoreCase("00") && strFecha.equalsIgnoreCase("0000")) {
                return null;
            }
            int nDevengo = Integer.parseInt(strDevengo);
            int yJuliana = Integer.parseInt(pagoID.substring(29, 30));
            int nDecenio = Integer.parseInt(strDevengo.substring(0, 1)) + (nDevengo % 10 > yJuliana ? 1 : 0);
            strYYYY = String.valueOf(sigloHoy) + String.valueOf(nDecenio) + strFecha.substring(0, 1);
            calLimite.set(1, Integer.parseInt(strYYYY));
            calLimite.set(6, Integer.parseInt(strFecha.substring(1, 4)));
            fecha = calLimite.getTime();
        } else if (strFormato.equals("522")) {
            String strSufijo = pagoID.substring(25, 28);
            String strDevengo = pagoID.substring(28, 30);
            String strFecha = byVolunteerPeriod ? pagoID.substring(30, 34) : pagoID.substring(42, 46);
            int nDevengo = Integer.parseInt(strDevengo);
            if (strFecha.equalsIgnoreCase("0000")) {
                strFecha = pagoID.substring(30, 34);
            }
            if (strDevengo.equalsIgnoreCase("00") && strFecha.equalsIgnoreCase("0000")) {
                return null;
            }
            int yJuliana = Integer.parseInt(strFecha.substring(0, 1));
            int nDecenio = Integer.parseInt(strDevengo.substring(0, 1)) + (nDevengo % 10 > yJuliana ? 1 : 0);
            strYYYY = String.valueOf(sigloHoy) + String.valueOf(nDecenio) + strFecha.substring(0, 1);
            calLimite.set(1, Integer.parseInt(strYYYY));
            calLimite.set(6, Integer.parseInt(strFecha.substring(1, 4)));
            fecha = calLimite.getTime();
        } else {
            if (strFormato.equals("508")) {
                return null;
            }
            return null;
        }
        return fecha;
    }

    public static String obtenerFechaLimiteDePagoIDFormateada(String pagoID, boolean byVolunteerPeriod, String format) {
        Date fecha = LimitDateHelper.obtenerFechaLimiteDePagoID(pagoID, byVolunteerPeriod);
        SimpleDateFormat formatter = new SimpleDateFormat("ddMMyy", Locale.getDefault());
        return formatter.format(fecha);
    }
}

