/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.utils;

import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12f.exe.pasarelapagos.exceptions.ConfigLoadException;
import p12f.exe.pasarelapagos.objects.SignedAuth;
import p12f.exe.pasarelapagos.security.crypto.TripleDESEBCDICCryptoHelper;

public class EncryptUtils {
    private static final Logger log = LoggerFactory.getLogger(EncryptUtils.class);
    public static final String defaultEncType = "base64";

    public static String decryptSignedAuthDocument(String clave1, String clave2, SignedAuth signedAuth, String encType) throws Exception {
        log.warn("[P12MT] ********************************************************");
        log.warn("[P12MT] ******************  D E C R Y P T  *********************");
        log.warn("[P12MT] ********************************************************");
        log.warn("[P12MT] SignHelper._decryptSignedAuthDocument(...," + encType + "): DECRYPT");
        log.warn("[P12MT] ========================================================");
        log.warn("[P12MT] >>>>> Semiclaves de entrada:");
        log.warn("[P12MT]      .Semiclave1: [" + clave1.substring(0, clave1.length() / 2) + "...]");
        log.warn("[P12MT]      .Semiclave2: [" + clave2.substring(0, clave2.length() / 2) + "...]");
        log.warn("[P12MT] Doc.original CIFRADO:" + signedAuth.document);
        log.warn("[P12MT] ********************************************************");
        TripleDESEBCDICCryptoHelper encrypter = new TripleDESEBCDICCryptoHelper();
        String resul = encrypter.decrypt(clave1, clave2, encType, "DESede/CBC/SpacePadding", signedAuth.baseAuthContent.document);
        log.warn("[P12MT] Doc.original DESCIFRADO:" + resul);
        log.warn("[P12MT] ********************************************************");
        return resul;
    }

    public static SignedAuth encryptDocument(SignedAuth signedAuth, String clave1, String clave2, String encType) throws Exception {
        SignedAuth encryptedSignedAuth = SignedAuth.getObject(signedAuth.toXML());
        try {
            if (clave1 == null || clave2 == null) {
                throw new Exception("[P12MT] SignHelper.encryptDocument(...,EF) - No se han definido las claves accountPaymentKey1 y accountPaymentKey2 para la Entidad Financiera");
            }
            encryptedSignedAuth.baseAuthContent.document = EncryptUtils.encryptSignedAuthDocument(clave1, clave2, signedAuth, encType != null ? encType : defaultEncType);
            return encryptedSignedAuth;
        }
        catch (XOMarshallerException e) {
            throw new Exception(e);
        }
        catch (ConfigLoadException e) {
            throw new Exception((Throwable)((Object)e));
        }
    }

    public static String encryptSignedAuthDocument(String clave1, String clave2, SignedAuth signedAuth, String encType) throws Exception {
        log.warn("[P12MT] ********************************************************");
        log.warn("[P12MT] ******************  E N C R Y P T  *********************");
        log.warn("[P12MT] ********************************************************");
        log.warn("[P12MT] SignHelper._encryptSignedAuthDocument(...," + encType + "): ENCRYPT");
        log.warn("[P12MT] ========================================================");
        log.warn("[P12MT] >>>>> Semiclaves de entrada:");
        log.warn("[P12MT]      .Semiclave1: [" + clave1.substring(0, clave1.length() / 2) + "...]");
        log.warn("[P12MT]      .Semiclave2: [" + clave2.substring(0, clave2.length() / 2) + "...]");
        TripleDESEBCDICCryptoHelper encrypter = new TripleDESEBCDICCryptoHelper();
        return encrypter.encrypt(clave1, clave2, encType, "DESede/CBC/SpacePadding", signedAuth.baseAuthContent.document);
    }
}

