/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.utils;

import java.util.StringTokenizer;
import p12f.exe.pasarelapagos.objects.DatosPago;
import p12f.exe.pasarelapagos.objects.PeriodoPago;

public class ControlCodeHelper {
    public static boolean compruebaCC(DatosPago datosPago) {
        int tipoValidacion = datosPago.validar;
        if (tipoValidacion == 0) {
            return true;
        }
        if (tipoValidacion == 1) {
            if ("507".equals(datosPago.formato)) {
                return ControlCodeHelper.validarDC57(datosPago);
            }
            if ("502".equals(datosPago.formato)) {
                return ControlCodeHelper.validarDC60(datosPago);
            }
            if ("508".equals(datosPago.formato)) {
                return ControlCodeHelper.validarDC60(datosPago);
            }
            if ("521".equals(datosPago.formato)) {
                return ControlCodeHelper.validarDC60(datosPago);
            }
            if ("522".equals(datosPago.formato)) {
                return ControlCodeHelper.validarDC60(datosPago);
            }
            if ("523".equals(datosPago.formato)) {
                return ControlCodeHelper.validarDC60_523(datosPago);
            }
        } else if (tipoValidacion == 2 && datosPago.formato.equals("507")) {
            return ControlCodeHelper.validarDC57NoEstandar(datosPago);
        }
        return false;
    }

    public static boolean validarDC57(DatosPago datosPago) {
        String strDigitoControlCalculado;
        String referencia = datosPago.referencia;
        String strDigitoControlActual = referencia.substring(referencia.length() - 2);
        return strDigitoControlActual.equals(strDigitoControlCalculado = ControlCodeHelper.obtenerDCReferencia57(datosPago));
    }

    public static String obtenerDCReferencia57(DatosPago datosPago) {
        int comaIndx;
        long numImporte;
        String emisor = datosPago.emisor;
        long numEntidad = Long.parseLong(emisor.substring(0, emisor.length() - 4));
        long numSufijo = Long.parseLong(emisor.substring(emisor.length() - 3));
        String referencia = datosPago.referencia;
        long numReferencia = Long.parseLong(referencia.substring(0, referencia.length() - 2));
        PeriodoPago periodoNormal = datosPago.periodosPago.get("periodoNormal");
        long numIdentificacion = Long.parseLong(periodoNormal.identificacion);
        long numSuma = numEntidad + numSufijo + numReferencia + numIdentificacion + (numImporte = periodoNormal.importe);
        long resto = numSuma % 97L;
        double numDivision = (double)resto / 97.0;
        String strDecimales = Double.toString(numDivision);
        if (strDecimales.length() == 3) {
            strDecimales = strDecimales + "0";
        }
        if ((comaIndx = strDecimales.indexOf(46)) > 0) {
            strDecimales = strDecimales.substring(comaIndx + 1, comaIndx + 3);
        } else {
            comaIndx = strDecimales.indexOf(44);
            if (comaIndx > 0) {
                strDecimales = strDecimales.substring(comaIndx + 1, comaIndx + 3);
            }
        }
        if (strDecimales.equalsIgnoreCase("00") || strDecimales.equalsIgnoreCase("0")) {
            return "00";
        }
        int digitoControl = 100 - Integer.parseInt(strDecimales);
        String strDigitoControl = new Integer(digitoControl).toString();
        if (new Integer(digitoControl).toString().length() == 1) {
            strDigitoControl = "0" + digitoControl;
        }
        return strDigitoControl;
    }

    public static boolean validarDC60(DatosPago datosPago) {
        String strDCReferenciaCalculado;
        String strDCReferenciaActual;
        String emisor = datosPago.emisor;
        String strDCEmisorActual = emisor.substring(emisor.length() - 1);
        String strDCEmisorCalculado = ControlCodeHelper.obtenerDCEmisor60(emisor);
        String referencia = datosPago.referencia;
        String formato = datosPago.formato;
        if ("522".equals(formato)) {
            strDCReferenciaActual = referencia.substring(referencia.length() - 4);
            strDCReferenciaCalculado = ControlCodeHelper.obtenerDCReferencia60_recargo(datosPago);
        } else {
            strDCReferenciaActual = referencia.substring(referencia.length() - 2);
            strDCReferenciaCalculado = ControlCodeHelper.obtenerDCReferencia60(datosPago);
        }
        if (!strDCEmisorActual.equals(strDCEmisorCalculado)) {
            return false;
        }
        return strDCReferenciaActual.equals(strDCReferenciaCalculado);
    }

    public static boolean validarDC60_523(DatosPago datosPago) {
        String strDCJustificanteCalculado;
        String justificante = datosPago.numeroJustificante;
        String strDCJustificanteActual = justificante.substring(justificante.length() - 1);
        if (!strDCJustificanteActual.equals(strDCJustificanteCalculado = ControlCodeHelper.obtenerDCReferencia60_523(datosPago))) {
            return false;
        }
        return strDCJustificanteActual.equals(strDCJustificanteCalculado);
    }

    public static String obtenerDCEmisor60(String emisor) {
        int dig1 = Integer.parseInt(emisor.substring(0, 1));
        int dig2 = Integer.parseInt(emisor.substring(1, 2));
        int dig3 = Integer.parseInt(emisor.substring(2, 3));
        int dig4 = Integer.parseInt(emisor.substring(3, 4));
        int dig5 = Integer.parseInt(emisor.substring(4, 5));
        int total = (dig1 *= 6) + (dig2 *= 5) + (dig3 *= 4) + (dig4 *= 3) + (dig5 *= 2);
        int digitoControl = total % 11;
        if (digitoControl == 10) {
            digitoControl = 0;
        }
        return new Integer(digitoControl).toString();
    }

    public static String obtenerDCReferencia60(DatosPago datosPago) {
        String decimal;
        StringTokenizer st;
        long numEntidad = Long.parseLong(datosPago.emisor);
        String referencia = datosPago.referencia;
        long numReferencia = Long.parseLong(referencia.substring(0, 10));
        PeriodoPago periodoNormal = datosPago.periodosPago.get("periodoNormal");
        String identificacion = periodoNormal.identificacion;
        long numIdentificacion = Long.parseLong(identificacion);
        long numImporte = periodoNormal.importe;
        long campo1 = numEntidad;
        long campo2 = numReferencia;
        long campo3 = numIdentificacion + numImporte;
        long numSuma = (campo1 *= 76L) + (campo2 *= 9L) + (campo3 = (campo3 - 1L) * 55L);
        long resto = numSuma % 97L;
        double numDivision = (double)resto / 97.0;
        String strDecimales = Double.toString(numDivision);
        int comaIndx = strDecimales.indexOf(46);
        if (comaIndx > 0) {
            st = new StringTokenizer(strDecimales, ".");
            st.nextToken();
            decimal = st.nextToken();
            strDecimales = decimal.length() == 1 ? decimal + "0" : decimal.substring(0, 2);
        } else {
            comaIndx = strDecimales.indexOf(44);
            if (comaIndx > 0) {
                st = new StringTokenizer(strDecimales, ",");
                st.nextToken();
                decimal = st.nextToken();
                strDecimales = decimal.length() == 1 ? decimal + "0" : decimal.substring(0, 2);
            }
        }
        int digitoControl = 99 - Integer.parseInt(strDecimales);
        String strDigitoControl = new Integer(digitoControl).toString();
        if (strDigitoControl.length() == 1) {
            strDigitoControl = "0" + strDigitoControl;
        }
        if (strDigitoControl.equals("00")) {
            strDigitoControl = "99";
        }
        return strDigitoControl;
    }

    public static String obtenerDCReferencia60_recargo(DatosPago datosPago) {
        int digitoControlRec;
        String strDigitoControlRec;
        String decimal;
        StringTokenizer st;
        long numEntidad = Long.parseLong(datosPago.emisor);
        String referencia = datosPago.referencia;
        long numReferencia = Long.parseLong(referencia.substring(0, 10));
        PeriodoPago periodoVoluntario = datosPago.periodosPago.get("periodoVoluntario");
        String identificacionVol = periodoVoluntario.identificacion;
        long numIdentificacionVol = Long.parseLong(identificacionVol);
        long numImporteVol = periodoVoluntario.importe;
        PeriodoPago periodoConRecargo = datosPago.periodosPago.get("periodoConRecargo");
        String identificacionRec = periodoConRecargo.identificacion;
        long numIdentificacionRec = Long.parseLong(identificacionRec);
        long numImporteRec = periodoConRecargo.importe;
        if (numImporteRec == 0L && identificacionRec.endsWith("0000")) {
            numIdentificacionRec = 0L;
        }
        long campo1 = numEntidad;
        long campo2 = numReferencia;
        long campo3Vol = numIdentificacionVol + numImporteVol;
        long campo3Rec = numIdentificacionRec + numImporteRec;
        campo3Vol = (campo3Vol - 1L) * 55L;
        campo3Rec = (campo3Rec - 1L) * 55L;
        long numSumaVol = (campo1 *= 76L) + (campo2 *= 9L) + campo3Vol;
        long numSumaRec = campo1 + campo2 + campo3Rec;
        long restoVol = numSumaVol % 97L;
        long restoRec = numSumaRec % 97L;
        double numDivisionVol = (double)restoVol / 97.0;
        double numDivisionRec = (double)restoRec / 97.0;
        String strDecimalesVol = Double.toString(numDivisionVol);
        String strDecimalesRec = Double.toString(numDivisionRec);
        int comaIndx = strDecimalesVol.indexOf(46);
        if (comaIndx > 0) {
            st = new StringTokenizer(strDecimalesVol, ".");
            st.nextToken();
            decimal = st.nextToken();
            strDecimalesVol = decimal.length() == 1 ? decimal + "0" : decimal.substring(0, 2);
        } else {
            comaIndx = strDecimalesVol.indexOf(44);
            if (comaIndx > 0) {
                st = new StringTokenizer(strDecimalesVol, ",");
                st.nextToken();
                decimal = st.nextToken();
                strDecimalesVol = decimal.length() == 1 ? decimal + "0" : decimal.substring(0, 2);
            }
        }
        comaIndx = strDecimalesRec.indexOf(46);
        if (comaIndx > 0) {
            st = new StringTokenizer(strDecimalesRec, ".");
            st.nextToken();
            decimal = st.nextToken();
            strDecimalesRec = decimal.length() == 1 ? decimal + "0" : decimal.substring(0, 2);
        } else {
            comaIndx = strDecimalesRec.indexOf(44);
            if (comaIndx > 0) {
                st = new StringTokenizer(strDecimalesRec, ",");
                st.nextToken();
                decimal = st.nextToken();
                strDecimalesRec = decimal.length() == 1 ? decimal + "0" : decimal.substring(0, 2);
            }
        }
        int digitoControlVol = 99 - Integer.parseInt(strDecimalesVol);
        String strDigitoControlVol = new Integer(digitoControlVol).toString();
        if (strDigitoControlVol.length() == 1) {
            strDigitoControlVol = "0" + strDigitoControlVol;
        }
        if (strDigitoControlVol.equals("00")) {
            strDigitoControlVol = "99";
        }
        if ((strDigitoControlRec = new Integer(digitoControlRec = 99 - Integer.parseInt(strDecimalesRec)).toString()).length() == 1) {
            strDigitoControlRec = "0" + strDigitoControlRec;
        }
        if (strDigitoControlRec.equals("00")) {
            strDigitoControlRec = "99";
        }
        return strDigitoControlVol + strDigitoControlRec;
    }

    public static String obtenerDCReferencia60_523(DatosPago datosPago) {
        long numEntidad = Long.parseLong(datosPago.emisor);
        String justificante = datosPago.numeroJustificante;
        long numJustificante = Long.parseLong(justificante.substring(0, 12));
        long campo3 = numEntidad + numJustificante;
        long resto = campo3 % 7L;
        String strDigitoControl = new Long(resto).toString();
        return strDigitoControl;
    }

    public static boolean validarDC57NoEstandar(DatosPago datosPago) {
        String strDigitoControlCalculado;
        String referencia = datosPago.referencia;
        String strDigitoControlActual = referencia.substring(referencia.length() - 2);
        return strDigitoControlActual.equals(strDigitoControlCalculado = ControlCodeHelper.obtenerDCReferencia57NoEstandar(datosPago));
    }

    public static String obtenerDCReferencia57NoEstandar(DatosPago datosPago) {
        String referencia;
        long numReferencia;
        long numSufijo;
        String emisor = datosPago.emisor;
        long numEntidad = Long.parseLong(emisor.substring(0, emisor.length() - 4));
        long numSuma = numEntidad + (numSufijo = Long.parseLong(emisor.substring(emisor.length() - 3))) + (numReferencia = Long.parseLong((referencia = datosPago.referencia).substring(0, referencia.length() - 2)));
        long resto = numSuma % 97L;
        double numDivision = (double)resto / 97.0;
        if (numDivision == 0.0) {
            return "00";
        }
        String strDecimales = Double.toString(numDivision);
        int comaIndx = strDecimales.indexOf(46);
        if (comaIndx > 0) {
            strDecimales = strDecimales.substring(comaIndx + 1, comaIndx + 3);
        } else {
            comaIndx = strDecimales.indexOf(44);
            if (comaIndx > 0) {
                strDecimales = strDecimales.substring(comaIndx + 1, comaIndx + 3);
            }
        }
        if (strDecimales.equalsIgnoreCase("00") || strDecimales.equalsIgnoreCase("0")) {
            return "00";
        }
        int digitoControl = 100 - Integer.parseInt(strDecimales);
        String strDigitoControl = new Integer(digitoControl).toString();
        if (new Integer(digitoControl).toString().length() == 1) {
            strDigitoControl = "0" + digitoControl;
        }
        return strDigitoControl;
    }
}

