/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import p12f.exe.pasarelapagos.exceptions.P12RequestException;
import p12f.exe.pasarelapagos.utils.CSBConstants;
import p12f.exe.pasarelapagos.utils.CSBFIELD;
import p12f.exe.pasarelapagos.utils.exceptions.CSBFormatException;

public class CSBHelpper {
    public static Map<String, String> decode(String code) throws CSBFormatException {
        HashMap<String, String> resultado = new HashMap<String, String>();
        String cpr = code.substring(2, 5);
        if (CSBConstants.CSB502.csbCode.toString().equals(cpr)) {
            CSBFIELD[] tramaCompleta502 = CSBConstants.CSB502.tramas.get(CSBConstants.CSB502.csbCode);
            Map<CSBFIELD, String> csbFields = CSBHelpper._decode(tramaCompleta502, code);
            resultado.put("emisor", csbFields.get(CSBConstants.CSB502.EMISOR));
            resultado.put("formato", csbFields.get(CSBConstants.CSB502.FORMATO));
            Map<CSBFIELD, String> csbFieldsAux = CSBHelpper.decode502(csbFields.get(CSBConstants.CSB502.IDENTIFICACION), CSBConstants.CSB502.IDENTIFICACION);
            resultado.put("sufijo_tributo", csbFieldsAux.get(CSBConstants.CSB502.TRIBUTO));
        } else if (CSBConstants.CSB507.csbCode.toString().equals(cpr)) {
            CSBFIELD[] tramaCompleta507 = CSBConstants.CSB507.tramas.get(CSBConstants.CSB507.csbCode);
            Map<CSBFIELD, String> csbFields = CSBHelpper._decode(tramaCompleta507, code);
            resultado.put("emisor", csbFields.get(CSBConstants.CSB507.EMISOR));
            resultado.put("formato", csbFields.get(CSBConstants.CSB507.FORMATO));
            resultado.put("sufijo_tributo", csbFields.get(CSBConstants.CSB507.SUFIJO));
        } else if (CSBConstants.CSB508.csbCode.toString().equals(cpr)) {
            CSBFIELD[] tramaCompleta508 = CSBConstants.CSB508.tramas.get(CSBConstants.CSB508.csbCode);
            Map<CSBFIELD, String> csbFields = CSBHelpper._decode(tramaCompleta508, code);
            resultado.put("emisor", csbFields.get(CSBConstants.CSB508.EMISOR));
            resultado.put("formato", csbFields.get(CSBConstants.CSB508.FORMATO));
            Map<CSBFIELD, String> csbFieldsAux = CSBHelpper.decode508(csbFields.get(CSBConstants.CSB508.IDENTIFICACION), CSBConstants.CSB508.IDENTIFICACION);
            resultado.put("sufijo_tributo", csbFieldsAux.get(CSBConstants.CSB508.TRIBUTO));
        } else if (CSBConstants.CSB521.csbCode.toString().equals(cpr)) {
            CSBFIELD[] tramaCompleta521 = CSBConstants.CSB521.tramas.get(CSBConstants.CSB521.csbCode);
            Map<CSBFIELD, String> csbFields = CSBHelpper._decode(tramaCompleta521, code);
            resultado.put("emisor", csbFields.get(CSBConstants.CSB521.EMISOR));
            resultado.put("formato", csbFields.get(CSBConstants.CSB521.FORMATO));
            Map<CSBFIELD, String> csbFieldsAux = CSBHelpper.decode521(csbFields.get(CSBConstants.CSB521.IDENTIFICACION), CSBConstants.CSB521.IDENTIFICACION);
            resultado.put("sufijo_tributo", csbFieldsAux.get(CSBConstants.CSB521.TRIBUTO));
        } else if (CSBConstants.CSB522.csbCode.toString().equals(cpr)) {
            CSBFIELD[] tramaCompleta522 = CSBConstants.CSB522.tramas.get(CSBConstants.CSB522.csbCode);
            Map<CSBFIELD, String> csbFields = CSBHelpper._decode(tramaCompleta522, code);
            resultado.put("emisor", csbFields.get(CSBConstants.CSB522.EMISOR));
            resultado.put("formato", csbFields.get(CSBConstants.CSB522.FORMATO));
            resultado.put("sufijo_tributo", csbFields.get(CSBConstants.CSB522.TRIBUTO));
        } else if (CSBConstants.CSB523.csbCode.toString().equals(cpr)) {
            CSBFIELD[] tramaCompleta523 = CSBConstants.CSB523.tramas.get(CSBConstants.CSB523.csbCode);
            Map<CSBFIELD, String> csbFields = CSBHelpper._decode523(tramaCompleta523, code);
            resultado.put("emisor", csbFields.get(CSBConstants.CSB523.EMISOR));
            resultado.put("formato", csbFields.get(CSBConstants.CSB523.FORMATO));
            resultado.put("sufijo_tributo", csbFields.get(CSBConstants.CSB523.TRIBUTO));
        } else {
            return null;
        }
        return resultado;
    }

    public static Map<CSBFIELD, String> decode502(String code) throws CSBFormatException {
        CSBFIELD[] tramaCompleta502 = CSBConstants.CSB502.tramas.get(CSBConstants.CSB502.csbCode);
        return CSBHelpper._decode(tramaCompleta502, code);
    }

    public static Map<CSBFIELD, String> decode502(String code, CSBFIELD field) throws CSBFormatException {
        CSBFIELD[] tramaCompleta502 = CSBConstants.CSB502.tramas.get(field.id);
        if (tramaCompleta502 == null) {
            throw new CSBFormatException("El campo " + field.id + " no se puede descomponer porque es un campo simple o porque no se ha defindo una trama para su decodificaci\u00f3n");
        }
        return CSBHelpper._decode(tramaCompleta502, code);
    }

    public static Map<CSBFIELD, String> decode507(String code) throws CSBFormatException {
        CSBFIELD[] tramaCompleta507 = CSBConstants.CSB507.tramas.get(CSBConstants.CSB507.csbCode);
        return CSBHelpper._decode(tramaCompleta507, code);
    }

    public static Map<CSBFIELD, String> decode507(String code, CSBFIELD field) throws CSBFormatException {
        CSBFIELD[] tramaField507 = CSBConstants.CSB507.tramas.get(field.id);
        if (tramaField507 == null) {
            throw new CSBFormatException("El campo " + field.id + " no se puede descomponer porque es un campo simple o porque no se ha defindo una trama para su decodificaci\u00f3n.El CSB507 actuamente no tiene tramas compuestas");
        }
        return CSBHelpper._decode(tramaField507, code);
    }

    public static Map<CSBFIELD, String> decode508(String code) throws CSBFormatException {
        CSBFIELD[] tramaCompleta508 = CSBConstants.CSB508.tramas.get(CSBConstants.CSB508.csbCode);
        return CSBHelpper._decode(tramaCompleta508, code);
    }

    public static Map<CSBFIELD, String> decode508(String code, CSBFIELD field) throws CSBFormatException {
        CSBFIELD[] tramaField508 = CSBConstants.CSB508.tramas.get(field.id);
        if (tramaField508 == null) {
            throw new CSBFormatException("El campo " + field.id + " no se puede descomponer porque es un campo simple o porque no se ha defindo una trama para su decodificaci\u00f3n");
        }
        return CSBHelpper._decode(tramaField508, code);
    }

    public static Map<CSBFIELD, String> decode521(String code) throws CSBFormatException {
        CSBFIELD[] tramaCompleta521 = CSBConstants.CSB521.tramas.get(CSBConstants.CSB521.csbCode);
        return CSBHelpper._decode(tramaCompleta521, code);
    }

    public static Map<CSBFIELD, String> decode521(String code, CSBFIELD field) throws CSBFormatException {
        CSBFIELD[] tramaField521 = CSBConstants.CSB521.tramas.get(field.id);
        if (tramaField521 == null) {
            throw new CSBFormatException("El campo " + field.id + " no se puede descomponer porque es un campo simple o porque no se ha defindo una trama para su decodificaci\u00f3n.");
        }
        return CSBHelpper._decode(tramaField521, code);
    }

    public static Map<CSBFIELD, String> decode522(String code) throws CSBFormatException {
        CSBFIELD[] tramaCompleta522 = CSBConstants.CSB522.tramas.get(CSBConstants.CSB522.csbCode);
        return CSBHelpper._decode(tramaCompleta522, code);
    }

    public static Map<CSBFIELD, String> decode522(String code, CSBFIELD field) throws CSBFormatException {
        CSBFIELD[] tramaField522 = CSBConstants.CSB522.tramas.get(field.id);
        if (tramaField522 == null) {
            throw new CSBFormatException("El campo " + field.id + " no se puede descomponer porque es un campo simple o porque no se ha defindo una trama para su decodificaci\u00f3n");
        }
        return CSBHelpper._decode(tramaField522, code);
    }

    public static Map<CSBFIELD, String> decode523(String code) throws CSBFormatException {
        CSBFIELD[] tramaCompleta523 = CSBConstants.CSB523.tramas.get(CSBConstants.CSB523.csbCode);
        return CSBHelpper._decode523(tramaCompleta523, code);
    }

    public static Map<CSBFIELD, String> decode523(String code, CSBFIELD field) throws CSBFormatException {
        CSBFIELD[] tramaField523 = CSBConstants.CSB523.tramas.get(field.id);
        if (tramaField523 == null) {
            throw new CSBFormatException("El campo " + field.id + " no se puede descomponer porque es un campo simple o porque no se ha defindo una trama para su decodificaci\u00f3n.");
        }
        return CSBHelpper._decode523(tramaField523, code);
    }

    public static String debug(CSBFIELD[] tramaCompleta, String code) throws CSBFormatException {
        String debugText = "\nDEBUG CSB CODE.\n";
        debugText = debugText + "=======================================================\n";
        debugText = debugText + "Code : " + code + "\n";
        List<String> listaRegExp = CSBHelpper._getRegExpList(tramaCompleta);
        String code502Copy = new String(code);
        for (int i = 0; i < listaRegExp.size(); ++i) {
            String regExp = listaRegExp.get(i);
            Pattern p = null;
            p = i < listaRegExp.size() - 1 ? Pattern.compile(regExp + "([(\\d || \\w)]*)") : Pattern.compile(regExp);
            Matcher m = p.matcher(code502Copy);
            debugText = m.matches() ? debugText + "\n" + regExp + " " + tramaCompleta[i].id + ":" + m.group(1) : debugText + "\n" + regExp + " " + tramaCompleta[i].id + ": NOT MATCHES";
            code502Copy = code502Copy.replaceFirst(regExp, "");
        }
        return debugText;
    }

    public static String getDigitoControlCSB507(String emisor, String sufijo, String referencia, String identificacion, String importeCenteuros) {
        try {
            long lngEmisor = Long.parseLong(emisor);
            long lngSufijo = Long.parseLong(sufijo);
            long lngReferencia = Long.parseLong(referencia.substring(0, 11));
            long lngIdentificacion = Long.parseLong(identificacion);
            long lngImporte = Long.parseLong(importeCenteuros);
            long suma = lngEmisor + lngSufijo + lngReferencia + lngIdentificacion + lngImporte;
            long resto = suma % 97L;
            double decimales = (double)resto / 97.0;
            String strDecimales = Double.toString(decimales);
            int comaIndx = strDecimales.indexOf(46);
            if (comaIndx > 0) {
                strDecimales = strDecimales.substring(comaIndx + 1);
            } else {
                comaIndx = strDecimales.indexOf(44);
                if (comaIndx > 0) {
                    strDecimales = strDecimales.substring(comaIndx + 1);
                }
            }
            if (Double.parseDouble(strDecimales) == 0.0) {
                return "00";
            }
            int digitoControl = 100 - Integer.parseInt(strDecimales = strDecimales.length() == 1 ? strDecimales + "0" : strDecimales.substring(0, 2));
            if (digitoControl < 10) {
                return "0" + digitoControl;
            }
            return Integer.toString(digitoControl);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "EX";
        }
    }

    public static void isValidCPR(String cpr) throws P12RequestException {
        if (!(("90" + CSBConstants.CSB507.csbCode.toString()).equals(cpr.substring(0, 5)) || ("90" + CSBConstants.CSB502.csbCode.toString()).equals(cpr.substring(0, 5)) || ("90" + CSBConstants.CSB522.csbCode.toString()).equals(cpr.substring(0, 5)) || ("90" + CSBConstants.CSB521.csbCode.toString()).equals(cpr.substring(0, 5)) || ("90" + CSBConstants.CSB508.csbCode.toString()).equals(cpr.substring(0, 5)) || ("90" + CSBConstants.CSB523.csbCode.toString()).equals(cpr.substring(0, 5)))) {
            throw new P12RequestException("El formato del CPR '" + cpr + "' no es correcto");
        }
    }

    public static void isValidCSB(String oid) throws P12RequestException {
        CSBHelpper.isValidCPR(oid.substring(0, 5));
        String cpr = oid.substring(2, 5);
        try {
            if (CSBConstants.CSB507.csbCode.toString().equals(cpr)) {
                CSBHelpper.decode507(oid);
            } else if (CSBConstants.CSB502.csbCode.toString().equals(cpr)) {
                CSBHelpper.decode502(oid);
            } else if (CSBConstants.CSB522.csbCode.toString().equals(cpr)) {
                CSBHelpper.decode522(oid);
            } else if (CSBConstants.CSB521.csbCode.toString().equals(cpr)) {
                CSBHelpper.decode521(oid);
            } else if (CSBConstants.CSB508.csbCode.toString().equals(cpr)) {
                CSBHelpper.decode508(oid);
            } else if (CSBConstants.CSB523.csbCode.toString().equals(cpr)) {
                CSBHelpper.decode523(oid);
            }
        }
        catch (CSBFormatException e) {
            throw new P12RequestException("El formato del CSB '" + oid + "' no es correcto: " + e.getMessage());
        }
    }

    public static void isValidMultipleCSB(String oids) throws P12RequestException {
        String[] oidsArray;
        for (String oid : oidsArray = oids.split(",")) {
            if ("".equals(oid)) continue;
            CSBHelpper.isValidCSB(oid);
        }
    }

    private static Map<CSBFIELD, String> _decode(CSBFIELD[] trama, String code) throws CSBFormatException {
        HashMap<CSBFIELD, String> map = new HashMap<CSBFIELD, String>();
        String regExp = CSBHelpper._getRegExp(trama);
        Pattern p = Pattern.compile(regExp);
        Matcher m = p.matcher(code);
        if (!m.matches()) {
            throw new CSBFormatException("La trama : " + code + " no sigue el formato correcto : " + regExp + "\n" + CSBHelpper.debug(trama, code));
        }
        CSBFIELD field = null;
        for (int i = 0; i < trama.length; ++i) {
            field = trama[i];
            map.put(field, m.group(i + 1));
        }
        return map;
    }

    private static Map<CSBFIELD, String> _decode523(CSBFIELD[] trama, String code) throws CSBFormatException {
        HashMap<CSBFIELD, String> map = new HashMap<CSBFIELD, String>();
        String regExp = CSBHelpper._getRegExp523(trama);
        Pattern p = Pattern.compile(regExp);
        Matcher m = p.matcher(code);
        if (!m.matches()) {
            throw new CSBFormatException("La trama : " + code + " no sigue el formato correcto : " + regExp + "\n" + CSBHelpper.debug(trama, code));
        }
        CSBFIELD field = null;
        for (int i = 0; i < trama.length; ++i) {
            field = trama[i];
            map.put(field, m.group(i + 1));
        }
        return map;
    }

    private static String _getRegExp(CSBFIELD[] trama) {
        String regExp = new String();
        String grupo = null;
        for (int i = 0; i < trama.length; ++i) {
            CSBFIELD campo = trama[i];
            grupo = "([0-9]{" + campo.length + "})";
            regExp = regExp + grupo;
        }
        return regExp;
    }

    private static String _getRegExp523(CSBFIELD[] trama) {
        String regExp = new String();
        String grupo = null;
        for (int i = 0; i < trama.length; ++i) {
            CSBFIELD campo = trama[i];
            grupo = campo.length == 9 || campo.length == 20 ? "([a-zA-Z0-9]{" + campo.length + "})" : "([0-9]{" + campo.length + "})";
            regExp = regExp + grupo;
        }
        return regExp;
    }

    private static List<String> _getRegExpList(CSBFIELD[] trama) {
        ArrayList<String> regDescompuesto = new ArrayList<String>();
        String grupo = null;
        for (int i = 0; i < trama.length; ++i) {
            CSBFIELD campo = trama[i];
            grupo = "([0-9]{" + campo.length + "})";
            regDescompuesto.add(grupo);
        }
        return regDescompuesto;
    }
}

