/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.utils;

import com.ejie.r01f.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12f.exe.pasarelapagos.objects.AccountData;
import p12f.exe.pasarelapagos.security.crypto.TripleDESEBCDICCryptoHelper;
import p12f.exe.pasarelapagos.utils.CSBHelpper;

public class AccountDataUtil {
    private static final Logger log = LoggerFactory.getLogger(AccountDataUtil.class);

    public static String generateOID(String admin, String type, String reference) {
        SimpleDateFormat sd = new SimpleDateFormat("ddMMyy");
        String identificacion = sd.format(new Date(System.currentTimeMillis()));
        String referenceWith00 = reference + "00";
        String dc = CSBHelpper.getDigitoControlCSB507(admin, type, referenceWith00, identificacion, "0");
        String oid = admin + type + reference + dc + identificacion;
        String formattedString = StringUtils.lPadWithChar((String)oid, (char)'0', (int)19);
        return formattedString;
    }

    public static String getFinantialOrgCode(AccountData nonEncryptedHolderCertData) throws Exception {
        String itemToCert = nonEncryptedHolderCertData.encData.value;
        try {
            if (nonEncryptedHolderCertData.accountNumberFormat.equalsIgnoreCase("cc")) {
                return itemToCert.substring(0, 4);
            }
            if (nonEncryptedHolderCertData.accountNumberFormat.equalsIgnoreCase("iban")) {
                return itemToCert.substring(4, 8);
            }
        }
        catch (Exception ex) {
            throw new Exception("Error en el formato de cuenta :, pe. C\u00f3digo IBAN: ES7620770024003102575766 (formato electr\u00f3nico).\n \n  :" + ex.getLocalizedMessage() + "@ itemToCert=" + itemToCert);
        }
        return null;
    }

    public static String encryptAccountData(String clave1, String clave2, AccountData accountData) throws Exception {
        log.info("[P12F] AccountDataUtil.encryptAccountData ---- CIFRAR");
        log.info("======================================================");
        if (clave1 == null || clave2 == null) {
            throw new Exception("No se han definido las claves accountHolderKey1 y  accountHolderKey2");
        }
        log.info("[P12F] >>>>> Semiclaves de entrada:");
        log.info("[P12F]      .Semiclave1: [" + clave1.substring(0, clave1.length() / 2) + "...]");
        log.info("[P12F]      .Semiclave2: [" + clave2.substring(0, clave2.length() / 2) + "...]");
        String encType = accountData.encData.encType;
        String data = accountData.encData.value;
        data = StringUtils.rPadWithChar((String)data, (char)' ', (int)32);
        log.debug(">>>>>Trama final a encriptar (rellenar a 32 espacios por la derecha para lograr paridad x 8:" + data + "data.length()=" + data.length());
        String claveFinal = new String(Hex.encode((byte[])TripleDESEBCDICCryptoHelper.doXOR(clave1, clave2))).toUpperCase();
        log.info("[P12F] Clave final XOR: [" + claveFinal.substring(0, claveFinal.length() / 2) + "...]");
        TripleDESEBCDICCryptoHelper encrypter = new TripleDESEBCDICCryptoHelper();
        if (encType != null && encType.equalsIgnoreCase("hex")) {
            return encrypter.encryptHEX(claveFinal, data);
        }
        return encrypter.encrypt(claveFinal, data);
    }

    public static String decryptData(String clave1, String clave2, AccountData accountData) throws Exception {
        log.info("[P12F] AccountDataUtil.decryptData ---- DESCIFRAR");
        log.info("======================================================");
        String encType = accountData.encData.encType;
        String data = accountData.encData.value;
        if (clave1 == null || clave2 == null) {
            throw new Exception("No se han definido las claves accountHolderKey1 y  accountHolderKey2");
        }
        log.info("[P12F] >>>>> Semiclaves de entrada:");
        log.info("[P12F]      .Semiclave1: [" + clave1.substring(0, clave1.length() / 2) + "...]");
        log.info("[P12F]      .Semiclave2: [" + clave2.substring(0, clave2.length() / 2) + "...]");
        String claveFinal = new String(Hex.encode((byte[])TripleDESEBCDICCryptoHelper.doXOR(clave1, clave2))).toUpperCase();
        TripleDESEBCDICCryptoHelper encrypter = new TripleDESEBCDICCryptoHelper();
        if (encType != null && encType.equalsIgnoreCase("hex")) {
            return encrypter.decryptHEX(claveFinal, data);
        }
        return encrypter.decrypt(claveFinal, data);
    }
}

