/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.transformer;

import com.ejie.r01f.rpcdispatcher.RPCCall;
import com.ejie.r01f.rpcdispatcher.RPCClient;
import com.ejie.r01f.rpcdispatcher.RPCException;
import com.ejie.r01f.rpcdispatcher.RPCFunction;
import com.ejie.r01f.rpcdispatcher.RPCParameter;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import p12f.exe.pasarelapagos.paymentrequest.PaymentGatewayData;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;
import p12f.exe.pasarelapagos.transformer.ObjectTransformer;
import p12f.exe.pasarelapagos.transformer.ObjectTransformerException;
import p12f.exe.pasarelapagos.v1.objects.ResultadoOperacion;

public class PaymentManagerAPIToV1 {
    private static final Logger log = LoggerFactory.getLogger(PaymentManagerAPIToV1.class);

    public PaymentGatewayData doExecInitializePayment(PaymentGatewayData paymentGatewayData) {
        log.debug(":::::::::::: CLIENT : PaymentManagerAPIToV1.createPayment ::::::::::::");
        ObjectTransformer transformer = new ObjectTransformer();
        RPCCall rpcCall = null;
        try {
            p12f.exe.pasarelapagos.v1.objects.PeticionPago peticionPago = transformer.transformToOldPaymentData(paymentGatewayData);
            rpcCall = this._createNewPeticionPagoRPCCALL(peticionPago);
            this.sendRPCCall(rpcCall);
            PeticionPago peticionPagoInicializada = paymentGatewayData.paymentRequestData.peticionesPago.values().iterator().next();
            peticionPagoInicializada.id = transformer.getNewOIDFormat(peticionPago.protocolo.pagoID);
            paymentGatewayData.paymentRequestData.peticionesPago.put(peticionPagoInicializada.id, peticionPagoInicializada);
            return paymentGatewayData;
        }
        catch (ObjectTransformerException e) {
            e.printStackTrace();
            return null;
        }
        catch (RPCException e) {
            e.printStackTrace();
            return null;
        }
        catch (XOMarshallerException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public RPCCall _createNewPeticionPagoRPCCALL(p12f.exe.pasarelapagos.v1.objects.PeticionPago peticionPago) throws RPCException, XOMarshallerException {
        RPCCall rpcCall = new RPCCall();
        rpcCall.setModule("ia");
        RPCFunction function = new RPCFunction();
        function.setName("newPeticionPago");
        RPCParameter parameterInstancia = new RPCParameter("instanciaPasarela", "String", "1");
        RPCParameter parameterEmisor = new RPCParameter("emisor", "String", peticionPago.emisor.codigo);
        RPCParameter parameterReferencia = new RPCParameter("referencia", "String", peticionPago.referencia);
        RPCParameter parameterIdentificacion = new RPCParameter("identificacion", "String", peticionPago.identificacion);
        RPCParameter parameterImporte = new RPCParameter("importe", "double", "" + peticionPago.importe);
        RPCParameter parameterPeticionPagoXML = new RPCParameter("peticionPagoXML", "XML", peticionPago.toXML());
        function.putParameter(parameterInstancia);
        function.putParameter(parameterEmisor);
        function.putParameter(parameterReferencia);
        function.putParameter(parameterIdentificacion);
        function.putParameter(parameterImporte);
        function.putParameter(parameterPeticionPagoXML);
        rpcCall.addFunction(function);
        return rpcCall;
    }

    public ResultadoOperacion sendRPCCall(RPCCall rpcCall) throws IOException {
        RPCClient rpcClient = null;
        String url = XMLProperties.get((String)"p12ft", (String)"integracionPasarelaV1/urlPasarela");
        String proxyRequired = XMLProperties.getPropertyNode((String)"p12ft", (String)"integracionPasarelaV1/proxy/@required").getNodeValue();
        if (proxyRequired.equalsIgnoreCase("true")) {
            String authorizationRequired;
            String proxyHost = XMLProperties.getProperty((String)"p12ft", (String)"integracionPasarelaV1/proxy/host");
            String proxyPort = XMLProperties.getProperty((String)"p12ft", (String)"integracionPasarelaV1/proxy/port");
            rpcClient = new RPCClient(url, proxyHost, proxyPort);
            if (XMLProperties.getPropertyNode((String)"p12ft", (String)"integracionPasarelaV1/proxy/authorization") != null && (authorizationRequired = XMLProperties.getProperty((String)"p12ft", (String)"integracionPasarelaV1/proxy/authorization/@required")).equalsIgnoreCase("true")) {
                String proxyUsr = XMLProperties.getProperty((String)"p12ft", (String)"integracionPasarelaV1/proxy/authorization/usr");
                String proxyPwd = XMLProperties.getProperty((String)"p12ft", (String)"integracionPasarelaV1/proxy/authorization/pwd");
                rpcClient.setProxyAuthorization(proxyUsr, proxyPwd);
            }
        } else {
            rpcClient = new RPCClient(url);
        }
        InputStream is = rpcClient.sendRPCCall(rpcCall);
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        String returnString = new String();
        String inputLine = new String();
        while ((inputLine = in.readLine()) != null) {
            returnString = returnString + inputLine;
        }
        ResultadoOperacion resultadoOperacion = null;
        try {
            resultadoOperacion = ResultadoOperacion.getObject(returnString);
        }
        catch (XOMarshallerException e) {
            throw new IOException(e.getDetailedMessage());
        }
        return resultadoOperacion;
    }

    public void _returnVale(InputStream is) throws IOException {
    }
}

