/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.transformer;

import com.ejie.r01f.util.MoneyUtils;
import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import p12f.exe.pasarelapagos.objects.Concepto;
import p12f.exe.pasarelapagos.objects.DatosPago;
import p12f.exe.pasarelapagos.objects.Estado;
import p12f.exe.pasarelapagos.objects.Expediente;
import p12f.exe.pasarelapagos.objects.Imagen;
import p12f.exe.pasarelapagos.objects.PaymentStateData;
import p12f.exe.pasarelapagos.objects.PeriodoPago;
import p12f.exe.pasarelapagos.objects.ProtocolData;
import p12f.exe.pasarelapagos.objects.Url;
import p12f.exe.pasarelapagos.objects.config.AdminConfig;
import p12f.exe.pasarelapagos.objects.config.PaymentTypeConfig;
import p12f.exe.pasarelapagos.paymentrequest.Backend;
import p12f.exe.pasarelapagos.paymentrequest.BackendData;
import p12f.exe.pasarelapagos.paymentrequest.ConceptoPeticion;
import p12f.exe.pasarelapagos.paymentrequest.FinantialOrg;
import p12f.exe.pasarelapagos.paymentrequest.Liquidacion;
import p12f.exe.pasarelapagos.paymentrequest.PaymentMode;
import p12f.exe.pasarelapagos.paymentrequest.PaymentRequestData;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;
import p12f.exe.pasarelapagos.paymentrequest.PresentationRequestData;
import p12f.exe.pasarelapagos.transformer.ObjectTransformerException;
import p12f.exe.pasarelapagos.utils.CSBConstants;
import p12f.exe.pasarelapagos.v1.objects.Aplicacion;
import p12f.exe.pasarelapagos.v1.objects.ConceptoPago;
import p12f.exe.pasarelapagos.v1.objects.ConceptoPeticionPago;
import p12f.exe.pasarelapagos.v1.objects.DatoAdicional;
import p12f.exe.pasarelapagos.v1.objects.DatosOperacion;
import p12f.exe.pasarelapagos.v1.objects.Descripcion;
import p12f.exe.pasarelapagos.v1.objects.Emisor;
import p12f.exe.pasarelapagos.v1.objects.EntidadFinanciera;
import p12f.exe.pasarelapagos.v1.objects.EstadoPago;
import p12f.exe.pasarelapagos.v1.objects.InetAddr;
import p12f.exe.pasarelapagos.v1.objects.MedioPago;
import p12f.exe.pasarelapagos.v1.objects.Mensaje;
import p12f.exe.pasarelapagos.v1.objects.Pago;
import p12f.exe.pasarelapagos.v1.objects.Presentacion;
import p12f.exe.pasarelapagos.v1.objects.Protocolo;
import p12f.exe.pasarelapagos.v1.objects.ResultadoPago;
import p12f.exe.pasarelapagos.v1.objects.Tercero;
import p12f.exe.pasarelapagos.v1.objects.config.ConfigEntidad;
import p12f.exe.pasarelapagos.v1.objects.config.ConfigSufijo;

public class ObjectTransformerHelpper {
    public static final String IDIOMA_ES = "es";
    public static final String IDIOMA_EU = "eu";
    public static final String CPR_507 = "90507";
    public static final String OLD_CPR = "9050794";
    public static final String OLD_CSB = "507";
    public static final String BACKEND_SIPCA_ID = "SIPCA";
    public static final String OLD_PAYMENT_DEFAULT_INSTANCE = "1";
    public static final String PERIODOS_PAGO_ID = "ID";
    public static final String PROTOCOLO_URL_VUELTA = "urlVuelta";
    public static final String PROTOCOLO_URL_VALIDACION = "urlValidacion";
    public static final String PROTOCOLO_URL_RESULTADO = "urlResultado";
    static SimpleDateFormat dateFormatter = new SimpleDateFormat("ddMMyy");
    static SimpleDateFormat dateFormatter2 = new SimpleDateFormat("dd/MM/yyyy [HH:mm:ss]");
    public static final String URL_VUELTA = "urlVuelta";
    public static final String IDIOMA = "idioma";

    public static PaymentRequestData getNewPaymentRequestData(p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPeticionPago) throws ObjectTransformerException {
        PaymentRequestData paymentRequestData = new PaymentRequestData();
        paymentRequestData.peticionesPago = new HashMap<String, PeticionPago>();
        PeticionPago newPeticionPago = ObjectTransformerHelpper.getNewPeticionPago(oldPeticionPago);
        paymentRequestData.peticionesPago.put(newPeticionPago.id, newPeticionPago);
        return paymentRequestData;
    }

    public static PeticionPago getNewPeticionPago(p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPeticionPago) throws ObjectTransformerException {
        PeticionPago newPeticionPago = new PeticionPago();
        newPeticionPago.id = ObjectTransformerHelpper.getNewOIDFormat(oldPeticionPago.protocolo.pagoID);
        newPeticionPago.datosPago = ObjectTransformerHelpper._getNewDatosPago(oldPeticionPago);
        newPeticionPago.conceptos = ObjectTransformerHelpper._getNewConceptosPeticionPago(oldPeticionPago.conceptosPeticionPago);
        newPeticionPago.backend = ObjectTransformerHelpper._getBackendDataMapOfPeticionPago(oldPeticionPago);
        newPeticionPago.emisor = ObjectTransformerHelpper._getNewEmisor(oldPeticionPago.emisor);
        newPeticionPago.expediente = ObjectTransformerHelpper._getNewExpediente(oldPeticionPago);
        newPeticionPago.aplicacion = ObjectTransformerHelpper._getNewAplicacion(oldPeticionPago.aplicacion);
        newPeticionPago.aplicacion.datosAdicionales = ObjectTransformerHelpper._setDatosAdicionales(oldPeticionPago);
        newPeticionPago.descripcion = ObjectTransformerHelpper._getNewDescripcion(oldPeticionPago);
        newPeticionPago.imagenes = ObjectTransformerHelpper._getNewImages(oldPeticionPago.imagenes);
        newPeticionPago.mensajes = ObjectTransformerHelpper._getNewMessageMap(oldPeticionPago.mensajes);
        newPeticionPago.finantialOrgs = ObjectTransformerHelpper._getNewFinantialOrgs(oldPeticionPago.presentacion.entidadesFinancieras);
        newPeticionPago.paymentModes = ObjectTransformerHelpper._getNewPaymentModes(oldPeticionPago.presentacion.mediosPago);
        newPeticionPago.datosAdicionales = ObjectTransformerHelpper._getNewDatosAdicionales(oldPeticionPago.datosAdicionales);
        return newPeticionPago;
    }

    private static Map _getNewImages(Map oldImages) {
        HashMap<String, Imagen> newImages = new HashMap<String, Imagen>();
        if (oldImages != null) {
            for (p12f.exe.pasarelapagos.v1.objects.Imagen imagenOld : oldImages.values()) {
                Imagen newImagen = new Imagen();
                newImagen = new Imagen();
                newImagen.id = imagenOld.id;
                if (imagenOld.bin != null) {
                    newImagen.bin = imagenOld.bin.toString();
                }
                newImagen.url = imagenOld.url;
                newImages.put(newImagen.id, newImagen);
            }
        }
        return newImages;
    }

    public static p12f.exe.pasarelapagos.objects.Pago getNewPago(Pago oldPago) throws ObjectTransformerException {
        p12f.exe.pasarelapagos.objects.Pago newPago = new p12f.exe.pasarelapagos.objects.Pago();
        newPago.id = ObjectTransformerHelpper.getNewOIDFormat(oldPago.protocolo.pagoID);
        newPago.datosPago = ObjectTransformerHelpper._getNewDatosPago(oldPago);
        newPago.conceptos = ObjectTransformerHelpper._getNewConceptosPago(oldPago.conceptosPago);
        newPago.emisor = ObjectTransformerHelpper._getNewEmisor(oldPago.emisor);
        newPago.descripcion = ObjectTransformerHelpper._getNewDescripcion(oldPago);
        return newPago;
    }

    public static p12f.exe.pasarelapagos.v1.objects.PeticionPago getOldPeticionPago(PeticionPago newPeticionPago, ProtocolData newProtocolData, PresentationRequestData newPresentationData) throws ObjectTransformerException {
        if (newPeticionPago == null) {
            throw new ObjectTransformerException("Objeto PeticionPago nulo. Repase los datos");
        }
        if (newProtocolData == null) {
            throw new ObjectTransformerException("Objeto ProtocolData nulo. Repase los datos");
        }
        if (newPresentationData == null) {
            throw new ObjectTransformerException("Objeto PresentationRequestData nulo. Repase los datos");
        }
        p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPeticionPago = new p12f.exe.pasarelapagos.v1.objects.PeticionPago();
        oldPeticionPago.referencia = newPeticionPago.datosPago.referencia;
        PeriodoPago newPeriodoPago = newPeticionPago.datosPago.periodosPago.values().iterator().next();
        oldPeticionPago.identificacion = newPeriodoPago.identificacion;
        if (newPeriodoPago.fechaFin != null) {
            oldPeticionPago.fechaLimitePago = newPeriodoPago.fechaFin.substring(0, 2) + "/" + newPeriodoPago.fechaFin.substring(2, 4) + "/20" + newPeriodoPago.fechaFin.substring(4, 6);
        }
        if (newPeticionPago.aplicacion != null) {
            oldPeticionPago.aplicacion = ObjectTransformerHelpper._getOldAplicacion(newPeticionPago.aplicacion);
        }
        if (newPeticionPago.conceptos != null) {
            oldPeticionPago.conceptosPeticionPago = ObjectTransformerHelpper._getOldConceptosPeticionPago(newPeticionPago.conceptos);
        }
        if (newPeticionPago.emisor != null) {
            String codigo = newPeticionPago.datosPago.emisor;
            oldPeticionPago.emisor = ObjectTransformerHelpper._getOldEmisor(newPeticionPago.emisor, codigo);
        }
        if (newPeticionPago.descripcion != null) {
            oldPeticionPago.descripcion = new Descripcion();
            if (newPeticionPago.descripcion.get(IDIOMA_ES) != null) {
                oldPeticionPago.descripcion.castellano = (String)newPeticionPago.descripcion.get(IDIOMA_ES);
            }
            if (newPeticionPago.descripcion.get(IDIOMA_EU) != null) {
                oldPeticionPago.descripcion.euskera = (String)newPeticionPago.descripcion.get(IDIOMA_EU);
            }
        }
        oldPeticionPago.presentacion = ObjectTransformerHelpper._getOldPresentationRequestData(newPresentationData);
        oldPeticionPago.protocolo = ObjectTransformerHelpper._getOldProtocolData(newPeticionPago, newProtocolData);
        oldPeticionPago = ObjectTransformerHelpper._setBackendDataOfPeticionPago(newPeticionPago, oldPeticionPago);
        if (newPeticionPago.expediente != null) {
            oldPeticionPago.tercero = ObjectTransformerHelpper._getOldTercero(newPeticionPago.expediente.tercero);
        }
        if (newPeticionPago.liquidacion != null) {
            oldPeticionPago.liquidacion = ObjectTransformerHelpper._getOldLiquidacionPeticionPago(newPeticionPago.liquidacion);
        }
        oldPeticionPago.mensajes = ObjectTransformerHelpper._getOldMessageMap(newPeticionPago.mensajes);
        oldPeticionPago.importe = ObjectTransformerHelpper.getOldImporte(newPeticionPago);
        oldPeticionPago.imagenes = ObjectTransformerHelpper._getOldImageMap(newPeticionPago.imagenes);
        oldPeticionPago.datosAdicionales = ObjectTransformerHelpper._getOldDatosAdicionales(newPeticionPago.datosAdicionales);
        return oldPeticionPago;
    }

    public static String getNewOIDFormat(String pagoID) {
        String emisorCSB = pagoID.substring(0, 8);
        String sufijoCSB = pagoID.substring(8, 11);
        String referencia = pagoID.substring(11, 24);
        String identificacion = pagoID.substring(24, 30);
        String centeuros = pagoID.substring(30, pagoID.length());
        while (centeuros.length() < 10) {
            centeuros = "0" + centeuros;
        }
        String csbCode = CSBConstants.CSB507.ID_APP.defaultValue + CSBConstants.CSB507.csbCode;
        csbCode = csbCode + emisorCSB + sufijoCSB + referencia + identificacion + centeuros + CSBConstants.CSB507.DIGITO_PARIDAD.defaultValue;
        return csbCode;
    }

    public static String getOldOIDFormat(String pagoID) {
        String emisorCSB = pagoID.substring(5, 13);
        String sufijoCSB = pagoID.substring(13, 16);
        String referencia = pagoID.substring(16, 29);
        String identificacion = pagoID.substring(29, 35);
        String centeuros = pagoID.substring(35, pagoID.length() - 1);
        long centeurosLong = Long.parseLong(centeuros);
        String csbCode = emisorCSB + sufijoCSB + referencia + identificacion + centeurosLong;
        return csbCode;
    }

    public static PaymentTypeConfig getNewPaymentTypeConfig(ConfigSufijo sufijoV1) throws ObjectTransformerException {
        PaymentTypeConfig newPaymentTypeConfig = new PaymentTypeConfig();
        newPaymentTypeConfig.oid = sufijoV1.emisor.cif + sufijoV1.oid + CSBConstants.CSB507.csbCode;
        newPaymentTypeConfig.activa = true;
        newPaymentTypeConfig.emisor = sufijoV1.emisor.codigo.substring(0, 8);
        newPaymentTypeConfig.tributo = sufijoV1.emisor.codigo.substring(9, 12);
        newPaymentTypeConfig.formato = OLD_CSB;
        newPaymentTypeConfig.validar = 1;
        newPaymentTypeConfig.descripcion.put(IDIOMA_ES, sufijoV1.descripcion.castellano);
        newPaymentTypeConfig.descripcion.put(IDIOMA_EU, sufijoV1.descripcion.euskera);
        newPaymentTypeConfig.conceptos = ObjectTransformerHelpper._getNewConceptosPeticionPago(sufijoV1.conceptosPeticionPago);
        newPaymentTypeConfig.imagenes = ObjectTransformerHelpper._getNewImages(sufijoV1.imagenes);
        Imagen imagen = newPaymentTypeConfig.imagenes.get(OLD_PAYMENT_DEFAULT_INSTANCE);
        if (imagen != null) {
            Imagen copiaImagen = new Imagen();
            copiaImagen.alt = imagen.alt;
            copiaImagen.bin = imagen.bin;
            copiaImagen.url = imagen.url;
            copiaImagen.id = "logoEmisor";
            newPaymentTypeConfig.imagenes.put(copiaImagen.id, copiaImagen);
        }
        newPaymentTypeConfig.mensajes = ObjectTransformerHelpper._getNewMessageMap(sufijoV1.mensajes);
        newPaymentTypeConfig.backend = ObjectTransformerHelpper._getBackendDataMapOfSufijo(sufijoV1);
        newPaymentTypeConfig.aplicacion = ObjectTransformerHelpper._getNewAplicacion(sufijoV1.aplicacion);
        newPaymentTypeConfig.finantialOrgs = ObjectTransformerHelpper._getNewFinantialOrgs(sufijoV1.presentacion.entidadesFinancieras);
        newPaymentTypeConfig.paymentModes = ObjectTransformerHelpper._getNewPaymentModes(sufijoV1.presentacion.mediosPago);
        if (sufijoV1.liquidacion != null) {
            newPaymentTypeConfig.liquidacion = ObjectTransformerHelpper._getNewLiquidacionPeticionPago(sufijoV1.liquidacion);
        }
        return newPaymentTypeConfig;
    }

    public static AdminConfig getNewAdminConfig(ConfigEntidad emisorV1, ConfigSufijo sufijoV1) {
        AdminConfig newAdminConfig = new AdminConfig();
        newAdminConfig.oid = emisorV1.oid;
        newAdminConfig.cif = emisorV1.cif;
        newAdminConfig.descripcion.put(IDIOMA_ES, emisorV1.descripcion.castellano);
        newAdminConfig.descripcion.put(IDIOMA_EU, emisorV1.descripcion.euskera);
        newAdminConfig.calle = sufijoV1.emisor.calle;
        newAdminConfig.municipio = sufijoV1.emisor.municipio;
        newAdminConfig.territorio = sufijoV1.emisor.territorio;
        newAdminConfig.codigoPostal = sufijoV1.emisor.codigoPostal;
        return newAdminConfig;
    }

    private static DatosPago _getNewDatosPago(p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPeticionPago) {
        DatosPago newDatosPago = new DatosPago();
        String entidadEmisora = oldPeticionPago.emisor.codigo.substring(0, 8);
        String sufijo = oldPeticionPago.emisor.codigo.substring(oldPeticionPago.emisor.codigo.length() - 3, oldPeticionPago.emisor.codigo.length());
        String referencia = oldPeticionPago.referencia;
        String identificacion = oldPeticionPago.identificacion;
        String importe = Long.toString(MoneyUtils.getCenteuros((double)oldPeticionPago.importe));
        StringUtils.rPadWithChar((String)importe, (char)'0', (int)10);
        newDatosPago.formato = OLD_CSB;
        newDatosPago.validar = 1;
        newDatosPago.cpr = OLD_CPR;
        newDatosPago.codigo = CPR_507 + entidadEmisora + sufijo + referencia + identificacion + importe + '0';
        newDatosPago.emisor = entidadEmisora + "-" + sufijo;
        newDatosPago.tipo = sufijo;
        newDatosPago.referencia = referencia;
        newDatosPago.periodosPago = ObjectTransformerHelpper._getNewPeriodosPago(oldPeticionPago);
        return newDatosPago;
    }

    private static DatosPago _getNewDatosPago(Pago oldPago) {
        DatosPago newDatosPago = new DatosPago();
        String entidadEmisora = oldPago.emisor.cif;
        String sufijo = oldPago.emisor.codigo.substring(oldPago.emisor.codigo.length() - 3, oldPago.emisor.codigo.length());
        String referencia = oldPago.referencia;
        String identificacion = oldPago.identificacion;
        String importe = oldPago.importe;
        while (importe.length() < 10) {
            importe = "0" + importe;
        }
        newDatosPago.formato = OLD_CSB;
        newDatosPago.validar = 1;
        newDatosPago.cpr = OLD_CPR;
        newDatosPago.codigo = CPR_507 + entidadEmisora + sufijo + referencia + identificacion + importe + "0";
        newDatosPago.emisor = entidadEmisora + "-" + sufijo;
        newDatosPago.tipo = sufijo;
        newDatosPago.referencia = referencia;
        newDatosPago.periodosPago = ObjectTransformerHelpper._getNewPeriodosPago(oldPago);
        return newDatosPago;
    }

    private static Map _getNewPeriodosPago(p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPeticionPago) {
        HashMap<String, PeriodoPago> periodosPagoMap = new HashMap<String, PeriodoPago>();
        PeriodoPago periodoPago = new PeriodoPago();
        periodoPago.id = "periodoNormal";
        periodoPago.identificacion = oldPeticionPago.identificacion;
        periodoPago.importe = ObjectTransformerHelpper.getNewImporte(oldPeticionPago);
        String fechaLimite = oldPeticionPago.fechaLimitePago;
        if (fechaLimite != null) {
            String dia = fechaLimite.substring(0, 2);
            String mes = fechaLimite.substring(3, 5);
            String anio = fechaLimite.substring(8, 10);
            periodoPago.fechaFin = dia + mes + anio;
        }
        periodoPago.validarFechaFin = true;
        periodoPago.activo = true;
        periodosPagoMap.put(periodoPago.id, periodoPago);
        return periodosPagoMap;
    }

    private static Map _getNewPeriodosPago(Pago oldPago) {
        HashMap<String, PeriodoPago> periodosPagoMap = new HashMap<String, PeriodoPago>();
        PeriodoPago periodoPago = new PeriodoPago();
        periodoPago.id = "periodoNormal";
        periodoPago.identificacion = oldPago.identificacion;
        periodoPago.importe = new Double(oldPago.importe).longValue();
        String fechaLimite = oldPago.fechaLimitePago;
        String dia = fechaLimite.substring(0, 2);
        String mes = fechaLimite.substring(3, 5);
        String anio = fechaLimite.substring(8, 10);
        periodoPago.fechaFin = dia + mes + anio;
        periodoPago.validarFechaFin = true;
        periodoPago.activo = true;
        periodosPagoMap.put(periodoPago.id, periodoPago);
        return periodosPagoMap;
    }

    private static long _getCenteuros(double cantidad) {
        StringBuffer centeuros = new StringBuffer(new Double(cantidad).toString());
        if (centeuros.indexOf(".") != -1) {
            if (centeuros.length() > centeuros.indexOf(".") + 3) {
                centeuros.delete(centeuros.indexOf(".") + 3, centeuros.length());
            } else {
                while (centeuros.length() < centeuros.indexOf(".") + 3) {
                    centeuros.append("0");
                }
            }
            centeuros.deleteCharAt(centeuros.indexOf("."));
        } else {
            centeuros.append("00");
        }
        return Long.parseLong(centeuros.toString());
    }

    private static List _getNewConceptosPeticionPago(List oldConceptosPeticionPago) throws ObjectTransformerException {
        ArrayList<ConceptoPeticion> newConceptosPeticionPago = new ArrayList<ConceptoPeticion>();
        if (oldConceptosPeticionPago != null) {
            for (int i = 0; i < oldConceptosPeticionPago.size(); ++i) {
                ConceptoPeticionPago oldCPP = (ConceptoPeticionPago)oldConceptosPeticionPago.get(i);
                ConceptoPeticion newCPP = ObjectTransformerHelpper._getNewConceptoPeticionPago(oldCPP);
                if (i + 1 < oldConceptosPeticionPago.size()) {
                    ConceptoPeticionPago oldCPP2 = (ConceptoPeticionPago)oldConceptosPeticionPago.get(i + 1);
                    ConceptoPeticion newCPP2 = ObjectTransformerHelpper._getNewConceptoPeticionPago(oldCPP2);
                    if (newCPP2.IVARepercutido) {
                        newCPP.tieneIVARepercutido = true;
                    } else if (newCPP2.tipoIVA != 0L && newCPP2.importeIVA != 0L) {
                        newCPP.tipoIVA = newCPP2.tipoIVA;
                        newCPP.tipoIVA = newCPP2.importeIVA;
                    }
                }
                newConceptosPeticionPago.add(newCPP);
            }
        }
        return newConceptosPeticionPago;
    }

    private static List _getNewConceptosPago(List oldConceptosPago) throws ObjectTransformerException {
        ArrayList<Concepto> newConceptosPago = new ArrayList<Concepto>();
        if (oldConceptosPago != null) {
            for (int i = 0; i < oldConceptosPago.size(); ++i) {
                ConceptoPago oldCPP = (ConceptoPago)oldConceptosPago.get(i);
                Concepto newCPP = ObjectTransformerHelpper._getNewConceptoPago(oldCPP);
                if (i + 1 < oldConceptosPago.size()) {
                    ConceptoPago oldCPP2 = (ConceptoPago)oldConceptosPago.get(i + 1);
                    Concepto newCPP2 = ObjectTransformerHelpper._getNewConceptoPago(oldCPP2);
                    if (newCPP2.IVARepercutido) {
                        newCPP.tieneIVARepercutido = true;
                    } else if (newCPP2.tipoIVA != 0L && newCPP2.importeIVA != 0L) {
                        newCPP.tipoIVA = newCPP2.tipoIVA;
                        newCPP.tipoIVA = newCPP2.importeIVA;
                    }
                }
                newConceptosPago.add(newCPP);
            }
        }
        return newConceptosPago;
    }

    private static ConceptoPeticion _getNewConceptoPeticionPago(ConceptoPeticionPago oldCPP) throws ObjectTransformerException {
        ConceptoPeticion newCPP = null;
        newCPP = new ConceptoPeticion();
        newCPP.numeroLinea = oldCPP.numeroLinea;
        newCPP.descripcion = new HashMap();
        newCPP.descripcion.put(IDIOMA_ES, oldCPP.castellano);
        newCPP.descripcion.put(IDIOMA_EU, oldCPP.euskera);
        newCPP.importe = ObjectTransformerHelpper._getCenteuros(oldCPP.importe);
        newCPP.baseImponible = ObjectTransformerHelpper._getCenteuros(oldCPP.baseImponible);
        newCPP.tipoIVA = ObjectTransformerHelpper._getCenteuros(oldCPP.tipoIVA);
        newCPP.IVARepercutido = oldCPP.ivaRepercutido;
        newCPP.importeIVA = ObjectTransformerHelpper._getCenteuros(oldCPP.importeIVA);
        newCPP.backendDataMap = ObjectTransformerHelpper._getBackendDataOfConceptoPeticion(oldCPP);
        return newCPP;
    }

    private static Concepto _getNewConceptoPago(ConceptoPago oldCPP) throws ObjectTransformerException {
        ConceptoPeticion newCPP = null;
        newCPP = new ConceptoPeticion();
        newCPP.descripcion = new HashMap();
        newCPP.descripcion.put(IDIOMA_ES, oldCPP.castellano);
        newCPP.descripcion.put(IDIOMA_EU, oldCPP.euskera);
        newCPP.importe = ObjectTransformerHelpper._getCenteuros(Long.parseLong(oldCPP.importe));
        return newCPP;
    }

    private static List _getNewDatosAdicionales(List oldDatosAdicionales) {
        ArrayList<p12f.exe.pasarelapagos.objects.DatoAdicional> newDatosAdicionales = new ArrayList<p12f.exe.pasarelapagos.objects.DatoAdicional>();
        if (oldDatosAdicionales != null) {
            for (DatoAdicional oldDatoAdicional : oldDatosAdicionales) {
                p12f.exe.pasarelapagos.objects.DatoAdicional newDatoAdicional = new p12f.exe.pasarelapagos.objects.DatoAdicional();
                newDatoAdicional.id = oldDatoAdicional.id;
                newDatoAdicional.valor = oldDatoAdicional.valor;
                if (oldDatoAdicional.castellano != null) {
                    newDatoAdicional.texto.put(IDIOMA_ES, oldDatoAdicional.castellano);
                }
                if (oldDatoAdicional.euskera != null) {
                    newDatoAdicional.texto.put(IDIOMA_EU, oldDatoAdicional.euskera);
                }
                newDatosAdicionales.add(newDatoAdicional);
            }
        }
        return newDatosAdicionales;
    }

    private static List _getOldConceptosPeticionPago(List newConceptosPeticionPago) throws ObjectTransformerException {
        ArrayList<ConceptoPeticionPago> oldConceptosPeticionPago = new ArrayList<ConceptoPeticionPago>();
        ConceptoPeticionPago oldCPP = null;
        ConceptoPeticion newCPP2 = null;
        for (ConceptoPeticion newCPP2 : newConceptosPeticionPago) {
            oldCPP = new ConceptoPeticionPago();
            oldCPP.numeroLinea = newCPP2.numeroLinea;
            oldCPP.importe = new Long(newCPP2.importe).doubleValue() / 100.0;
            oldCPP.castellano = (String)newCPP2.descripcion.get(IDIOMA_ES);
            oldCPP.euskera = (String)newCPP2.descripcion.get(IDIOMA_EU);
            oldCPP = ObjectTransformerHelpper._setBackendDataOfConceptoPeticion(newCPP2, oldCPP);
            oldConceptosPeticionPago.add(oldCPP);
        }
        return oldConceptosPeticionPago;
    }

    private static Map _getBackendDataOfConceptoPeticion(ConceptoPeticionPago oldCPP) throws ObjectTransformerException {
        HashMap<String, BackendData> backendDataMap = new HashMap<String, BackendData>();
        String fieldName2 = null;
        String fieldValue = null;
        BackendData bendData = null;
        Field field = null;
        List fields = XMLProperties.getPropertyList((String)"p12ft", (String)"sipca/conceptoPeticionPago/fields/field");
        if (fields == null) {
            throw new ObjectTransformerException("No ha definido los campos Backend SIPCA para ConceptoPeticionPago :getPropertyList(\"p12f\",\"sipca/conceptoPeticionPago/fields/field\") ");
        }
        try {
            for (String fieldName2 : fields) {
                field = oldCPP.getClass().getDeclaredField(fieldName2);
                if (field.get(oldCPP) == null) continue;
                fieldValue = field.get(oldCPP).toString();
                bendData = new BackendData(fieldName2, fieldValue);
                backendDataMap.put(fieldName2, bendData);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackEndDataOfConceptoPeticion.SecurityException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackEndDataOfConceptoPeticion.NoSuchFieldException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackEndDataOfConceptoPeticion.IllegalAccessException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        return backendDataMap;
    }

    private static ConceptoPeticionPago _setBackendDataOfConceptoPeticion(ConceptoPeticion newCPP, ConceptoPeticionPago oldCPP) throws ObjectTransformerException {
        String fieldName2 = null;
        Field fieldOldCPP = null;
        BackendData backendData = null;
        List fields = XMLProperties.getPropertyList((String)"p12ft", (String)"sipca/conceptoPeticionPago/fields/field");
        if (fields == null) {
            throw new ObjectTransformerException("No ha definido los campos Backend SIPCA para ConceptoPeticionPago :getPropertyList(\"p12f\",\"sipca/conceptoPeticionPago/fields/field\") ");
        }
        try {
            for (String fieldName2 : fields) {
                backendData = newCPP.backendDataMap.get(fieldName2);
                fieldOldCPP = oldCPP.getClass().getDeclaredField(fieldName2);
                if (backendData == null) continue;
                if (fieldOldCPP.getType().getClass().getName().equals("java.lang.String")) {
                    fieldOldCPP.set(oldCPP, backendData.value);
                    continue;
                }
                if (fieldOldCPP.getType().getClass().getName().equals("double")) {
                    fieldOldCPP.setDouble(oldCPP, Double.parseDouble(backendData.value));
                    continue;
                }
                if (fieldOldCPP.getType().getClass().getName().equals("int")) {
                    fieldOldCPP.setInt(oldCPP, Integer.parseInt(backendData.value));
                    continue;
                }
                if (!fieldOldCPP.getType().getClass().getName().equals("boolean")) continue;
                fieldOldCPP.setBoolean(oldCPP, Boolean.valueOf(backendData.value));
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackEndDataOfConceptoPeticion.SecurityException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackEndDataOfConceptoPeticion.NoSuchFieldException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackEndDataOfConceptoPeticion.IllegalAccessException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        return oldCPP;
    }

    private static Backend _getBackendDataMapOfPeticionPago(p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPeticionPago) throws ObjectTransformerException {
        Backend backend = new Backend();
        backend.systemID = BACKEND_SIPCA_ID;
        backend.enabled = oldPeticionPago.informarSIPCA;
        String fieldName2 = null;
        String fieldValue = null;
        BackendData bendData = null;
        Field field = null;
        List fields = XMLProperties.getPropertyList((String)"p12ft", (String)"sipca/peticionPago/fields/field");
        if (fields == null) {
            throw new ObjectTransformerException("No ha definido los campos Backend SIPCA para ConceptoPeticionPago :getPropertyList(\"p12f\",\"sipca/PeticionPago/fields/field\") ");
        }
        try {
            for (String fieldName2 : fields) {
                field = oldPeticionPago.getClass().getDeclaredField(fieldName2);
                if (field.get(oldPeticionPago) == null) continue;
                fieldValue = field.get(oldPeticionPago).toString();
                bendData = new BackendData(fieldName2, fieldValue);
                backend.put(bendData);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackendDataMapForNewPeticionPago.SecurityException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackendDataMapForNewPeticionPago.NoSuchFieldException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackendDataMapForNewPeticionPago.IllegalAccessException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        return backend;
    }

    private static Backend _getBackendDataMapOfSufijo(ConfigSufijo oldSufijo) throws ObjectTransformerException {
        Backend backend = new Backend();
        backend.systemID = BACKEND_SIPCA_ID;
        backend.enabled = oldSufijo.informarSIPCA;
        String fieldName2 = null;
        String fieldValue = null;
        BackendData bendData = null;
        Field field = null;
        List fields = XMLProperties.getPropertyList((String)"p12ft", (String)"sipca/peticionPago/fields/field");
        if (fields == null) {
            throw new ObjectTransformerException("No ha definido los campos Backend SIPCA para ConceptoPeticionPago :getPropertyList(\"p12f\",\"sipca/PeticionPago/fields/field\") ");
        }
        try {
            for (String fieldName2 : fields) {
                field = oldSufijo.getClass().getDeclaredField(fieldName2);
                if (field.get(oldSufijo) == null) continue;
                fieldValue = field.get(oldSufijo).toString();
                bendData = new BackendData(fieldName2, fieldValue);
                backend.put(bendData);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackendDataMapForNewPeticionPago.SecurityException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackendDataMapForNewPeticionPago.NoSuchFieldException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackendDataMapForNewPeticionPago.IllegalAccessException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        return backend;
    }

    private static p12f.exe.pasarelapagos.v1.objects.PeticionPago _setBackendDataOfPeticionPago(PeticionPago newPP, p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPP) throws ObjectTransformerException {
        String fieldName2 = null;
        Field fieldOldCPP = null;
        BackendData backendData = null;
        List fields = XMLProperties.getPropertyList((String)"p12ft", (String)"sipca/peticionPago/fields/field");
        if (fields == null) {
            throw new ObjectTransformerException("No ha definido los campos Backend SIPCA para ConceptoPeticionPago :getPropertyList(\"p12f\",\"sipca/conceptoPeticionPago/fields/field\") ");
        }
        try {
            for (String fieldName2 : fields) {
                if (newPP.backend == null) continue;
                backendData = newPP.backend.get(fieldName2);
                fieldOldCPP = oldPP.getClass().getDeclaredField(fieldName2);
                if (backendData == null) continue;
                if (fieldOldCPP.getType().getClass().getName().equals("java.lang.String") || fieldOldCPP.getType().getName().equals("java.lang.String")) {
                    fieldOldCPP.set(oldPP, backendData.value);
                    continue;
                }
                if (fieldOldCPP.getType().getClass().getName().equals("double") || fieldOldCPP.getType().getName().equals("double")) {
                    fieldOldCPP.setDouble(oldPP, Double.parseDouble(backendData.value));
                    continue;
                }
                if (fieldOldCPP.getType().getClass().getName().equals("int") || fieldOldCPP.getType().getName().equals("int")) {
                    fieldOldCPP.setInt(oldPP, Integer.parseInt(backendData.value));
                    continue;
                }
                if (!fieldOldCPP.getType().getClass().getName().equals("boolean") && !fieldOldCPP.getType().getName().equals("boolean")) continue;
                fieldOldCPP.setBoolean(oldPP, Boolean.valueOf(backendData.value));
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackEndDataOfConceptoPeticion.SecurityException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackEndDataOfConceptoPeticion.NoSuchFieldException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new ObjectTransformerException("getBackEndDataOfConceptoPeticion.IllegalAccessException::No se pueden obtener el BackEndDataMap para los Conceptos de Peticion de Pago.Revisa la configuracion de los campos");
        }
        return oldPP;
    }

    private static Liquidacion _getNewLiquidacionPeticionPago(p12f.exe.pasarelapagos.v1.objects.Liquidacion oldLiquidacion) {
        Liquidacion liqui = new Liquidacion();
        liqui.paymentGatewayVersion = OLD_PAYMENT_DEFAULT_INSTANCE;
        if (oldLiquidacion.plantillasLiquidacion != null && oldLiquidacion.plantillasLiquidacion.get("pdf") != null) {
            String plantilla = ((InetAddr)oldLiquidacion.plantillasLiquidacion.get((Object)"pdf")).urlCastellano;
            String cadena1 = plantilla.substring(0, plantilla.indexOf("/aplic/p72/html"));
            String cadena2 = "/datos/p12i/file";
            String cadena3 = plantilla.substring(plantilla.indexOf("/xml/"));
            liqui.urlPlantilla = cadena1 + cadena2 + cadena3;
        }
        liqui.imagenes = ObjectTransformerHelpper._getNewImages(oldLiquidacion.imagenes);
        return liqui;
    }

    private static p12f.exe.pasarelapagos.v1.objects.Liquidacion _getOldLiquidacionPeticionPago(Liquidacion newLiquidacion) {
        p12f.exe.pasarelapagos.v1.objects.Liquidacion liqui = new p12f.exe.pasarelapagos.v1.objects.Liquidacion();
        liqui.imagenes = ObjectTransformerHelpper._getOldImageMap(newLiquidacion.imagenes);
        return liqui;
    }

    private static p12f.exe.pasarelapagos.objects.Emisor _getNewEmisor(Emisor oldEmisor) {
        p12f.exe.pasarelapagos.objects.Emisor emisor = new p12f.exe.pasarelapagos.objects.Emisor();
        emisor.calle = oldEmisor.calle;
        emisor.cif = oldEmisor.cif;
        emisor.codigoPostal = oldEmisor.codigoPostal;
        emisor.municipio = oldEmisor.municipio;
        emisor.nombre = new HashMap<String, String>();
        emisor.nombre.put(IDIOMA_ES, oldEmisor.nombreCastellano);
        emisor.nombre.put(IDIOMA_EU, oldEmisor.nombreEuskera);
        emisor.territorio = oldEmisor.territorio;
        return emisor;
    }

    private static Emisor _getOldEmisor(p12f.exe.pasarelapagos.objects.Emisor newEmisor, String codigo) {
        StringTokenizer st = new StringTokenizer(codigo);
        String cif = st.nextToken("-");
        Emisor emisor = new Emisor();
        emisor.calle = newEmisor.calle;
        emisor.cif = cif;
        emisor.codigo = codigo;
        emisor.codigoPostal = newEmisor.codigoPostal;
        emisor.municipio = newEmisor.municipio;
        emisor.nombreCastellano = newEmisor.nombre.get(IDIOMA_ES);
        emisor.nombreEuskera = newEmisor.nombre.get(IDIOMA_EU);
        emisor.territorio = newEmisor.territorio;
        return emisor;
    }

    private static Expediente _getNewExpediente(p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPeticionPago) {
        Expediente expediente = new Expediente();
        expediente.codigo = oldPeticionPago.expedienteAsociado;
        expediente.descripcion = new HashMap<String, String>();
        if (oldPeticionPago.tercero != null) {
            expediente.tercero = new p12f.exe.pasarelapagos.objects.Tercero();
            expediente.tercero.calle = oldPeticionPago.tercero.domicilio;
            expediente.tercero.codigoPostal = oldPeticionPago.tercero.codigoPostal;
            expediente.tercero.dniNif = oldPeticionPago.tercero.dniNif;
            expediente.tercero.municipio = oldPeticionPago.tercero.municipio;
            expediente.tercero.pais = oldPeticionPago.tercero.pais;
            expediente.tercero.territorio = oldPeticionPago.tercero.provincia;
            expediente.tercero.razonSocial = oldPeticionPago.tercero.razonSocial;
            expediente.tercero.datosAdicionales = ObjectTransformerHelpper._getNewDatosAdicionales(oldPeticionPago.tercero.datosAdicionales);
        }
        return expediente;
    }

    private static Tercero _getOldTercero(p12f.exe.pasarelapagos.objects.Tercero newTercero) {
        Tercero oldTercero = new Tercero();
        oldTercero.codigoPostal = newTercero.codigoPostal;
        oldTercero.razonSocial = newTercero.razonSocial;
        oldTercero.dniNif = newTercero.dniNif;
        oldTercero.domicilio = newTercero.calle;
        oldTercero.localidad = newTercero.municipio;
        oldTercero.municipio = newTercero.municipio;
        oldTercero.pais = newTercero.pais;
        oldTercero.provincia = newTercero.territorio;
        oldTercero.datosAdicionales = ObjectTransformerHelpper._getOldDatosAdicionales(newTercero.datosAdicionales);
        return oldTercero;
    }

    private static p12f.exe.pasarelapagos.paymentrequest.Aplicacion _getNewAplicacion(Aplicacion oldPeticionPagoAPP) {
        p12f.exe.pasarelapagos.paymentrequest.Aplicacion aplicacion = new p12f.exe.pasarelapagos.paymentrequest.Aplicacion();
        if (oldPeticionPagoAPP != null) {
            aplicacion.nombre = new HashMap<String, String>();
            aplicacion.nombre.put(IDIOMA_ES, oldPeticionPagoAPP.castellano);
            aplicacion.nombre.put(IDIOMA_EU, oldPeticionPagoAPP.euskera);
            aplicacion.codigo = oldPeticionPagoAPP.codigo.toLowerCase();
            if (aplicacion.codigo.equals("p72")) {
                aplicacion.codigo = "p12";
            }
            aplicacion.responsable = oldPeticionPagoAPP.responsable;
        }
        aplicacion.eventListenerConfig.eventListenerMethodBitMap = "0000000000";
        aplicacion.eventListenerConfig.eventListenerClass = "p12gt.exe.pasarelapagos.events.DefaultEventListenerImpl";
        aplicacion.eventListenerConfig.properties = new HashMap<String, String>();
        if (oldPeticionPagoAPP != null && oldPeticionPagoAPP.urlVueltaResultadoPago != null) {
            aplicacion.eventListenerConfig.properties.put("urlClient", oldPeticionPagoAPP.urlVueltaResultadoPago);
        }
        aplicacion.eventListenerConfig.properties.put("paymentGatewayVersion", OLD_PAYMENT_DEFAULT_INSTANCE);
        return aplicacion;
    }

    private static Map _setDatosAdicionales(p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPeticionPago) throws ObjectTransformerException {
        p12f.exe.pasarelapagos.objects.DatoAdicional datoAdicional;
        HashMap<String, p12f.exe.pasarelapagos.objects.DatoAdicional> datosAdicionales = new HashMap<String, p12f.exe.pasarelapagos.objects.DatoAdicional>();
        if (oldPeticionPago.protocolo.urlVuelta != null) {
            datoAdicional = new p12f.exe.pasarelapagos.objects.DatoAdicional();
            datoAdicional.id = "urlVuelta";
            datoAdicional.valor = oldPeticionPago.protocolo.urlVuelta;
            datosAdicionales.put(datoAdicional.id, datoAdicional);
        }
        if (oldPeticionPago.presentacion.idioma != null) {
            datoAdicional = new p12f.exe.pasarelapagos.objects.DatoAdicional();
            datoAdicional.id = IDIOMA;
            datoAdicional.valor = oldPeticionPago.presentacion.idioma;
            datosAdicionales.put(datoAdicional.id, datoAdicional);
        }
        return datosAdicionales;
    }

    private static Aplicacion _getOldAplicacion(p12f.exe.pasarelapagos.paymentrequest.Aplicacion newPeticionPagoAPP) {
        Aplicacion aplicacion = new Aplicacion();
        if (newPeticionPagoAPP.nombre != null) {
            aplicacion.castellano = newPeticionPagoAPP.nombre.get(IDIOMA_ES);
            aplicacion.euskera = newPeticionPagoAPP.nombre.get(IDIOMA_EU);
        }
        if (newPeticionPagoAPP.codigo != null) {
            aplicacion.codigo = newPeticionPagoAPP.codigo.toLowerCase();
        }
        if (newPeticionPagoAPP.responsable != null) {
            aplicacion.responsable = newPeticionPagoAPP.responsable;
        }
        if (newPeticionPagoAPP.eventListenerConfig != null && newPeticionPagoAPP.eventListenerConfig.properties != null && newPeticionPagoAPP.eventListenerConfig.properties.get("url") != null) {
            aplicacion.urlVueltaResultadoPago = newPeticionPagoAPP.eventListenerConfig.properties.get("urlClient");
        }
        return aplicacion;
    }

    public static ProtocolData getNewProtocolData(p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPeticionPago) {
        Protocolo oldProtocolo = oldPeticionPago.protocolo;
        ProtocolData protocolData = new ProtocolData();
        protocolData.token = oldProtocolo.token;
        protocolData.responseURL = null;
        protocolData.sourceSessionId = oldProtocolo.sessionID;
        protocolData.destinationSessionId = oldProtocolo.sessionID;
        try {
            if (oldProtocolo.timeStamp != null) {
                int anio;
                int mes;
                int dia;
                Calendar fecha = Calendar.getInstance();
                StringTokenizer st = new StringTokenizer(oldProtocolo.timeStamp.trim(), "/[:");
                int numTokens = st.countTokens();
                if (numTokens >= 3 && numTokens <= 4) {
                    dia = Integer.parseInt(st.nextToken());
                    mes = Integer.parseInt(st.nextToken());
                    anio = Integer.parseInt(st.nextToken());
                    fecha.set(anio, mes, dia);
                }
                if (numTokens >= 6) {
                    int segundo;
                    dia = Integer.parseInt(st.nextToken().trim());
                    mes = Integer.parseInt(st.nextToken().trim());
                    anio = Integer.parseInt(st.nextToken().trim());
                    int hora = Integer.parseInt(st.nextToken().trim());
                    int minuto = Integer.parseInt(st.nextToken().trim());
                    String segundos = st.nextToken().trim();
                    if (segundos.indexOf(".") > 0) {
                        StringTokenizer stSeconds = new StringTokenizer(segundos, ".");
                        segundo = Integer.parseInt(stSeconds.nextToken().trim());
                    } else {
                        String secPa = segundos.substring(0, 2);
                        segundo = Integer.parseInt(secPa);
                    }
                    fecha.set(anio, mes - 1, dia, hora, minuto, segundo);
                }
                protocolData.timeStamp = fecha.getTimeInMillis();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        protocolData.sourceOperationNumber = oldProtocolo.numeroOperacion;
        protocolData.urls = new HashMap<String, Url>();
        Url urlVuelta = new Url();
        urlVuelta.url = oldProtocolo.urlVuelta;
        urlVuelta.id = "urlVuelta";
        protocolData.urls.put("urlVuelta", urlVuelta);
        Url urlResultado = new Url();
        urlResultado.url = oldProtocolo.urlResultado;
        urlResultado.id = PROTOCOLO_URL_RESULTADO;
        protocolData.urls.put(PROTOCOLO_URL_RESULTADO, urlResultado);
        Url urlValidacion = new Url();
        urlValidacion.url = oldProtocolo.urlValidacion;
        urlValidacion.id = PROTOCOLO_URL_VALIDACION;
        protocolData.urls.put(PROTOCOLO_URL_VALIDACION, urlValidacion);
        return protocolData;
    }

    private static Protocolo _getOldProtocolData(PeticionPago newPeticionPago, ProtocolData newProtocolData) {
        Protocolo protocolData = new Protocolo();
        PeriodoPago newPeriodoPago = newPeticionPago.datosPago.periodosPago.values().iterator().next();
        protocolData.pagoID = p12f.exe.pasarelapagos.v1.objects.PeticionPago.getPagoOID(newPeticionPago.datosPago.emisor, newPeticionPago.datosPago.referencia, newPeriodoPago.identificacion, ObjectTransformerHelpper.getOldImporte(newPeticionPago));
        protocolData.token = newProtocolData.token;
        protocolData.sessionID = newProtocolData.sourceSessionId;
        Date fecha = new Date();
        fecha.setTime(newProtocolData.timeStamp);
        protocolData.timeStamp = dateFormatter2.format(fecha);
        protocolData.numeroOperacion = "0001";
        if (newProtocolData.urls.get("urlVuelta") != null) {
            Url urlVuelta = newProtocolData.urls.get("urlVuelta");
            protocolData.urlVuelta = urlVuelta.url;
        }
        protocolData.urlValidacion = XMLProperties.get((String)"p12ft", (String)"urls/urlValidacion");
        protocolData.urlResultado = XMLProperties.get((String)"p12ft", (String)"urls/urlResultado");
        return protocolData;
    }

    private static Map _getNewFinantialOrgs(List oldEntidadesFinancieras) {
        HashMap<String, FinantialOrg> finantialOrgs = new HashMap<String, FinantialOrg>();
        if (oldEntidadesFinancieras != null) {
            for (EntidadFinanciera entidadFinancieraOld : oldEntidadesFinancieras) {
                if (entidadFinancieraOld.id == null) continue;
                FinantialOrg financialOrg = new FinantialOrg();
                financialOrg.oid = entidadFinancieraOld.id;
                financialOrg.text = entidadFinancieraOld.descripcion;
                financialOrg.def = entidadFinancieraOld.def;
                finantialOrgs.put(financialOrg.oid, financialOrg);
            }
        }
        return finantialOrgs;
    }

    private static Map _getNewPaymentModes(List oldPaymentModes) {
        HashMap<String, PaymentMode> paymentModes = new HashMap<String, PaymentMode>();
        if (oldPaymentModes != null) {
            for (MedioPago oldMedioPago : oldPaymentModes) {
                if (oldMedioPago.id == null) continue;
                PaymentMode newMedioPago = new PaymentMode();
                newMedioPago.oid = oldMedioPago.id;
                paymentModes.put(newMedioPago.oid, newMedioPago);
            }
        }
        return paymentModes;
    }

    public static PresentationRequestData getNewPresentationRequestData(p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPeticionPago) {
        PresentationRequestData newPresentationData = new PresentationRequestData();
        Presentacion oldPresentationData = oldPeticionPago.presentacion;
        newPresentationData.idioma = oldPresentationData.idioma;
        newPresentationData.imagenes = new HashMap<String, Imagen>();
        if (oldPresentationData.imagenes != null) {
            for (p12f.exe.pasarelapagos.v1.objects.Imagen imagenOld : oldPresentationData.imagenes.values()) {
                Imagen newImagen = new Imagen();
                newImagen = new Imagen();
                newImagen.id = imagenOld.id;
                if (imagenOld.bin != null) {
                    newImagen.bin = imagenOld.bin.toString();
                }
                newImagen.url = imagenOld.url;
                newPresentationData.imagenes.put(newImagen.id, newImagen);
            }
        }
        newPresentationData.mensajes = new HashMap<String, p12f.exe.pasarelapagos.objects.Mensaje>();
        if (oldPeticionPago.mensajes != null) {
            for (Mensaje oldMensaje : oldPeticionPago.mensajes.values()) {
                p12f.exe.pasarelapagos.objects.Mensaje newMensaje = new p12f.exe.pasarelapagos.objects.Mensaje();
                newMensaje.texto = new HashMap<String, String>();
                newMensaje.texto.put(IDIOMA_ES, oldMensaje.castellano);
                newMensaje.texto.put(IDIOMA_EU, oldMensaje.euskera);
                newMensaje.id = oldMensaje.id;
                newPresentationData.mensajes.put(newMensaje.id, newMensaje);
            }
        }
        return newPresentationData;
    }

    private static Presentacion _getOldPresentationRequestData(PresentationRequestData newPresentationData) {
        Presentacion oldPresentationData = new Presentacion();
        oldPresentationData.idioma = newPresentationData.idioma;
        oldPresentationData.instance = OLD_PAYMENT_DEFAULT_INSTANCE;
        newPresentationData.idioma = oldPresentationData.idioma;
        oldPresentationData.imagenes = new HashMap();
        if (newPresentationData.imagenes != null) {
            for (Imagen newImagen : newPresentationData.imagenes.values()) {
                p12f.exe.pasarelapagos.v1.objects.Imagen oldImagen = new p12f.exe.pasarelapagos.v1.objects.Imagen();
                oldImagen.id = newImagen.id;
                if (newImagen.bin != null) {
                    oldImagen.bin = newImagen.bin.getBytes();
                }
                oldImagen.url = newImagen.url;
                oldPresentationData.imagenes.put(oldImagen.id, oldImagen);
            }
        }
        oldPresentationData.entidadesFinancieras = new ArrayList();
        if (newPresentationData.finantialOrgs != null) {
            for (FinantialOrg financialOrg : newPresentationData.finantialOrgs.values()) {
                EntidadFinanciera entidadFinancieraOld = new EntidadFinanciera();
                entidadFinancieraOld.id = financialOrg.oid;
                entidadFinancieraOld.descripcion = financialOrg.text;
                entidadFinancieraOld.def = financialOrg.def;
                oldPresentationData.entidadesFinancieras.add(entidadFinancieraOld);
            }
        }
        oldPresentationData.mediosPago = new ArrayList();
        if (newPresentationData.paymentModes != null && newPresentationData.paymentModes.size() > 0) {
            for (PaymentMode newMedioPago : newPresentationData.paymentModes.values()) {
                MedioPago oldMedioPago = new MedioPago();
                oldMedioPago.id = newMedioPago.oid;
                oldPresentationData.mediosPago.add(oldMedioPago);
            }
        } else {
            MedioPago oldMedioPago = new MedioPago();
            oldMedioPago.id = "02";
            oldPresentationData.mediosPago.add(oldMedioPago);
        }
        return oldPresentationData;
    }

    private static Map _getOldMessageMap(Map newMessageMap) {
        HashMap<String, Mensaje> oldMensajes = new HashMap<String, Mensaje>();
        if (newMessageMap != null) {
            for (p12f.exe.pasarelapagos.objects.Mensaje newMensaje : newMessageMap.values()) {
                Mensaje oldMessage = new Mensaje();
                oldMessage.id = newMensaje.id;
                oldMessage.castellano = newMensaje.texto.get(IDIOMA_ES);
                oldMessage.euskera = newMensaje.texto.get(IDIOMA_EU);
                oldMensajes.put(oldMessage.id, oldMessage);
            }
        }
        return oldMensajes;
    }

    private static Map _getOldImageMap(Map newImageMap) {
        HashMap<String, p12f.exe.pasarelapagos.v1.objects.Imagen> oldImagenes = new HashMap<String, p12f.exe.pasarelapagos.v1.objects.Imagen>();
        if (newImageMap != null) {
            for (Imagen newImagen : newImageMap.values()) {
                p12f.exe.pasarelapagos.v1.objects.Imagen oldImagen = new p12f.exe.pasarelapagos.v1.objects.Imagen();
                oldImagen.id = newImagen.id;
                oldImagen.url = newImagen.url;
                oldImagenes.put(oldImagen.id, oldImagen);
            }
        }
        return oldImagenes;
    }

    private static double getOldImporte(PeticionPago peticionPago) {
        PeriodoPago periodoPago = peticionPago.datosPago.periodosPago.values().iterator().next();
        return new Long(periodoPago.importe).doubleValue() / 100.0;
    }

    private static long getNewImporte(p12f.exe.pasarelapagos.v1.objects.PeticionPago peticionPago) {
        double dblCantidad = peticionPago.importe;
        return MoneyUtils.getCenteuros((double)dblCantidad);
    }

    private static Map _getNewDescripcion(Pago oldPago) {
        HashMap<String, String> descripcion = new HashMap<String, String>();
        if (oldPago.descripcion.castellano != null) {
            descripcion.put(IDIOMA_ES, oldPago.descripcion.castellano);
        }
        if (oldPago.descripcion.euskera != null) {
            descripcion.put(IDIOMA_EU, oldPago.descripcion.euskera);
        }
        return descripcion;
    }

    private static Map _getNewDescripcion(p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPago) {
        HashMap<String, String> descripcion = new HashMap<String, String>();
        if (oldPago.descripcion.castellano != null) {
            descripcion.put(IDIOMA_ES, oldPago.descripcion.castellano);
        }
        if (oldPago.descripcion.euskera != null) {
            descripcion.put(IDIOMA_EU, oldPago.descripcion.euskera);
        }
        return descripcion;
    }

    public static Estado getNewEstado(ResultadoPago resultadoPago) {
        Estado estado = new Estado();
        try {
            estado.codigo = resultadoPago.resultado ? "04" : "05";
            String fecha = resultadoPago.datosOperacion.fecha;
            estado.fechaPago = ObjectTransformerHelpper._formateOldDate(fecha);
            String hora = resultadoPago.datosOperacion.hora;
            estado.horaPago = ObjectTransformerHelpper._formateOldHour(hora);
            estado.entidad = resultadoPago.datosOperacion.entidadFinanciera.id;
            String importe = resultadoPago.datosOperacion.importe;
            while (importe.length() < 10) {
                importe = "0" + importe;
            }
            estado.importe = importe;
            estado.mensajes = ObjectTransformerHelpper._getNewMessageMap(resultadoPago.mensajes);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return estado;
    }

    private static Map _getNewMessageMap(List oldMessageList) {
        HashMap<String, p12f.exe.pasarelapagos.objects.Mensaje> newMensajes = new HashMap<String, p12f.exe.pasarelapagos.objects.Mensaje>();
        if (oldMessageList != null) {
            int i = 0;
            for (Mensaje oldMessage : oldMessageList) {
                p12f.exe.pasarelapagos.objects.Mensaje newMessage = new p12f.exe.pasarelapagos.objects.Mensaje();
                newMessage.id = new Integer(i).toString();
                newMessage.texto.put(IDIOMA_ES, oldMessage.castellano);
                newMessage.texto.put(IDIOMA_EU, oldMessage.euskera);
                newMensajes.put(newMessage.id, newMessage);
            }
        }
        return newMensajes;
    }

    private static Map _getNewMessageMap(Map oldMessageList) {
        HashMap<String, p12f.exe.pasarelapagos.objects.Mensaje> newMensajes = new HashMap<String, p12f.exe.pasarelapagos.objects.Mensaje>();
        if (oldMessageList != null) {
            Iterator it = oldMessageList.keySet().iterator();
            while (it.hasNext()) {
                Mensaje oldMessage = (Mensaje)oldMessageList.get(it.next());
                p12f.exe.pasarelapagos.objects.Mensaje newMessage = new p12f.exe.pasarelapagos.objects.Mensaje();
                newMessage.id = oldMessage.id;
                newMessage.texto.put(IDIOMA_ES, oldMessage.castellano);
                newMessage.texto.put(IDIOMA_EU, oldMessage.euskera);
                newMensajes.put(newMessage.id, newMessage);
            }
        }
        return newMensajes;
    }

    public static ResultadoPago getOldResultadoPago(PaymentStateData paymentStateData) {
        ResultadoPago resultadoPago = new ResultadoPago();
        resultadoPago.resultado = true;
        resultadoPago.datosOperacion = new DatosOperacion();
        if (paymentStateData.estado.codigo.equals("04")) {
            resultadoPago.datosOperacion.fecha = ObjectTransformerHelpper._formatearFecha(paymentStateData.estado.fechaPago);
            resultadoPago.datosOperacion.hora = ObjectTransformerHelpper._formatearHora(paymentStateData.estado.horaPago);
            EntidadFinanciera entidadFinanciera = new EntidadFinanciera();
            entidadFinanciera.id = paymentStateData.estado.entidad;
            entidadFinanciera.descripcion = "Entidad " + paymentStateData.estado.entidad;
            resultadoPago.datosOperacion.entidadFinanciera = entidadFinanciera;
            resultadoPago.datosOperacion.numeroOperacion = paymentStateData.estado.numeroOperacion;
        }
        resultadoPago.datosOperacion.codigoEmisor = paymentStateData.datosPago.emisor;
        resultadoPago.datosOperacion.referencia = paymentStateData.datosPago.referencia;
        PeriodoPago periodoNormal = paymentStateData.datosPago.periodosPago.get("periodoNormal");
        resultadoPago.datosOperacion.identificacion = periodoNormal.identificacion;
        resultadoPago.datosOperacion.importe = Long.toString(periodoNormal.importe);
        resultadoPago.estadoPago = paymentStateData.estado.codigo.equals("04") ? new EstadoPago("30") : new EstadoPago("31");
        Map<String, p12f.exe.pasarelapagos.objects.Mensaje> mensajes = paymentStateData.estado.mensajes;
        if (mensajes != null && mensajes.size() > 0) {
            resultadoPago.mensajes = new ArrayList();
            Iterator<String> it = mensajes.keySet().iterator();
            while (it.hasNext()) {
                p12f.exe.pasarelapagos.objects.Mensaje mensaje = mensajes.get(it.next());
                Mensaje mensajeV1 = new Mensaje();
                mensajeV1.id = mensaje.id;
                mensajeV1.castellano = mensaje.texto.get(IDIOMA_ES);
                mensajeV1.euskera = mensaje.texto.get(IDIOMA_EU);
            }
        }
        resultadoPago.protocolo = new Protocolo();
        resultadoPago.protocolo.pagoID = ObjectTransformerHelpper.getOldOIDFormat(paymentStateData.id);
        return resultadoPago;
    }

    private static String _formatearFecha(String fecha) {
        return fecha.substring(0, 2) + "/" + fecha.substring(2, 4) + "/" + fecha.substring(4, 6);
    }

    private static String _formatearHora(String hora) {
        return hora.substring(0, 2) + ":" + hora.substring(2, 4) + ":" + hora.substring(4, 6);
    }

    private static List _getOldDatosAdicionales(List newDatosAdicionales) {
        ArrayList<DatoAdicional> oldDatosAdicionales = new ArrayList<DatoAdicional>();
        if (newDatosAdicionales != null) {
            for (p12f.exe.pasarelapagos.objects.DatoAdicional newDatoAdicional : newDatosAdicionales) {
                DatoAdicional oldDatoAdicional = new DatoAdicional();
                oldDatoAdicional.id = newDatoAdicional.id;
                oldDatoAdicional.valor = newDatoAdicional.valor;
                oldDatoAdicional.castellano = newDatoAdicional.texto.get(IDIOMA_ES);
                oldDatoAdicional.euskera = newDatoAdicional.texto.get(IDIOMA_EU);
                oldDatosAdicionales.add(oldDatoAdicional);
            }
        }
        return oldDatosAdicionales;
    }

    private static String _formateOldHour(String currentHour) {
        try {
            String segundos;
            String minutos;
            StringTokenizer st = new StringTokenizer(currentHour, ":");
            String hora = st.nextToken();
            if (hora.length() == 1) {
                hora = "0" + hora;
            }
            if ((minutos = st.nextToken()).length() == 1) {
                minutos = "0" + minutos;
            }
            if ((segundos = st.nextToken()).length() == 1) {
                segundos = "0" + segundos;
            }
            return hora + minutos + segundos;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return currentHour;
        }
    }

    private static String _formateOldDate(String currentDate) {
        try {
            String anyo;
            String mes;
            StringTokenizer st = new StringTokenizer(currentDate, "/");
            String dia = st.nextToken();
            if (dia.length() == 1) {
                dia = "0" + dia;
            }
            if ((mes = st.nextToken()).length() == 1) {
                mes = "0" + mes;
            }
            if ((anyo = st.nextToken()).length() == 1) {
                anyo = "0" + anyo;
            } else if (anyo.length() > 2) {
                anyo = anyo.substring(anyo.length() - 2, anyo.length());
            }
            return dia + mes + anyo;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return currentDate;
        }
    }
}

