/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.transformer;

import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import p12f.exe.pasarelapagos.objects.ProtocolData;
import p12f.exe.pasarelapagos.paymentrequest.PaymentGatewayData;
import p12f.exe.pasarelapagos.paymentrequest.PaymentRequestData;
import p12f.exe.pasarelapagos.paymentrequest.PeticionPago;
import p12f.exe.pasarelapagos.paymentrequest.PresentationRequestData;
import p12f.exe.pasarelapagos.transformer.ObjectTransformerAPI;
import p12f.exe.pasarelapagos.transformer.ObjectTransformerException;
import p12f.exe.pasarelapagos.transformer.ObjectTransformerHelpper;

public class ObjectTransformer
implements ObjectTransformerAPI {
    @Override
    public PaymentGatewayData transformToNewPaymentData(p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPeticionPago) throws ObjectTransformerException {
        PaymentGatewayData paymentGatewayData = new PaymentGatewayData();
        paymentGatewayData.paymentRequestData = ObjectTransformerHelpper.getNewPaymentRequestData(oldPeticionPago);
        paymentGatewayData.protocolData = ObjectTransformerHelpper.getNewProtocolData(oldPeticionPago);
        paymentGatewayData.presentationData = ObjectTransformerHelpper.getNewPresentationRequestData(oldPeticionPago);
        return paymentGatewayData;
    }

    @Override
    public p12f.exe.pasarelapagos.v1.objects.PeticionPago transformToOldPaymentData(PaymentGatewayData paymentGatewayData) throws ObjectTransformerException {
        PeticionPago newPeticionPago = paymentGatewayData.paymentRequestData.peticionesPago.values().iterator().next();
        p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPeticionPago = ObjectTransformerHelpper.getOldPeticionPago(newPeticionPago, paymentGatewayData.protocolData, paymentGatewayData.presentationData);
        return oldPeticionPago;
    }

    public p12f.exe.pasarelapagos.v1.objects.PeticionPago transformToOldPaymentData(String paymentRequestDataXML, String presentationRequestDataXML, String protocolDataXML) throws ObjectTransformerException {
        p12f.exe.pasarelapagos.v1.objects.PeticionPago oldPeticionPago = null;
        try {
            PresentationRequestData prd = PresentationRequestData.getObject(presentationRequestDataXML);
            PaymentGatewayData paymentGatewayData2 = new PaymentGatewayData();
            paymentGatewayData2.paymentRequestData = PaymentRequestData.getObject(paymentRequestDataXML);
            paymentGatewayData2.protocolData = ProtocolData.getObject(protocolDataXML);
            paymentGatewayData2.presentationData = prd;
            oldPeticionPago = this.transformToOldPaymentData(paymentGatewayData2);
        }
        catch (XOMarshallerException e) {
            throw new ObjectTransformerException(e);
        }
        return oldPeticionPago;
    }

    @Override
    public String getNewOIDFormat(String oldOid) throws ObjectTransformerException {
        return ObjectTransformerHelpper.getNewOIDFormat(oldOid);
    }

    @Override
    public String getOldOIDFormat(String oldOid) throws ObjectTransformerException {
        return ObjectTransformerHelpper.getOldOIDFormat(oldOid);
    }
}

