/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.security.crypto;

import com.ejie.r01f.util.StringUtils;
import com.ejie.r01f.util.encoders.Base64Utils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Hex;
import p12f.exe.pasarelapagos.security.crypto.CryptoHelperException;

public class TripleDESEBCDICCryptoHelper {
    public static final String CIPHER_3DES_CBC_PKCS5Padding = "DESede/CBC/PKCS5Padding";
    public static final String CIPHER_3DES_CBC_NOPADDING = "DESede/CBC/NoPadding";
    public static final String CIPHER_3DES_CBC_SpacePADDING = "DESede/CBC/SpacePadding";
    public static final String CIPHER_3DES_ECB_PKCS5Padding = "DESede/ECB/PKCS5Padding";
    public static final String CIPHER_3DES_ECB_NOPADDING = "DESede/ECB/NoPadding";
    public static final String ENC_TYPE_HEX = "hex";
    public static final String ENC_TYPE_BASE64 = "base64";
    public static final String ENC_TYPE_NONE = "none";
    public static final String encoding = "CP500";
    private static final String ALGORITHM_3DES = "DESede";
    private static final byte[] ivBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};

    public String encrypt(String clave1, String clave2, String encType, String modeCipherPadding, String str) throws CryptoHelperException {
        if (ENC_TYPE_NONE.equals(encType)) {
            return str;
        }
        try {
            String passPhrase = new String(Hex.encode((byte[])TripleDESEBCDICCryptoHelper.doXOR(clave1, clave2))).toUpperCase();
            if (ENC_TYPE_BASE64.equals(encType)) {
                return this.encrypt(passPhrase, modeCipherPadding, str);
            }
            if (ENC_TYPE_HEX.equals(encType)) {
                return this.encryptHEX(passPhrase, modeCipherPadding, str);
            }
            throw new CryptoHelperException("Not supported encode type : " + encType);
        }
        catch (Exception e) {
            throw new CryptoHelperException(e);
        }
    }

    public String decrypt(String clave1, String clave2, String encType, String modeCipherPadding, String str) throws CryptoHelperException {
        if (ENC_TYPE_NONE.equals(encType)) {
            return str;
        }
        try {
            String passPhrase = new String(Hex.encode((byte[])TripleDESEBCDICCryptoHelper.doXOR(clave1, clave2))).toUpperCase();
            if (ENC_TYPE_BASE64.equals(encType)) {
                return this.decrypt(passPhrase, modeCipherPadding, str);
            }
            if (ENC_TYPE_HEX.equals(encType)) {
                return this.decryptHEX(passPhrase, modeCipherPadding, str);
            }
            throw new CryptoHelperException("Not supported encode type : " + encType);
        }
        catch (Exception e) {
            throw new CryptoHelperException(e);
        }
    }

    public String encrypt(String passPhrase, String str) throws CryptoHelperException {
        return this.encrypt(passPhrase, CIPHER_3DES_CBC_NOPADDING, str);
    }

    public String encrypt(String passPhrase, String modeCipherPadding, String str) throws CryptoHelperException {
        try {
            String strToCipher = str;
            byte[] seed_key = Hex.decode((String)passPhrase);
            SecretKeySpec keySpec = new SecretKeySpec(seed_key, ALGORITHM_3DES);
            if (CIPHER_3DES_CBC_SpacePADDING.equals(modeCipherPadding)) {
                if (str.length() % 8 != 0) {
                    int modulo = str.length() % 8;
                    strToCipher = StringUtils.rPadWithChar((String)str, (char)' ', (int)(str.length() + 8 - modulo));
                }
                modeCipherPadding = CIPHER_3DES_CBC_NOPADDING;
            }
            Cipher ecipher = Cipher.getInstance(modeCipherPadding);
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            ecipher.init(1, (Key)keySpec, iv);
            byte[] toEBCDIC = strToCipher.getBytes(encoding);
            byte[] enc = ecipher.doFinal(toEBCDIC);
            return Base64Utils.encodeOrThrow((byte[])enc);
        }
        catch (BadPaddingException e) {
            throw new CryptoHelperException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoHelperException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoHelperException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoHelperException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoHelperException(e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoHelperException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoHelperException(e);
        }
        catch (Exception e) {
            throw new CryptoHelperException(e);
        }
    }

    public String encryptHEX(String passPhrase, String str) throws CryptoHelperException {
        return this.encryptHEX(passPhrase, CIPHER_3DES_CBC_NOPADDING, str);
    }

    public String encryptHEX(String passPhrase, String modeCipherPadding, String str) throws CryptoHelperException {
        try {
            String strToCipher = str;
            byte[] seed_key = Hex.decode((String)passPhrase);
            SecretKeySpec keySpec = new SecretKeySpec(seed_key, ALGORITHM_3DES);
            if (CIPHER_3DES_CBC_SpacePADDING.equals(modeCipherPadding)) {
                if (str.length() % 8 != 0) {
                    int modulo = str.length() % 8;
                    strToCipher = StringUtils.rPadWithChar((String)str, (char)' ', (int)(str.length() + 8 - modulo));
                }
                modeCipherPadding = CIPHER_3DES_CBC_NOPADDING;
            }
            Cipher ecipher = Cipher.getInstance(modeCipherPadding);
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            ecipher.init(1, (Key)keySpec, iv);
            byte[] toEBCDIC = strToCipher.getBytes(encoding);
            byte[] enc = ecipher.doFinal(toEBCDIC);
            return new String(Hex.encode((byte[])enc)).toUpperCase();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new CryptoHelperException(ex);
        }
    }

    public String decryptHEX(String passPhrase, String encryptedChain) throws CryptoHelperException {
        return this.decryptHEX(passPhrase, CIPHER_3DES_CBC_NOPADDING, encryptedChain);
    }

    public String decryptHEX(String passPhrase, String modeCipherPadding, String encryptedChain) throws CryptoHelperException {
        try {
            byte[] seed_key = Hex.decode((String)passPhrase);
            SecretKeySpec keySpec = new SecretKeySpec(seed_key, ALGORITHM_3DES);
            boolean removeLastWithespaces = false;
            if (CIPHER_3DES_CBC_SpacePADDING.equals(modeCipherPadding)) {
                modeCipherPadding = CIPHER_3DES_CBC_NOPADDING;
                removeLastWithespaces = true;
            }
            Cipher dcipher = Cipher.getInstance(modeCipherPadding);
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            dcipher.init(2, (Key)keySpec, iv);
            byte[] encData = Hex.decode((String)encryptedChain);
            String decodedStr = new String(dcipher.doFinal(encData), encoding);
            if (removeLastWithespaces) {
                return decodedStr.replaceAll("\\s+$", "");
            }
            return decodedStr;
        }
        catch (BadPaddingException e) {
            throw new CryptoHelperException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoHelperException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoHelperException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoHelperException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoHelperException(e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoHelperException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoHelperException(e);
        }
        catch (Exception e) {
            throw new CryptoHelperException(e);
        }
    }

    public String decrypt(String passPhrase, String encryptedChain) throws CryptoHelperException {
        return this.decrypt(passPhrase, CIPHER_3DES_CBC_NOPADDING, encryptedChain);
    }

    public String decrypt(String passPhrase, String modeCipherPadding, String encryptedChain) throws CryptoHelperException {
        try {
            byte[] seed_key = Hex.decode((String)passPhrase);
            SecretKeySpec keySpec = new SecretKeySpec(seed_key, ALGORITHM_3DES);
            boolean removeLastWithespaces = false;
            if (CIPHER_3DES_CBC_SpacePADDING.equals(modeCipherPadding)) {
                modeCipherPadding = CIPHER_3DES_CBC_NOPADDING;
                removeLastWithespaces = true;
            }
            Cipher dcipher = Cipher.getInstance(modeCipherPadding);
            IvParameterSpec iv = new IvParameterSpec(ivBytes);
            dcipher.init(2, (Key)keySpec, iv);
            byte[] dec = Base64Utils.decodeOrThrow((String)encryptedChain);
            String decodedStr = new String(dcipher.doFinal(dec), encoding);
            if (removeLastWithespaces) {
                return decodedStr.replaceAll("\\s+$", "");
            }
            return decodedStr;
        }
        catch (BadPaddingException e) {
            throw new CryptoHelperException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoHelperException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoHelperException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoHelperException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new CryptoHelperException(e);
        }
        catch (InvalidKeyException e) {
            throw new CryptoHelperException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptoHelperException(e);
        }
        catch (Exception e) {
            throw new CryptoHelperException(e);
        }
    }

    public static byte[] doXOR(String clave1, String clave2) throws Exception {
        if (clave1.length() != clave2.length()) {
            throw new Exception("Las dos cadenas deben tener la misma longitud.");
        }
        byte[] keyBytes1 = Hex.decode((String)clave1);
        byte[] keyBytes2 = Hex.decode((String)clave2);
        byte[] keyBytesXOR = new byte[keyBytes1.length];
        for (int i = 0; i < keyBytesXOR.length; ++i) {
            int intValue = new Byte(keyBytes1[i]).intValue() ^ new Byte(keyBytes2[i]).intValue();
            keyBytesXOR[i] = new Integer(intValue).byteValue();
        }
        return keyBytesXOR;
    }
}

