/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.security.crypto;

import com.ejie.r01f.util.encoders.Base64Utils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import p12f.exe.pasarelapagos.security.crypto.CryptoHelperException;
import p12f.exe.pasarelapagos.security.crypto.ICryptoHelper;

public class DESCryptoHelper
implements ICryptoHelper {
    public static final String encoding = "UTF-8";
    private Cipher ecipher;
    private Cipher dcipher;
    byte[] salt = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};
    int iterationCount = 19;

    public static DESCryptoHelper getInstance(String pass) {
        return new DESCryptoHelper(pass, null);
    }

    public static DESCryptoHelper getInstance(String pass, String provider) {
        return new DESCryptoHelper(pass, provider);
    }

    private DESCryptoHelper(String passPhrase, String provider) {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), this.salt, this.iterationCount);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.ecipher = provider == null ? Cipher.getInstance(key.getAlgorithm()) : Cipher.getInstance(key.getAlgorithm(), provider);
            this.dcipher = provider == null ? Cipher.getInstance(key.getAlgorithm()) : Cipher.getInstance(key.getAlgorithm(), provider);
            PBEParameterSpec paramSpec = new PBEParameterSpec(this.salt, this.iterationCount);
            this.ecipher.init(1, (Key)key, paramSpec);
            this.dcipher.init(2, (Key)key, paramSpec);
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String encrypt(String str) throws CryptoHelperException {
        try {
            byte[] utf8 = str.getBytes(encoding);
            byte[] enc = this.ecipher.doFinal(utf8);
            return Base64Utils.encode((byte[])enc);
        }
        catch (BadPaddingException e) {
            throw new CryptoHelperException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoHelperException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoHelperException(e);
        }
    }

    @Override
    public String decrypt(String str) throws CryptoHelperException {
        try {
            byte[] dec = Base64Utils.decode((String)str);
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, encoding);
        }
        catch (BadPaddingException e) {
            throw new CryptoHelperException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptoHelperException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new CryptoHelperException(e);
        }
    }

    public static final class DESCryptoHelperHelperHolder {
        static final DESCryptoHelper cryptoHelperInstance = new DESCryptoHelper("balalallala", null);
    }
}

