/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.security.app.manager.custom;

import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import p12f.exe.pasarelapagos.objects.security.SecurityContext;
import p12f.exe.pasarelapagos.objects.security.SecurityContextConfig;
import p12f.exe.pasarelapagos.security.app.custom.DefaultXMLToken;
import p12f.exe.pasarelapagos.security.app.manager.SecurityManagerInterface;

public class ThirdRegistrySecurityManager
implements SecurityManagerInterface {
    private SecurityContextConfig _securityContextConfig;

    public ThirdRegistrySecurityManager(SecurityContextConfig securityContextConfig) {
        this._securityContextConfig = securityContextConfig;
    }

    @Override
    public boolean hasPermission(SecurityContext ctx) throws SecurityException {
        try {
            String appClientID = ctx.getAppClientID();
            String appClientKey = this._securityContextConfig.key;
            String expirationMillis = this._securityContextConfig.expirationMillis;
            long howMillisLongWasThisCtx = ThirdRegistrySecurityManager._howMillisLongWasThisCTX(new Date(Long.parseLong(ctx.getTimestamp())));
            if (expirationMillis != null && howMillisLongWasThisCtx > Long.parseLong(expirationMillis)) {
                throw new SecurityException("SecurityContext No V\u00e1lido : Caducado :" + howMillisLongWasThisCtx / 1000L + " segundos ");
            }
            DefaultXMLToken serverGeneratedToken = ThirdRegistrySecurityManager._generateTokenData(appClientID, appClientKey, ctx.getAppClientSessionID(), ctx.getTimestamp());
            DefaultXMLToken clientToken = DefaultXMLToken.getObjectFromBase64(ctx.getTokenData().getContent());
            if (serverGeneratedToken.getValue().equalsIgnoreCase(clientToken.getValue())) {
                return true;
            }
        }
        catch (Exception ex) {
            throw new SecurityException(ex.getMessage());
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage());
        }
        return false;
    }

    public static DefaultXMLToken _generateTokenData(String appClientID, String appClientKey, String appClientSessionID, String timestamp) throws Exception {
        String token_data = appClientID + appClientSessionID + timestamp;
        String hmac = ThirdRegistrySecurityManager._HMAC_MD5_encode(appClientKey, token_data);
        DefaultXMLToken defaultToken = new DefaultXMLToken();
        defaultToken.setValue(hmac);
        return defaultToken;
    }

    public static String _HMAC_MD5_encode(String key, String message) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "HmacMD5");
        Mac mac = Mac.getInstance("HmacMD5");
        mac.init(keySpec);
        byte[] rawHmac = mac.doFinal(message.getBytes());
        return new String(Hex.encodeHex((byte[])rawHmac));
    }

    public static long _howMillisLongWasThisCTX(Date eventDate) {
        long today = System.currentTimeMillis();
        return today - eventDate.getTime();
    }
}

