/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.security.app.manager.custom;

import com.ejie.r01f.xmlproperties.XMLProperties;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import p12f.exe.pasarelapagos.objects.security.SecurityContext;
import p12f.exe.pasarelapagos.security.app.custom.DefaultXMLToken;
import p12f.exe.pasarelapagos.security.app.manager.SecurityManagerInterface;

public class DefaultSecurityManager
implements SecurityManagerInterface {
    String _appServerCode;

    public DefaultSecurityManager(String appCode) {
        this._appServerCode = appCode;
    }

    @Override
    public boolean hasPermission(SecurityContext ctx) throws SecurityException {
        try {
            String appClientID = ctx.getAppClientID();
            String service = ctx.getServiceName();
            String appClientKey = XMLProperties.get((String)this._appServerCode, (String)("defaultSecurityManagerDefinition/services/service[@id='" + service + "']/app[@id='" + appClientID + "']/appClientKey"));
            String expirationMillis = XMLProperties.get((String)this._appServerCode, (String)("defaultSecurityManagerDefinition/services/service[@id='" + service + "']/app[@id='" + appClientID + "']/expirationMillis"));
            if (appClientKey == null) {
                String message = "\n\n";
                message = message + "[ATENCI\u00d3N ] No est\u00e1 definido en la parte servidora el defaultSecurityManagerDefinition:\n";
                message = message + "<defaultSecurityManagerDefinition>\n";
                message = message + "<services>\n";
                message = message + "<services id='" + service + "'>" + "\n";
                message = message + "\t\t<app id ='" + appClientID + "'>" + "\n";
                message = message + "\t\t<appClientKey>????????????</appClientKey>\n";
                message = message + "\t\t<expirationMillis>5000</expirationMillis>\n";
                message = message + "\t\t</app>\n";
                message = message + "</defaultSecurityManagerDefinition>\n";
                throw new SecurityException(message);
            }
            long howMillisLongWasThisCtx = DefaultSecurityManager._howMillisLongWasThisCTX(new Date(Long.parseLong(ctx.getTimestamp())));
            if (expirationMillis != null && howMillisLongWasThisCtx > Long.parseLong(expirationMillis)) {
                throw new SecurityException("SecurityContext No V\u00e1lido : Caducado :" + howMillisLongWasThisCtx / 1000L + " segundos ");
            }
            DefaultXMLToken serverGeneratedToken = DefaultSecurityManager._generateTokenData(appClientID, appClientKey, ctx.getAppClientSessionID(), ctx.getTimestamp());
            DefaultXMLToken clientToken = DefaultXMLToken.getObjectFromBase64(ctx.getTokenData().getContent());
            if (serverGeneratedToken.getValue().equalsIgnoreCase(clientToken.getValue())) {
                return true;
            }
        }
        catch (Exception ex) {
            throw new SecurityException(ex.getMessage());
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage());
        }
        return false;
    }

    public boolean hasPermission(SecurityContext ctx, String securityKey, long expirationMillis) throws SecurityException {
        try {
            String appClientID = ctx.getAppClientID();
            long howMillisLongWasThisCtx = DefaultSecurityManager._howMillisLongWasThisCTX(new Date(Long.parseLong(ctx.getTimestamp())));
            if (howMillisLongWasThisCtx > expirationMillis) {
                throw new SecurityException("SecurityContext No V\u00e1lido : Caducado :" + howMillisLongWasThisCtx / 1000L + " segundos ");
            }
            DefaultXMLToken serverGeneratedToken = DefaultSecurityManager._generateTokenData(appClientID, securityKey, ctx.getAppClientSessionID(), ctx.getTimestamp());
            DefaultXMLToken clientToken = DefaultXMLToken.getObjectFromBase64(ctx.getTokenData().getContent());
            if (serverGeneratedToken.getValue().equalsIgnoreCase(clientToken.getValue())) {
                return true;
            }
        }
        catch (Exception ex) {
            throw new SecurityException(ex.getMessage());
        }
        catch (Throwable ex) {
            throw new SecurityException(ex.getMessage());
        }
        return false;
    }

    public static DefaultXMLToken _generateTokenData(String appClientID, String appClientKey, String appClientSessionID, String timestamp) throws Exception {
        String token_data = appClientID + appClientSessionID + timestamp;
        String hmac = DefaultSecurityManager._HMAC_MD5_encode(appClientKey, token_data);
        DefaultXMLToken defaultToken = new DefaultXMLToken();
        defaultToken.setValue(hmac);
        return defaultToken;
    }

    public static String _HMAC_MD5_encode(String key, String message) throws Exception {
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "HmacMD5");
        Mac mac = Mac.getInstance("HmacMD5");
        mac.init(keySpec);
        byte[] rawHmac = mac.doFinal(message.getBytes());
        return new String(Hex.encodeHex((byte[])rawHmac));
    }

    public static long _howMillisLongWasThisCTX(Date eventDate) {
        long today = System.currentTimeMillis();
        return today - eventDate.getTime();
    }
}

