/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.security.app.custom;

import com.ejie.r01f.guids.GUIDDispenser;
import com.ejie.r01f.guids.GUIDDispenserDef;
import com.ejie.r01f.guids.GUIDDispenserException;
import com.ejie.r01f.guids.GUIDDispenserManager;
import java.util.HashMap;
import java.util.Properties;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import p12f.exe.pasarelapagos.objects.Base64Content;
import p12f.exe.pasarelapagos.objects.security.SecurityContext;
import p12f.exe.pasarelapagos.security.app.SecurityContextGeneratorInterface;
import p12f.exe.pasarelapagos.security.app.SecurityContextParam;
import p12f.exe.pasarelapagos.security.app.custom.DefaultXMLToken;

public class DefaultSecurityContextGenerator
implements SecurityContextGeneratorInterface {
    public static final String APP_CLIENT_ID = "appClientID";
    public static final String APP_CLIENT_KEY = "appClientKey";
    public static final String APP_SERVICE_NAME = "serviceName";

    @Override
    public SecurityContext generateSecurityContext(HashMap inputdataList) throws SecurityException {
        try {
            String appClientID = (String)((SecurityContextParam)inputdataList.get(APP_CLIENT_ID)).getValue();
            String appClientKey = (String)((SecurityContextParam)inputdataList.get(APP_CLIENT_KEY)).getValue();
            String serviceName = (String)((SecurityContextParam)inputdataList.get(APP_SERVICE_NAME)).getValue();
            String appClientSessionID = DefaultSecurityContextGenerator._generateSessionID(appClientID);
            String timestamp = Long.toString(System.currentTimeMillis());
            SecurityContext ctx = new SecurityContext();
            ctx.setAppClientID(appClientID);
            ctx.setAppClientSessionID(appClientSessionID);
            ctx.setServiceName(serviceName);
            ctx.setTimestamp(timestamp);
            ctx.setType("custom");
            DefaultXMLToken token = DefaultSecurityContextGenerator._generateTokenData(appClientID, appClientKey, appClientSessionID, timestamp);
            Base64Content tokenData = new Base64Content();
            tokenData.setContent(token.toBase64());
            ctx.setTokenData(tokenData);
            return ctx;
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SecurityException(ex.getLocalizedMessage());
        }
    }

    public static String _generateSessionID(String appCode) {
        try {
            Properties props = new Properties();
            props.put("length", "32");
            GUIDDispenserDef def = new GUIDDispenserDef(appCode, "default", "cx", "com.ejie.r01f.guids.SimpleGUIDDispenser", props);
            GUIDDispenser disp1 = GUIDDispenserManager.createDispenser((GUIDDispenserDef)def);
            String uid = disp1.getGUID();
            return uid;
        }
        catch (GUIDDispenserException giex) {
            throw new SecurityException(giex.getLocalizedMessage());
        }
    }

    public static DefaultXMLToken _generateTokenData(String appClientID, String appClientKey, String appClientSessionID, String timestamp) {
        String token_data = appClientID + appClientSessionID + timestamp;
        String hmac = DefaultSecurityContextGenerator._HMAC_MD5_encode(appClientKey, token_data);
        DefaultXMLToken defaultToken = new DefaultXMLToken();
        defaultToken.setValue(hmac);
        return defaultToken;
    }

    public static String _HMAC_MD5_encode(String key, String message) {
        SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(), "HmacMD5");
        try {
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(keySpec);
            byte[] rawHmac = mac.doFinal(message.getBytes());
            return new String(Hex.encodeHex((byte[])rawHmac));
        }
        catch (Exception e) {
            throw new SecurityException(e.getLocalizedMessage());
        }
    }
}

