/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.security;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import n38c.exe.N38API;
import n38i.exe.N38Excepcion;
import n38i.exe.N38ParameterException;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import p12f.exe.pasarelapagos.security.ISecurityInfo;
import p12f.exe.pasarelapagos.security.SecurityHelperException;
import p12f.exe.pasarelapagos.security.SecurityObject;
import p12f.exe.pasarelapagos.security.XLNetsPrintWritter;

public class SecurityHelperXLNets
implements ISecurityInfo {
    private static final Logger log = LoggerFactory.getLogger(SecurityHelperXLNets.class);
    private HttpServletRequest request;
    private HttpServletResponse response;
    private N38API n38API;

    @Override
    public boolean init(HttpServletRequest request, HttpServletResponse response) throws SecurityHelperException {
        try {
            log.debug("\n\n>>>>>>>>>>>> INICIALIZANDO OBJETO SEGURIDAD XLNETS : p12f.exe.pasarelapagos.security.SecurityHelperXLNets VZ-4X");
            this.request = request;
            this.response = response;
            this.n38API = new N38API(request);
            log.debug("\n\n\n>>>>SESSION:" + XLNetsPrintWritter.print(this.n38API.n38ItemSesion()));
            return this.isValidSession();
        }
        catch (Exception e) {
            log.debug(">>Excepcion capturada en Initialize de SecurityHelper:" + e);
            return false;
        }
    }

    @Override
    public String[] getPerfiles() throws SecurityHelperException {
        try {
            String[] perfiles = this.n38API.n38ItemSesion("n38perfiles");
            return perfiles;
        }
        catch (Throwable e) {
            throw new SecurityHelperException("SecurityHelpper:getPerfiles");
        }
    }

    public String getPersonaNombre() throws SecurityHelperException {
        try {
            String uidPersona = this.getPersonaUID();
            Document personaDocument = this.n38API.n38ItemObtenerPersonas("n38PuestoUID=" + uidPersona);
            log.debug(XLNetsPrintWritter.print(personaDocument));
            String filtro = "//elemento[@subtipo=\"n38persona\"]/parametro[@id=\"cn\"]/valor/text()";
            String nombre = XPathAPI.selectNodeList((Node)personaDocument, (String)filtro).item(0).getNodeValue();
            return nombre;
        }
        catch (Exception e) {
            throw new SecurityHelperException("SecurityHelpper:getPersonaNombre");
        }
    }

    public String getPersonaUID() throws SecurityHelperException {
        try {
            return this.n38API.n38ItemSesion("n38puestouid")[0];
        }
        catch (Exception e) {
            throw new SecurityHelperException("SecurityHelpper:getPersonaUID");
        }
    }

    public String getPersonaDNI() throws SecurityHelperException {
        try {
            return this.n38API.n38ItemSesion("dni")[0];
        }
        catch (Exception e) {
            throw new SecurityHelperException("SecurityHelpper:getPersonaDNI");
        }
    }

    @Override
    public boolean hasPermission(String uidFuncion) throws SecurityHelperException {
        NodeList lista;
        try {
            log.debug("SecurityHelpper :: Obtener el item de seguridad para la funcion: " + uidFuncion);
            Document itemSeguridad = this.n38API.n38ItemSeguridad(uidFuncion);
            log.debug(XLNetsPrintWritter.print(itemSeguridad));
            log.debug(" SecurityHelpper ::  Obtener la lista de permisos.");
            lista = XPathAPI.selectNodeList((Node)itemSeguridad, (String)"//elementos");
        }
        catch (Exception e) {
            log.debug("SecurityHelpper ::  Se ha producido una excepcion al tratar de comprobar los permisos");
            throw new SecurityHelperException("SecurityHelpperXLNets:hasPermision:" + e);
        }
        log.debug("Longitud de la lista de permisos: " + lista.getLength());
        return lista.getLength() != 0;
    }

    @Override
    public SecurityObject getSecurityObject(String uidFuncion) throws SecurityHelperException {
        SecurityObject objetoSeguridad = null;
        try {
            log.debug("\n\n\n>>>>SecurityHelpper ::SESSION:" + XLNetsPrintWritter.print(this.n38API.n38ItemSesion()));
            if (this.hasPermission(uidFuncion)) {
                log.debug(">>>>>>>>>>>> SecurityHelpper :: Obteniendo objeto de seguridad para " + this.n38API.n38ItemSesion("n38puestouid")[0]);
                objetoSeguridad = new SecurityObject(this.n38API.n38ItemSesion("n38puestouid")[0]);
                objetoSeguridad.setPerfiles(this.getPerfiles());
                objetoSeguridad.setPersona(this.getPersonaNombre());
                objetoSeguridad.dni = this.getPersonaDNI();
            } else {
                log.debug(" SecurityHelpper :: El usuario no tiene permiso para esta funci\u00f3n.");
            }
        }
        catch (Exception e) {
            log.debug(" SecurityHelpper :: Se ha producido una excepcion al tratar de obtener el SecurityObject");
            throw new SecurityException(" SecurityHelpper ::  SecurityHelpperException:getSecurityObject:" + e);
        }
        return objetoSeguridad;
    }

    @Override
    public void redirectToLogin(String finalURI) {
        log.debug(">>>>>>>>>>>> Redirigiendo a :" + finalURI);
        try {
            this.response.sendRedirect(finalURI);
        }
        catch (IOException e) {
            throw new SecurityException("SecurityHelpperException:redirectToLogin:" + e);
        }
    }

    public boolean isValidSession() {
        String uidSession = null;
        try {
            uidSession = this.n38API.n38ItemSesion("n38uidsesion")[0];
            return uidSession != null && !uidSession.equalsIgnoreCase("");
        }
        catch (N38ParameterException e) {
            throw new SecurityException("SecurityHelpperException:isValidSession:" + (Object)((Object)e));
        }
        catch (N38Excepcion e) {
            throw new SecurityException("SecurityHelpperException:isValidSession:" + (Object)((Object)e));
        }
    }
}

