/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.paymentrequest;

import com.ejie.r01f.util.DateUtils;
import com.ejie.r01f.xml.marshalling.XOManager;
import com.ejie.r01f.xml.marshalling.XOMarshallerException;
import com.ejie.r01f.xmlproperties.XMLProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import p12f.exe.pasarelapagos.exceptions.PaymentRequestException;
import p12f.exe.pasarelapagos.objects.DatosPago;
import p12f.exe.pasarelapagos.objects.DatosResolucion;
import p12f.exe.pasarelapagos.objects.Expediente;
import p12f.exe.pasarelapagos.objects.PeriodoPago;
import p12f.exe.pasarelapagos.paymentrequest.Aplicacion;
import p12f.exe.pasarelapagos.paymentrequest.Backend;
import p12f.exe.pasarelapagos.paymentrequest.ConceptoResolucion;
import p12f.exe.pasarelapagos.paymentrequest.Validacion;
import p12f.exe.pasarelapagos.utils.CSBConstants;
import p12f.exe.pasarelapagos.utils.CSBFIELD;
import p12f.exe.pasarelapagos.utils.CSBHelpper;
import p12f.exe.pasarelapagos.utils.exceptions.CSBFormatException;

public class ResolutionRequestData
implements Serializable {
    private static final long serialVersionUID = 2831450572622697829L;
    public static final String MOTIVO_DEVOLUCION_ESTIMACION_RECURSO = "1";
    public static final String MOTIVO_DEVOLUCION_COBRO_DUPLICADO = "2";
    public static final String MOTIVO_DEVOLUCION_COBRO_ERRONEO = "3";
    public static final String MOTIVO_DEVOLUCION_OTRAS_CAUSAS = "10";
    public String pagoID;
    public DatosPago datosPago;
    public DatosResolucion datosResolucion;
    public Backend backend;
    public List<ConceptoResolucion> conceptos;
    public Aplicacion aplicacion;
    public Expediente expediente;
    public Validacion validacion = null;

    public static ResolutionRequestData getObject(String xml) throws XOMarshallerException {
        return (ResolutionRequestData)XOManager.getObject((String)XMLProperties.get((String)"p12ft", (String)"objectMapPath"), (String)xml);
    }

    public String toXML() throws XOMarshallerException {
        return XOManager.getXML((String)XMLProperties.get((String)"p12ft", (String)"objectMapPath"), (Object)this);
    }

    public void validate() {
        String errorMsg = null;
        if (this.validacion == null) {
            try {
                Map<CSBFIELD, String> paymentDataMap = CSBHelpper.decode507(this.pagoID);
                String sufijo = paymentDataMap.get(CSBConstants.CSB507.SUFIJO);
                String referencia = paymentDataMap.get(CSBConstants.CSB507.REFERENCIA);
                String identificacion = paymentDataMap.get(CSBConstants.CSB507.IDENTIFICACION);
                if (referencia.length() != 13) {
                    throw new PaymentRequestException("La referencia debe ser de longitud 13 y ese de longitud " + referencia.length());
                }
                if (this.backend == null) {
                    throw new PaymentRequestException("No hay datos de backend");
                }
                if (this.backend.get("ejercicioContable") == null) {
                    throw new PaymentRequestException("No hay datos de backend del EJERCICIO CONTABLE");
                }
                PeriodoPago periodoPago = this.datosPago.periodosPago.values().iterator().next();
                if (Integer.parseInt(sufijo) > 500) {
                    DateUtils.getDateFromFormatedString((String)identificacion, (String)"ddMMyy");
                } else if (periodoPago.fechaFin != null) {
                    DateUtils.getDateFromFormatedString((String)periodoPago.fechaFin, (String)"dd/MM/yyyy");
                }
                Long.toString(periodoPago.importe);
                if (this.datosResolucion == null || this.datosResolucion.motivo == null || "".equals(this.datosResolucion.motivo)) {
                    throw new PaymentRequestException("No hay MOTIVO DEVOLUCION");
                }
            }
            catch (PaymentRequestException e) {
                errorMsg = e.getRawMessage();
            }
            catch (CSBFormatException e) {
                errorMsg = e.getRawMessage();
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    errorMsg = " Se ha producido alg\u00fan tipo de excepci\u00f3n no recogida en la validaci\u00f3n: " + e.getMessage() + " de la siguiente petici\u00f3n de Resoluci\u00f3n:\n" + this.toXML();
                }
                catch (XOMarshallerException e1) {
                    e1.printStackTrace();
                }
            }
            Validacion validacion = new Validacion();
            if (errorMsg == null) {
                validacion.valido = true;
            } else {
                validacion.valido = false;
                validacion.mensaje = errorMsg;
            }
            this.validacion = validacion;
        }
    }
}

