/*
 * Decompiled with CFR 0.152.
 */
package p12f.exe.pasarelapagos.paymentrequest;

import com.google.gwt.core.shared.GwtIncompatible;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import p12f.exe.pasarelapagos.exceptions.LimitDateException;
import p12f.exe.pasarelapagos.objects.Pago;
import p12f.exe.pasarelapagos.objects.PeriodoPago;
import p12f.exe.pasarelapagos.paymentrequest.Aplicacion;
import p12f.exe.pasarelapagos.paymentrequest.Backend;
import p12f.exe.pasarelapagos.paymentrequest.BackendData;
import p12f.exe.pasarelapagos.paymentrequest.ConceptoPeticion;
import p12f.exe.pasarelapagos.paymentrequest.FinantialOrg;
import p12f.exe.pasarelapagos.paymentrequest.Liquidacion;
import p12f.exe.pasarelapagos.paymentrequest.PaymentMode;
import p12f.exe.pasarelapagos.paymentrequest.Validacion;
import p12f.exe.pasarelapagos.utils.LimitDateHelper;
import p12f.exe.pasarelapagos.utils.exceptions.PaymentDataHelpperException;

public class PeticionPago
extends Pago
implements Serializable {
    private static final long serialVersionUID = 8347824902563325608L;
    public static final String DEVENGO_PAGO = "0";
    public static final String DEVENGO_EMISION = "1";
    public Backend backend = new Backend();
    public Aplicacion aplicacion = new Aplicacion();
    public Liquidacion liquidacion = new Liquidacion();
    public Map<String, FinantialOrg> finantialOrgs = new HashMap<String, FinantialOrg>();
    public Map<String, PaymentMode> paymentModes = new HashMap<String, PaymentMode>();
    public Validacion validacion = null;
    public String devengo;
    public Boolean exento = null;

    @GwtIncompatible
    public long getImporteNormal() {
        Map<String, PeriodoPago> periodosPago = this.datosPago.periodosPago;
        long importe = 0L;
        if (periodosPago.get("periodoNormal") != null) {
            PeriodoPago periodoPago = periodosPago.get("periodoNormal");
            importe = periodoPago.importe;
        } else if (periodosPago.get("periodoVoluntario") != null) {
            PeriodoPago periodoPago = periodosPago.get("periodoVoluntario");
            importe = periodoPago.importe;
        }
        return importe;
    }

    @GwtIncompatible
    public long getImporteConRecargo() {
        Map<String, PeriodoPago> periodosPago = this.datosPago.periodosPago;
        long importe = 0L;
        if (periodosPago.get("periodoConRecargo") != null) {
            PeriodoPago periodoPago = periodosPago.get("periodoConRecargo");
            importe = periodoPago.importe;
        }
        return importe;
    }

    /*
     * Enabled aggressive block sorting
     */
    @GwtIncompatible
    public void comprobarPeriodos() throws LimitDateException, PaymentDataHelpperException {
        Map<String, PeriodoPago> periodosPago = this.datosPago.periodosPago;
        PeriodoPago periodoNormal = periodosPago.get("periodoNormal");
        if (periodoNormal != null) {
            String fechaLimite = periodoNormal.fechaFin;
            if (fechaLimite == null) {
                periodoNormal.activo = true;
                return;
            }
            if (LimitDateHelper.comprobarFecha(fechaLimite)) {
                periodoNormal.activo = true;
                return;
            }
            periodoNormal.activo = false;
            throw new LimitDateException();
        }
        PeriodoPago periodoVoluntario = periodosPago.get("periodoVoluntario");
        PeriodoPago periodoConRecargo = periodosPago.get("periodoConRecargo");
        if (periodoVoluntario == null) throw new PaymentDataHelpperException();
        if (periodoConRecargo == null) throw new PaymentDataHelpperException();
        String fechaLimiteVol = periodoVoluntario.fechaFin;
        if (LimitDateHelper.comprobarFecha(fechaLimiteVol)) {
            periodoVoluntario.activo = true;
            periodoConRecargo.activo = false;
            return;
        }
        periodoVoluntario.activo = false;
        String fechaLimiteRec = periodoConRecargo.fechaFin;
        if (LimitDateHelper.comprobarFecha(fechaLimiteRec)) {
            periodoConRecargo.activo = true;
            return;
        }
        periodoConRecargo.activo = false;
        throw new LimitDateException();
    }

    @GwtIncompatible
    public String validate() {
        BackendData informarSipca;
        if (this.datosPago == null) {
            return "datospago_null";
        }
        String error_validacion = null;
        error_validacion = this.datosPago.validate();
        if (error_validacion != null) {
            return error_validacion;
        }
        if (this.backend != null && this.backend.backendDataMap != null && this.backend.backendDataMap.size() > 0 && (informarSipca = this.backend.backendDataMap.get("informarSIPCA")) != null && "true".equals(informarSipca.value)) {
            if (this.conceptos != null && this.conceptos.size() > 0) {
                for (int i = 0; i < this.conceptos.size(); ++i) {
                    ConceptoPeticion concepto = (ConceptoPeticion)this.conceptos.get(i);
                    if (concepto.numeroLinea != i + 1) {
                        return "numero_linea";
                    }
                    if (concepto.descripcion == null || concepto.descripcion.size() == 0) {
                        return "concepto_descripcion";
                    }
                    if (concepto.importe == 0L) {
                        return "concepto_importe";
                    }
                    if (concepto.backendDataMap == null || concepto.backendDataMap.size() == 0) {
                        return "concepto_backend_null";
                    }
                    BackendData codigoIngreso = concepto.backendDataMap.get("codigoIngreso");
                    if (codigoIngreso == null || codigoIngreso.value == null) {
                        return "codigo_ingreso";
                    }
                    if (concepto.IVARepercutido) {
                        if (concepto.baseImponible == 0L) {
                            return "base_imponible";
                        }
                        if (concepto.tipoIVA == 0L) {
                            return "tipo_IVA";
                        }
                        if (concepto.importeIVA == 0L) {
                            return "importe_IVA";
                        }
                        BackendData conceptoIVA = concepto.backendDataMap.get("conceptoIVA");
                        if (conceptoIVA == null || conceptoIVA.value == null) {
                            return "concepto_IVA";
                        }
                        BackendData territorioIVA = concepto.backendDataMap.get("territorioIVA");
                        if (territorioIVA != null && territorioIVA.value != null) continue;
                        return "territorio_IVA";
                    }
                    if (concepto.noPresupuestario != null && !concepto.noPresupuestario.booleanValue()) {
                        BackendData territorioApp;
                        BackendData aplicacionPresupuestaria = concepto.backendDataMap.get("aplicPresupuestaria");
                        if (aplicacionPresupuestaria == null || aplicacionPresupuestaria.value == null) {
                            return "aplicacion_presupuestaria";
                        }
                        if (this._appIsNewFormat(aplicacionPresupuestaria.value) && ((territorioApp = concepto.backendDataMap.get("territorioAplicacionPresupuestaria")) == null || territorioApp.value == null)) {
                            return "territorio_aplicacion_presupuestaria";
                        }
                    }
                    if (!concepto.tieneIVARepercutido) continue;
                    if (this.conceptos.size() > i + 1) {
                        ConceptoPeticion conceptoIVARepercutido = (ConceptoPeticion)this.conceptos.get(i + 1);
                        if (conceptoIVARepercutido == null) {
                            return "concepto_IVA_repercutido";
                        }
                        if (conceptoIVARepercutido.IVARepercutido) continue;
                        return "concepto_IVA_repercutido";
                    }
                    return "concepto_IVA_repercutido";
                }
            } else {
                return null;
            }
        }
        return null;
    }

    private boolean _appIsNewFormat(String aplicacion) {
        System.out.println("[P12FT][PeticionPago][VALIDATE]:::_appIsNewFormat::: CHECK IF APP IS NEW/OLD FORMAT::::: " + aplicacion);
        if (this._appIsOldFormat(aplicacion)) {
            System.out.println("[P12FT][PeticionPago][VALIDATE]:::_appIsNewFormat::: APPLICATION SENT IS OLD FORMAT");
            return false;
        }
        System.out.println("[P12FT][PeticionPago][VALIDATE]:::_appIsNewFormat::: APPLICATION SENT IS NEW FORMAT");
        return true;
    }

    private boolean _appIsOldFormat(String aplicacion) {
        int resto2;
        if (aplicacion == null || "".equals(aplicacion)) {
            return true;
        }
        boolean valida = false;
        StringBuffer aplicacionAux = new StringBuffer(aplicacion.substring(0, aplicacion.length() - 1));
        while (aplicacionAux.length() < 30) {
            aplicacionAux.append(DEVENGO_PAGO);
        }
        StringBuffer aplicAux2 = new StringBuffer("");
        String letras = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String numeros = "12345678901234567890123456";
        for (int i = 0; i < aplicacionAux.length(); ++i) {
            int posLetras = letras.indexOf(aplicacionAux.charAt(i));
            int posNumeros = numeros.indexOf(aplicacionAux.charAt(i));
            if (posLetras > -1) {
                aplicAux2.append(numeros.charAt(posLetras));
                continue;
            }
            if (posNumeros > -1) {
                aplicAux2.append(aplicacionAux.charAt(i));
                continue;
            }
            return false;
        }
        String aplicParte1 = aplicAux2.substring(0, 15);
        String aplicParte2 = aplicAux2.substring(15);
        long parte1 = Long.parseLong(aplicParte1);
        long parte2 = Long.parseLong(aplicParte2);
        int resto1 = Integer.parseInt(Long.toString(parte1 % 13L));
        int restoTotal = resto1 + (resto2 = Integer.parseInt(Long.toString(parte2 % 12L)));
        if (restoTotal >= 14) {
            ++restoTotal;
        }
        if (aplicacion.charAt(aplicacion.length() - 1) == letras.charAt(restoTotal)) {
            valida = true;
        }
        return valida;
    }
}

